/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.health;

import com.codahale.metrics.Clock;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.annotation.Async;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;

public class AsyncHealthCheckDecorator
extends HealthCheck
implements Runnable {
    private static final String NO_RESULT_YET_MESSAGE = "Waiting for first asynchronous check result.";
    private final HealthCheck healthCheck;
    private final ScheduledFuture<?> future;
    private final long healthyTtl;
    private final Clock clock;
    private volatile HealthCheck.Result result;

    AsyncHealthCheckDecorator(HealthCheck healthCheck, ScheduledExecutorService executorService, Clock clock) {
        AsyncHealthCheckDecorator.check(healthCheck != null, "healthCheck cannot be null");
        AsyncHealthCheckDecorator.check(executorService != null, "executorService cannot be null");
        Async async = healthCheck.getClass().getAnnotation(Async.class);
        AsyncHealthCheckDecorator.check(async != null, "healthCheck must contain Async annotation");
        AsyncHealthCheckDecorator.check(async.period() > 0L, "period cannot be less than or equal to zero");
        AsyncHealthCheckDecorator.check(async.initialDelay() >= 0L, "initialDelay cannot be less than zero");
        this.clock = clock;
        this.healthCheck = healthCheck;
        this.healthyTtl = async.unit().toMillis(async.healthyTtl() <= 0L ? 2L * async.period() : async.healthyTtl());
        this.result = Async.InitialState.HEALTHY.equals((Object)async.initialState()) ? HealthCheck.Result.healthy(NO_RESULT_YET_MESSAGE) : HealthCheck.Result.unhealthy(NO_RESULT_YET_MESSAGE);
        this.future = Async.ScheduleType.FIXED_RATE.equals((Object)async.scheduleType()) ? executorService.scheduleAtFixedRate(this, async.initialDelay(), async.period(), async.unit()) : executorService.scheduleWithFixedDelay(this, async.initialDelay(), async.period(), async.unit());
    }

    AsyncHealthCheckDecorator(HealthCheck healthCheck, ScheduledExecutorService executorService) {
        this(healthCheck, executorService, Clock.defaultClock());
    }

    @Override
    public void run() {
        this.result = this.healthCheck.execute();
    }

    @Override
    protected HealthCheck.Result check() throws Exception {
        long expiration = this.clock.getTime() - this.result.getTime() - this.healthyTtl;
        if (expiration > 0L) {
            return HealthCheck.Result.builder().unhealthy().usingClock(this.clock).withMessage("Result was %s but it expired %d milliseconds ago", this.result.isHealthy() ? "healthy" : "unhealthy", expiration).build();
        }
        return this.result;
    }

    boolean tearDown() {
        return this.future.cancel(true);
    }

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    private static void check(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }
}

