/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.rx.util.BackpressureStrategy;
import com.github.davidmoten.util.Preconditions;
import rx.Notification;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.functions.Func3;

public final class TransformerStateMachine<State, In, Out>
implements Observable.Transformer<In, Out> {
    private final Func0<? extends State> initialState;
    private final Func3<? super State, ? super In, ? super Subscriber<Out>, ? extends State> transition;
    private final Func2<? super State, ? super Subscriber<Out>, Boolean> completion;
    private final BackpressureStrategy backpressureStrategy;
    private final int initialRequest;
    private static final Func1<Notification<?>, Boolean> NOT_UNSUBSCRIBED = new Func1<Notification<?>, Boolean>(){

        public Boolean call(Notification<?> t) {
            return t != UnsubscribedNotificationHolder.unsubscribedNotification();
        }
    };

    private TransformerStateMachine(Func0<? extends State> initialState, Func3<? super State, ? super In, ? super Subscriber<Out>, ? extends State> transition, Func2<? super State, ? super Subscriber<Out>, Boolean> completion, BackpressureStrategy backpressureStrategy, int initialRequest) {
        Preconditions.checkNotNull(initialState);
        Preconditions.checkNotNull(transition);
        Preconditions.checkNotNull(completion);
        Preconditions.checkNotNull((Object)backpressureStrategy);
        Preconditions.checkArgument(initialRequest > 0, "initialRequest must be greater than zero");
        this.initialState = initialState;
        this.transition = transition;
        this.completion = completion;
        this.backpressureStrategy = backpressureStrategy;
        this.initialRequest = initialRequest;
    }

    public static <State, In, Out> Observable.Transformer<In, Out> create(Func0<? extends State> initialState, Func3<? super State, ? super In, ? super Subscriber<Out>, ? extends State> transition, Func2<? super State, ? super Subscriber<Out>, Boolean> completion, BackpressureStrategy backpressureStrategy, int initialRequest) {
        return new TransformerStateMachine<State, In, Out>(initialState, transition, completion, backpressureStrategy, initialRequest);
    }

    public Observable<Out> call(final Observable<In> source) {
        return Observable.defer((Func0)new Func0<Observable<Out>>(){

            public Observable<Out> call() {
                Mutable<Object> state = new Mutable<Object>(TransformerStateMachine.this.initialState.call());
                return source.materialize().flatMap(TransformerStateMachine.execute(TransformerStateMachine.this.transition, TransformerStateMachine.this.completion, state, TransformerStateMachine.this.backpressureStrategy), TransformerStateMachine.this.initialRequest).takeWhile(NOT_UNSUBSCRIBED).dematerialize();
            }
        });
    }

    private static <State, Out, In> Func1<Notification<In>, Observable<Notification<Out>>> execute(final Func3<? super State, ? super In, ? super Subscriber<Out>, ? extends State> transition, final Func2<? super State, ? super Subscriber<Out>, Boolean> completion, final Mutable<State> state, final BackpressureStrategy backpressureStrategy) {
        return new Func1<Notification<In>, Observable<Notification<Out>>>(){

            public Observable<Notification<Out>> call(final Notification<In> in) {
                Observable o = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Notification<Out>>(){

                    /*
                     * Exception decompiling
                     */
                    public void call(Subscriber<? super Notification<Out>> subscriber) {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
                         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                });
                return TransformerStateMachine.applyBackpressure(o, backpressureStrategy);
            }
        };
    }

    private static <Out> Observable<Notification<Out>> applyBackpressure(Observable<Notification<Out>> o, BackpressureStrategy backpressureStrategy) {
        if (backpressureStrategy == BackpressureStrategy.BUFFER) {
            return o.onBackpressureBuffer();
        }
        if (backpressureStrategy == BackpressureStrategy.DROP) {
            return o.onBackpressureDrop();
        }
        if (backpressureStrategy == BackpressureStrategy.LATEST) {
            return o.onBackpressureLatest();
        }
        throw new IllegalArgumentException("backpressure strategy not supported: " + (Object)((Object)backpressureStrategy));
    }

    private static <Out> NotificationSubscriber<Out> wrap(Subscriber<? super Notification<Out>> sub) {
        return new NotificationSubscriber(sub);
    }

    static /* synthetic */ NotificationSubscriber access$700(Subscriber x0) {
        return TransformerStateMachine.wrap(x0);
    }

    private static final class NotificationSubscriber<Out>
    extends Subscriber<Out> {
        private final Subscriber<? super Notification<Out>> sub;

        NotificationSubscriber(Subscriber<? super Notification<Out>> sub) {
            this.sub = sub;
            this.add((Subscription)sub);
        }

        public void onCompleted() {
            this.sub.onNext((Object)Notification.createOnCompleted());
        }

        public void onError(Throwable e) {
            this.sub.onNext((Object)Notification.createOnError((Throwable)e));
        }

        public void onNext(Out t) {
            this.sub.onNext((Object)Notification.createOnNext(t));
        }
    }

    private static final class Mutable<T> {
        T value;

        Mutable(T value) {
            this.value = value;
        }
    }

    private static final class UnsubscribedNotificationHolder {
        private static final Notification<Object> INSTANCE = Notification.createOnNext(null);

        private UnsubscribedNotificationHolder() {
        }

        static <T> Notification<T> unsubscribedNotification() {
            return INSTANCE;
        }
    }
}

