/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.MRDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.service.AbstractService;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class HistoryServerStateStoreService
extends AbstractService {
    public HistoryServerStateStoreService() {
        super(HistoryServerStateStoreService.class.getName());
    }

    public void serviceInit(Configuration conf) throws IOException {
        this.initStorage(conf);
    }

    public void serviceStart() throws IOException {
        this.startStorage();
    }

    public void serviceStop() throws IOException {
        this.closeStorage();
    }

    protected abstract void initStorage(Configuration var1) throws IOException;

    protected abstract void startStorage() throws IOException;

    protected abstract void closeStorage() throws IOException;

    public abstract HistoryServerState loadState() throws IOException;

    public abstract void storeToken(MRDelegationTokenIdentifier var1, Long var2) throws IOException;

    public abstract void updateToken(MRDelegationTokenIdentifier var1, Long var2) throws IOException;

    public abstract void removeToken(MRDelegationTokenIdentifier var1) throws IOException;

    public abstract void storeTokenMasterKey(DelegationKey var1) throws IOException;

    public abstract void removeTokenMasterKey(DelegationKey var1) throws IOException;

    public static class HistoryServerState {
        Map<MRDelegationTokenIdentifier, Long> tokenState = new HashMap<MRDelegationTokenIdentifier, Long>();
        Set<DelegationKey> tokenMasterKeyState = new HashSet<DelegationKey>();

        public Map<MRDelegationTokenIdentifier, Long> getTokenState() {
            return this.tokenState;
        }

        public Set<DelegationKey> getTokenMasterKeyState() {
            return this.tokenMasterKeyState;
        }
    }
}

