/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.math.BigDecimal;
import java.util.Arrays;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.ElementView2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.BigArray;
import org.ojalgo.array.ComplexArray;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.SparseArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.FactoryStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.operation.MultiplyBoth;
import org.ojalgo.scalar.ComplexNumber;

public final class SparseStore<N extends Number>
extends FactoryStore<N>
implements ElementsConsumer<N> {
    public static final Factory<BigDecimal> BIG = (rowsCount, columnsCount) -> SparseStore.makeBig((int)rowsCount, (int)columnsCount);
    public static final Factory<ComplexNumber> COMPLEX = (rowsCount, columnsCount) -> SparseStore.makeComplex((int)rowsCount, (int)columnsCount);
    public static final Factory<Double> PRIMITIVE = (rowsCount, columnsCount) -> SparseStore.makePrimitive((int)rowsCount, (int)columnsCount);
    private final SparseArray<N> myElements;
    private final int[] myFirsts;
    private final int[] myLimits;
    private final PhysicalStore.FillByMultiplying<N> myMultiplyer;

    public static SparseStore<BigDecimal> makeBig(int rowsCount, int columnsCount) {
        return new SparseStore<BigDecimal>(BigDenseStore.FACTORY, rowsCount, columnsCount, (SparseArray<BigDecimal>)((SparseArray.SparseFactory)SparseArray.factory(BigArray.FACTORY, rowsCount * columnsCount).initial(rowsCount + columnsCount)).make());
    }

    public static SparseStore<ComplexNumber> makeComplex(int rowsCount, int columnsCount) {
        return new SparseStore<ComplexNumber>(ComplexDenseStore.FACTORY, rowsCount, columnsCount, (SparseArray<ComplexNumber>)((SparseArray.SparseFactory)SparseArray.factory(ComplexArray.FACTORY, rowsCount * columnsCount).initial(rowsCount + columnsCount)).make());
    }

    public static SparseStore<Double> makePrimitive(int rowsCount, int columnsCount) {
        return new SparseStore<Double>(PrimitiveDenseStore.FACTORY, rowsCount, columnsCount, (SparseArray<Double>)((SparseArray.SparseFactory)SparseArray.factory(Primitive64Array.FACTORY, rowsCount * columnsCount).initial(rowsCount + columnsCount)).make());
    }

    private SparseStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount) {
        super(factory, rowsCount, columnsCount);
        this.myElements = null;
        this.myFirsts = null;
        this.myLimits = null;
        this.myMultiplyer = null;
        ProgrammingError.throwForIllegalInvocation();
    }

    SparseStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount, SparseArray<N> elements) {
        super(factory, rowsCount, columnsCount);
        this.myElements = elements;
        this.myFirsts = new int[rowsCount];
        this.myLimits = new int[rowsCount];
        Arrays.fill(this.myFirsts, columnsCount);
        Class<?> tmpType = factory.scalar().zero().getNumber().getClass();
        this.myMultiplyer = tmpType.equals(Double.class) ? MultiplyBoth.getPrimitive(rowsCount, columnsCount) : (tmpType.equals(ComplexNumber.class) ? MultiplyBoth.getComplex(rowsCount, columnsCount) : (tmpType.equals(BigDecimal.class) ? MultiplyBoth.getBig(rowsCount, columnsCount) : null));
    }

    @Override
    public void add(long row, long col, double addend) {
        if (addend != PrimitiveMath.ZERO) {
            this.myElements.add(Structure2D.index((long)this.myFirsts.length, row, col), addend);
            this.updateNonZeros(row, col);
        }
    }

    @Override
    public void add(long row, long col, Number addend) {
        this.myElements.add(Structure2D.index((long)this.myFirsts.length, row, col), addend);
        this.updateNonZeros(row, col);
    }

    public void clear() {
        this.myElements.reset();
        Arrays.fill(this.myFirsts, (int)this.countColumns());
        Arrays.fill(this.myLimits, 0);
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myElements.doubleValue(Structure2D.index((long)this.myFirsts.length, row, col));
    }

    @Override
    public void fillByMultiplying(Access1D<N> left, Access1D<N> right) {
        this.myMultiplyer.invoke(this, left, (int)(left.count() / this.countRows()), right);
    }

    @Override
    public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
        this.set(row, col, (Number)values.get(valueIndex));
    }

    @Override
    public void fillOne(long row, long col, N value) {
        this.myElements.fillOne(Structure2D.index((long)this.myFirsts.length, row, col), value);
        this.updateNonZeros(row, col);
    }

    @Override
    public void fillOne(long row, long col, NullaryFunction<N> supplier) {
        this.myElements.fillOne(Structure2D.index((long)this.myFirsts.length, row, col), supplier);
        this.updateNonZeros(row, col);
    }

    @Override
    public int firstInColumn(int col) {
        int tmpRowDim = this.myFirsts.length;
        int tmpRangeFirst = tmpRowDim * col;
        int tmpRangeLimit = tmpRowDim * (col + 1);
        long tmpFirstInRange = this.myElements.firstInRange(tmpRangeFirst, tmpRangeLimit);
        if ((long)tmpRangeFirst == tmpFirstInRange) {
            return 0;
        }
        return (int)(tmpFirstInRange % (long)tmpRowDim);
    }

    @Override
    public int firstInRow(int row) {
        return this.myFirsts[row];
    }

    @Override
    public N get(long row, long col) {
        return this.myElements.get(Structure2D.index((long)this.myFirsts.length, row, col));
    }

    @Override
    public int limitOfColumn(int col) {
        int tmpRowDim = this.myFirsts.length;
        int tmpRangeFirst = tmpRowDim * col;
        int tmpRangeLimit = tmpRangeFirst + tmpRowDim;
        long tmpLimitOfRange = this.myElements.limitOfRange(tmpRangeFirst, tmpRangeLimit);
        if ((long)tmpRangeLimit == tmpLimitOfRange) {
            return tmpRowDim;
        }
        return (int)tmpLimitOfRange % tmpRowDim;
    }

    @Override
    public int limitOfRow(int row) {
        return this.myLimits[row];
    }

    @Override
    public void modifyAll(UnaryFunction<N> modifier) {
        long tmpLimit = this.count();
        if (this.isPrimitive()) {
            for (long i = 0L; i < tmpLimit; ++i) {
                this.set(i, modifier.invoke(this.doubleValue(i)));
            }
        } else {
            for (long i = 0L; i < tmpLimit; ++i) {
                this.set(i, (Number)modifier.invoke(this.get(i)));
            }
        }
    }

    @Override
    public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
        long tmpLimit = Math.min(left.count(), this.count());
        if (this.isPrimitive()) {
            for (long i = 0L; i < tmpLimit; ++i) {
                this.set(i, function.invoke(left.doubleValue(i), this.doubleValue(i)));
            }
        } else {
            for (long i = 0L; i < tmpLimit; ++i) {
                this.set(i, (Number)function.invoke(left.get(i), this.get(i)));
            }
        }
    }

    @Override
    public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
        long tmpLimit = Math.min(this.count(), right.count());
        if (this.isPrimitive()) {
            for (long i = 0L; i < tmpLimit; ++i) {
                this.set(i, function.invoke(this.doubleValue(i), right.doubleValue(i)));
            }
        } else {
            for (long i = 0L; i < tmpLimit; ++i) {
                this.set(i, (Number)function.invoke(this.get(i), right.get(i)));
            }
        }
    }

    @Override
    public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
        if (this.isPrimitive()) {
            this.set(row, col, modifier.invoke(this.doubleValue(row, col)));
        } else {
            this.set(row, col, (Number)modifier.invoke(this.get(row, col)));
        }
    }

    @Override
    public void multiply(Access1D<N> right, ElementsConsumer<N> target) {
        if (this.isPrimitive()) {
            long tmpRightStructure = this.countColumns();
            long tmpRightColumns = target.countColumns();
            if (target instanceof SparseStore) {
                ((SparseStore)target).clear();
            } else {
                target.fillAll(this.physical().scalar().zero().getNumber());
            }
            for (ElementView2D tmpNonzero : this.nonzeros()) {
                long tmpRow = tmpNonzero.row();
                long tmpCol = tmpNonzero.column();
                double tmpValue = tmpNonzero.doubleValue();
                long tmpFirst = MatrixUtils.firstInRow(right, tmpRow, 0L);
                long tmpLimit = MatrixUtils.limitOfRow(right, tmpRow, tmpRightColumns);
                for (long j = tmpFirst; j < tmpLimit; ++j) {
                    long tmpIndex = Structure2D.index(tmpRightStructure, tmpCol, j);
                    target.add(tmpRow, j, tmpValue * right.doubleValue(tmpIndex));
                }
            }
        } else {
            super.multiply(right, target);
        }
    }

    public ElementView2D<N, ?> nonzeros() {
        return new Access2D.ElementView(this.myElements.nonzeros(), this.countRows());
    }

    @Override
    public ElementsConsumer<N> regionByColumns(int ... columns) {
        return new PhysicalStore.ColumnsRegion<N>(this, this.myMultiplyer, columns);
    }

    @Override
    public ElementsConsumer<N> regionByLimits(int rowLimit, int columnLimit) {
        return new PhysicalStore.LimitRegion<N>(this, this.myMultiplyer, rowLimit, columnLimit);
    }

    @Override
    public ElementsConsumer<N> regionByOffsets(int rowOffset, int columnOffset) {
        return new PhysicalStore.OffsetRegion<N>(this, this.myMultiplyer, rowOffset, columnOffset);
    }

    @Override
    public ElementsConsumer<N> regionByRows(int ... rows) {
        return new PhysicalStore.RowsRegion<N>(this, this.myMultiplyer, rows);
    }

    @Override
    public ElementsConsumer<N> regionByTransposing() {
        return new PhysicalStore.TransposedRegion<N>(this, this.myMultiplyer);
    }

    @Override
    public void set(long row, long col, double value) {
        this.myElements.set(Structure2D.index((long)this.myFirsts.length, row, col), value);
        this.updateNonZeros(row, col);
    }

    @Override
    public void set(long row, long col, Number value) {
        this.myElements.set(Structure2D.index((long)this.myFirsts.length, row, col), value);
        this.updateNonZeros(row, col);
    }

    private void updateNonZeros(long row, long col) {
        this.updateNonZeros((int)row, (int)col);
    }

    @Override
    protected void addNonzerosTo(ElementsConsumer<N> consumer) {
        this.myElements.supplyNonZerosTo(consumer);
    }

    void updateNonZeros(int row, int col) {
        this.myFirsts[row] = Math.min(col, this.myFirsts[row]);
        this.myLimits[row] = Math.max(col + 1, this.myLimits[row]);
    }

    public static interface Factory<N extends Number> {
        public SparseStore<N> make(long var1, long var3);
    }
}

