/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.IOException;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.netio.Message;
import org.ojalgo.netio.ProcessInputStream;
import org.ojalgo.netio.ProcessOutputStream;

public abstract class SystemProcess {
    private static String ERROR_TEXT = "System command not working!";
    private ProcessInputStream myInStream;
    private ProcessOutputStream myOutStream;
    private Process myProcess;

    public SystemProcess(String[] aCommandArray, String aLastCommandPrefix) {
        Runtime tmpRuntime = Runtime.getRuntime();
        try {
            this.myProcess = tmpRuntime.exec(aCommandArray);
            this.myOutStream = new ProcessOutputStream(this.myProcess);
            this.myInStream = new ProcessInputStream(this.myProcess, aLastCommandPrefix);
            this.myInStream.collectMessages();
        }
        catch (IOException anException) {
            throw new ProgrammingError(ERROR_TEXT);
        }
    }

    private SystemProcess() {
        ProgrammingError.throwForIllegalInvocation();
    }

    public List<Message> communicate(List<Message> aBatch) {
        this.myOutStream.sendBatch(aBatch);
        return this.myInStream.collectMessages();
    }

    public List<Message> communicate(Message aMessage) {
        this.myOutStream.sendMessage(aMessage);
        return this.myInStream.collectMessages();
    }

    public String getLastReturnArgument() {
        return this.myInStream.getLastArgument();
    }

    public void terminate() {
        try {
            if (this.myOutStream != null) {
                this.myOutStream.close();
            }
            if (this.myInStream != null) {
                this.myInStream.close();
            }
            if (this.myProcess != null) {
                this.myProcess.destroy();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.myOutStream = null;
            this.myInStream = null;
            this.myProcess = null;
        }
    }
}

