/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.format;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.ojalgo.function.UnaryFunction;

public class TransformationFormat<N extends Number>
extends NumberFormat {
    private final UnaryFunction<N> myTransfoFunc;
    private final UnaryFunction<N> myInverseFunc;
    private final NumberFormat myFormat;

    public TransformationFormat(UnaryFunction<N> transformer, NumberFormat format, UnaryFunction<N> inverse) {
        this.myTransfoFunc = transformer;
        this.myFormat = format;
        this.myInverseFunc = inverse;
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.myFormat.format(this.myTransfoFunc.invoke(number), toAppendTo, pos);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.myFormat.format(this.myTransfoFunc.invoke(number), toAppendTo, pos);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        return this.myFormat.format(this.myTransfoFunc.invoke((Number)obj), toAppendTo, pos);
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        return this.myInverseFunc.invoke((Number)this.myFormat.parseObject(source, parsePosition));
    }
}

