/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.spi;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.shaded.com.google.common.base.Objects;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.shaded.com.google.inject.Binder;
import org.apache.hadoop.shaded.com.google.inject.internal.Errors;
import org.apache.hadoop.shaded.com.google.inject.internal.util.SourceProvider;
import org.apache.hadoop.shaded.com.google.inject.spi.Element;
import org.apache.hadoop.shaded.com.google.inject.spi.ElementVisitor;

public final class Message
implements Serializable,
Element {
    private final String message;
    private final Throwable cause;
    private final List<Object> sources;
    private static final long serialVersionUID = 0L;

    public Message(List<Object> sources, String message, Throwable cause) {
        this.sources = ImmutableList.copyOf(sources);
        this.message = (String)Preconditions.checkNotNull((Object)message, (Object)"message");
        this.cause = cause;
    }

    public Message(String message, Throwable cause) {
        this((List<Object>)ImmutableList.of(), message, cause);
    }

    public Message(Object source, String message) {
        this((List<Object>)ImmutableList.of((Object)source), message, null);
    }

    public Message(String message) {
        this((List<Object>)ImmutableList.of(), message, null);
    }

    @Override
    public String getSource() {
        return this.sources.isEmpty() ? SourceProvider.UNKNOWN_SOURCE.toString() : Errors.convert(this.sources.get(this.sources.size() - 1)).toString();
    }

    public List<Object> getSources() {
        return this.sources;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String toString() {
        return this.message;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.message, this.cause, this.sources});
    }

    public boolean equals(Object o) {
        if (!(o instanceof Message)) {
            return false;
        }
        Message e = (Message)o;
        return this.message.equals(e.message) && Objects.equal((Object)this.cause, (Object)e.cause) && this.sources.equals(e.sources);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).addError(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        Object[] sourcesAsStrings = this.sources.toArray();
        for (int i = 0; i < sourcesAsStrings.length; ++i) {
            sourcesAsStrings[i] = Errors.convert(sourcesAsStrings[i]).toString();
        }
        return new Message((List<Object>)ImmutableList.copyOf((Object[])sourcesAsStrings), this.message, this.cause);
    }
}

