/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.CollectionType;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.lib.DocumentStoreFactory;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.writer.DocumentStoreWriter;
import org.apache.hadoop.yarn.server.timelineservice.storage.SchemaCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentStoreCollectionCreator
implements SchemaCreator {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentStoreCollectionCreator.class);

    public void createTimelineSchema(String[] args) {
        try {
            YarnConfiguration conf = new YarnConfiguration();
            LOG.info("Creating database and collections for DocumentStore : {}", (Object)DocumentStoreUtils.getStoreVendor((Configuration)conf));
            try (DocumentStoreWriter documentStoreWriter = DocumentStoreFactory.createDocumentStoreWriter((Configuration)conf);){
                documentStoreWriter.createDatabase();
                documentStoreWriter.createCollection(CollectionType.APPLICATION.getCollectionName());
                documentStoreWriter.createCollection(CollectionType.ENTITY.getCollectionName());
                documentStoreWriter.createCollection(CollectionType.FLOW_ACTIVITY.getCollectionName());
                documentStoreWriter.createCollection(CollectionType.FLOW_RUN.getCollectionName());
            }
        }
        catch (Exception e) {
            LOG.error("Error while creating Timeline Collections", (Throwable)e);
        }
    }
}

