/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.DateTieredMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.compactions.AbstractMultiOutputCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DateTieredCompactor
extends AbstractMultiOutputCompactor<DateTieredMultiFileWriter> {
    private static final Logger LOG = LoggerFactory.getLogger(DateTieredCompactor.class);

    public DateTieredCompactor(Configuration conf, HStore store) {
        super(conf, store);
    }

    protected boolean needEmptyFile(CompactionRequestImpl request) {
        OptionalLong maxSeqId = StoreUtils.getMaxSequenceIdInList(request.getFiles());
        OptionalLong storeMaxSeqId = this.store.getMaxSequenceId();
        return maxSeqId.isPresent() && storeMaxSeqId.isPresent() && maxSeqId.getAsLong() == storeMaxSeqId.getAsLong();
    }

    public List<Path> compact(final CompactionRequestImpl request, final List<Long> lowerBoundaries, final Map<Long, String> lowerBoundariesPolicies, ThroughputController throughputController, User user) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing compaction with " + lowerBoundaries.size() + "windows, lower boundaries: " + lowerBoundaries);
        }
        return this.compact(request, this.defaultScannerFactory, new Compactor.CellSinkFactory<DateTieredMultiFileWriter>(){

            @Override
            public DateTieredMultiFileWriter createWriter(InternalScanner scanner, Compactor.FileDetails fd, boolean shouldDropBehind, boolean major, Consumer<Path> writerCreationTracker) throws IOException {
                DateTieredMultiFileWriter writer = DateTieredCompactor.this.createMultiWriter(request, lowerBoundaries, lowerBoundariesPolicies);
                DateTieredCompactor.this.initMultiWriter(writer, scanner, fd, shouldDropBehind, major, writerCreationTracker);
                return writer;
            }
        }, throughputController, user);
    }

    protected DateTieredMultiFileWriter createMultiWriter(CompactionRequestImpl request, List<Long> lowerBoundaries, Map<Long, String> lowerBoundariesPolicies) {
        return new DateTieredMultiFileWriter(lowerBoundaries, lowerBoundariesPolicies, this.needEmptyFile(request), c -> c.getTimestamp());
    }

    @Override
    protected List<Path> commitWriter(DateTieredMultiFileWriter writer, Compactor.FileDetails fd, CompactionRequestImpl request) throws IOException {
        List<Path> pathList = writer.commitWriters(fd.maxSeqId, request.isAllFiles(), request.getFiles());
        return pathList;
    }
}

