/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.balancer.RegionLocationFinder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRegionLocationFinder {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionLocationFinder.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static MiniHBaseCluster cluster;
    private static final TableName tableName;
    private static final byte[] FAMILY;
    private static Table table;
    private static final int ServerNum = 5;
    private static RegionLocationFinder finder;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        cluster = TEST_UTIL.startMiniCluster(5);
        table = TEST_UTIL.createTable(tableName, FAMILY, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        TEST_UTIL.waitTableAvailable(tableName, 1000L);
        TEST_UTIL.loadTable(table, FAMILY);
        for (int i = 0; i < 5; ++i) {
            HRegionServer server = cluster.getRegionServer(i);
            for (HRegion region : server.getRegions(tableName)) {
                region.flush(true);
            }
        }
        finder.setConf(TEST_UTIL.getConfiguration());
        finder.setServices((MasterServices)cluster.getMaster());
        finder.setClusterMetrics(cluster.getMaster().getClusterMetrics());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        table.close();
        TEST_UTIL.deleteTable(tableName);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testInternalGetTopBlockLocation() throws Exception {
        for (int i = 0; i < 5; ++i) {
            HRegionServer server = cluster.getRegionServer(i);
            for (HRegion region : server.getRegions(tableName)) {
                HDFSBlocksDistribution blocksDistribution1 = region.getHDFSBlocksDistribution();
                HDFSBlocksDistribution blocksDistribution2 = finder.getBlockDistribution(region.getRegionInfo());
                Assert.assertEquals((long)blocksDistribution1.getUniqueBlocksTotalWeight(), (long)blocksDistribution2.getUniqueBlocksTotalWeight());
                if (blocksDistribution1.getUniqueBlocksTotalWeight() == 0L) continue;
                Assert.assertEquals(blocksDistribution1.getTopHosts().get(0), blocksDistribution2.getTopHosts().get(0));
            }
        }
    }

    @Test
    public void testMapHostNameToServerName() throws Exception {
        ArrayList<String> topHosts = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            HRegionServer server = cluster.getRegionServer(i);
            String serverHost = server.getServerName().getHostname();
            if (topHosts.contains(serverHost)) continue;
            topHosts.add(serverHost);
        }
        List servers = finder.mapHostNameToServerName(topHosts);
        Assert.assertEquals((long)1L, (long)topHosts.size());
        for (int i = 0; i < 5; ++i) {
            ServerName server = cluster.getRegionServer(i).getServerName();
            Assert.assertTrue((boolean)servers.contains(server));
        }
    }

    @Test
    public void testGetTopBlockLocations() throws Exception {
        for (int i = 0; i < 5; ++i) {
            HRegionServer server = cluster.getRegionServer(i);
            for (HRegion region : server.getRegions(tableName)) {
                List topHosts;
                List servers = finder.getTopBlockLocations(region.getRegionInfo());
                if (region.getHDFSBlocksDistribution().getUniqueBlocksTotalWeight() == 0L || !(topHosts = region.getHDFSBlocksDistribution().getTopHosts()).contains(server.getServerName().getHostname())) continue;
                for (int j = 0; j < 5; ++j) {
                    ServerName serverName = cluster.getRegionServer(j).getServerName();
                    Assert.assertTrue((boolean)servers.contains(serverName));
                }
            }
        }
    }

    @Test
    public void testRefreshAndWait() throws Exception {
        finder.getCache().invalidateAll();
        for (int i = 0; i < 5; ++i) {
            HRegionServer server = cluster.getRegionServer(i);
            List regions = server.getRegions(tableName);
            if (regions.size() <= 0) continue;
            ArrayList<RegionInfo> regionInfos = new ArrayList<RegionInfo>(regions.size());
            for (HRegion region : regions) {
                regionInfos.add(region.getRegionInfo());
            }
            finder.refreshAndWait(regionInfos);
            for (RegionInfo regionInfo : regionInfos) {
                Assert.assertNotNull((Object)finder.getCache().getIfPresent((Object)regionInfo));
            }
        }
    }

    @Test
    public void testRefreshRegionsWithChangedLocality() throws InterruptedException {
        HDFSBlocksDistribution newValue;
        HDFSBlocksDistribution hbd;
        TableDescriptor table = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"RegionLocationFinder")).build();
        int numRegions = 100;
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>(numRegions);
        for (int i = 1; i <= numRegions; ++i) {
            byte[] startKey = i == 0 ? HConstants.EMPTY_START_ROW : Bytes.toBytes((int)i);
            byte[] endKey = i == numRegions ? HConstants.EMPTY_BYTE_ARRAY : Bytes.toBytes((int)(i + 1));
            RegionInfo region = RegionInfoBuilder.newBuilder((TableName)table.getTableName()).setStartKey(startKey).setEndKey(endKey).build();
            regions.add(region);
        }
        ServerName testServer = ServerName.valueOf((String)"host-0", (int)12345, (long)12345L);
        RegionInfo testRegion = (RegionInfo)regions.get(0);
        RegionLocationFinder finder = new RegionLocationFinder(){

            protected HDFSBlocksDistribution internalGetTopBlockLocation(RegionInfo region) {
                return TestRegionLocationFinder.generate(region);
            }
        };
        HashMap<RegionInfo, HDFSBlocksDistribution> cache = new HashMap<RegionInfo, HDFSBlocksDistribution>();
        for (RegionInfo region : regions) {
            hbd = finder.getBlockDistribution(region);
            cache.put(region, hbd);
        }
        finder.setClusterMetrics(this.getMetricsWithLocality(testServer, testRegion.getRegionName(), 0.123f));
        for (RegionInfo region : regions) {
            hbd = finder.getBlockDistribution(region);
            Assert.assertSame(cache.get(region), (Object)hbd);
        }
        finder.setClusterMetrics(this.getMetricsWithLocality(testServer, testRegion.getRegionName(), 0.345f));
        long now = System.currentTimeMillis();
        HDFSBlocksDistribution cached = (HDFSBlocksDistribution)cache.get(testRegion);
        do {
            Thread.sleep(1000L);
        } while (cached == (newValue = finder.getBlockDistribution(testRegion)) && System.currentTimeMillis() - now < 30000L);
        for (RegionInfo region : regions) {
            HDFSBlocksDistribution hbd2 = finder.getBlockDistribution(region);
            if (region.equals(testRegion)) {
                Assert.assertNotSame(cache.get(region), (Object)hbd2);
                continue;
            }
            Assert.assertSame(cache.get(region), (Object)hbd2);
        }
    }

    private static HDFSBlocksDistribution generate(RegionInfo region) {
        HDFSBlocksDistribution distribution = new HDFSBlocksDistribution();
        int seed = region.hashCode();
        Random rand = new Random(seed);
        int size = 1 + rand.nextInt(10);
        for (int i = 0; i < size; ++i) {
            distribution.addHostsAndBlockWeight(new String[]{"host-" + i}, (long)(1 + rand.nextInt(100)));
        }
        return distribution;
    }

    private ClusterMetrics getMetricsWithLocality(ServerName serverName, byte[] region, float locality) {
        RegionMetrics regionMetrics = (RegionMetrics)Mockito.mock(RegionMetrics.class);
        Mockito.when((Object)Float.valueOf(regionMetrics.getDataLocality())).thenReturn((Object)Float.valueOf(locality));
        TreeMap<byte[], RegionMetrics> regionMetricsMap = new TreeMap<byte[], RegionMetrics>(Bytes.BYTES_COMPARATOR);
        regionMetricsMap.put(region, regionMetrics);
        ServerMetrics serverMetrics = (ServerMetrics)Mockito.mock(ServerMetrics.class);
        Mockito.when((Object)serverMetrics.getRegionMetrics()).thenReturn(regionMetricsMap);
        HashMap<ServerName, ServerMetrics> serverMetricsMap = new HashMap<ServerName, ServerMetrics>();
        serverMetricsMap.put(serverName, serverMetrics);
        ClusterMetrics metrics = (ClusterMetrics)Mockito.mock(ClusterMetrics.class);
        Mockito.when((Object)metrics.getLiveServerMetrics()).thenReturn(serverMetricsMap);
        return metrics;
    }

    static {
        tableName = TableName.valueOf((String)"table");
        FAMILY = Bytes.toBytes((String)"cf");
        finder = new RegionLocationFinder();
    }
}

