/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.mqtt;

import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.hertzbeat.collector.collect.mqtt.CertificateFormatter;
import org.apache.hertzbeat.common.entity.job.protocol.MqttProtocol;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class MqttSslFactory {
    public static SSLSocketFactory getMslSocketFactory(MqttProtocol mqttProtocol, boolean insecureSkipVerify) {
        try {
            TrustManager[] trustManagers;
            Security.addProvider((Provider)new BouncyCastleProvider());
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, null);
            Certificate[] chain = null;
            if (mqttProtocol.getClientCert() != null && !mqttProtocol.getClientCert().isEmpty()) {
                String formatClientCert = CertificateFormatter.formatCertificateChain(mqttProtocol.getClientCert());
                try (ByteArrayInputStream certIn = new ByteArrayInputStream(formatClientCert.getBytes());){
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    Collection<? extends Certificate> certs = cf.generateCertificates(certIn);
                    chain = certs.toArray(new Certificate[0]);
                }
            }
            if (mqttProtocol.getClientKey() != null && !mqttProtocol.getClientKey().isEmpty()) {
                String formatClientKey = CertificateFormatter.formatPrivateKey(mqttProtocol.getClientKey());
                try (PEMParser pemParser = new PEMParser((Reader)new StringReader(formatClientKey));){
                    PrivateKey privateKey;
                    JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
                    Object object = pemParser.readObject();
                    if (object instanceof PEMKeyPair) {
                        privateKey = converter.getPrivateKey(((PEMKeyPair)object).getPrivateKeyInfo());
                    } else if (object instanceof PrivateKeyInfo) {
                        privateKey = converter.getPrivateKey((PrivateKeyInfo)object);
                    } else {
                        throw new IllegalArgumentException("Unsupported private key type");
                    }
                    ks.setKeyEntry("private-key", privateKey, "".toCharArray(), chain);
                }
            }
            if (insecureSkipVerify) {
                trustManagers = MqttSslFactory.createInsecureTrustManager();
            } else {
                String formatCaCert = CertificateFormatter.formatCertificateChain(mqttProtocol.getCaCert());
                KeyStore trustStore = MqttSslFactory.createMergedTrustStore(formatCaCert);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(trustStore);
                trustManagers = tmf.getTrustManagers();
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, "".toCharArray());
            SSLContext context = SSLContext.getInstance(mqttProtocol.getTlsVersion());
            context.init(kmf.getKeyManagers(), trustManagers, null);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException("Fails to SSL initialize: " + e.getMessage(), e);
        }
    }

    public static SSLSocketFactory getSslSocketFactory(MqttProtocol mqttProtocol, boolean insecureSkipVerify) {
        try {
            TrustManager[] trustManagers;
            Security.addProvider((Provider)new BouncyCastleProvider());
            if (insecureSkipVerify) {
                trustManagers = MqttSslFactory.createInsecureTrustManager();
            } else {
                String formatCaCert = CertificateFormatter.formatCertificateChain(mqttProtocol.getCaCert());
                KeyStore trustStore = MqttSslFactory.createMergedTrustStore(formatCaCert);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(trustStore);
                trustManagers = tmf.getTrustManagers();
            }
            SSLContext sslContext = SSLContext.getInstance(mqttProtocol.getTlsVersion());
            sslContext.init(null, trustManagers, null);
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException("Fails to SSL initialize: " + e.getMessage(), e);
        }
    }

    private static TrustManager[] createInsecureTrustManager() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
    }

    private static KeyStore createMergedTrustStore(String caCertPem) throws Exception {
        KeyStore mergedKs = KeyStore.getInstance(KeyStore.getDefaultType());
        mergedKs.load(null, null);
        TrustManagerFactory systemTmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        systemTmf.init((KeyStore)null);
        X509TrustManager systemTm = (X509TrustManager)systemTmf.getTrustManagers()[0];
        int systemIndex = 1;
        for (X509Certificate cert : systemTm.getAcceptedIssuers()) {
            mergedKs.setCertificateEntry("system-ca-" + systemIndex++, cert);
        }
        if (caCertPem != null && !caCertPem.isEmpty()) {
            try (ByteArrayInputStream caIn = new ByteArrayInputStream(caCertPem.getBytes());){
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> customCerts = cf.generateCertificates(caIn);
                int customIndex = 1;
                for (Certificate certificate : customCerts) {
                    mergedKs.setCertificateEntry("custom-ca-" + customIndex++, certificate);
                }
            }
        }
        return mergedKs;
    }
}

