/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.column.add;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.column.add.AlterTableAddColumnsDesc;
import org.apache.hadoop.hive.ql.ddl.table.constraint.ConstraintsUtils;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={864})
public class AlterTableAddColumnsAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableAddColumnsAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        ArrayList<ConstraintsUtils.ConstraintInfo> defaultConstraintsInfo = new ArrayList<ConstraintsUtils.ConstraintInfo>();
        List<FieldSchema> newCols = AlterTableAddColumnsAnalyzer.getColumns((ASTNode)command.getChild(0), true, this.ctx.getTokenRewriteStream(), new ArrayList<SQLPrimaryKey>(), new ArrayList<SQLForeignKey>(), new ArrayList<SQLUniqueConstraint>(), new ArrayList<SQLNotNullConstraint>(), defaultConstraintsInfo, new ArrayList<SQLCheckConstraint>(), (Configuration)this.conf);
        boolean isCascade = false;
        if (null != command.getFirstChildWithType(940)) {
            isCascade = true;
        }
        AlterTableAddColumnsDesc desc = new AlterTableAddColumnsDesc(tableName, partitionSpec, isCascade, newCols);
        Table table = this.getTable(tableName, true);
        if (AcidUtils.isTransactionalTable(table)) {
            this.setAcidDdlDesc(desc);
        }
        this.addInputsOutputsAlterTable(tableName, partitionSpec, desc, desc.getType(), false);
        DDLUtils.setDefaultColumnValues(table, tableName, defaultConstraintsInfo, (Configuration)this.conf);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

