/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.mr;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectCache
implements org.apache.hadoop.hive.ql.exec.ObjectCache {
    private static final Logger LOG = LoggerFactory.getLogger((String)ObjectCache.class.getName());
    private final Map<String, Object> cache = new ConcurrentHashMap<String, Object>();

    @Override
    public void release(String key) {
        LOG.debug("{} no longer needed", (Object)key);
        this.cache.remove(key);
    }

    @Override
    public <T> T retrieve(String key) throws HiveException {
        return (T)this.cache.get(key);
    }

    @Override
    public <T> T retrieve(String key, Callable<T> fn) throws HiveException {
        Object value = this.cache.get(key);
        if (value != null || fn == null) {
            return (T)value;
        }
        try {
            LOG.debug("Creating {}", (Object)key);
            value = fn.call();
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        Object previous = this.cache.putIfAbsent(key, value);
        return (T)(previous != null ? previous : value);
    }

    @Override
    public <T> Future<T> retrieveAsync(String key, Callable<T> fn) throws HiveException {
        final T value = this.retrieve(key, fn);
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                return value;
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return value;
            }
        };
    }

    @Override
    public void remove(String key) {
        this.cache.remove(key);
    }
}

