/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.kinesis;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.io.kinesis.KinesisIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.transforms.kinesis.KinesisRecordToHopRowFn;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamKinesisConsumeTransform
extends PTransform<PBegin, PCollection<HopRow>> {
    private String transformName;
    private String rowMetaJson;
    private String accessKey;
    private String secretKey;
    private Regions regions;
    private String streamName;
    private String uniqueIdField;
    private String dataField;
    private String dataType;
    private String partitionKeyField;
    private String sequenceNumberField;
    private String subSequenceNumberField;
    private String shardIdField;
    private String streamNameField;
    private String maxNumRecords;
    private String maxReadTimeMs;
    private String upToDateThresholdMs;
    private String requestRecordsLimit;
    private boolean arrivalTimeWatermarkPolicy;
    private String arrivalTimeWatermarkPolicyMs;
    private boolean processingTimeWatermarkPolicy;
    private boolean fixedDelayRatePolicy;
    private String fixedDelayRatePolicyMs;
    private String maxCapacityPerShard;
    private static final Logger LOG = LoggerFactory.getLogger(BeamKinesisConsumeTransform.class);
    private static final Counter numErrors = Metrics.counter((String)"main", (String)"BeamKinesisConsumerError");

    public BeamKinesisConsumeTransform() {
    }

    public BeamKinesisConsumeTransform(String transformName, String accessKey, String secretKey, Regions regions, String rowMetaJson, String streamName, String uniqueIdField, String dataField, String dataType, String partitionKeyField, String sequenceNumberField, String subSequenceNumberField, String shardIdField, String streamNameField, String maxNumRecords, String maxReadTimeMs, String upToDateThresholdMs, String requestRecordsLimit, boolean arrivalTimeWatermarkPolicy, String arrivalTimeWatermarkPolicyMs, boolean processingTimeWatermarkPolicy, boolean fixedDelayRatePolicy, String fixedDelayRatePolicyMs, String maxCapacityPerShard) {
        super(transformName);
        this.transformName = transformName;
        this.rowMetaJson = rowMetaJson;
        this.streamName = streamName;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.regions = regions;
        this.uniqueIdField = uniqueIdField;
        this.dataField = dataField;
        this.dataType = dataType;
        this.partitionKeyField = partitionKeyField;
        this.sequenceNumberField = sequenceNumberField;
        this.subSequenceNumberField = subSequenceNumberField;
        this.shardIdField = shardIdField;
        this.streamNameField = streamNameField;
        this.maxNumRecords = maxNumRecords;
        this.maxReadTimeMs = maxReadTimeMs;
        this.upToDateThresholdMs = upToDateThresholdMs;
        this.requestRecordsLimit = requestRecordsLimit;
        this.arrivalTimeWatermarkPolicy = arrivalTimeWatermarkPolicy;
        this.arrivalTimeWatermarkPolicyMs = arrivalTimeWatermarkPolicyMs;
        this.processingTimeWatermarkPolicy = processingTimeWatermarkPolicy;
        this.fixedDelayRatePolicy = fixedDelayRatePolicy;
        this.fixedDelayRatePolicyMs = fixedDelayRatePolicyMs;
        this.maxCapacityPerShard = maxCapacityPerShard;
        if (!"String".equalsIgnoreCase(dataType)) {
            throw new RuntimeException("Only String messages are supported at this time");
        }
    }

    public PCollection<HopRow> expand(PBegin input) {
        try {
            BeamHop.init();
            KinesisIO.Read kinesisRecordRead = KinesisIO.read().withAWSClientsProvider(this.accessKey, this.secretKey, this.regions).withStreamName(this.streamName).withInitialPositionInStream(InitialPositionInStream.LATEST);
            if (StringUtils.isNotEmpty((String)this.maxNumRecords)) {
                kinesisRecordRead = kinesisRecordRead.withMaxNumRecords(Long.parseLong(this.maxNumRecords));
            }
            if (StringUtils.isNotEmpty((String)this.maxReadTimeMs)) {
                kinesisRecordRead = kinesisRecordRead.withMaxReadTime(Duration.millis((long)Long.parseLong(this.maxReadTimeMs)));
            }
            if (StringUtils.isNotEmpty((String)this.upToDateThresholdMs)) {
                kinesisRecordRead = kinesisRecordRead.withUpToDateThreshold(Duration.millis((long)Long.parseLong(this.upToDateThresholdMs)));
            }
            if (StringUtils.isNotEmpty((String)this.requestRecordsLimit)) {
                kinesisRecordRead = kinesisRecordRead.withRequestRecordsLimit(Integer.parseInt(this.requestRecordsLimit));
            }
            if (this.arrivalTimeWatermarkPolicy) {
                kinesisRecordRead = kinesisRecordRead.withArrivalTimeWatermarkPolicy();
                if (StringUtils.isNotEmpty((String)this.arrivalTimeWatermarkPolicyMs)) {
                    kinesisRecordRead = kinesisRecordRead.withArrivalTimeWatermarkPolicy(Duration.millis((long)Long.parseLong(this.arrivalTimeWatermarkPolicyMs)));
                }
            }
            if (this.processingTimeWatermarkPolicy) {
                kinesisRecordRead = kinesisRecordRead.withProcessingTimeWatermarkPolicy();
            }
            if (this.fixedDelayRatePolicy) {
                kinesisRecordRead = kinesisRecordRead.withFixedDelayRateLimitPolicy();
                if (StringUtils.isNotEmpty((String)this.fixedDelayRatePolicyMs)) {
                    kinesisRecordRead = kinesisRecordRead.withFixedDelayRateLimitPolicy(Duration.millis((long)Long.parseLong(this.fixedDelayRatePolicyMs)));
                }
            }
            if (StringUtils.isNotEmpty((String)this.maxCapacityPerShard)) {
                kinesisRecordRead = kinesisRecordRead.withMaxCapacityPerShard(Integer.valueOf(Integer.parseInt(this.maxCapacityPerShard)));
            }
            PCollection kinesisRecordPCollection = (PCollection)input.apply((PTransform)kinesisRecordRead);
            KinesisRecordToHopRowFn recordToRowFn = new KinesisRecordToHopRowFn(this.transformName, this.rowMetaJson, this.uniqueIdField, this.partitionKeyField, this.sequenceNumberField, this.subSequenceNumberField, this.shardIdField, this.streamNameField);
            PCollection output = (PCollection)kinesisRecordPCollection.apply((PTransform)ParDo.of((DoFn)recordToRowFn));
            return output;
        }
        catch (Exception e) {
            numErrors.inc();
            LOG.error("Error in Kafka input transform", (Throwable)e);
            throw new RuntimeException("Error in Kafka input transform", e);
        }
    }

    public static final class KVStringGenericRecordToHopRowFn
    extends DoFn<KV<String, GenericRecord>, HopRow> {
        private final String rowMetaJson;
        private final String transformName;
        private final Logger LOG = LoggerFactory.getLogger(KVStringGenericRecordToHopRowFn.class);
        private final Counter numErrors = Metrics.counter((String)"main", (String)"BeamSubscribeTransformErrors");
        private IRowMeta rowMeta;
        private transient Counter inputCounter;
        private transient Counter writtenCounter;

        public KVStringGenericRecordToHopRowFn(String transformName, String rowMetaJson) {
            this.transformName = transformName;
            this.rowMetaJson = rowMetaJson;
        }

        @DoFn.Setup
        public void setUp() {
            try {
                this.inputCounter = Metrics.counter((String)"input", (String)this.transformName);
                this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
                BeamHop.init();
                this.rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
                Metrics.counter((String)"init", (String)this.transformName).inc();
            }
            catch (Exception e) {
                this.numErrors.inc();
                this.LOG.error("Error in setup of KV<String,GenericRecord> to Hop Row conversion function", (Throwable)e);
                throw new RuntimeException("Error in setup of KV<String,GenericRecord> to Hop Row conversion function", e);
            }
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext processContext) {
            try {
                KV kv = (KV)processContext.element();
                this.inputCounter.inc();
                Object[] outputRow = new Object[this.rowMeta.size()];
                outputRow[0] = kv.getKey();
                outputRow[1] = kv.getValue();
                processContext.output((Object)new HopRow(outputRow));
                this.writtenCounter.inc();
            }
            catch (Exception e) {
                this.numErrors.inc();
                this.LOG.error("Error in KV<String,GenericRecord> to Hop Row conversion function", (Throwable)e);
                throw new RuntimeException("Error in KV<String,GenericRecord> to Hop Row conversion function", e);
            }
        }
    }

    public static final class KVStringStringToHopRowFn
    extends DoFn<KV<String, String>, HopRow> {
        private final String rowMetaJson;
        private final String transformName;
        private final Logger LOG = LoggerFactory.getLogger(KVStringStringToHopRowFn.class);
        private final Counter numErrors = Metrics.counter((String)"main", (String)"BeamSubscribeTransformErrors");
        private IRowMeta rowMeta;
        private transient Counter inputCounter;
        private transient Counter writtenCounter;

        public KVStringStringToHopRowFn(String transformName, String rowMetaJson) {
            this.transformName = transformName;
            this.rowMetaJson = rowMetaJson;
        }

        @DoFn.Setup
        public void setUp() {
            try {
                this.inputCounter = Metrics.counter((String)"input", (String)this.transformName);
                this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
                BeamHop.init();
                this.rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
                Metrics.counter((String)"init", (String)this.transformName).inc();
            }
            catch (Exception e) {
                this.numErrors.inc();
                this.LOG.error("Error in setup of KV<String,String> to Hop Row conversion function", (Throwable)e);
                throw new RuntimeException("Error in setup of KV<String,String> to Hop Row conversion function", e);
            }
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext processContext) {
            try {
                KV kv = (KV)processContext.element();
                this.inputCounter.inc();
                Object[] outputRow = new Object[this.rowMeta.size()];
                outputRow[0] = kv.getKey();
                outputRow[1] = kv.getValue();
                processContext.output((Object)new HopRow(outputRow));
                this.writtenCounter.inc();
            }
            catch (Exception e) {
                this.numErrors.inc();
                this.LOG.error("Error in KV<String,String> to Hop Row conversion function", (Throwable)e);
                throw new RuntimeException("Error in KV<String,String> to Hop Row conversion function", e);
            }
        }
    }
}

