/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.snowflake.client.jdbc.internal.com.nimbusds.common.contenttype.ContentType;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.AbstractOptionallyIdentifiedRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.OAuth2Error;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParameterRequirement;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.Scope;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.SerializeException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.ClientID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.rar.AuthorizationDetail;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.RefreshToken;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.MapUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.ResourceUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.StringUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.URLUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.nativesso.DeviceSecret;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;

@Immutable
public class TokenRequest
extends AbstractOptionallyIdentifiedRequest {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final AuthorizationGrant authzGrant;
    private final Scope scope;
    private final List<AuthorizationDetail> authorizationDetails;
    private final List<URI> resources;
    private final RefreshToken existingGrant;
    private final DeviceSecret deviceSecret;
    private final Map<String, List<String>> customParams;
    private static final Set<String> ALLOWED_REPEATED_PARAMS;

    public TokenRequest(URI endpoint, ClientAuthentication clientAuth, AuthorizationGrant authzGrant, Scope scope) {
        this(endpoint, clientAuth, authzGrant, scope, null, null);
    }

    @Deprecated
    public TokenRequest(URI endpoint, ClientAuthentication clientAuth, AuthorizationGrant authzGrant, Scope scope, List<URI> resources, Map<String, List<String>> customParams) {
        this(endpoint, clientAuth, authzGrant, scope, null, resources, customParams);
    }

    @Deprecated
    public TokenRequest(URI endpoint, ClientAuthentication clientAuth, AuthorizationGrant authzGrant, Scope scope, List<AuthorizationDetail> authorizationDetails, List<URI> resources, Map<String, List<String>> customParams) {
        this(endpoint, clientAuth, authzGrant, scope, authorizationDetails, resources, null, customParams);
    }

    @Deprecated
    public TokenRequest(URI endpoint, ClientAuthentication clientAuth, AuthorizationGrant authzGrant) {
        this(endpoint, clientAuth, authzGrant, null);
    }

    public TokenRequest(URI endpoint, ClientID clientID, AuthorizationGrant authzGrant, Scope scope) {
        this(endpoint, clientID, authzGrant, scope, null, null, null);
    }

    @Deprecated
    public TokenRequest(URI endpoint, ClientID clientID, AuthorizationGrant authzGrant, Scope scope, List<URI> resources, RefreshToken existingGrant, Map<String, List<String>> customParams) {
        this(endpoint, clientID, authzGrant, scope, null, resources, existingGrant, customParams);
    }

    @Deprecated
    public TokenRequest(URI endpoint, ClientID clientID, AuthorizationGrant authzGrant, Scope scope, List<AuthorizationDetail> authorizationDetails, List<URI> resources, RefreshToken existingGrant, Map<String, List<String>> customParams) {
        this(endpoint, clientID, authzGrant, scope, authorizationDetails, resources, existingGrant, null, customParams);
    }

    @Deprecated
    public TokenRequest(URI endpoint, ClientID clientID, AuthorizationGrant authzGrant) {
        this(endpoint, clientID, authzGrant, null);
    }

    public TokenRequest(URI endpoint, AuthorizationGrant authzGrant, Scope scope) {
        this(endpoint, (ClientID)null, authzGrant, scope);
    }

    @Deprecated
    public TokenRequest(URI endpoint, AuthorizationGrant authzGrant) {
        this(endpoint, (ClientID)null, authzGrant, null);
    }

    public TokenRequest(URI endpoint, ClientAuthentication clientAuth, AuthorizationGrant authzGrant, Scope scope, List<AuthorizationDetail> authorizationDetails, List<URI> resources, DeviceSecret deviceSecret, Map<String, List<String>> customParams) {
        super(endpoint, Objects.requireNonNull(clientAuth));
        this.authzGrant = Objects.requireNonNull(authzGrant);
        this.scope = scope;
        if (resources != null) {
            for (URI resourceURI : resources) {
                if (ResourceUtils.isLegalResourceURI(resourceURI)) continue;
                throw new IllegalArgumentException("Resource URI must be absolute and with no query or fragment: " + resourceURI);
            }
        }
        this.authorizationDetails = authorizationDetails;
        this.resources = resources;
        this.existingGrant = null;
        this.deviceSecret = deviceSecret;
        this.customParams = MapUtils.isNotEmpty(customParams) ? customParams : Collections.emptyMap();
    }

    public TokenRequest(URI endpoint, ClientID clientID, AuthorizationGrant authzGrant, Scope scope, List<AuthorizationDetail> authorizationDetails, List<URI> resources, RefreshToken existingGrant, DeviceSecret deviceSecret, Map<String, List<String>> customParams) {
        super(endpoint, clientID);
        if (authzGrant.getType().requiresClientAuthentication()) {
            throw new IllegalArgumentException("The \"" + authzGrant.getType() + "\" grant type requires client authentication");
        }
        if (authzGrant.getType().requiresClientID() && clientID == null) {
            throw new IllegalArgumentException("The \"" + authzGrant.getType() + "\" grant type requires a \"client_id\" parameter");
        }
        this.authzGrant = authzGrant;
        this.scope = scope;
        if (resources != null) {
            for (URI resourceURI : resources) {
                if (ResourceUtils.isLegalResourceURI(resourceURI)) continue;
                throw new IllegalArgumentException("Resource URI must be absolute and with no query or fragment: " + resourceURI);
            }
        }
        this.authorizationDetails = authorizationDetails;
        this.resources = resources;
        this.existingGrant = existingGrant;
        this.deviceSecret = deviceSecret;
        this.customParams = MapUtils.isNotEmpty(customParams) ? customParams : Collections.emptyMap();
    }

    public AuthorizationGrant getAuthorizationGrant() {
        return this.authzGrant;
    }

    public Scope getScope() {
        return this.scope;
    }

    public List<AuthorizationDetail> getAuthorizationDetails() {
        return this.authorizationDetails;
    }

    public List<URI> getResources() {
        return this.resources;
    }

    public RefreshToken getExistingGrant() {
        return this.existingGrant;
    }

    public DeviceSecret getDeviceSecret() {
        return this.deviceSecret;
    }

    public Map<String, List<String>> getCustomParameters() {
        return Collections.unmodifiableMap(this.customParams);
    }

    public List<String> getCustomParameter(String name) {
        return this.customParams.get(name);
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        LinkedHashMap<String, List<String>> params;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        httpRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(httpRequest);
        }
        try {
            params = new LinkedHashMap<String, List<String>>(httpRequest.getBodyAsFormParameters());
        }
        catch (ParseException e) {
            throw new SerializeException(e.getMessage(), e);
        }
        params.putAll(this.getAuthorizationGrant().toParameters());
        switch (this.getAuthorizationGrant().getType().getScopeRequirementInTokenRequest()) {
            case REQUIRED: {
                if (CollectionUtils.isEmpty(this.getScope())) {
                    throw new SerializeException("Scope is required for the " + this.getAuthorizationGrant().getType() + " grant");
                }
                params.put("scope", Collections.singletonList(this.getScope().toString()));
                break;
            }
            case OPTIONAL: {
                if (!CollectionUtils.isNotEmpty(this.getScope())) break;
                params.put("scope", Collections.singletonList(this.getScope().toString()));
                break;
            }
        }
        if (this.getClientID() != null) {
            params.put("client_id", Collections.singletonList(this.getClientID().getValue()));
        }
        if (this.getAuthorizationDetails() != null) {
            params.put("authorization_details", Collections.singletonList(AuthorizationDetail.toJSONString(this.getAuthorizationDetails())));
        }
        if (this.getResources() != null) {
            LinkedList<String> values = new LinkedList<String>();
            for (URI uri : this.getResources()) {
                if (uri == null) continue;
                values.add(uri.toString());
            }
            params.put("resource", values);
        }
        if (this.getExistingGrant() != null) {
            params.put("existing_grant", Collections.singletonList(this.getExistingGrant().getValue()));
        }
        if (this.getDeviceSecret() != null) {
            params.put("device_secret", Collections.singletonList(this.getDeviceSecret().getValue()));
        }
        if (!this.getCustomParameters().isEmpty()) {
            params.putAll(this.getCustomParameters());
        }
        httpRequest.setBody(URLUtils.serializeParameters(params));
        return httpRequest;
    }

    public static TokenRequest parse(HTTPRequest httpRequest) throws ParseException {
        String rt;
        ClientAuthentication clientAuth;
        URI endpoint = httpRequest.getURI();
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        try {
            clientAuth = ClientAuthentication.parse(httpRequest);
        }
        catch (ParseException e) {
            throw new ParseException(e.getMessage(), OAuth2Error.INVALID_REQUEST.appendDescription(": " + e.getMessage()));
        }
        Map params = httpRequest.getBodyAsFormParameters();
        Set<String> repeatParams = MultivaluedMapUtils.getKeysWithMoreThanOneValue(params, ALLOWED_REPEATED_PARAMS);
        if (!repeatParams.isEmpty()) {
            String msg = "Parameter(s) present more than once: " + repeatParams;
            throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.setDescription(msg));
        }
        if (clientAuth instanceof ClientSecretBasic && (StringUtils.isNotBlank((CharSequence)MultivaluedMapUtils.getFirstValue(params, "client_assertion")) || StringUtils.isNotBlank((CharSequence)MultivaluedMapUtils.getFirstValue(params, "client_assertion_type")))) {
            String msg = "Multiple conflicting client authentication methods found: Basic and JWT assertion";
            throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.appendDescription(": " + msg));
        }
        AuthorizationGrant grant = AuthorizationGrant.parse(params);
        if (clientAuth == null && grant.getType().requiresClientAuthentication()) {
            String msg = "Missing client authentication";
            throw new ParseException(msg, OAuth2Error.INVALID_CLIENT.appendDescription(": " + msg));
        }
        ClientID clientID = null;
        if (clientAuth == null) {
            String clientIDString = (String)MultivaluedMapUtils.getFirstValue(params, "client_id");
            if (StringUtils.isNotBlank(clientIDString)) {
                clientID = new ClientID(clientIDString);
            }
            if (clientID == null && grant.getType().requiresClientID()) {
                String msg = "Missing required client_id parameter";
                throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.appendDescription(": " + msg));
            }
        }
        String scopeValue = (String)MultivaluedMapUtils.getFirstValue(params, "scope");
        ParameterRequirement scopeRequirement = grant.getType().getScopeRequirementInTokenRequest();
        Scope scope = null;
        if (scopeValue != null && (ParameterRequirement.REQUIRED.equals((Object)scopeRequirement) || ParameterRequirement.OPTIONAL.equals((Object)scopeRequirement))) {
            scope = Scope.parse(scopeValue);
        }
        String json = (String)MultivaluedMapUtils.getFirstValue(params, "authorization_details");
        List<AuthorizationDetail> authorizationDetails = null;
        if (json != null) {
            authorizationDetails = AuthorizationDetail.parseList(json);
        }
        LinkedList<URI> resources = null;
        List vList = (List)params.get("resource");
        if (vList != null) {
            resources = new LinkedList<URI>();
            for (String uriValue : vList) {
                URI resourceURI;
                if (uriValue == null) continue;
                String errMsg = "Illegal resource parameter: Must be an absolute URI without a fragment: " + uriValue;
                try {
                    resourceURI = new URI(uriValue);
                }
                catch (URISyntaxException e) {
                    throw new ParseException(errMsg, OAuth2Error.INVALID_TARGET.setDescription(errMsg));
                }
                if (!ResourceUtils.isLegalResourceURI(resourceURI)) {
                    throw new ParseException(errMsg, OAuth2Error.INVALID_TARGET.setDescription(errMsg));
                }
                resources.add(resourceURI);
            }
        }
        RefreshToken existingGrant = StringUtils.isNotBlank(rt = (String)MultivaluedMapUtils.getFirstValue(params, "existing_grant")) ? new RefreshToken(rt) : null;
        DeviceSecret deviceSecret = DeviceSecret.parse((String)MultivaluedMapUtils.getFirstValue(params, "device_secret"));
        HashMap<String, List<String>> customParams = new HashMap<String, List<String>>();
        for (Map.Entry p : params.entrySet()) {
            if (REGISTERED_PARAMETER_NAMES.contains(((String)p.getKey()).toLowerCase()) || grant.getType().getRequestParameterNames().contains(p.getKey())) continue;
            customParams.put((String)p.getKey(), (List<String>)p.getValue());
        }
        if (clientAuth != null) {
            return new TokenRequest(endpoint, clientAuth, grant, scope, authorizationDetails, resources, deviceSecret, customParams);
        }
        return new TokenRequest(endpoint, clientID, grant, scope, authorizationDetails, resources, existingGrant, deviceSecret, customParams);
    }

    static {
        HashSet<String> p = new HashSet<String>();
        p.add("grant_type");
        p.add("client_id");
        p.add("client_secret");
        p.add("client_assertion_type");
        p.add("client_assertion");
        p.add("scope");
        p.add("authorization_details");
        p.add("resource");
        p.add("existing_grant");
        p.add("device_secret");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(p);
        ALLOWED_REPEATED_PARAMS = new HashSet<String>(Arrays.asList("resource", "audience"));
    }

    public static class Builder {
        private final URI endpoint;
        private final ClientAuthentication clientAuth;
        private final ClientID clientID;
        private final AuthorizationGrant authzGrant;
        private Scope scope;
        private List<AuthorizationDetail> authorizationDetails;
        private List<URI> resources;
        private RefreshToken existingGrant;
        private DeviceSecret deviceSecret;
        private final Map<String, List<String>> customParams = new HashMap<String, List<String>>();

        public Builder(URI endpoint, ClientAuthentication clientAuth, AuthorizationGrant authzGrant) {
            this.endpoint = endpoint;
            this.clientAuth = Objects.requireNonNull(clientAuth);
            this.clientID = null;
            this.authzGrant = Objects.requireNonNull(authzGrant);
        }

        public Builder(URI endpoint, ClientID clientID, AuthorizationGrant authzGrant) {
            this.endpoint = endpoint;
            this.clientAuth = null;
            this.clientID = Objects.requireNonNull(clientID);
            this.authzGrant = Objects.requireNonNull(authzGrant);
        }

        public Builder(URI endpoint, AuthorizationGrant authzGrant) {
            this.endpoint = endpoint;
            this.clientAuth = null;
            this.clientID = null;
            this.authzGrant = Objects.requireNonNull(authzGrant);
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder authorizationDetails(List<AuthorizationDetail> authorizationDetails) {
            this.authorizationDetails = authorizationDetails;
            return this;
        }

        public Builder resource(URI resource) {
            this.resources = resource != null ? Collections.singletonList(resource) : null;
            return this;
        }

        public Builder resources(URI ... resources) {
            this.resources = resources != null ? Arrays.asList(resources) : null;
            return this;
        }

        public Builder existingGrant(RefreshToken existingGrant) {
            this.existingGrant = existingGrant;
            return this;
        }

        public Builder deviceSecret(DeviceSecret deviceSecret) {
            this.deviceSecret = deviceSecret;
            return this;
        }

        public Builder customParameter(String name, String ... values) {
            if (values == null || values.length == 0) {
                this.customParams.remove(name);
            } else {
                this.customParams.put(name, Arrays.asList(values));
            }
            return this;
        }

        public TokenRequest build() {
            try {
                if (this.clientAuth != null) {
                    return new TokenRequest(this.endpoint, this.clientAuth, this.authzGrant, this.scope, this.authorizationDetails, this.resources, this.deviceSecret, this.customParams);
                }
                return new TokenRequest(this.endpoint, this.clientID, this.authzGrant, this.scope, this.authorizationDetails, this.resources, this.existingGrant, this.deviceSecret, this.customParams);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }
}

