/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.verifier;

import java.util.Set;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc.SecurityContext;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.JWTClaimsSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.proc.BadJWTException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.assertions.jwt.JWTAssertionDetailsVerifier;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.Audience;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;

@Immutable
class JWTAuthenticationClaimsSetVerifier
extends JWTAssertionDetailsVerifier {
    private static final BadJWTException ISS_SUB_MISMATCH_EXCEPTION = new BadJWTException("Issuer and subject JWT claims don't match");

    public JWTAuthenticationClaimsSetVerifier(Set<Audience> expectedAudience) {
        this(expectedAudience, -1L);
    }

    public JWTAuthenticationClaimsSetVerifier(Set<Audience> expectedAudience, long expMaxAhead) {
        super(expectedAudience, expMaxAhead);
    }

    @Override
    public void verify(JWTClaimsSet claimsSet, SecurityContext securityContext) throws BadJWTException {
        super.verify(claimsSet, securityContext);
        if (!claimsSet.getIssuer().equals(claimsSet.getSubject())) {
            throw ISS_SUB_MISMATCH_EXCEPTION;
        }
    }
}

