/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.search.BaseMetadataSearchableAnalyser;
import org.apache.hop.core.search.ISearchQuery;
import org.apache.hop.core.search.ISearchResult;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableAnalyser;
import org.apache.hop.core.search.SearchableAnalyserPlugin;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.PipelineUnitTestDatabaseReplacement;
import org.apache.hop.testing.VariableValue;

@SearchableAnalyserPlugin(id="PipelineUnitTestSearchableAnalyser", name="Search in pipeline unit test metadata")
public class PipelineUnitTestSearchableAnalyser
extends BaseMetadataSearchableAnalyser<PipelineUnitTest>
implements ISearchableAnalyser<PipelineUnitTest> {
    public Class<PipelineUnitTest> getSearchableClass() {
        return PipelineUnitTest.class;
    }

    public List<ISearchResult> search(ISearchable<PipelineUnitTest> searchable, ISearchQuery searchQuery) {
        PipelineUnitTest unitTest = (PipelineUnitTest)searchable.getSearchableObject();
        ArrayList<ISearchResult> results = new ArrayList<ISearchResult>();
        this.matchProperty(searchable, results, searchQuery, "name", unitTest.getName(), null);
        this.matchProperty(searchable, results, searchQuery, "description", unitTest.getDescription(), null);
        this.matchProperty(searchable, results, searchQuery, "type", unitTest.getType() != null ? unitTest.getType().name() : null, null);
        this.matchProperty(searchable, results, searchQuery, "pipeline-filename", unitTest.getPipelineFilename(), null);
        this.matchProperty(searchable, results, searchQuery, "test-filename", unitTest.getFilename(), null);
        this.matchProperty(searchable, results, searchQuery, "base-path", unitTest.getBasePath(), null);
        this.matchProperty(searchable, results, searchQuery, "auto-open", unitTest.isAutoOpening() ? "Y" : "N", null);
        for (VariableValue configurationVariable : unitTest.variableValues) {
            this.matchProperty(searchable, results, searchQuery, "Unit test variable name", configurationVariable.getKey(), null);
            this.matchProperty(searchable, results, searchQuery, "Unit test variable value", configurationVariable.getValue(), null);
        }
        for (PipelineUnitTestDatabaseReplacement replacement : unitTest.getDatabaseReplacements()) {
            this.matchProperty(searchable, results, searchQuery, "Unit test database replacement: original", replacement.getOriginalDatabaseName(), null);
            this.matchProperty(searchable, results, searchQuery, "Unit test database replacement: replacement", replacement.getReplacementDatabaseName(), null);
        }
        return results;
    }
}

