/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class CharConverter
implements Serializable {
    static final long serialVersionUID = 4L;
    private static boolean faultTolerantConversion_ = false;
    private Converter table_;

    public CharConverter() {
        this.table_ = new Converter();
    }

    public CharConverter(String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            throw new NullPointerException("encoding");
        }
        this.table_ = new Converter(encoding);
    }

    public CharConverter(int ccsid) throws UnsupportedEncodingException {
        this.table_ = new Converter(ccsid);
    }

    public CharConverter(int ccsid, AS400 system) throws UnsupportedEncodingException {
        if (system == null) {
            if (Trace.traceOn_) {
                Trace.log(1, "Null-valued 'system' argument specified.");
            }
            this.table_ = new Converter(ccsid);
        } else {
            this.table_ = new Converter(ccsid, system);
        }
    }

    public String byteArrayToString(byte[] source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        return this.table_.byteArrayToString(source);
    }

    public String byteArrayToString(byte[] source, int offset) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        return this.table_.byteArrayToString(source, offset);
    }

    public String byteArrayToString(byte[] source, int offset, int length) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        return this.table_.byteArrayToString(source, offset, length);
    }

    public String byteArrayToString(byte[] source, int offset, int length, int type) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        return this.byteArrayToString(source, offset, length, new BidiConversionProperties(type));
    }

    public String byteArrayToString(byte[] source, int offset, int length, BidiConversionProperties properties) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        return this.table_.byteArrayToString(source, offset, length, properties);
    }

    public static String byteArrayToString(AS400 system, byte[] source) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        try {
            return new Converter(system.getCcsid(), system).byteArrayToString(source);
        }
        catch (UnsupportedEncodingException e) {
            Trace.log(2, "Unexpected UnsupportedEncodingException:", (Throwable)e);
            throw new InternalErrorException(10);
        }
    }

    public static String byteArrayToString(int ccsid, AS400 system, byte[] source) throws UnsupportedEncodingException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        return new Converter(ccsid, system).byteArrayToString(source);
    }

    public static String byteArrayToString(int ccsid, byte[] source) throws UnsupportedEncodingException {
        if (source == null) {
            throw new NullPointerException("source");
        }
        return new Converter(ccsid).byteArrayToString(source);
    }

    public static String convertIFSQSYSPathnameToJobPathname(String qsysData, int jobCCSID) throws UnsupportedEncodingException {
        if (qsysData == null) {
            throw new NullPointerException("qsysData");
        }
        return new Converter(jobCCSID, null).byteArrayToString(new Converter(37, null).stringToByteArray(qsysData));
    }

    public static String convertJobPathnameToIFSQSYSPathname(String jobData, int jobCCSID) throws UnsupportedEncodingException {
        if (jobData == null) {
            throw new NullPointerException("jobData");
        }
        return new Converter(37, null).byteArrayToString(new Converter(jobCCSID, null).stringToByteArray(jobData));
    }

    public int getCcsid() {
        return this.table_.getCcsid();
    }

    public String getEncoding() {
        return this.table_.getEncoding();
    }

    public static boolean isFaultTolerantConversion() {
        return faultTolerantConversion_;
    }

    public static void setFaultTolerantConversion(boolean faultTolerantConversion) {
        if (Trace.traceOn_) {
            Trace.log(3, "Setting fault tolerant conversion:", faultTolerantConversion);
        }
        faultTolerantConversion_ = faultTolerantConversion;
    }

    public byte[] stringToByteArray(String source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        return this.table_.stringToByteArray(source);
    }

    public byte[] stringToByteArray(String source, int type) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        return this.stringToByteArray(source, new BidiConversionProperties(type));
    }

    public byte[] stringToByteArray(String source, BidiConversionProperties properties) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        return this.table_.stringToByteArray(source, properties);
    }

    public void stringToByteArray(String source, byte[] destination) throws CharConversionException {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (destination == null) {
            throw new NullPointerException("destination");
        }
        this.table_.stringToByteArray(source, destination);
    }

    public void stringToByteArray(String source, byte[] destination, int offset) throws CharConversionException {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (destination == null) {
            throw new NullPointerException("destination");
        }
        this.table_.stringToByteArray(source, destination, offset);
    }

    public void stringToByteArray(String source, byte[] destination, int offset, int length) throws CharConversionException {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (destination == null) {
            throw new NullPointerException("destination");
        }
        this.table_.stringToByteArray(source, destination, offset, length);
    }

    public void stringToByteArray(String source, byte[] destination, int offset, int length, int type) throws CharConversionException {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (destination == null) {
            throw new NullPointerException("destination");
        }
        this.table_.stringToByteArray(source, destination, offset, length, new BidiConversionProperties(type));
    }

    public void stringToByteArray(String source, byte[] destination, int offset, int length, BidiConversionProperties properties) throws CharConversionException {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (destination == null) {
            throw new NullPointerException("destination");
        }
        this.table_.stringToByteArray(source, destination, offset, length, properties);
    }

    public static byte[] stringToByteArray(AS400 system, String source) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        try {
            return new Converter(system.getCcsid(), system).stringToByteArray(source);
        }
        catch (UnsupportedEncodingException e) {
            Trace.log(2, "Unexpected UnsupportedEncodingException:", (Throwable)e);
            throw new InternalErrorException(10);
        }
    }

    public static byte[] stringToByteArray(int ccsid, AS400 system, String source) throws UnsupportedEncodingException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        return new Converter(ccsid, system).stringToByteArray(source);
    }

    public static byte[] stringToByteArray(int ccsid, String source) throws UnsupportedEncodingException {
        if (source == null) {
            throw new NullPointerException("source");
        }
        return new Converter(ccsid).stringToByteArray(source);
    }
}

