/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.Trace;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

class DDMDataStream
extends DataStream {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    protected static final int HEADER_LENGTH = 6;
    protected static final int MAX_DATA_STREAM_LEN = Short.MAX_VALUE;
    protected static final int CONTINUATION_MASK = 128;
    protected static final byte CHAINED_MASK = 64;
    protected static final byte CONTINUE_ON_ERROR_MASK = 32;
    protected static final int OBJECT_DATA_STREAM = 17;
    protected static final int REPLY_DATA_STREAM = 16;
    protected static final int REQUEST_DATA_STREAM = 1;
    protected static final byte SAME_CORRELATOR_MASK = 16;
    protected static final byte TYPE_MASK = 3;

    static DDMDataStream construct(InputStream is, Hashtable dataStreams, AS400ImplRemote system, int connectionID) throws IOException {
        DDMDataStream baseDataStream = new DDMDataStream();
        if (DDMDataStream.readFromStream(is, baseDataStream.data_, 0, 6, connectionID) < 6) {
            Trace.log(2, "Failed to read all of the DDM data stream header.");
            throw new ConnectionDroppedException(2);
        }
        DDMDataStream modelDataStream = (DDMDataStream)dataStreams.get(baseDataStream);
        DDMDataStream newDataStream = null;
        if (modelDataStream == null) {
            newDataStream = new DDMDataStream();
        } else {
            newDataStream = (DDMDataStream)modelDataStream.getNewDataStream();
            if (newDataStream == null) {
                newDataStream = new DDMDataStream();
            }
        }
        newDataStream.setSystem(system);
        newDataStream.setConnectionID(connectionID);
        int packetLength = baseDataStream.getLength();
        if (packetLength - 6 > 0) {
            if (baseDataStream.isContinued()) {
                byte[] maxPacket = new byte[32765];
                byte[] nextLength = new byte[2];
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                b.write(baseDataStream.data_, 0, 6);
                byte[] packet = new byte[packetLength - 6];
                if (DDMDataStream.readFromStream(is, packet, 0, packetLength - 6, connectionID) < packetLength - 6) {
                    Trace.log(2, "Failed to read all of the DDM data stream packet.");
                    throw new ConnectionDroppedException(2);
                }
                b.write(packet);
                boolean done = false;
                while (!done) {
                    if (DDMDataStream.readFromStream(is, nextLength, 0, 2, connectionID) < 2) {
                        Trace.log(2, "Failed to read all of the DDM data stream packet length.");
                        throw new ConnectionDroppedException(2);
                    }
                    packetLength = BinaryConverter.byteArrayToUnsignedShort(nextLength, 0);
                    if (packetLength == 65535) {
                        packet = maxPacket;
                        packetLength = Short.MAX_VALUE;
                    } else {
                        packet = new byte[packetLength - 2];
                        done = true;
                    }
                    if (DDMDataStream.readFromStream(is, packet, 0, packetLength - 2, connectionID) < packetLength - 2) {
                        Trace.log(2, "Failed to read all of the DDM data stream continuation packet.");
                        throw new ConnectionDroppedException(2);
                    }
                    b.write(packet);
                }
                newDataStream.data_ = b.toByteArray();
            } else {
                newDataStream.data_ = new byte[packetLength];
                System.arraycopy(baseDataStream.data_, 0, newDataStream.data_, 0, 6);
                if (newDataStream.data_.length - 6 > 0) {
                    newDataStream.readAfterHeader(is);
                }
            }
        }
        return newDataStream;
    }

    DDMDataStream() {
        super(6);
    }

    DDMDataStream(byte[] data) {
        super(6, data);
        this.setLength(this.data_.length);
    }

    DDMDataStream(int totalLength) {
        super(6);
        this.data_ = new byte[totalLength];
        this.setLength(this.data_.length);
    }

    boolean continueOnError() {
        return (this.data_[3] & 0x20) != 0;
    }

    int getCodePoint() {
        return this.data_.length > 6 ? this.get16bit(8) : 0;
    }

    @Override
    int getCorrelation() {
        return this.get16bit(4);
    }

    byte getGDSId() {
        return this.data_[2];
    }

    @Override
    int getLength() {
        int len;
        if (this.isContinued()) {
            byte[] length = new byte[2];
            System.arraycopy(this.data_, 0, length, 0, 2);
            length[0] = (byte)(length[0] & 0x7F);
            len = BinaryConverter.byteArrayToUnsignedShort(length, 0);
        } else {
            len = this.get16bit(0);
        }
        return len;
    }

    int getType() {
        return this.data_[3] & 3;
    }

    @Override
    public int hashCode() {
        return this.getType();
    }

    boolean hasSameRequestCorrelation() {
        return (this.data_[3] & 0x10) != 0;
    }

    boolean isChained() {
        return (this.data_[3] & 0x40) != 0;
    }

    boolean isContinued() {
        return (this.data_[0] & 0x80) != 0;
    }

    void setContinueOnError(boolean cont) {
        this.data_[3] = cont ? (byte)(this.data_[3] | 0x20) : (byte)(this.data_[3] & 0xFFFFFFDF);
    }

    @Override
    void setCorrelation(int correlation) {
        this.set16bit(correlation, 4);
    }

    void setGDSId(byte id) {
        this.data_[2] = id;
    }

    void setIsChained(boolean chained) {
        this.data_[3] = chained ? (byte)(this.data_[3] | 0x40) : (byte)(this.data_[3] & 0xFFFFFFBF);
    }

    @Override
    void setLength(int length) {
        this.set16bit(length, 0);
    }

    void setHasSameRequestCorrelation(boolean same) {
        this.data_[3] = same ? (byte)(this.data_[3] | 0x10) : (byte)(this.data_[3] & 0xFFFFFFEF);
    }

    void setType(int type) {
        this.data_[3] = type == 1 ? (byte)(this.data_[3] | 1) : (type == 2 ? (byte)(this.data_[3] | 2) : (byte)(this.data_[3] | 3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void write(OutputStream out) throws IOException {
        int bytesToWrite = this.data_.length;
        if (bytesToWrite > Short.MAX_VALUE) {
            bytesToWrite = Short.MAX_VALUE;
            this.data_[0] = -1;
            this.data_[1] = -1;
        }
        OutputStream outputStream = out;
        synchronized (outputStream) {
            out.write(this.data_, 0, bytesToWrite);
            out.flush();
        }
        if (Trace.isTraceOn()) {
            Trace.log(0, "DDMDataStream.write() (connID=" + this.connectionID_ + "):", this.data_, 0, bytesToWrite);
        }
        if (this.data_.length > bytesToWrite) {
            DataOutputStream dos = new DataOutputStream(out);
            int packetLength = 0;
            for (int i = bytesToWrite; i < this.data_.length; i += packetLength - 2) {
                OutputStream outputStream2;
                packetLength = this.data_.length - i + 2;
                if (packetLength > Short.MAX_VALUE) {
                    packetLength = Short.MAX_VALUE;
                    outputStream2 = out;
                    synchronized (outputStream2) {
                        dos.writeShort(-1);
                        dos.flush();
                    }
                    if (Trace.isTraceOn()) {
                        Trace.log(0, "DDMDataStream.write() continuation (connID=" + this.connectionID_ + "):", new byte[]{-1, -1});
                    }
                } else {
                    outputStream2 = out;
                    synchronized (outputStream2) {
                        dos.writeShort(packetLength);
                        dos.flush();
                    }
                    if (Trace.isTraceOn()) {
                        Trace.log(0, "DDMDataStream.write() packetLength (connID=" + this.connectionID_ + "):", new byte[]{(byte)(packetLength >> 8), (byte)packetLength});
                    }
                }
                outputStream2 = out;
                synchronized (outputStream2) {
                    dos.write(this.data_, i, packetLength - 2);
                    dos.flush();
                }
                if (!Trace.isTraceOn()) continue;
                Trace.log(0, "DDMDataStream.write() (connID=" + this.connectionID_ + "):", this.data_, i, packetLength - 2);
            }
        }
        outputStream = out;
        synchronized (outputStream) {
            out.flush();
        }
    }
}

