/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import java.io.StringWriter;

class BitBuf
implements Cloneable {
    private byte[] data;
    private int bitlen;
    private static StringBuffer binbyte = new StringBuffer("01234567");
    private static StringBuffer hexbyte = new StringBuffer("FF");
    private final int[] masks = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    private final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public BitBuf(byte[] bytes) {
        this.data = (byte[])bytes.clone();
        this.bitlen = this.data.length * 8;
    }

    public BitBuf(int[] ints) {
        this.data = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            this.data[i] = (byte)ints[i];
        }
        this.bitlen = this.data.length * 8;
    }

    public BitBuf(byte b) {
        this.data = new byte[1];
        this.data[0] = b;
        this.bitlen = this.data.length * 8;
    }

    public BitBuf(int i) {
        this.data = new byte[i];
        this.bitlen = this.data.length * 8;
    }

    public BitBuf(BitBuf b, int bitstart, int bitlength) {
        if (bitlength < 0) {
            bitlength = 0;
        }
        this.bitlen = bitlength;
        int newlen = (bitlength + 7) / 8;
        this.data = new byte[newlen];
        for (int x = 0; x < newlen; ++x) {
            this.data[x] = b.getOctet(bitstart + 8 * x);
        }
        this.truncate();
    }

    public String byteAsBin(int i) {
        for (int x = 7; x >= 0; --x) {
            binbyte.setCharAt(x, (this.data[i] & 0xFF & this.masks[x]) > 0 ? (char)'1' : '0');
        }
        return binbyte.toString();
    }

    public String byteAsHex(int i) {
        hexbyte.setCharAt(0, this.hexchars[this.data[i] >>> 4 & 0xF]);
        hexbyte.setCharAt(1, this.hexchars[this.data[i] & 0xF]);
        return hexbyte.toString();
    }

    public Object clone() {
        BitBuf b = new BitBuf(this.data);
        return b;
    }

    public boolean getBitAsBool(int bit) {
        int byteloc = bit / 8;
        int bitloc = bit % 8;
        return (this.data[byteloc] & 0xFF & this.masks[bitloc]) > 0;
    }

    public byte getBitAsByte(int bit) {
        int byteloc = bit / 8;
        int bitloc = bit % 8;
        if ((this.data[byteloc] & 0xFF & this.masks[bitloc]) > 0) {
            return 1;
        }
        return 0;
    }

    public int getBitSize() {
        return this.bitlen;
    }

    public byte[] getBytes() {
        return (byte[])this.data.clone();
    }

    public int getByteSize() {
        return this.data.length;
    }

    public byte getOctet(int startbit) {
        byte b;
        if (startbit >= this.bitlen || startbit < -8) {
            b = 0;
        } else if (startbit < 0) {
            b = (byte)((this.data[0] & 0xFF) >>> 0 - startbit);
        } else {
            int byteloc = startbit / 8;
            int bitshift = startbit % 8;
            b = this.data[byteloc];
            b = (byte)(b << bitshift);
            if (bitshift > 0 && startbit + 8 < this.bitlen) {
                b = (byte)(b | (this.data[byteloc + 1] & 0xFF) >>> 8 - bitshift);
            }
        }
        return b;
    }

    public void shiftLeft(int x) {
        this.shiftBufferLeft(x);
    }

    public void shiftRight(int x) {
        this.shiftBufferRight(x);
        this.truncate();
    }

    public void shiftBufferLeft(int d) {
        int i;
        int byteshift = d / 8;
        int bitshift = d % 8;
        if (byteshift > 0) {
            for (i = 0; i < this.data.length; ++i) {
                this.data[i] = i < this.data.length - byteshift ? this.data[i + byteshift] : (byte)0;
            }
        }
        if (bitshift > 0) {
            for (i = 0; i < this.data.length; ++i) {
                if (i < this.data.length - 1) {
                    this.data[i] = (byte)(this.data[i] << bitshift | (this.data[i + 1] & 0xFF) >>> 8 - bitshift);
                    continue;
                }
                int n = i;
                this.data[n] = (byte)(this.data[n] << bitshift);
            }
        }
    }

    public void shiftBufferRight(int d) {
        int i;
        int byteshift = d / 8;
        int bitshift = d % 8;
        if (byteshift > 0) {
            i = this.data.length;
            while (i-- > 0) {
                if (i >= byteshift) {
                    this.data[i] = this.data[i - byteshift];
                    continue;
                }
                this.data[i] = 0;
            }
        }
        if (bitshift > 0) {
            i = this.data.length;
            while (i-- > 0) {
                if (i > 0) {
                    this.data[i] = (byte)((this.data[i] & 0xFF) >>> bitshift | this.data[i - 1] << 8 - bitshift);
                    continue;
                }
                this.data[i] = (byte)((this.data[i] & 0xFF) >>> bitshift);
            }
        }
    }

    public BitBuf slice(int s) {
        return new BitBuf(this, s, this.bitlen - s);
    }

    public BitBuf slice(int s, int l) {
        return new BitBuf(this, s, l);
    }

    public String toBinString() {
        return this.toBinString(0, "");
    }

    public String toBinString(int groupsize, String separator) {
        StringWriter out = new StringWriter();
        for (int x = 0; x < this.data.length; ++x) {
            out.write(this.byteAsBin(x));
            if (groupsize == 0 || x % groupsize != 0) continue;
            out.write(separator);
        }
        return out.toString();
    }

    public String toBinString(String sep) {
        return this.toBinString(1, sep);
    }

    public byte toByte() {
        return this.getOctet(this.bitlen - 8);
    }

    public String toHexString() {
        return this.toHexString(0, "");
    }

    public String toHexString(int groupsize, String separator) {
        StringWriter out = new StringWriter();
        for (int x = 0; x < this.data.length; ++x) {
            if (x != 0 && groupsize > 0 && x % groupsize == 0) {
                out.write(separator);
            }
            out.write(this.byteAsHex(x));
        }
        return out.toString();
    }

    public String toHexString(String sep) {
        return this.toHexString(1, sep);
    }

    public String toHexStringJustified(int grouplen, String separator) {
        BitBuf b = (BitBuf)this.clone();
        int slack = b.bitlen % 8;
        if (slack > 0) {
            b.shiftBufferRight(8 - slack);
        }
        return b.toHexString(grouplen, separator);
    }

    public int toInt() {
        long r = 0L;
        for (int i = 0; i < 4; ++i) {
            r |= (long)((this.getOctet(this.bitlen - 8 * (i + 1)) & 0xFF) << i * 8);
        }
        return (int)r;
    }

    public long toLong() {
        long r = 0L;
        for (int i = 0; i < 8; ++i) {
            r |= (long)(this.getOctet(this.bitlen - 8 * (i + 1)) & 0xFF) << i * 8;
        }
        return r;
    }

    public short toShort() {
        long r = 0L;
        for (int i = 0; i < 2; ++i) {
            r |= (long)((this.getOctet(this.bitlen - 8 * (i + 1)) & 0xFF) << i * 8);
        }
        return (short)r;
    }

    private void truncate() {
        int tailbits = this.bitlen % 8;
        if (tailbits > 0) {
            int n = this.data.length - 1;
            this.data[n] = (byte)(this.data[n] & ~((1 << 8 - tailbits) - 1));
        }
    }
}

