/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import java.io.File;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;

class ResourceLoader {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final boolean DEBUG_ = false;
    private static String genericDescription_ = null;
    private static ResourceBundle resources_ = null;
    private static ResourceBundle printResources_ = null;
    private static ResourceBundle queryResources_ = null;

    ResourceLoader() {
    }

    static final Icon getIcon(String fileName) {
        return ResourceLoader.getIcon(fileName, null);
    }

    static final Icon getIcon(String fileName, String description) {
        ImageIcon icon = null;
        try {
            URL url;
            if (description == null) {
                if (genericDescription_ == null) {
                    genericDescription_ = ResourceLoader.getText("PRODUCT_TITLE");
                }
                description = genericDescription_;
            }
            if ((url = ResourceLoader.class.getResource(fileName)) == null) {
                fileName = "com" + File.separator + "ibm" + File.separator + "as400" + File.separator + "vaccess" + File.separator + fileName;
                icon = new ImageIcon(fileName, description);
            } else {
                icon = new ImageIcon(url, description);
            }
        }
        catch (Exception e) {
            Trace.log(2, "Icon " + fileName + " not loaded: " + e.getMessage() + ".");
        }
        return icon;
    }

    static final String getPrintText(String key) {
        try {
            if (printResources_ == null) {
                printResources_ = ResourceBundle.getBundle("com.ibm.as400.vaccess.VNPMRI");
            }
            return printResources_.getString(key);
        }
        catch (MissingResourceException e) {
            Trace.log(2, "Error while loading print MRI resource: " + key + ".");
            throw e;
        }
    }

    static final String getQueryText(String key) {
        try {
            if (queryResources_ == null) {
                queryResources_ = ResourceBundle.getBundle("com.ibm.as400.vaccess.VQRYMRI");
            }
            return queryResources_.getString(key);
        }
        catch (MissingResourceException e) {
            Trace.log(2, "Error while loading query MRI resource: " + key + ".");
            throw e;
        }
    }

    static final String getText(String key) {
        try {
            if (resources_ == null) {
                resources_ = ResourceBundle.getBundle("com.ibm.as400.vaccess.VMRI");
            }
            return resources_.getString(key);
        }
        catch (MissingResourceException e) {
            Trace.log(2, "Error while loading MRI resource: " + key + ".");
            throw e;
        }
    }

    static String substitute(String text, String value) {
        return ResourceLoader.substitute(text, new String[]{value});
    }

    static String substitute(String text, String[] values) {
        String result = text;
        for (int i = 0; i < values.length; ++i) {
            String variable = "&" + i;
            int j = result.indexOf(variable);
            if (j < 0) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append(result.substring(0, j));
            buffer.append(values[i]);
            buffer.append(result.substring(j + variable.length()));
            result = buffer.toString();
        }
        return result;
    }
}

