/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.pipeline.delegates;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.gui.IGuiPosition;
import org.apache.hop.core.gui.IUndo;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PartitionerPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.history.AuditManager;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.IPartitioner;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformErrorMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformPartitioningMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.ShowBrowserDialog;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.hopgui.partition.PartitionMethodSelector;
import org.apache.hop.ui.hopgui.partition.PartitionSettings;
import org.apache.hop.ui.hopgui.partition.processor.IMethodProcessor;
import org.apache.hop.ui.hopgui.partition.processor.MethodProcessorFactory;
import org.apache.hop.ui.pipeline.transform.TransformErrorMetaDialog;
import org.eclipse.swt.widgets.Shell;

public class HopGuiPipelineTransformDelegate {
    private static final Class<?> PKG = HopGui.class;
    private HopGui hopGui;
    private HopGuiPipelineGraph pipelineGraph;
    private Map<String, ITransformDialog> dialogs = new HashMap<String, ITransformDialog>();

    public HopGuiPipelineTransformDelegate(HopGui hopGui, HopGuiPipelineGraph pipelineGraph) {
        this.hopGui = hopGui;
        this.pipelineGraph = pipelineGraph;
    }

    public ITransformDialog getTransformDialog(ITransformMeta transformMeta, PipelineMeta pipelineMeta, String transformName) throws HopException {
        PluginRegistry registry = PluginRegistry.getInstance();
        IPlugin plugin = registry.getPlugin(TransformPluginType.class, (Object)transformMeta);
        if (plugin == null) {
            throw new HopException("Missing transform plugin for '" + transformName + "'");
        }
        String dialogClassName = (String)plugin.getClassMap().get(ITransformDialog.class);
        if (dialogClassName == null) {
            dialogClassName = transformMeta.getDialogClassName();
        }
        if (dialogClassName == null) {
            throw new HopException("Unable to find dialog class for plugin '" + plugin.getIds()[0] + "' : " + plugin.getName());
        }
        try {
            Class dialogClass = (Class)registry.getClass(plugin, dialogClassName);
            Constructor dialogConstructor = dialogClass.getConstructor(Shell.class, IVariables.class, transformMeta.getClass(), PipelineMeta.class);
            Object[] arguments = new Object[]{this.hopGui.getShell(), this.pipelineGraph.getVariables(), transformMeta, pipelineMeta};
            return (ITransformDialog)dialogConstructor.newInstance(arguments);
        }
        catch (Exception dialogClass) {
            Object[] arguments = new Object[]{this.hopGui.getShell(), this.pipelineGraph.getVariables(), transformMeta, pipelineMeta, transformName};
            try {
                Class dialogClass2 = (Class)registry.getClass(plugin, dialogClassName);
                Constructor dialogConstructor = dialogClass2.getConstructor(Shell.class, IVariables.class, Object.class, PipelineMeta.class, String.class);
                return (ITransformDialog)dialogConstructor.newInstance(arguments);
            }
            catch (Exception dialogClass2) {
                try {
                    Class[] sig = new Class[]{Shell.class, IVariables.class, ITransformMeta.class, PipelineMeta.class, String.class};
                    Method method = transformMeta.getClass().getDeclaredMethod("getDialog", sig);
                    if (method != null) {
                        this.hopGui.getLog().logDebug("Use of ITransformMeta#getDialog is deprecated, use PluginDialog annotation instead.");
                        return (ITransformDialog)method.invoke((Object)transformMeta, arguments);
                    }
                }
                catch (Throwable e) {
                    String errorTitle = BaseMessages.getString(PKG, (String)"HopGui.Dialog.ErrorCreatingTransformDialog.Title", (String[])new String[0]);
                    String errorMsg = BaseMessages.getString(PKG, (String)"HopGui.Dialog.ErrorCreatingTransformDialog.Message", (String[])new String[]{dialogClassName});
                    new ErrorDialog(this.hopGui.getActiveShell(), errorTitle, errorMsg, e);
                }
                return null;
            }
        }
    }

    public String editTransform(PipelineMeta pipelineMeta, TransformMeta transformMeta) {
        Object transformName = null;
        try {
            String name = transformMeta.getName();
            ITransformDialog dialog = this.dialogs.get(name);
            if (dialog != null && !dialog.isDisposed()) {
                dialog.setActive();
                return null;
            }
            TransformMeta before = (TransformMeta)transformMeta.clone();
            dialog = this.getTransformDialog(transformMeta.getTransform(), pipelineMeta, name);
            if (dialog != null) {
                this.dialogs.put(name, dialog);
                dialog.setMetadataProvider((IHopMetadataProvider)this.hopGui.getMetadataProvider());
                transformMeta.getTransform().convertIOMetaToTransformNames();
                transformName = dialog.open();
                this.dialogs.remove(name);
            }
            if (!Utils.isEmpty(transformName)) {
                transformMeta.getTransform().resetTransformIoMeta();
                for (IStream infoStream : transformMeta.getTransform().getTransformIOMeta().getInfoStreams()) {
                    if (infoStream.getTransformMeta() == null) continue;
                    infoStream.setSubject(infoStream.getTransformMeta().getName());
                }
                transformMeta.getTransform().searchInfoAndTargetTransforms(pipelineMeta.getTransforms());
                transformMeta.setChanged();
                Object newname = transformName;
                TransformMeta smeta = pipelineMeta.findTransform((String)newname, transformMeta);
                int nr = 2;
                while (smeta != null) {
                    newname = (String)transformName + " " + nr;
                    smeta = pipelineMeta.findTransform((String)newname);
                    ++nr;
                }
                if (nr > 2) {
                    transformName = newname;
                    MessageBox mb = new MessageBox(this.hopGui.getActiveShell(), 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"HopGui.Dialog.TransformnameExists.Message", (String[])new String[]{transformName}));
                    mb.setText(BaseMessages.getString(PKG, (String)"HopGui.Dialog.TransformnameExists.Title", (String[])new String[0]));
                    mb.open();
                }
                TransformMeta newTransformMeta = (TransformMeta)transformMeta.clone();
                newTransformMeta.setName((String)transformName);
                pipelineMeta.clearCaches();
                pipelineMeta.notifyAllListeners(transformMeta, newTransformMeta);
                transformMeta.setName((String)transformName);
                TransformMeta after = (TransformMeta)transformMeta.clone();
                this.hopGui.undoDelegate.addUndoChange((IUndo)pipelineMeta, new TransformMeta[]{before}, new TransformMeta[]{after}, new int[]{pipelineMeta.indexOfTransform(transformMeta)});
            }
            this.pipelineGraph.updateGui();
        }
        catch (Throwable e) {
            if (this.hopGui.getShell().isDisposed()) {
                return null;
            }
            new ErrorDialog(this.hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"HopGui.Dialog.UnableOpenDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.Dialog.UnableOpenDialog.Message", (String[])new String[0]), e);
        }
        return transformName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public TransformMeta newTransform(PipelineMeta pipelineMeta, String id, String name, String description, boolean openit, boolean rename, Point location) {
        try {
            TransformMeta transformMeta;
            block32: {
                IPlugin transformPlugin;
                block33: {
                    transformMeta = null;
                    if (rename && pipelineMeta.findTransform((String)name) != null) {
                        int i = 2;
                        String newName = (String)name + " " + i;
                        while (pipelineMeta.findTransform(newName) != null) {
                            newName = (String)name + " " + ++i;
                        }
                        name = newName;
                    }
                    PluginRegistry registry = PluginRegistry.getInstance();
                    transformPlugin = id != null ? registry.findPluginWithId(TransformPluginType.class, id) : registry.findPluginWithName(TransformPluginType.class, description);
                    if (transformPlugin == null) break block32;
                    ITransformMeta info = (ITransformMeta)registry.loadClass(transformPlugin);
                    info.setDefault();
                    transformMeta = new TransformMeta(transformPlugin.getIds()[0], (String)name, info);
                    if (name != null) {
                        Object newName = name;
                        TransformMeta candiateTransformMeta = pipelineMeta.findTransform((String)newName);
                        int nr = 2;
                        while (candiateTransformMeta != null) {
                            newName = (String)name + " " + nr;
                            candiateTransformMeta = pipelineMeta.findTransform((String)newName);
                            ++nr;
                        }
                        if (nr > 2) {
                            transformMeta.setName((String)newName);
                            MessageBox mb = new MessageBox(this.hopGui.getActiveShell(), 34);
                            mb.setMessage(BaseMessages.getString(PKG, (String)"HopGui.Dialog.ChangeTransformname.Message", (String[])new String[]{newName}));
                            mb.setText(BaseMessages.getString(PKG, (String)"HopGui.Dialog.ChangeTransformname.Title", (String[])new String[0]));
                            mb.open();
                        }
                        PropsUi.setLocation((IGuiPosition)transformMeta, location.x, location.y);
                        pipelineMeta.addTransform(transformMeta);
                        this.hopGui.undoDelegate.addUndoNew((IUndo)pipelineMeta, new TransformMeta[]{transformMeta}, new int[]{pipelineMeta.indexOfTransform(transformMeta)});
                        AuditManager.registerEvent((String)HopNamespace.getNamespace(), (String)"transform", (String)transformPlugin.getIds()[0], (String)"create");
                        if (openit) {
                            this.pipelineGraph.editTransform(pipelineMeta, transformMeta);
                        }
                        break block33;
                    }
                    TransformMeta newName = null;
                    return newName;
                }
                try {
                    this.pipelineGraph.updateGui();
                }
                catch (HopException e) {
                    String filename = transformPlugin.getErrorHelpFile();
                    if (!Utils.isEmpty((CharSequence)filename)) {
                        FileInputStream fis = null;
                        try {
                            StringBuilder content = new StringBuilder();
                            fis = new FileInputStream(new File(filename));
                            int ch = fis.read();
                            while (ch >= 0) {
                                content.append((char)ch);
                                ch = fis.read();
                            }
                            ShowBrowserDialog sbd = new ShowBrowserDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"HopGui.Dialog.ErrorHelpText.Title", (String[])new String[0]), content.toString());
                            sbd.open();
                        }
                        catch (Exception ex) {
                            new ErrorDialog(this.hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"HopGui.Dialog.ErrorShowingHelpText.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.Dialog.ErrorShowingHelpText.Message", (String[])new String[0]), ex);
                        }
                        finally {
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (Exception ex) {
                                    this.hopGui.getLog().logError("Error closing plugin help file", (Throwable)ex);
                                }
                            }
                        }
                    } else {
                        new ErrorDialog(this.hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"HopGui.Dialog.UnableCreateNewTransform.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.Dialog.UnableCreateNewTransform.Message", (String[])new String[0]), (Exception)((Object)e));
                    }
                    TransformMeta transformMeta2 = null;
                    this.pipelineGraph.redraw();
                    return transformMeta2;
                }
                catch (Throwable e) {
                    if (!this.hopGui.getShell().isDisposed()) {
                        new ErrorDialog(this.hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"HopGui.Dialog.ErrorCreatingTransform.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.Dialog.UnableCreateNewTransform.Message", (String[])new String[0]), e);
                    }
                    TransformMeta transformMeta3 = null;
                    this.pipelineGraph.redraw();
                    return transformMeta3;
                }
            }
            TransformMeta transformMeta4 = transformMeta;
            return transformMeta4;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.pipelineGraph.redraw();
        }
    }

    public TransformMeta insertTransform(PipelineMeta pipelineMeta, PipelineHopMeta hop, String id, String name, Point location) {
        TransformMeta transformMeta = this.newTransform(pipelineMeta, id, name, name, false, false, location);
        return this.insertTransform(pipelineMeta, hop, transformMeta);
    }

    public TransformMeta insertTransform(PipelineMeta pipelineMeta, PipelineHopMeta hop, TransformMeta transformMeta) {
        TransformMeta fromTransform = hop.getFromTransform();
        TransformMeta toTransform = hop.getToTransform();
        ITransformIOMeta fromIo = fromTransform.getTransform().getTransformIOMeta();
        for (Object stream : fromIo.getTargetStreams()) {
            if (stream.getTransformMeta() == null || !stream.getTransformMeta().equals((Object)toTransform)) continue;
            stream.setTransformMeta(transformMeta);
            fromTransform.getTransform().handleStreamSelection((IStream)stream);
        }
        ITransformIOMeta toIo = toTransform.getTransform().getTransformIOMeta();
        for (IStream stream : toIo.getInfoStreams()) {
            if (stream.getTransformMeta() == null || !stream.getTransformMeta().equals((Object)fromTransform)) continue;
            stream.setTransformMeta(transformMeta);
            toTransform.getTransform().handleStreamSelection(stream);
        }
        TransformErrorMeta errorMeta = fromTransform.getTransformErrorMeta();
        if (fromTransform.isDoingErrorHandling() && toTransform.equals((Object)errorMeta.getTargetTransform())) {
            errorMeta.setTargetTransform(transformMeta);
        }
        PipelineHopMeta newHop1 = new PipelineHopMeta(fromTransform, transformMeta);
        newHop1.setEnabled(hop.isEnabled());
        if (pipelineMeta.findPipelineHop(newHop1) == null) {
            pipelineMeta.addPipelineHop(newHop1);
            this.hopGui.undoDelegate.addUndoNew((IUndo)pipelineMeta, new PipelineHopMeta[]{newHop1}, new int[]{pipelineMeta.indexOfPipelineHop(newHop1)}, true);
        }
        PipelineHopMeta newHop2 = new PipelineHopMeta(transformMeta, toTransform);
        newHop2.setEnabled(hop.isEnabled());
        if (pipelineMeta.findPipelineHop(newHop2) == null) {
            pipelineMeta.addPipelineHop(newHop2);
            toTransform.getTransform().searchInfoAndTargetTransforms(pipelineMeta.getTransforms());
            this.hopGui.undoDelegate.addUndoNew((IUndo)pipelineMeta, new PipelineHopMeta[]{newHop2}, new int[]{pipelineMeta.indexOfPipelineHop(newHop2)}, true);
        }
        this.hopGui.undoDelegate.addUndoDelete((IUndo)pipelineMeta, new PipelineHopMeta[]{hop}, new int[]{pipelineMeta.indexOfPipelineHop(hop)}, true);
        pipelineMeta.removePipelineHop(hop);
        return transformMeta;
    }

    public void editTransformPartitioning(PipelineMeta pipelineMeta, TransformMeta transformMeta) {
        String[] schemaNames;
        try {
            schemaNames = this.hopGui.partitionManager.getNamesArray();
        }
        catch (HopException e) {
            new ErrorDialog(this.hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"HopGui.ErrorDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.ErrorDialog.ErrorFetchingFromRepo.PartitioningSchemas", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        try {
            if (this.isDefinedSchemaExist(schemaNames)) {
                PluginRegistry registry = PluginRegistry.getInstance();
                List plugins = registry.getPlugins(PartitionerPluginType.class);
                int exactSize = TransformPartitioningMeta.methodDescriptions.length + plugins.size();
                PartitionSettings partitionSettings = new PartitionSettings(exactSize, pipelineMeta, transformMeta, this.hopGui.partitionManager);
                partitionSettings.fillOptionsAndCodesByPlugins(plugins);
                PartitionMethodSelector methodSelector = new PartitionMethodSelector();
                String partitionMethodDescription = methodSelector.askForPartitionMethod(this.hopGui.getShell(), partitionSettings);
                if (!StringUtil.isEmpty((String)partitionMethodDescription)) {
                    String method = partitionSettings.getMethodByMethodDescription(partitionMethodDescription);
                    int methodType = TransformPartitioningMeta.getMethodType((String)method);
                    partitionSettings.updateMethodType(methodType);
                    partitionSettings.updateMethod(method);
                    IMethodProcessor methodProcessor = MethodProcessorFactory.create(methodType);
                    methodProcessor.schemaSelection(partitionSettings, this.hopGui.getShell(), (shell, settings) -> {
                        TransformPartitioningMeta partitioningMeta = settings.getTransformMeta().getTransformPartitioningMeta();
                        ITransformDialog dialog = this.getPartitionerDialog(shell, this.pipelineGraph.getVariables(), settings.getTransformMeta(), partitioningMeta, settings.getPipelineMeta());
                        return dialog.open();
                    });
                }
                transformMeta.setChanged();
                this.hopGui.undoDelegate.addUndoChange((IUndo)partitionSettings.getPipelineMeta(), new TransformMeta[]{partitionSettings.getBefore()}, new TransformMeta[]{partitionSettings.getAfter()}, new int[]{partitionSettings.getPipelineMeta().indexOfTransform(partitionSettings.getTransformMeta())});
                this.pipelineGraph.redraw();
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getActiveShell(), "Error", "There was an unexpected error while editing the partitioning method specifics:", e);
        }
    }

    public boolean isDefinedSchemaExist(String[] schemaNames) {
        if (schemaNames == null || schemaNames.length == 0) {
            MessageBox box = new MessageBox(this.hopGui.getActiveShell(), 33);
            box.setText("Create a partition schema");
            box.setMessage("You first need to create one or more partition schemas before you can select one!");
            box.open();
            return false;
        }
        return true;
    }

    public ITransformDialog getPartitionerDialog(Shell shell, IVariables variables, TransformMeta transformMeta, TransformPartitioningMeta partitioningMeta, PipelineMeta pipelineMeta) throws HopException {
        IPartitioner partitioner = partitioningMeta.getPartitioner();
        String dialogClassName = partitioner.getDialogClassName();
        Class[] paramClasses = new Class[]{Shell.class, IVariables.class, TransformMeta.class, TransformPartitioningMeta.class, PipelineMeta.class};
        Object[] paramArgs = new Object[]{shell, variables, transformMeta, partitioningMeta, pipelineMeta};
        try {
            Class<?> dialogClass = partitioner.getClass().getClassLoader().loadClass(dialogClassName);
            Constructor<?> dialogConstructor = dialogClass.getConstructor(paramClasses);
            return (ITransformDialog)dialogConstructor.newInstance(paramArgs);
        }
        catch (Exception e) {
            throw new HopException("Unable to open dialog of partitioning method", (Throwable)e);
        }
    }

    public void editTransformErrorHandling(PipelineMeta pipelineMeta, TransformMeta transformMeta) {
        if (transformMeta != null && transformMeta.supportsErrorHandling()) {
            TransformErrorMeta transformErrorMeta = transformMeta.getTransformErrorMeta();
            if (transformErrorMeta == null) {
                transformErrorMeta = new TransformErrorMeta(transformMeta);
            }
            List targetTransforms = pipelineMeta.findNextTransforms(transformMeta, true);
            TransformErrorMetaDialog dialog = new TransformErrorMetaDialog(this.hopGui.getActiveShell(), this.pipelineGraph.getVariables(), transformErrorMeta, pipelineMeta, targetTransforms);
            if (dialog.open()) {
                transformMeta.setTransformErrorMeta(transformErrorMeta);
                transformMeta.setChanged();
                this.pipelineGraph.redraw();
            }
        }
    }

    public void delTransforms(PipelineMeta pipelineMeta, List<TransformMeta> transforms) {
        if (transforms == null || transforms.isEmpty()) {
            return;
        }
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.hopGui.getLog(), (IVariables)this.pipelineGraph.getVariables(), (String)HopExtensionPoint.PipelineBeforeDeleteTransforms.id, transforms);
        }
        catch (HopException e) {
            return;
        }
        ArrayList<PipelineHopMeta> pipelineHops = new ArrayList<PipelineHopMeta>();
        int[] hopIndexes = new int[pipelineMeta.nrPipelineHops()];
        int hopIndex = 0;
        block2: for (int i = pipelineMeta.nrPipelineHops() - 1; i >= 0; --i) {
            PipelineHopMeta hi = pipelineMeta.getPipelineHop(i);
            for (int j = 0; j < transforms.size() && hopIndex < hopIndexes.length; ++j) {
                if (!hi.getFromTransform().equals((Object)transforms.get(j)) && !hi.getToTransform().equals((Object)transforms.get(j))) continue;
                int idx = pipelineMeta.indexOfPipelineHop(hi);
                pipelineHops.add(hi.clone());
                hopIndexes[hopIndex] = idx;
                pipelineMeta.removePipelineHop(idx);
                ++hopIndex;
                continue block2;
            }
        }
        if (!pipelineHops.isEmpty()) {
            Object[] hops = pipelineHops.toArray(new PipelineHopMeta[pipelineHops.size()]);
            this.hopGui.undoDelegate.addUndoDelete((IUndo)pipelineMeta, hops, hopIndexes);
        }
        int[] positions = new int[transforms.size()];
        for (int i = 0; i < transforms.size(); ++i) {
            int pos = pipelineMeta.indexOfTransform(transforms.get(i));
            pipelineMeta.removeTransform(pos);
            positions[i] = pos;
        }
        this.hopGui.undoDelegate.addUndoDelete((IUndo)pipelineMeta, transforms.toArray(new TransformMeta[0]), positions);
        this.pipelineGraph.redraw();
    }

    public void delTransform(PipelineMeta pipelineMeta, TransformMeta transformMeta) {
        this.delTransforms(pipelineMeta, Arrays.asList(transformMeta));
    }
}

