/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.mapper;

import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseRecord;
import com.clickhouse.data.ClickHouseRecordMapper;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.mapper.AbstractRecordMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

@Deprecated
final class DynamicRecordMapper
extends AbstractRecordMapper {
    private final Constructor<?> constructor;
    private final PropertySetter[] setters;

    protected DynamicRecordMapper(Class<?> objClass) {
        super(objClass);
        this.constructor = DynamicRecordMapper.getDefaultConstructor(objClass);
        this.setters = new PropertySetter[0];
    }

    protected DynamicRecordMapper(Class<?> objClass, List<ClickHouseColumn> columns, Constructor<?> defaultConstructor) {
        super(objClass);
        this.constructor = defaultConstructor;
        AbstractRecordMapper.PropertyInfo[] properties = DynamicRecordMapper.getProperties(objClass, columns);
        int len = properties.length;
        ArrayList<PropertySetter> list = new ArrayList<PropertySetter>(len);
        for (int i = 0; i < len; ++i) {
            AbstractRecordMapper.PropertyInfo p = properties[i];
            Class<?> type = p.setter.getParameterTypes()[0];
            if (Object.class == type) {
                list.add(new ObjectSetter(p.index, p.setter));
                continue;
            }
            if (ClickHouseValue.class.isAssignableFrom(type)) {
                list.add(new ValueSetter(p.index, type, p.setter));
                continue;
            }
            list.add(new PropertySetter(p.index, !type.isPrimitive() && !PropertySetter.typedValues.containsKey(type.getName()) ? ClickHouseDataType.toPrimitiveType(type) : type, p.setter));
        }
        this.setters = list.toArray(new PropertySetter[0]);
    }

    @Override
    public ClickHouseRecordMapper get(ClickHouseDataConfig config, List<ClickHouseColumn> columns) {
        return new DynamicRecordMapper(this.clazz, columns == null ? Collections.emptyList() : columns, this.constructor);
    }

    @Override
    public <T> T mapTo(ClickHouseRecord r, Class<T> objClass, T obj) {
        this.check(r, objClass);
        if (obj == null) {
            obj = DynamicRecordMapper.newInstance(this.constructor, new Object[0]);
        }
        try {
            for (PropertySetter setter : this.setters) {
                setter.accept(obj, r.getValue(setter.index));
            }
            return obj;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to map record to specified class", e);
        }
    }

    static class PropertySetter
    implements BiConsumer<Object, ClickHouseValue> {
        private static final Map<String, Method> typedValues;
        protected final int index;
        protected final Class<?> type;
        protected final Method getter;
        protected final Method setter;

        protected PropertySetter(int valueIndex, Class<?> valueType, Method s) {
            this.index = valueIndex;
            this.type = valueType;
            this.getter = typedValues.get(valueType.getName());
            this.setter = s;
        }

        @Override
        public void accept(Object obj, ClickHouseValue val) {
            try {
                this.setter.invoke(obj, this.getter != null ? this.getter.invoke((Object)val, new Object[0]) : val.asObject(this.type));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(ClickHouseUtils.format("Failed to set [%s] due to %s", this.type.getName(), e.getMessage()));
            }
        }

        static {
            HashMap<String, Method> map = new HashMap<String, Method>();
            for (Method m : ClickHouseValue.class.getMethods()) {
                Class<?> type;
                int modifiers = m.getModifiers();
                String name = m.getName();
                if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || m.getParameterCount() != 0 || !name.startsWith("as") || (type = m.getReturnType()) == Void.class) continue;
                map.put(type.getName(), m);
            }
            typedValues = Collections.unmodifiableMap(map);
        }
    }

    static class ObjectSetter
    extends PropertySetter {
        ObjectSetter(int valueIndex, Method s) {
            super(valueIndex, Object.class, s);
        }

        @Override
        public void accept(Object obj, ClickHouseValue val) {
            try {
                this.setter.invoke(obj, val.asObject());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(ClickHouseUtils.format("Failed to set %s due to %s", val, e.getMessage()));
            }
        }
    }

    static class ValueSetter
    extends PropertySetter {
        ValueSetter(int valueIndex, Class<?> valueType, Method s) {
            super(valueIndex, valueType, s);
        }

        @Override
        public void accept(Object obj, ClickHouseValue val) {
            try {
                this.setter.invoke(obj, val);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(ClickHouseUtils.format("Failed to set %s due to %s", val, e.getMessage()));
            }
        }
    }
}

