/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.SchemaElement;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.KeyspaceNotDefinedException;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.VirtualKeyspaceRegistry;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.schema.DistributedSchema;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;

public abstract class DescribeStatement<T>
extends CQLStatement.Raw
implements CQLStatement {
    private static final String KS = "system";
    private static final String CF = "describe";
    private static final List<ColumnSpecification> LIST_METADATA = ImmutableList.of((Object)new ColumnSpecification("system", "describe", new ColumnIdentifier("keyspace_name", true), UTF8Type.instance), (Object)new ColumnSpecification("system", "describe", new ColumnIdentifier("type", true), UTF8Type.instance), (Object)new ColumnSpecification("system", "describe", new ColumnIdentifier("name", true), UTF8Type.instance));
    private static final List<ColumnSpecification> ELEMENT_METADATA = ImmutableList.builder().addAll(LIST_METADATA).add((Object)new ColumnSpecification("system", "describe", new ColumnIdentifier("create_statement", true), UTF8Type.instance)).build();
    private static final int PAGING_STATE_VERSION = 1;
    static final String SCHEMA_CHANGED_WHILE_PAGING_MESSAGE = "The schema has changed since the previous page of the DESCRIBE statement result. Please retry the DESCRIBE statement.";
    private boolean includeInternalDetails;

    public final void withInternalDetails() {
        this.includeInternalDetails = true;
    }

    @Override
    public final CQLStatement prepare(ClientState clientState) throws RequestValidationException {
        return this;
    }

    @Override
    public final List<ColumnSpecification> getBindVariables() {
        return Collections.emptyList();
    }

    @Override
    public final void authorize(ClientState state) {
    }

    @Override
    public final void validate(ClientState state) {
    }

    @Override
    public final AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.DESCRIBE);
    }

    @Override
    public final ResultMessage execute(QueryState state, QueryOptions options, Dispatcher.RequestTime requestTime) throws RequestValidationException, RequestExecutionException {
        return this.executeLocally(state, options);
    }

    @Override
    public ResultMessage executeLocally(QueryState state, QueryOptions options) {
        DistributedSchema schema = Schema.instance.getDistributedSchemaBlocking();
        Keyspaces keyspaces = Keyspaces.builder().add(schema.getKeyspaces()).add(Schema.instance.getLocalKeyspaces()).add(VirtualKeyspaceRegistry.instance.virtualKeyspacesMetadata()).build();
        PagingState pagingState = options.getPagingState();
        long offset = this.getOffset(pagingState, schema.getVersion());
        int pageSize = options.getPageSize();
        Stream<Object> stream = this.describe(state.getClientState(), keyspaces);
        if (offset > 0L) {
            stream = stream.skip(offset);
        }
        if (pageSize > 0) {
            stream = stream.limit(pageSize);
        }
        List<List<ByteBuffer>> rows = stream.map(e -> this.toRow(e, this.includeInternalDetails)).collect(Collectors.toList());
        ResultSet.ResultMetadata resultMetadata = new ResultSet.ResultMetadata(this.metadata(state.getClientState()));
        ResultSet result = new ResultSet(resultMetadata, rows);
        if (pageSize > 0 && rows.size() == pageSize) {
            result.metadata.setHasMorePages(this.getPagingState(offset + (long)pageSize, schema.getVersion()));
        }
        return new ResultMessage.Rows(result);
    }

    protected abstract List<ColumnSpecification> metadata(ClientState var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PagingState getPagingState(long nextPageOffset, UUID schemaVersion) {
        try (DataOutputBuffer out = new DataOutputBuffer();){
            out.writeShort(1);
            out.writeUTF(FBUtilities.getReleaseVersionString());
            out.write(UUIDGen.decompose(schemaVersion));
            out.writeLong(nextPageOffset);
            PagingState pagingState = new PagingState(out.asNewBuffer(), null, Integer.MAX_VALUE, Integer.MAX_VALUE);
            return pagingState;
        }
        catch (IOException e) {
            throw new InvalidRequestException("Invalid paging state.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getOffset(PagingState pagingState, UUID schemaVersion) {
        if (pagingState == null) {
            return 0L;
        }
        try (DataInputBuffer in = new DataInputBuffer(pagingState.partitionKey, false);){
            RequestValidations.checkTrue(in.readShort() == 1, "Incompatible paging state");
            String pagingStateServerVersion = in.readUTF();
            String releaseVersion = FBUtilities.getReleaseVersionString();
            RequestValidations.checkTrue(pagingStateServerVersion.equals(releaseVersion), "The server version of the paging state %s is different from the one of the server %s", pagingStateServerVersion, releaseVersion);
            byte[] bytes = new byte[16];
            in.read(bytes);
            UUID version = UUIDGen.getUUID(ByteBuffer.wrap(bytes));
            RequestValidations.checkTrue(schemaVersion.equals(version), SCHEMA_CHANGED_WHILE_PAGING_MESSAGE);
            long l = in.readLong();
            return l;
        }
        catch (IOException e) {
            throw new InvalidRequestException("Invalid paging state.", e);
        }
    }

    protected abstract List<ByteBuffer> toRow(T var1, boolean var2);

    protected abstract Stream<? extends T> describe(ClientState var1, Keyspaces var2);

    private static KeyspaceMetadata validateKeyspace(String ks, Keyspaces keyspaces) {
        return keyspaces.get(ks).orElseThrow(() -> new KeyspaceNotDefinedException(String.format("'%s' not found in keyspaces", ks)));
    }

    public static DescribeStatement<SchemaElement> tables() {
        return new Listing(ks -> ks.tables.stream());
    }

    public static DescribeStatement<SchemaElement> types() {
        return new Listing(ks -> ks.types.stream());
    }

    public static DescribeStatement<SchemaElement> functions() {
        return new Listing(ks -> ks.functions.udfs());
    }

    public static DescribeStatement<SchemaElement> aggregates() {
        return new Listing(ks -> ks.functions.udas());
    }

    public static DescribeStatement<SchemaElement> keyspaces() {
        return new DescribeStatement<SchemaElement>(){

            @Override
            protected Stream<? extends SchemaElement> describe(ClientState state, Keyspaces keyspaces) {
                return keyspaces.stream().sorted(SchemaElement.NAME_COMPARATOR);
            }

            @Override
            protected List<ColumnSpecification> metadata(ClientState state) {
                return LIST_METADATA;
            }

            @Override
            protected List<ByteBuffer> toRow(SchemaElement element, boolean withInternals) {
                return ImmutableList.of((Object)ByteBufferUtil.bytes(element.elementKeyspaceQuotedIfNeeded()), (Object)ByteBufferUtil.bytes(element.elementType().toString()), (Object)ByteBufferUtil.bytes(element.elementNameQuotedIfNeeded()));
            }
        };
    }

    public static DescribeStatement<SchemaElement> schema(final boolean includeSystemKeyspaces) {
        return new DescribeStatement<SchemaElement>(){

            @Override
            protected Stream<? extends SchemaElement> describe(ClientState state, Keyspaces keyspaces) {
                return keyspaces.stream().filter(ks -> includeSystemKeyspaces || !SchemaConstants.isSystemKeyspace(ks.name)).sorted(SchemaElement.NAME_COMPARATOR).flatMap(ks -> DescribeStatement.getKeyspaceElements(ks, false));
            }

            @Override
            protected List<ColumnSpecification> metadata(ClientState state) {
                return ELEMENT_METADATA;
            }

            @Override
            protected List<ByteBuffer> toRow(SchemaElement element, boolean withInternals) {
                return ImmutableList.of((Object)ByteBufferUtil.bytes(element.elementKeyspaceQuotedIfNeeded()), (Object)ByteBufferUtil.bytes(element.elementType().toString()), (Object)ByteBufferUtil.bytes(element.elementNameQuotedIfNeeded()), (Object)ByteBufferUtil.bytes(element.toCqlString(withInternals, false)));
            }
        };
    }

    public static DescribeStatement<SchemaElement> keyspace(String keyspace, boolean onlyKeyspaceDefinition) {
        return new Element(keyspace, null, (ks, t) -> DescribeStatement.getKeyspaceElements(ks, onlyKeyspaceDefinition));
    }

    private static Stream<? extends SchemaElement> getKeyspaceElements(KeyspaceMetadata ks, boolean onlyKeyspace) {
        Stream<SchemaElement> s = Stream.of(ks);
        if (!onlyKeyspace) {
            s = Stream.concat(s, ks.types.sortedStream());
            s = Stream.concat(s, ks.functions.udfs().sorted(SchemaElement.NAME_COMPARATOR));
            s = Stream.concat(s, ks.functions.udas().sorted(SchemaElement.NAME_COMPARATOR));
            s = Stream.concat(s, ks.tables.stream().sorted(SchemaElement.NAME_COMPARATOR).flatMap(tm -> DescribeStatement.getTableElements(ks, tm)));
        }
        return s;
    }

    private static Stream<? extends SchemaElement> getTableElements(KeyspaceMetadata ks, TableMetadata table) {
        Stream<SchemaElement> s = Stream.of(table);
        s = Stream.concat(s, table.indexes.stream().map(i -> DescribeStatement.toDescribable(table, i)).sorted(SchemaElement.NAME_COMPARATOR));
        s = Stream.concat(s, ks.views.stream(table.id).sorted(SchemaElement.NAME_COMPARATOR));
        return s;
    }

    public static DescribeStatement<SchemaElement> table(String keyspace, String name) {
        return new Element(keyspace, name, (ks, t) -> {
            TableMetadata table = RequestValidations.checkNotNull(ks.getTableNullable((String)t), "Table '%s' not found in keyspace '%s'", t, ks.name);
            return Stream.concat(Stream.of(table), table.indexes.stream().map(index -> DescribeStatement.toDescribable(table, index)).sorted(SchemaElement.NAME_COMPARATOR));
        });
    }

    public static DescribeStatement<SchemaElement> index(String keyspace, String name) {
        return new Element(keyspace, name, (ks, index) -> {
            TableMetadata tm = ks.findIndexedTable((String)index).orElseThrow(() -> RequestValidations.invalidRequest("Table for existing index '%s' not found in '%s'", index, ks.name));
            return tm.indexes.get((String)index).map(i -> DescribeStatement.toDescribable(tm, i)).map(Stream::of).orElseThrow(() -> RequestValidations.invalidRequest("Index '%s' not found in '%s'", index, ks.name));
        });
    }

    public static DescribeStatement<SchemaElement> view(String keyspace, String name) {
        return new Element(keyspace, name, (ks, view) -> ks.views.get((String)view).map(Stream::of).orElseThrow(() -> RequestValidations.invalidRequest("Materialized view '%s' not found in '%s'", view, ks.name)));
    }

    public static DescribeStatement<SchemaElement> type(String keyspace, String name) {
        return new Element(keyspace, name, (ks, type) -> ks.types.get(ByteBufferUtil.bytes(type)).map(Stream::of).orElseThrow(() -> RequestValidations.invalidRequest("User defined type '%s' not found in '%s'", type, ks.name)));
    }

    public static DescribeStatement<SchemaElement> function(String keyspace, String name) {
        return new Element(keyspace, name, (ks, n) -> RequestValidations.checkNotEmpty(ks.functions.getUdfs(new FunctionName(ks.name, (String)n)), "User defined function '%s' not found in '%s'", n, ks.name).stream().sorted(SchemaElement.NAME_COMPARATOR));
    }

    public static DescribeStatement<SchemaElement> aggregate(String keyspace, String name) {
        return new Element(keyspace, name, (ks, n) -> RequestValidations.checkNotEmpty(ks.functions.getUdas(new FunctionName(ks.name, (String)n)), "User defined aggregate '%s' not found in '%s'", n, ks.name).stream().sorted(SchemaElement.NAME_COMPARATOR));
    }

    private static SchemaElement toDescribable(final TableMetadata table, final IndexMetadata index) {
        return new SchemaElement(){

            @Override
            public SchemaElement.SchemaElementType elementType() {
                return SchemaElement.SchemaElementType.INDEX;
            }

            @Override
            public String elementKeyspace() {
                return table.keyspace;
            }

            @Override
            public String elementName() {
                return index.name;
            }

            @Override
            public String toCqlString(boolean withInternals, boolean ifNotExists) {
                return index.toCqlString(table, ifNotExists);
            }
        };
    }

    public static DescribeStatement<SchemaElement> generic(final String keyspace, final String name) {
        return new DescribeStatement<SchemaElement>(){
            private DescribeStatement<SchemaElement> delegate;

            private DescribeStatement<SchemaElement> resolve(ClientState state, Keyspaces keyspaces) {
                Optional<IndexMetadata> index;
                String ks = keyspace;
                if (keyspace == null) {
                    if (keyspaces.containsKeyspace(name)) {
                        return 4.keyspace(name, false);
                    }
                    String rawKeyspace = state.getRawKeyspace();
                    ks = rawKeyspace == null ? name : rawKeyspace;
                }
                KeyspaceMetadata keyspaceMetadata = DescribeStatement.validateKeyspace(ks, keyspaces);
                if (keyspaceMetadata.tables.getNullable(name) != null) {
                    return 4.table(ks, name);
                }
                Optional<TableMetadata> indexed = keyspaceMetadata.findIndexedTable(name);
                if (indexed.isPresent() && (index = indexed.get().indexes.get(name)).isPresent()) {
                    return 4.index(ks, name);
                }
                if (keyspaceMetadata.views.getNullable(name) != null) {
                    return 4.view(ks, name);
                }
                throw RequestValidations.invalidRequest("'%s' not found in keyspace '%s'", name, ks);
            }

            @Override
            protected Stream<? extends SchemaElement> describe(ClientState state, Keyspaces keyspaces) {
                this.delegate = this.resolve(state, keyspaces);
                return this.delegate.describe(state, keyspaces);
            }

            @Override
            protected List<ColumnSpecification> metadata(ClientState state) {
                return this.delegate.metadata(state);
            }

            @Override
            protected List<ByteBuffer> toRow(SchemaElement element, boolean withInternals) {
                return this.delegate.toRow(element, withInternals);
            }
        };
    }

    public static DescribeStatement<List<Object>> cluster() {
        return new DescribeStatement<List<Object>>(){
            private static final int CLUSTER_NAME_INDEX = 0;
            private static final int PARTITIONER_NAME_INDEX = 1;
            private static final int SNITCH_CLASS_INDEX = 2;
            private static final int RANGE_OWNERSHIPS_INDEX = 3;

            @Override
            protected Stream<List<Object>> describe(ClientState state, Keyspaces keyspaces) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(DatabaseDescriptor.getClusterName());
                list.add(this.trimIfPresent(DatabaseDescriptor.getPartitionerName(), "org.apache.cassandra.dht."));
                list.add(this.trimIfPresent(DatabaseDescriptor.getEndpointSnitch().getClass().getName(), "org.apache.cassandra.locator."));
                String useKs = state.getRawKeyspace();
                if (this.mustReturnsRangeOwnerships(useKs)) {
                    list.add(StorageService.instance.getRangeToAddressMap(useKs).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toMap(e -> ((Token)((Range)e.getKey()).right).toString(), e -> ((EndpointsForRange)e.getValue()).stream().map(r -> r.endpoint().toString()).collect(Collectors.toList()))));
                }
                return Stream.of(list);
            }

            private boolean mustReturnsRangeOwnerships(String useKs) {
                return useKs != null && !SchemaConstants.isLocalSystemKeyspace(useKs) && !SchemaConstants.isSystemKeyspace(useKs);
            }

            @Override
            protected List<ColumnSpecification> metadata(ClientState state) {
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object[])new ColumnSpecification[]{new ColumnSpecification(DescribeStatement.KS, DescribeStatement.CF, new ColumnIdentifier("cluster", true), UTF8Type.instance), new ColumnSpecification(DescribeStatement.KS, DescribeStatement.CF, new ColumnIdentifier("partitioner", true), UTF8Type.instance), new ColumnSpecification(DescribeStatement.KS, DescribeStatement.CF, new ColumnIdentifier("snitch", true), UTF8Type.instance)});
                if (this.mustReturnsRangeOwnerships(state.getRawKeyspace())) {
                    builder.add((Object)new ColumnSpecification(DescribeStatement.KS, DescribeStatement.CF, new ColumnIdentifier("range_ownership", true), MapType.getInstance(UTF8Type.instance, ListType.getInstance(UTF8Type.instance, false), false)));
                }
                return builder.build();
            }

            @Override
            protected List<ByteBuffer> toRow(List<Object> elements, boolean withInternals) {
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object[])new ByteBuffer[]{UTF8Type.instance.decompose((String)elements.get(0)), UTF8Type.instance.decompose((String)elements.get(1)), UTF8Type.instance.decompose((String)elements.get(2))});
                if (elements.size() > 3) {
                    MapType<String, String> rangeOwnershipType = MapType.getInstance(UTF8Type.instance, ListType.getInstance(UTF8Type.instance, false), false);
                    builder.add((Object)rangeOwnershipType.decompose((Map)elements.get(3)));
                }
                return builder.build();
            }

            private String trimIfPresent(String src, String begin) {
                if (src.startsWith(begin)) {
                    return src.substring(begin.length());
                }
                return src;
            }
        };
    }

    public static class Element
    extends DescribeStatement<SchemaElement> {
        private final String keyspace;
        private final String name;
        private final BiFunction<KeyspaceMetadata, String, Stream<? extends SchemaElement>> elementsProvider;

        public Element(String keyspace, String name, BiFunction<KeyspaceMetadata, String, Stream<? extends SchemaElement>> elementsProvider) {
            this.keyspace = keyspace;
            this.name = name;
            this.elementsProvider = elementsProvider;
        }

        @Override
        protected Stream<? extends SchemaElement> describe(ClientState state, Keyspaces keyspaces) {
            String ks = this.keyspace == null ? RequestValidations.checkNotNull(state.getRawKeyspace(), "No keyspace specified and no current keyspace") : this.keyspace;
            return this.elementsProvider.apply(DescribeStatement.validateKeyspace(ks, keyspaces), this.name);
        }

        @Override
        protected List<ColumnSpecification> metadata(ClientState state) {
            return ELEMENT_METADATA;
        }

        @Override
        protected List<ByteBuffer> toRow(SchemaElement element, boolean withInternals) {
            return ImmutableList.of((Object)ByteBufferUtil.bytes(element.elementKeyspaceQuotedIfNeeded()), (Object)ByteBufferUtil.bytes(element.elementType().toString()), (Object)ByteBufferUtil.bytes(element.elementNameQuotedIfNeeded()), (Object)ByteBufferUtil.bytes(element.toCqlString(withInternals, false)));
        }
    }

    public static final class Listing
    extends DescribeStatement<SchemaElement> {
        private final Function<KeyspaceMetadata, Stream<? extends SchemaElement>> elementsProvider;

        public Listing(Function<KeyspaceMetadata, Stream<? extends SchemaElement>> elementsProvider) {
            this.elementsProvider = elementsProvider;
        }

        @Override
        protected Stream<? extends SchemaElement> describe(ClientState state, Keyspaces keyspaces) {
            String keyspace = state.getRawKeyspace();
            Stream<SchemaElement> stream = keyspace == null ? keyspaces.stream().sorted(SchemaElement.NAME_COMPARATOR) : Stream.of(DescribeStatement.validateKeyspace(keyspace, keyspaces));
            return stream.flatMap(k -> this.elementsProvider.apply((KeyspaceMetadata)k).sorted(SchemaElement.NAME_COMPARATOR));
        }

        @Override
        protected List<ColumnSpecification> metadata(ClientState state) {
            return LIST_METADATA;
        }

        @Override
        protected List<ByteBuffer> toRow(SchemaElement element, boolean withInternals) {
            return ImmutableList.of((Object)ByteBufferUtil.bytes(element.elementKeyspaceQuotedIfNeeded()), (Object)ByteBufferUtil.bytes(element.elementType().toString()), (Object)ByteBufferUtil.bytes(element.elementNameQuotedIfNeeded()));
        }
    }
}

