/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.DebuggableTask;
import org.apache.cassandra.concurrent.SharedExecutorPool;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.MonotonicClock;

final class QueriesTable
extends AbstractVirtualTable {
    private static final String TABLE_NAME = "queries";
    private static final String ID = "thread_id";
    private static final String QUEUED = "queued_micros";
    private static final String RUNNING = "running_micros";
    private static final String DESC = "task";

    QueriesTable(String keyspace) {
        super(TableMetadata.builder(keyspace, TABLE_NAME).comment("Lists currently running queries").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(ID, (AbstractType)UTF8Type.instance).addRegularColumn(QUEUED, (AbstractType)LongType.instance).addRegularColumn(RUNNING, (AbstractType)LongType.instance).addRegularColumn(DESC, (AbstractType)UTF8Type.instance).build());
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        for (DebuggableTask.RunningDebuggableTask task : SharedExecutorPool.SHARED.runningTasks()) {
            if (!task.hasTask()) continue;
            long creationTimeNanos = task.creationTimeNanos();
            long startTimeNanos = task.startTimeNanos();
            long now = MonotonicClock.Global.approxTime.now();
            long queuedMicros = TimeUnit.NANOSECONDS.toMicros(Long.max((startTimeNanos > 0L ? startTimeNanos : now) - creationTimeNanos, 0L));
            long runningMicros = startTimeNanos > 0L ? TimeUnit.NANOSECONDS.toMicros(now - startTimeNanos) : 0L;
            result.row(task.threadId()).column(QUEUED, queuedMicros).column(RUNNING, runningMicros).column(DESC, task.description());
        }
        return result;
    }
}

