/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.sampler.plugins.last;

import java.util.List;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.execution.sampler.ExecutionDataSamplerMeta;
import org.apache.hop.execution.sampler.ExecutionDataSamplerPlugin;
import org.apache.hop.execution.sampler.IExecutionDataSampler;
import org.apache.hop.execution.sampler.plugins.ExecutionDataSamplerBase;
import org.apache.hop.execution.sampler.plugins.last.LastRowsExecutionDataSamplerStore;
import org.apache.hop.pipeline.transform.stream.IStream;

@GuiPlugin
@ExecutionDataSamplerPlugin(id="LastRowsExecutionDataSampler", name="Last output rows", description="Samples the last rows of a transform output")
public class LastRowsExecutionDataSampler
extends ExecutionDataSamplerBase<LastRowsExecutionDataSamplerStore>
implements IExecutionDataSampler<LastRowsExecutionDataSamplerStore> {
    private static final Class<?> PKG = LastRowsExecutionDataSampler.class;

    public LastRowsExecutionDataSampler() {
    }

    public LastRowsExecutionDataSampler(LastRowsExecutionDataSampler sampler) {
        super(sampler);
    }

    public LastRowsExecutionDataSampler(String sampleSize) {
        super(sampleSize, "LastRowsExecutionDataSampler", "Last output rows");
    }

    @Override
    public LastRowsExecutionDataSampler clone() {
        return new LastRowsExecutionDataSampler(this);
    }

    @Override
    public LastRowsExecutionDataSamplerStore createSamplerStore(ExecutionDataSamplerMeta samplerMeta) {
        return new LastRowsExecutionDataSamplerStore(this, samplerMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sampleRow(LastRowsExecutionDataSamplerStore samplerStore, IStream.StreamType streamType, IRowMeta rowMeta, Object[] row) throws HopValueException {
        List<Object[]> list = samplerStore.getRows();
        synchronized (list) {
            List<Object[]> rows = samplerStore.getRows();
            if (streamType != IStream.StreamType.OUTPUT || samplerStore.getMaxRows() <= 0) {
                return;
            }
            if (rows.isEmpty()) {
                samplerStore.setRowMeta(rowMeta);
            }
            rows.add(0, rowMeta.cloneRow(row));
            if (rows.size() > samplerStore.getMaxRows()) {
                rows.remove(rows.size() - 1);
            }
        }
    }
}

