/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.util.DateTime;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.paging.Page;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.StorageObject;
import com.google.auth.ServiceAccountSigner;
import com.google.cloud.FieldSelector;
import com.google.cloud.Policy;
import com.google.cloud.ReadChannel;
import com.google.cloud.Service;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobWriteSession;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.CrossTransportUtils;
import com.google.cloud.storage.HmacKey;
import com.google.cloud.storage.HttpMethod;
import com.google.cloud.storage.Notification;
import com.google.cloud.storage.NotificationInfo;
import com.google.cloud.storage.Option;
import com.google.cloud.storage.PostPolicyV4;
import com.google.cloud.storage.ServiceAccount;
import com.google.cloud.storage.StorageBatch;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.TransportCompatibility;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.Utils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URL;
import java.nio.file.Path;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@InternalExtensionOnly
public interface Storage
extends Service<StorageOptions>,
AutoCloseable {
    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Bucket create(BucketInfo var1, BucketTargetOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob create(BlobInfo var1, BlobTargetOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob create(BlobInfo var1, byte[] var2, BlobTargetOption ... var3);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob create(BlobInfo var1, byte[] var2, int var3, int var4, BlobTargetOption ... var5);

    @Deprecated
    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob create(BlobInfo var1, InputStream var2, BlobWriteOption ... var3);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob createFrom(BlobInfo var1, Path var2, BlobWriteOption ... var3) throws IOException;

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob createFrom(BlobInfo var1, Path var2, int var3, BlobWriteOption ... var4) throws IOException;

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob createFrom(BlobInfo var1, InputStream var2, BlobWriteOption ... var3) throws IOException;

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob createFrom(BlobInfo var1, InputStream var2, int var3, BlobWriteOption ... var4) throws IOException;

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Bucket get(String var1, BucketGetOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Bucket lockRetentionPolicy(BucketInfo var1, BucketTargetOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob get(String var1, String var2, BlobGetOption ... var3);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob get(BlobId var1, BlobGetOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob get(BlobId var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob restore(BlobId var1, BlobRestoreOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Page<Bucket> list(BucketListOption ... var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Page<Blob> list(String var1, BlobListOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Bucket update(BucketInfo var1, BucketTargetOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob update(BlobInfo var1, BlobTargetOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob update(BlobInfo var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public boolean delete(String var1, BucketSourceOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public boolean delete(String var1, String var2, BlobSourceOption ... var3);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public boolean delete(BlobId var1, BlobSourceOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public boolean delete(BlobId var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob compose(ComposeRequest var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public CopyWriter copy(CopyRequest var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public byte[] readAllBytes(String var1, String var2, BlobSourceOption ... var3);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public byte[] readAllBytes(BlobId var1, BlobSourceOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public StorageBatch batch();

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public ReadChannel reader(String var1, String var2, BlobSourceOption ... var3);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public ReadChannel reader(BlobId var1, BlobSourceOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public void downloadTo(BlobId var1, Path var2, BlobSourceOption ... var3);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public void downloadTo(BlobId var1, OutputStream var2, BlobSourceOption ... var3);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public WriteChannel writer(BlobInfo var1, BlobWriteOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public WriteChannel writer(URL var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public URL signUrl(BlobInfo var1, long var2, TimeUnit var4, SignUrlOption ... var5);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo var1, long var2, TimeUnit var4, PostPolicyV4.PostFieldsV4 var5, PostPolicyV4.PostConditionsV4 var6, PostPolicyV4Option ... var7);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo var1, long var2, TimeUnit var4, PostPolicyV4.PostFieldsV4 var5, PostPolicyV4Option ... var6);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo var1, long var2, TimeUnit var4, PostPolicyV4.PostConditionsV4 var5, PostPolicyV4Option ... var6);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo var1, long var2, TimeUnit var4, PostPolicyV4Option ... var5);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public List<Blob> get(BlobId ... var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public List<Blob> get(Iterable<BlobId> var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public List<Blob> update(BlobInfo ... var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public List<Blob> update(Iterable<BlobInfo> var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public List<Boolean> delete(BlobId ... var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public List<Boolean> delete(Iterable<BlobId> var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl getAcl(String var1, Acl.Entity var2, BucketSourceOption ... var3);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl getAcl(String var1, Acl.Entity var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public boolean deleteAcl(String var1, Acl.Entity var2, BucketSourceOption ... var3);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public boolean deleteAcl(String var1, Acl.Entity var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl createAcl(String var1, Acl var2, BucketSourceOption ... var3);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl createAcl(String var1, Acl var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl updateAcl(String var1, Acl var2, BucketSourceOption ... var3);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl updateAcl(String var1, Acl var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public List<Acl> listAcls(String var1, BucketSourceOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public List<Acl> listAcls(String var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl getDefaultAcl(String var1, Acl.Entity var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public boolean deleteDefaultAcl(String var1, Acl.Entity var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl createDefaultAcl(String var1, Acl var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl updateDefaultAcl(String var1, Acl var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public List<Acl> listDefaultAcls(String var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl getAcl(BlobId var1, Acl.Entity var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public boolean deleteAcl(BlobId var1, Acl.Entity var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl createAcl(BlobId var1, Acl var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl updateAcl(BlobId var1, Acl var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public List<Acl> listAcls(BlobId var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public HmacKey createHmacKey(ServiceAccount var1, CreateHmacKeyOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public Page<HmacKey.HmacKeyMetadata> listHmacKeys(ListHmacKeysOption ... var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public HmacKey.HmacKeyMetadata getHmacKey(String var1, GetHmacKeyOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public void deleteHmacKey(HmacKey.HmacKeyMetadata var1, DeleteHmacKeyOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public HmacKey.HmacKeyMetadata updateHmacKeyState(HmacKey.HmacKeyMetadata var1, HmacKey.HmacKeyState var2, UpdateHmacKeyOption ... var3);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Policy getIamPolicy(String var1, BucketSourceOption ... var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Policy setIamPolicy(String var1, Policy var2, BucketSourceOption ... var3);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public List<Boolean> testIamPermissions(String var1, List<String> var2, BucketSourceOption ... var3);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public ServiceAccount getServiceAccount(String var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public Notification createNotification(String var1, NotificationInfo var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public Notification getNotification(String var1, String var2);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public List<Notification> listNotifications(String var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public boolean deleteNotification(String var1, String var2);

    @Override
    default public void close() throws Exception {
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC, TransportCompatibility.Transport.HTTP})
    default public BlobWriteSession blobWriteSession(BlobInfo blobInfo, BlobWriteOption ... options) {
        return (BlobWriteSession)CrossTransportUtils.throwGrpcOnly(CrossTransportUtils.fmtMethodName("blobWriteSession", BlobInfo.class, BlobWriteOption.class));
    }

    public static class BlobWriteOption
    extends Option<UnifiedOpts.ObjectTargetOpt>
    implements Serializable {
        private static final long serialVersionUID = 5536338021856320475L;

        BlobWriteOption(UnifiedOpts.ObjectTargetOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption predefinedAcl(@NonNull PredefinedAcl acl) {
            return new BlobWriteOption(UnifiedOpts.predefinedAcl(acl));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption doesNotExist() {
            return new BlobWriteOption(UnifiedOpts.doesNotExist());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption generationMatch() {
            return new BlobWriteOption(UnifiedOpts.generationMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption generationMatch(long generation) {
            return new BlobWriteOption(UnifiedOpts.generationMatch(generation));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption generationNotMatch() {
            return new BlobWriteOption(UnifiedOpts.generationNotMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption generationNotMatch(long generation) {
            return new BlobWriteOption(UnifiedOpts.generationNotMatch(generation));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption metagenerationMatch() {
            return new BlobWriteOption(UnifiedOpts.metagenerationMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption metagenerationMatch(long metageneration) {
            return new BlobWriteOption(UnifiedOpts.metagenerationMatch(metageneration));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption metagenerationNotMatch() {
            return new BlobWriteOption(UnifiedOpts.metagenerationNotMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption metagenerationNotMatch(long metageneration) {
            return new BlobWriteOption(UnifiedOpts.metagenerationNotMatch(metageneration));
        }

        @Deprecated
        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption md5Match() {
            return new BlobWriteOption(UnifiedOpts.md5MatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption crc32cMatch() {
            return new BlobWriteOption(UnifiedOpts.crc32cMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption encryptionKey(@NonNull Key key) {
            return new BlobWriteOption(UnifiedOpts.encryptionKey(key));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption encryptionKey(@NonNull String key) {
            return new BlobWriteOption(UnifiedOpts.encryptionKey(key));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption kmsKeyName(@NonNull String kmsKeyName) {
            return new BlobWriteOption(UnifiedOpts.kmsKeyName(kmsKeyName));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption userProject(@NonNull String userProject) {
            return new BlobWriteOption(UnifiedOpts.userProject(userProject));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption disableGzipContent() {
            return new BlobWriteOption(UnifiedOpts.disableGzipContent());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption detectContentType() {
            return new BlobWriteOption(UnifiedOpts.detectContentType());
        }

        @BetaApi
        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption expectedObjectSize(long objectContentSize) {
            return new BlobWriteOption(UnifiedOpts.resumableUploadExpectedObjectSize(objectContentSize));
        }

        @BetaApi
        public static BlobWriteOption[] dedupe(BlobWriteOption ... os) {
            return (BlobWriteOption[])Option.dedupe(BlobWriteOption[]::new, (Option[])os);
        }

        @BetaApi
        public static BlobWriteOption[] dedupe(Collection<BlobWriteOption> collection, BlobWriteOption ... os) {
            return (BlobWriteOption[])Option.dedupe(BlobWriteOption[]::new, collection, (Option[])os);
        }

        @BetaApi
        public static BlobWriteOption[] dedupe(BlobWriteOption[] array, BlobWriteOption ... os) {
            return (BlobWriteOption[])Option.dedupe(BlobWriteOption[]::new, (Option[])array, (Option[])os);
        }
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public static class CopyRequest
    implements Serializable {
        private static final long serialVersionUID = 5670794463350011330L;
        private final BlobId source;
        private final List<BlobSourceOption> sourceOptions;
        private final boolean overrideInfo;
        private final BlobInfo target;
        private final List<BlobTargetOption> targetOptions;
        private final Long megabytesCopiedPerChunk;

        private CopyRequest(Builder builder) {
            this.source = (BlobId)Preconditions.checkNotNull((Object)builder.source);
            this.sourceOptions = ImmutableList.copyOf((Collection)builder.sourceOptions);
            this.overrideInfo = builder.overrideInfo;
            this.target = (BlobInfo)Preconditions.checkNotNull((Object)builder.target);
            this.targetOptions = ImmutableList.copyOf((Collection)builder.targetOptions);
            this.megabytesCopiedPerChunk = builder.megabytesCopiedPerChunk;
        }

        public BlobId getSource() {
            return this.source;
        }

        public List<BlobSourceOption> getSourceOptions() {
            return this.sourceOptions;
        }

        public BlobInfo getTarget() {
            return this.target;
        }

        public boolean overrideInfo() {
            return this.overrideInfo;
        }

        public List<BlobTargetOption> getTargetOptions() {
            return this.targetOptions;
        }

        public Long getMegabytesCopiedPerChunk() {
            return this.megabytesCopiedPerChunk;
        }

        public static CopyRequest of(String sourceBucket, String sourceBlob, BlobInfo target) {
            return CopyRequest.newBuilder().setSource(sourceBucket, sourceBlob).setTarget(target, new BlobTargetOption[0]).build();
        }

        public static CopyRequest of(BlobId sourceBlobId, BlobInfo target) {
            return CopyRequest.newBuilder().setSource(sourceBlobId).setTarget(target, new BlobTargetOption[0]).build();
        }

        public static CopyRequest of(String sourceBucket, String sourceBlob, String targetBlob) {
            return CopyRequest.newBuilder().setSource(sourceBucket, sourceBlob).setTarget(BlobId.of(sourceBucket, targetBlob)).build();
        }

        public static CopyRequest of(String sourceBucket, String sourceBlob, BlobId target) {
            return CopyRequest.newBuilder().setSource(sourceBucket, sourceBlob).setTarget(target).build();
        }

        public static CopyRequest of(BlobId sourceBlobId, String targetBlob) {
            return CopyRequest.newBuilder().setSource(sourceBlobId).setTarget(BlobId.of(sourceBlobId.getBucket(), targetBlob)).build();
        }

        public static CopyRequest of(BlobId sourceBlobId, BlobId targetBlobId) {
            return CopyRequest.newBuilder().setSource(sourceBlobId).setTarget(targetBlobId).build();
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private final Set<BlobSourceOption> sourceOptions = new LinkedHashSet<BlobSourceOption>();
            private final Set<BlobTargetOption> targetOptions = new LinkedHashSet<BlobTargetOption>();
            private BlobId source;
            private boolean overrideInfo;
            private BlobInfo target;
            private Long megabytesCopiedPerChunk;

            public Builder setSource(String bucket, String blob) {
                this.source = BlobId.of(bucket, blob);
                return this;
            }

            public Builder setSource(BlobId source) {
                this.source = source;
                return this;
            }

            public Builder setSourceOptions(BlobSourceOption ... options) {
                Collections.addAll(this.sourceOptions, options);
                return this;
            }

            public Builder setSourceOptions(Iterable<BlobSourceOption> options) {
                Iterables.addAll(this.sourceOptions, options);
                return this;
            }

            public Builder setTarget(BlobId targetId) {
                this.overrideInfo = false;
                this.target = BlobInfo.newBuilder(targetId).build();
                return this;
            }

            public Builder setTarget(BlobId targetId, BlobTargetOption ... options) {
                this.overrideInfo = false;
                this.target = BlobInfo.newBuilder(targetId).build();
                Collections.addAll(this.targetOptions, options);
                return this;
            }

            public Builder setTarget(BlobInfo target, BlobTargetOption ... options) {
                this.overrideInfo = true;
                this.target = (BlobInfo)Preconditions.checkNotNull((Object)target);
                Collections.addAll(this.targetOptions, options);
                return this;
            }

            public Builder setTarget(BlobInfo target, Iterable<BlobTargetOption> options) {
                this.overrideInfo = true;
                this.target = (BlobInfo)Preconditions.checkNotNull((Object)target);
                Iterables.addAll(this.targetOptions, options);
                return this;
            }

            public Builder setTarget(BlobId targetId, Iterable<BlobTargetOption> options) {
                this.overrideInfo = false;
                this.target = BlobInfo.newBuilder(targetId).build();
                Iterables.addAll(this.targetOptions, options);
                return this;
            }

            public Builder setMegabytesCopiedPerChunk(Long megabytesCopiedPerChunk) {
                this.megabytesCopiedPerChunk = megabytesCopiedPerChunk;
                return this;
            }

            public CopyRequest build() {
                return new CopyRequest(this);
            }
        }
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public static class ComposeRequest
    implements Serializable {
        private static final long serialVersionUID = 6612204553167273919L;
        private final List<SourceBlob> sourceBlobs;
        private final BlobInfo target;
        private final List<BlobTargetOption> targetOptions;
        private transient UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> targetOpts;

        private ComposeRequest(Builder builder) {
            this.sourceBlobs = ImmutableList.copyOf((Collection)builder.sourceBlobs);
            this.target = builder.target;
            this.targetOptions = ImmutableList.copyOf((Collection)builder.targetOptions);
            this.targetOpts = builder.opts.prepend(UnifiedOpts.Opts.unwrap(this.targetOptions).resolveFrom(this.target));
        }

        public List<SourceBlob> getSourceBlobs() {
            return this.sourceBlobs;
        }

        public BlobInfo getTarget() {
            return this.target;
        }

        public List<BlobTargetOption> getTargetOptions() {
            return this.targetOptions;
        }

        @InternalApi
        UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> getTargetOpts() {
            return this.targetOpts;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.targetOpts = this.targetOptions != null ? UnifiedOpts.Opts.unwrap(this.targetOptions) : UnifiedOpts.Opts.empty();
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static ComposeRequest of(Iterable<String> sources, BlobInfo target) {
            return ComposeRequest.newBuilder().setTarget(target).addSource(sources).build();
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static ComposeRequest of(String bucket, Iterable<String> sources, String target) {
            return ComposeRequest.of(sources, BlobInfo.newBuilder(BlobId.of(bucket, target)).build());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static Builder newBuilder() {
            return new Builder();
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static class Builder {
            private final List<SourceBlob> sourceBlobs = new LinkedList<SourceBlob>();
            private final Set<BlobTargetOption> targetOptions = new LinkedHashSet<BlobTargetOption>();
            private BlobInfo target;
            private UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts = UnifiedOpts.Opts.empty();

            public Builder addSource(Iterable<String> blobs) {
                for (String blob : blobs) {
                    this.sourceBlobs.add(new SourceBlob(blob));
                }
                return this;
            }

            public Builder addSource(String ... blobs) {
                return this.addSource(Arrays.asList(blobs));
            }

            public Builder addSource(String blob, long generation) {
                this.sourceBlobs.add(new SourceBlob(blob, generation));
                return this;
            }

            public Builder setTarget(BlobInfo target) {
                this.target = target;
                return this;
            }

            Builder setTargetOpts(UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
                this.opts = opts;
                return this;
            }

            public Builder setTargetOptions(BlobTargetOption ... options) {
                Collections.addAll(this.targetOptions, options);
                return this;
            }

            public Builder setTargetOptions(Iterable<BlobTargetOption> options) {
                Iterables.addAll(this.targetOptions, options);
                return this;
            }

            public ComposeRequest build() {
                Preconditions.checkArgument((!this.sourceBlobs.isEmpty() ? 1 : 0) != 0);
                Preconditions.checkNotNull((Object)this.target);
                Preconditions.checkNotNull(this.opts);
                return new ComposeRequest(this);
            }
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static class SourceBlob
        implements Serializable {
            private static final long serialVersionUID = -157636474404489874L;
            final String name;
            final Long generation;

            SourceBlob(String name) {
                this(name, null);
            }

            SourceBlob(String name, Long generation) {
                this.name = name;
                this.generation = generation;
            }

            public String getName() {
                return this.name;
            }

            public Long getGeneration() {
                return this.generation;
            }
        }
    }

    public static class SignUrlOption
    implements Serializable {
        private static final long serialVersionUID = -3165388740755311106L;
        private final Option option;
        private final Object value;

        private SignUrlOption(Option option, Object value) {
            this.option = option;
            this.value = value;
        }

        Option getOption() {
            return this.option;
        }

        Object getValue() {
            return this.value;
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static SignUrlOption httpMethod(HttpMethod httpMethod) {
            return new SignUrlOption(Option.HTTP_METHOD, (Object)httpMethod);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static SignUrlOption withContentType() {
            return new SignUrlOption(Option.CONTENT_TYPE, true);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static SignUrlOption withMd5() {
            return new SignUrlOption(Option.MD5, true);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static SignUrlOption withExtHeaders(Map<String, String> extHeaders) {
            return new SignUrlOption(Option.EXT_HEADERS, extHeaders);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static SignUrlOption withV2Signature() {
            return new SignUrlOption(Option.SIGNATURE_VERSION, (Object)SignatureVersion.V2);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static SignUrlOption withV4Signature() {
            return new SignUrlOption(Option.SIGNATURE_VERSION, (Object)SignatureVersion.V4);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static SignUrlOption signWith(ServiceAccountSigner signer) {
            return new SignUrlOption(Option.SERVICE_ACCOUNT_CRED, signer);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static SignUrlOption withHostName(String hostName) {
            return new SignUrlOption(Option.HOST_NAME, hostName);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static SignUrlOption withVirtualHostedStyle() {
            return new SignUrlOption(Option.VIRTUAL_HOSTED_STYLE, "");
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static SignUrlOption withPathStyle() {
            return new SignUrlOption(Option.PATH_STYLE, "");
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static SignUrlOption withBucketBoundHostname(String bucketBoundHostname) {
            return SignUrlOption.withBucketBoundHostname(bucketBoundHostname, UriScheme.HTTP);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static SignUrlOption withBucketBoundHostname(String bucketBoundHostname, UriScheme uriScheme) {
            return new SignUrlOption(Option.BUCKET_BOUND_HOST_NAME, uriScheme.getScheme() + "://" + bucketBoundHostname);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static SignUrlOption withQueryParams(Map<String, String> queryParams) {
            return new SignUrlOption(Option.QUERY_PARAMS, queryParams);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        static enum Option {
            HTTP_METHOD,
            CONTENT_TYPE,
            MD5,
            EXT_HEADERS,
            SERVICE_ACCOUNT_CRED,
            SIGNATURE_VERSION,
            HOST_NAME,
            PATH_STYLE,
            VIRTUAL_HOSTED_STYLE,
            BUCKET_BOUND_HOST_NAME,
            QUERY_PARAMS;

        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        static enum SignatureVersion {
            V2,
            V4;

        }
    }

    public static class PostPolicyV4Option
    implements Serializable {
        private static final long serialVersionUID = -1592545784993528897L;
        private final Option option;
        private final Object value;

        private PostPolicyV4Option(Option option, Object value) {
            this.option = option;
            this.value = value;
        }

        Option getOption() {
            return this.option;
        }

        Object getValue() {
            return this.value;
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static PostPolicyV4Option signWith(ServiceAccountSigner signer) {
            return new PostPolicyV4Option(Option.SERVICE_ACCOUNT_CRED, signer);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static PostPolicyV4Option withVirtualHostedStyle() {
            return new PostPolicyV4Option(Option.VIRTUAL_HOSTED_STYLE, "");
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static PostPolicyV4Option withPathStyle() {
            return new PostPolicyV4Option(Option.PATH_STYLE, "");
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static PostPolicyV4Option withBucketBoundHostname(String bucketBoundHostname) {
            return PostPolicyV4Option.withBucketBoundHostname(bucketBoundHostname, UriScheme.HTTP);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static PostPolicyV4Option withBucketBoundHostname(String bucketBoundHostname, UriScheme uriScheme) {
            return new PostPolicyV4Option(Option.BUCKET_BOUND_HOST_NAME, uriScheme.getScheme() + "://" + bucketBoundHostname);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        static enum Option {
            PATH_STYLE,
            VIRTUAL_HOSTED_STYLE,
            BUCKET_BOUND_HOST_NAME,
            SERVICE_ACCOUNT_CRED;

        }
    }

    public static class BlobListOption
    extends Option<UnifiedOpts.ObjectListOpt> {
        private static final long serialVersionUID = 5216908055423927281L;

        private BlobListOption(UnifiedOpts.ObjectListOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobListOption pageSize(long pageSize) {
            return new BlobListOption(UnifiedOpts.pageSize(pageSize));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobListOption pageToken(@NonNull String pageToken) {
            return new BlobListOption(UnifiedOpts.pageToken(pageToken));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobListOption prefix(@NonNull String prefix) {
            return new BlobListOption(UnifiedOpts.prefix(prefix));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobListOption currentDirectory() {
            return new BlobListOption(UnifiedOpts.currentDirectory());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobListOption delimiter(@NonNull String delimiter) {
            return new BlobListOption(UnifiedOpts.delimiter(delimiter));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobListOption startOffset(@NonNull String startOffset) {
            return new BlobListOption(UnifiedOpts.startOffset(startOffset));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobListOption endOffset(@NonNull String endOffset) {
            return new BlobListOption(UnifiedOpts.endOffset(endOffset));
        }

        @BetaApi
        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static BlobListOption matchGlob(@NonNull String glob) {
            return new BlobListOption(UnifiedOpts.matchGlob(glob));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobListOption includeFolders(boolean includeFolders) {
            return new BlobListOption(UnifiedOpts.includeFoldersAsPrefixes(includeFolders));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobListOption userProject(@NonNull String userProject) {
            return new BlobListOption(UnifiedOpts.userProject(userProject));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobListOption versions(boolean versions) {
            return new BlobListOption(UnifiedOpts.versionsFilter(versions));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobListOption fields(BlobField ... fields) {
            Objects.requireNonNull(fields, "fields must be non null");
            ImmutableSet set = (ImmutableSet)Streams.concat((Stream[])new Stream[]{Stream.of(UnifiedOpts.NamedField.literal("nextPageToken"), UnifiedOpts.NamedField.literal("prefixes")), Streams.concat((Stream[])new Stream[]{BlobField.REQUIRED_FIELDS.stream(), Arrays.stream(fields)}).map(f -> UnifiedOpts.NamedField.prefixed("items/", f))}).collect(ImmutableSet.toImmutableSet());
            return new BlobListOption(UnifiedOpts.fields((ImmutableSet<UnifiedOpts.NamedField>)set));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobListOption softDeleted(boolean softDeleted) {
            return new BlobListOption(UnifiedOpts.softDeleted(softDeleted));
        }

        @BetaApi
        public static BlobListOption[] dedupe(BlobListOption ... os) {
            return (BlobListOption[])Option.dedupe(BlobListOption[]::new, (Option[])os);
        }

        @BetaApi
        public static BlobListOption[] dedupe(Collection<BlobListOption> collection, BlobListOption ... os) {
            return (BlobListOption[])Option.dedupe(BlobListOption[]::new, collection, (Option[])os);
        }

        @BetaApi
        public static BlobListOption[] dedupe(BlobListOption[] array, BlobListOption ... os) {
            return (BlobListOption[])Option.dedupe(BlobListOption[]::new, (Option[])array, (Option[])os);
        }
    }

    public static class BucketListOption
    extends Option<UnifiedOpts.BucketListOpt> {
        private static final long serialVersionUID = 6388807550815607557L;

        private BucketListOption(UnifiedOpts.BucketListOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketListOption pageSize(long pageSize) {
            return new BucketListOption(UnifiedOpts.pageSize(pageSize));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketListOption pageToken(@NonNull String pageToken) {
            return new BucketListOption(UnifiedOpts.pageToken(pageToken));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketListOption prefix(@NonNull String prefix) {
            return new BucketListOption(UnifiedOpts.prefix(prefix));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketListOption userProject(@NonNull String userProject) {
            return new BucketListOption(UnifiedOpts.userProject(userProject));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketListOption fields(BucketField ... fields) {
            Objects.requireNonNull(fields, "fields must be non null");
            ImmutableSet set = (ImmutableSet)Streams.concat((Stream[])new Stream[]{Stream.of(UnifiedOpts.NamedField.literal("nextPageToken")), Streams.concat((Stream[])new Stream[]{BucketField.REQUIRED_FIELDS.stream(), Arrays.stream(fields)}).map(f -> UnifiedOpts.NamedField.prefixed("items/", f))}).collect(ImmutableSet.toImmutableSet());
            return new BucketListOption(UnifiedOpts.fields((ImmutableSet<UnifiedOpts.NamedField>)set));
        }

        @BetaApi
        public static BucketListOption[] dedupe(BucketListOption ... os) {
            return (BucketListOption[])Option.dedupe(BucketListOption[]::new, (Option[])os);
        }

        @BetaApi
        public static BucketListOption[] dedupe(Collection<BucketListOption> collection, BucketListOption ... os) {
            return (BucketListOption[])Option.dedupe(BucketListOption[]::new, collection, (Option[])os);
        }

        @BetaApi
        public static BucketListOption[] dedupe(BucketListOption[] array, BucketListOption ... os) {
            return (BucketListOption[])Option.dedupe(BucketListOption[]::new, (Option[])array, (Option[])os);
        }
    }

    public static class BlobRestoreOption
    extends Option<UnifiedOpts.ObjectSourceOpt> {
        private static final long serialVersionUID = 1922118465380110958L;

        BlobRestoreOption(UnifiedOpts.ObjectSourceOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobRestoreOption generationMatch(long generation) {
            return new BlobRestoreOption(UnifiedOpts.generationMatch(generation));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobRestoreOption generationNotMatch(long generation) {
            return new BlobRestoreOption(UnifiedOpts.generationNotMatch(generation));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobRestoreOption metagenerationMatch(long generation) {
            return new BlobRestoreOption(UnifiedOpts.metagenerationMatch(generation));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobRestoreOption metagenerationNotMatch(long generation) {
            return new BlobRestoreOption(UnifiedOpts.metagenerationNotMatch(generation));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobRestoreOption copySourceAcl(boolean copySourceAcl) {
            return new BlobRestoreOption(UnifiedOpts.copySourceAcl(copySourceAcl));
        }
    }

    public static class BlobGetOption
    extends Option<UnifiedOpts.ObjectSourceOpt> {
        private static final long serialVersionUID = -2857961421224394114L;

        BlobGetOption(UnifiedOpts.ObjectSourceOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobGetOption generationMatch() {
            return new BlobGetOption(UnifiedOpts.generationMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobGetOption generationMatch(long generation) {
            return new BlobGetOption(UnifiedOpts.generationMatch(generation));
        }

        @Deprecated
        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobGetOption generationNotMatch() {
            return new BlobGetOption(UnifiedOpts.generationNotMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobGetOption generationNotMatch(long generation) {
            return new BlobGetOption(UnifiedOpts.generationNotMatch(generation));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobGetOption metagenerationMatch(long metageneration) {
            return new BlobGetOption(UnifiedOpts.metagenerationMatch(metageneration));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobGetOption metagenerationNotMatch(long metageneration) {
            return new BlobGetOption(UnifiedOpts.metagenerationNotMatch(metageneration));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobGetOption fields(BlobField ... fields) {
            Objects.requireNonNull(fields, "fields must be non null");
            ImmutableSet set = ImmutableSet.builder().addAll(BlobField.REQUIRED_FIELDS).add((Object[])fields).build();
            return new BlobGetOption(UnifiedOpts.fields((ImmutableSet<UnifiedOpts.NamedField>)set));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobGetOption userProject(@NonNull String userProject) {
            return new BlobGetOption(UnifiedOpts.userProject(userProject));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobGetOption decryptionKey(@NonNull Key key) {
            return new BlobGetOption(UnifiedOpts.decryptionKey(key));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobGetOption decryptionKey(@NonNull String key) {
            return new BlobGetOption(UnifiedOpts.decryptionKey(key));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobGetOption shouldReturnRawInputStream(boolean shouldReturnRawInputStream) {
            return new BlobGetOption(UnifiedOpts.returnRawInputStream(shouldReturnRawInputStream));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobGetOption softDeleted(boolean softDeleted) {
            return new BlobGetOption(UnifiedOpts.softDeleted(softDeleted));
        }

        @BetaApi
        public static BlobGetOption[] dedupe(BlobGetOption ... os) {
            return (BlobGetOption[])Option.dedupe(BlobGetOption[]::new, (Option[])os);
        }

        @BetaApi
        public static BlobGetOption[] dedupe(Collection<BlobGetOption> collection, BlobGetOption ... os) {
            return (BlobGetOption[])Option.dedupe(BlobGetOption[]::new, collection, (Option[])os);
        }

        @BetaApi
        public static BlobGetOption[] dedupe(BlobGetOption[] array, BlobGetOption ... os) {
            return (BlobGetOption[])Option.dedupe(BlobGetOption[]::new, (Option[])array, (Option[])os);
        }
    }

    public static class BlobSourceOption
    extends Option<UnifiedOpts.ObjectSourceOpt> {
        private static final long serialVersionUID = -8626355836092280204L;

        BlobSourceOption(UnifiedOpts.ObjectSourceOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption generationMatch() {
            return new BlobSourceOption(UnifiedOpts.generationMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption generationMatch(long generation) {
            return new BlobSourceOption(UnifiedOpts.generationMatch(generation));
        }

        @Deprecated
        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption generationNotMatch() {
            return new BlobSourceOption(UnifiedOpts.generationNotMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption generationNotMatch(long generation) {
            return new BlobSourceOption(UnifiedOpts.generationNotMatch(generation));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption metagenerationMatch(long metageneration) {
            return new BlobSourceOption(UnifiedOpts.metagenerationMatch(metageneration));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption metagenerationNotMatch(long metageneration) {
            return new BlobSourceOption(UnifiedOpts.metagenerationNotMatch(metageneration));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption decryptionKey(@NonNull Key key) {
            return new BlobSourceOption(UnifiedOpts.decryptionKey(key));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption decryptionKey(@NonNull String key) {
            return new BlobSourceOption(UnifiedOpts.decryptionKey(key));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption userProject(@NonNull String userProject) {
            return new BlobSourceOption(UnifiedOpts.userProject(userProject));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobSourceOption shouldReturnRawInputStream(boolean shouldReturnRawInputStream) {
            return new BlobSourceOption(UnifiedOpts.returnRawInputStream(shouldReturnRawInputStream));
        }

        @BetaApi
        public static BlobSourceOption[] dedupe(BlobSourceOption ... os) {
            return (BlobSourceOption[])Option.dedupe(BlobSourceOption[]::new, (Option[])os);
        }

        @BetaApi
        public static BlobSourceOption[] dedupe(Collection<BlobSourceOption> collection, BlobSourceOption ... os) {
            return (BlobSourceOption[])Option.dedupe(BlobSourceOption[]::new, collection, (Option[])os);
        }

        @BetaApi
        public static BlobSourceOption[] dedupe(BlobSourceOption[] array, BlobSourceOption ... os) {
            return (BlobSourceOption[])Option.dedupe(BlobSourceOption[]::new, (Option[])array, (Option[])os);
        }
    }

    public static class BlobTargetOption
    extends Option<UnifiedOpts.ObjectTargetOpt> {
        private static final long serialVersionUID = -5554842495450599563L;

        BlobTargetOption(UnifiedOpts.ObjectTargetOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption predefinedAcl(@NonNull PredefinedAcl acl) {
            return new BlobTargetOption(UnifiedOpts.predefinedAcl(acl));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption doesNotExist() {
            return new BlobTargetOption(UnifiedOpts.doesNotExist());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption generationMatch() {
            return new BlobTargetOption(UnifiedOpts.generationMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption generationMatch(long generation) {
            return new BlobTargetOption(UnifiedOpts.generationMatch(generation));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption generationNotMatch(long generation) {
            return new BlobTargetOption(UnifiedOpts.generationNotMatch(generation));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption generationNotMatch() {
            return new BlobTargetOption(UnifiedOpts.generationNotMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption metagenerationMatch() {
            return new BlobTargetOption(UnifiedOpts.metagenerationMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption metagenerationMatch(long metageneration) {
            return new BlobTargetOption(UnifiedOpts.metagenerationMatch(metageneration));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption metagenerationNotMatch(long metageneration) {
            return new BlobTargetOption(UnifiedOpts.metagenerationNotMatch(metageneration));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption metagenerationNotMatch() {
            return new BlobTargetOption(UnifiedOpts.metagenerationNotMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption disableGzipContent() {
            return new BlobTargetOption(UnifiedOpts.disableGzipContent());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption detectContentType() {
            return new BlobTargetOption(UnifiedOpts.detectContentType());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption encryptionKey(@NonNull Key key) {
            return new BlobTargetOption(UnifiedOpts.encryptionKey(key));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption userProject(@NonNull String userProject) {
            return new BlobTargetOption(UnifiedOpts.userProject(userProject));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption encryptionKey(@NonNull String key) {
            return new BlobTargetOption(UnifiedOpts.encryptionKey(key));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption kmsKeyName(@NonNull String kmsKeyName) {
            return new BlobTargetOption(UnifiedOpts.kmsKeyName(kmsKeyName));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static BlobTargetOption overrideUnlockedRetention(boolean overrideUnlockedRetention) {
            return new BlobTargetOption(UnifiedOpts.overrideUnlockedRetention(overrideUnlockedRetention));
        }

        @BetaApi
        public static BlobTargetOption[] dedupe(BlobTargetOption ... os) {
            return (BlobTargetOption[])Option.dedupe(BlobTargetOption[]::new, (Option[])os);
        }

        @BetaApi
        public static BlobTargetOption[] dedupe(Collection<BlobTargetOption> collection, BlobTargetOption ... os) {
            return (BlobTargetOption[])Option.dedupe(BlobTargetOption[]::new, collection, (Option[])os);
        }

        @BetaApi
        public static BlobTargetOption[] dedupe(BlobTargetOption[] array, BlobTargetOption ... os) {
            return (BlobTargetOption[])Option.dedupe(BlobTargetOption[]::new, (Option[])array, (Option[])os);
        }
    }

    public static class BucketGetOption
    extends Option<UnifiedOpts.BucketSourceOpt> {
        private static final long serialVersionUID = -669900932880354035L;

        BucketGetOption(UnifiedOpts.BucketSourceOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketGetOption metagenerationMatch(long metageneration) {
            return new BucketGetOption(UnifiedOpts.metagenerationMatch(metageneration));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketGetOption metagenerationNotMatch(long metageneration) {
            return new BucketGetOption(UnifiedOpts.metagenerationNotMatch(metageneration));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketGetOption userProject(@NonNull String userProject) {
            return new BucketGetOption(UnifiedOpts.userProject(userProject));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketGetOption fields(BucketField ... fields) {
            Objects.requireNonNull(fields, "fields must be non null");
            ImmutableSet set = ImmutableSet.builder().addAll(BucketField.REQUIRED_FIELDS).add((Object[])fields).build();
            return new BucketGetOption(UnifiedOpts.fields((ImmutableSet<UnifiedOpts.NamedField>)set));
        }

        @BetaApi
        public static BucketGetOption[] dedupe(BucketGetOption ... os) {
            return (BucketGetOption[])Option.dedupe(BucketGetOption[]::new, (Option[])os);
        }

        @BetaApi
        public static BucketGetOption[] dedupe(Collection<BucketGetOption> collection, BucketGetOption ... os) {
            return (BucketGetOption[])Option.dedupe(BucketGetOption[]::new, collection, (Option[])os);
        }

        @BetaApi
        public static BucketGetOption[] dedupe(BucketGetOption[] array, BucketGetOption ... os) {
            return (BucketGetOption[])Option.dedupe(BucketGetOption[]::new, (Option[])array, (Option[])os);
        }
    }

    public static class UpdateHmacKeyOption
    extends Option<UnifiedOpts.HmacKeyTargetOpt> {
        private UpdateHmacKeyOption(UnifiedOpts.HmacKeyTargetOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static UpdateHmacKeyOption userProject(@NonNull String userProject) {
            return new UpdateHmacKeyOption(UnifiedOpts.userProject(userProject));
        }

        @BetaApi
        public static UpdateHmacKeyOption[] dedupe(UpdateHmacKeyOption ... os) {
            return (UpdateHmacKeyOption[])Option.dedupe(UpdateHmacKeyOption[]::new, (Option[])os);
        }

        @BetaApi
        public static UpdateHmacKeyOption[] dedupe(Collection<UpdateHmacKeyOption> collection, UpdateHmacKeyOption ... os) {
            return (UpdateHmacKeyOption[])Option.dedupe(UpdateHmacKeyOption[]::new, collection, (Option[])os);
        }

        @BetaApi
        public static UpdateHmacKeyOption[] dedupe(UpdateHmacKeyOption[] array, UpdateHmacKeyOption ... os) {
            return (UpdateHmacKeyOption[])Option.dedupe(UpdateHmacKeyOption[]::new, (Option[])array, (Option[])os);
        }
    }

    public static class DeleteHmacKeyOption
    extends Option<UnifiedOpts.HmacKeyTargetOpt> {
        private DeleteHmacKeyOption(UnifiedOpts.HmacKeyTargetOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static DeleteHmacKeyOption userProject(@NonNull String userProject) {
            return new DeleteHmacKeyOption(UnifiedOpts.userProject(userProject));
        }

        @BetaApi
        public static DeleteHmacKeyOption[] dedupe(DeleteHmacKeyOption ... os) {
            return (DeleteHmacKeyOption[])Option.dedupe(DeleteHmacKeyOption[]::new, (Option[])os);
        }

        @BetaApi
        public static DeleteHmacKeyOption[] dedupe(Collection<DeleteHmacKeyOption> collection, DeleteHmacKeyOption ... os) {
            return (DeleteHmacKeyOption[])Option.dedupe(DeleteHmacKeyOption[]::new, collection, (Option[])os);
        }

        @BetaApi
        public static DeleteHmacKeyOption[] dedupe(DeleteHmacKeyOption[] array, DeleteHmacKeyOption ... os) {
            return (DeleteHmacKeyOption[])Option.dedupe(DeleteHmacKeyOption[]::new, (Option[])array, (Option[])os);
        }
    }

    public static class GetHmacKeyOption
    extends Option<UnifiedOpts.HmacKeySourceOpt> {
        private GetHmacKeyOption(UnifiedOpts.HmacKeySourceOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static GetHmacKeyOption userProject(@NonNull String userProject) {
            return new GetHmacKeyOption(UnifiedOpts.userProject(userProject));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static GetHmacKeyOption projectId(@NonNull String projectId) {
            return new GetHmacKeyOption(UnifiedOpts.projectId(projectId));
        }

        @BetaApi
        public static GetHmacKeyOption[] dedupe(GetHmacKeyOption ... os) {
            return (GetHmacKeyOption[])Option.dedupe(GetHmacKeyOption[]::new, (Option[])os);
        }

        @BetaApi
        public static GetHmacKeyOption[] dedupe(Collection<GetHmacKeyOption> collection, GetHmacKeyOption ... os) {
            return (GetHmacKeyOption[])Option.dedupe(GetHmacKeyOption[]::new, collection, (Option[])os);
        }

        @BetaApi
        public static GetHmacKeyOption[] dedupe(GetHmacKeyOption[] array, GetHmacKeyOption ... os) {
            return (GetHmacKeyOption[])Option.dedupe(GetHmacKeyOption[]::new, (Option[])array, (Option[])os);
        }
    }

    public static class CreateHmacKeyOption
    extends Option<UnifiedOpts.HmacKeyTargetOpt> {
        private CreateHmacKeyOption(UnifiedOpts.HmacKeyTargetOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static CreateHmacKeyOption userProject(@NonNull String userProject) {
            return new CreateHmacKeyOption(UnifiedOpts.userProject(userProject));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static CreateHmacKeyOption projectId(@NonNull String projectId) {
            return new CreateHmacKeyOption(UnifiedOpts.projectId(projectId));
        }

        @BetaApi
        public static CreateHmacKeyOption[] dedupe(CreateHmacKeyOption ... os) {
            return (CreateHmacKeyOption[])Option.dedupe(CreateHmacKeyOption[]::new, (Option[])os);
        }

        @BetaApi
        public static CreateHmacKeyOption[] dedupe(Collection<CreateHmacKeyOption> collection, CreateHmacKeyOption ... os) {
            return (CreateHmacKeyOption[])Option.dedupe(CreateHmacKeyOption[]::new, collection, (Option[])os);
        }

        @BetaApi
        public static CreateHmacKeyOption[] dedupe(CreateHmacKeyOption[] array, CreateHmacKeyOption ... os) {
            return (CreateHmacKeyOption[])Option.dedupe(CreateHmacKeyOption[]::new, (Option[])array, (Option[])os);
        }
    }

    public static class ListHmacKeysOption
    extends Option<UnifiedOpts.HmacKeyListOpt> {
        private ListHmacKeysOption(UnifiedOpts.HmacKeyListOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static ListHmacKeysOption serviceAccount(@NonNull ServiceAccount serviceAccount) {
            return new ListHmacKeysOption(UnifiedOpts.serviceAccount(serviceAccount));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static ListHmacKeysOption maxResults(long pageSize) {
            return new ListHmacKeysOption(UnifiedOpts.pageSize(pageSize));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static ListHmacKeysOption pageToken(@NonNull String pageToken) {
            return new ListHmacKeysOption(UnifiedOpts.pageToken(pageToken));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static ListHmacKeysOption showDeletedKeys(boolean showDeletedKeys) {
            return new ListHmacKeysOption(UnifiedOpts.showDeletedKeys(showDeletedKeys));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static ListHmacKeysOption userProject(@NonNull String userProject) {
            return new ListHmacKeysOption(UnifiedOpts.userProject(userProject));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static ListHmacKeysOption projectId(@NonNull String projectId) {
            return new ListHmacKeysOption(UnifiedOpts.projectId(projectId));
        }

        @BetaApi
        public static ListHmacKeysOption[] dedupe(ListHmacKeysOption ... os) {
            return (ListHmacKeysOption[])Option.dedupe(ListHmacKeysOption[]::new, (Option[])os);
        }

        @BetaApi
        public static ListHmacKeysOption[] dedupe(Collection<ListHmacKeysOption> collection, ListHmacKeysOption ... os) {
            return (ListHmacKeysOption[])Option.dedupe(ListHmacKeysOption[]::new, collection, (Option[])os);
        }

        @BetaApi
        public static ListHmacKeysOption[] dedupe(ListHmacKeysOption[] array, ListHmacKeysOption ... os) {
            return (ListHmacKeysOption[])Option.dedupe(ListHmacKeysOption[]::new, (Option[])array, (Option[])os);
        }
    }

    public static class BucketSourceOption
    extends Option<UnifiedOpts.BucketSourceOpt> {
        private static final long serialVersionUID = 3808812145390746748L;

        BucketSourceOption(UnifiedOpts.BucketSourceOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketSourceOption metagenerationMatch(long metageneration) {
            return new BucketSourceOption(UnifiedOpts.metagenerationMatch(metageneration));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketSourceOption metagenerationNotMatch(long metageneration) {
            return new BucketSourceOption(UnifiedOpts.metagenerationNotMatch(metageneration));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketSourceOption userProject(@NonNull String userProject) {
            return new BucketSourceOption(UnifiedOpts.userProject(userProject));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketSourceOption requestedPolicyVersion(long version) {
            return new BucketSourceOption(UnifiedOpts.requestedPolicyVersion(version));
        }

        @BetaApi
        public static BucketSourceOption[] dedupe(BucketSourceOption ... os) {
            return (BucketSourceOption[])Option.dedupe(BucketSourceOption[]::new, (Option[])os);
        }

        @BetaApi
        public static BucketSourceOption[] dedupe(Collection<BucketSourceOption> collection, BucketSourceOption ... os) {
            return (BucketSourceOption[])Option.dedupe(BucketSourceOption[]::new, collection, (Option[])os);
        }

        @BetaApi
        public static BucketSourceOption[] dedupe(BucketSourceOption[] array, BucketSourceOption ... os) {
            return (BucketSourceOption[])Option.dedupe(BucketSourceOption[]::new, (Option[])array, (Option[])os);
        }
    }

    public static class BucketTargetOption
    extends Option<UnifiedOpts.BucketTargetOpt> {
        private static final long serialVersionUID = 6699243191830059404L;

        private BucketTargetOption(UnifiedOpts.BucketTargetOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketTargetOption predefinedAcl(@NonNull PredefinedAcl acl) {
            return new BucketTargetOption(UnifiedOpts.predefinedAcl(acl));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketTargetOption predefinedDefaultObjectAcl(@NonNull PredefinedAcl acl) {
            return new BucketTargetOption(UnifiedOpts.predefinedDefaultObjectAcl(acl));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static BucketTargetOption enableObjectRetention(boolean enable) {
            return new BucketTargetOption(UnifiedOpts.enableObjectRetention(enable));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketTargetOption metagenerationMatch() {
            return new BucketTargetOption(UnifiedOpts.metagenerationMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketTargetOption metagenerationNotMatch() {
            return new BucketTargetOption(UnifiedOpts.metagenerationNotMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketTargetOption userProject(@NonNull String userProject) {
            return new BucketTargetOption(UnifiedOpts.userProject(userProject));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static BucketTargetOption projection(@NonNull String projection) {
            return new BucketTargetOption(UnifiedOpts.projection(projection));
        }

        @BetaApi
        public static BucketTargetOption[] dedupe(BucketTargetOption ... os) {
            return (BucketTargetOption[])Option.dedupe(BucketTargetOption[]::new, (Option[])os);
        }

        public static BucketTargetOption[] dedupe(Collection<BucketTargetOption> collection, BucketTargetOption ... os) {
            return (BucketTargetOption[])Option.dedupe(BucketTargetOption[]::new, collection, (Option[])os);
        }

        public static BucketTargetOption[] dedupe(BucketTargetOption[] array, BucketTargetOption ... os) {
            return (BucketTargetOption[])Option.dedupe(BucketTargetOption[]::new, (Option[])array, (Option[])os);
        }
    }

    public static enum UriScheme {
        HTTP("http"),
        HTTPS("https");

        private final String scheme;

        private UriScheme(String scheme) {
            this.scheme = scheme;
        }

        public String getScheme() {
            return this.scheme;
        }
    }

    public static enum BlobField implements FieldSelector,
    UnifiedOpts.NamedField
    {
        ACL("acl", ObjectAccessControl.class),
        BUCKET("bucket", String.class),
        CACHE_CONTROL("cacheControl", "cache_control", String.class),
        COMPONENT_COUNT("componentCount", "component_count", Integer.class),
        CONTENT_DISPOSITION("contentDisposition", "content_disposition", String.class),
        CONTENT_ENCODING("contentEncoding", "content_encoding", String.class),
        CONTENT_LANGUAGE("contentLanguage", "content_language", String.class),
        CONTENT_TYPE("contentType", "content_type", String.class),
        CRC32C("crc32c", "checksums.crc32c", String.class),
        ETAG("etag", String.class),
        GENERATION("generation", Long.class),
        ID("id", String.class),
        KIND("kind", String.class),
        MD5HASH("md5Hash", "checksums.md5_hash", String.class),
        MEDIA_LINK("mediaLink", String.class),
        METADATA("metadata", HashMap.class),
        METAGENERATION("metageneration", Long.class),
        NAME("name", String.class),
        OWNER("owner", StorageObject.Owner.class),
        SELF_LINK("selfLink", String.class),
        SIZE("size", BigInteger.class),
        STORAGE_CLASS("storageClass", "storage_class", String.class),
        TIME_DELETED("timeDeleted", "delete_time", DateTime.class),
        TIME_CREATED("timeCreated", "create_time", DateTime.class),
        KMS_KEY_NAME("kmsKeyName", "kms_key", String.class),
        EVENT_BASED_HOLD("eventBasedHold", "event_based_hold", String.class),
        TEMPORARY_HOLD("temporaryHold", "temporary_hold", String.class),
        RETENTION_EXPIRATION_TIME("retentionExpirationTime", "retention_expire_time", DateTime.class),
        UPDATED("updated", "update_time", DateTime.class),
        CUSTOM_TIME("customTime", "custom_time", DateTime.class),
        TIME_STORAGE_CLASS_UPDATED("timeStorageClassUpdated", "update_storage_class_time", DateTime.class),
        CUSTOMER_ENCRYPTION("customerEncryption", "customer_encryption", String.class),
        RETENTION("retention", StorageObject.Retention.class),
        SOFT_DELETE_TIME("softDeleteTime", "soft_delete_time", DateTime.class),
        HARD_DELETE_TIME("hardDeleteTime", "hard_delete_time", DateTime.class);

        static final List<UnifiedOpts.NamedField> REQUIRED_FIELDS;
        private static final Map<String, BlobField> JSON_FIELD_NAME_INDEX;
        private final String selector;
        private final String grpcFieldName;
        private final Class<?> jsonClass;

        private BlobField(String selector, Class<?> jsonClass) {
            this(selector, selector, jsonClass);
        }

        private BlobField(String selector, String grpcFieldName, Class<?> jsonClass) {
            this.selector = selector;
            this.grpcFieldName = grpcFieldName;
            this.jsonClass = jsonClass;
        }

        public String getSelector() {
            return this.selector;
        }

        @Override
        public String getApiaryName() {
            return this.selector;
        }

        @Override
        public String getGrpcName() {
            return this.grpcFieldName;
        }

        Class<?> getJsonClass() {
            return this.jsonClass;
        }

        static @Nullable BlobField lookup(UnifiedOpts.NamedField nf) {
            UnifiedOpts.NamedField lookup = nf;
            if (nf instanceof UnifiedOpts.NestedNamedField) {
                UnifiedOpts.NestedNamedField nested = (UnifiedOpts.NestedNamedField)nf;
                lookup = nested.getParent();
            }
            return JSON_FIELD_NAME_INDEX.get(lookup.getApiaryName());
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)BUCKET, (Object)NAME);
            ImmutableMap.Builder tmp = ImmutableMap.builder();
            for (BlobField field : BlobField.values()) {
                tmp.put((Object)field.selector, (Object)field);
            }
            JSON_FIELD_NAME_INDEX = Utils.mapBuild(tmp);
        }
    }

    public static enum BucketField implements FieldSelector,
    UnifiedOpts.NamedField
    {
        ID("id", "bucket_id", String.class),
        SELF_LINK("selfLink", String.class),
        NAME("name", String.class),
        TIME_CREATED("timeCreated", "create_time", DateTime.class),
        METAGENERATION("metageneration", Long.class),
        ACL("acl", ArrayList.class),
        DEFAULT_OBJECT_ACL("defaultObjectAcl", "default_object_acl", ArrayList.class),
        OWNER("owner", Bucket.Owner.class),
        LABELS("labels", HashMap.class),
        LOCATION("location", String.class),
        LOCATION_TYPE("locationType", "location_type", String.class),
        WEBSITE("website", Bucket.Website.class),
        VERSIONING("versioning", Bucket.Versioning.class),
        CORS("cors", ArrayList.class),
        LIFECYCLE("lifecycle", Bucket.Lifecycle.class),
        STORAGE_CLASS("storageClass", "storage_class", String.class),
        ETAG("etag", String.class),
        ENCRYPTION("encryption", Bucket.Encryption.class),
        BILLING("billing", Bucket.Billing.class),
        DEFAULT_EVENT_BASED_HOLD("defaultEventBasedHold", "default_event_based_hold", Boolean.class),
        RETENTION_POLICY("retentionPolicy", "retention_policy", Bucket.RetentionPolicy.class),
        IAMCONFIGURATION("iamConfiguration", "iam_config", Bucket.IamConfiguration.class),
        LOGGING("logging", Bucket.Logging.class),
        UPDATED("updated", "update_time", DateTime.class),
        RPO("rpo", String.class),
        CUSTOM_PLACEMENT_CONFIG("customPlacementConfig", "custom_placement_config", Bucket.CustomPlacementConfig.class),
        AUTOCLASS("autoclass", Bucket.Autoclass.class),
        HIERARCHICAL_NAMESPACE("hierarchicalNamespace", "hierarchical_namespace", Bucket.HierarchicalNamespace.class),
        OBJECT_RETENTION("objectRetention", Bucket.ObjectRetention.class),
        SOFT_DELETE_POLICY("softDeletePolicy", "soft_delete_policy", Bucket.SoftDeletePolicy.class);

        static final List<BucketField> REQUIRED_FIELDS;
        private static final Map<String, BucketField> JSON_FIELD_NAME_INDEX;
        private final String selector;
        private final String grpcFieldName;
        private final Class<?> jsonClass;

        private BucketField(String selector, Class<?> jsonClass) {
            this(selector, selector, jsonClass);
        }

        private BucketField(String selector, String grpcFieldName, Class<?> jsonClass) {
            this.selector = selector;
            this.grpcFieldName = grpcFieldName;
            this.jsonClass = jsonClass;
        }

        public String getSelector() {
            return this.selector;
        }

        @Override
        public String getApiaryName() {
            return this.selector;
        }

        @Override
        public String getGrpcName() {
            return this.grpcFieldName;
        }

        Class<?> getJsonClass() {
            return this.jsonClass;
        }

        static @Nullable BucketField lookup(UnifiedOpts.NamedField nf) {
            UnifiedOpts.NamedField lookup = nf;
            if (nf instanceof UnifiedOpts.NestedNamedField) {
                UnifiedOpts.NestedNamedField nested = (UnifiedOpts.NestedNamedField)nf;
                lookup = nested.getParent();
            }
            return JSON_FIELD_NAME_INDEX.get(lookup.getApiaryName());
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)NAME);
            ImmutableMap.Builder tmp = ImmutableMap.builder();
            for (BucketField field : BucketField.values()) {
                tmp.put((Object)field.selector, (Object)field);
            }
            JSON_FIELD_NAME_INDEX = Utils.mapBuild(tmp);
        }
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public static enum PredefinedAcl {
        AUTHENTICATED_READ("authenticatedRead"),
        ALL_AUTHENTICATED_USERS("allAuthenticatedUsers"),
        PRIVATE("private"),
        PROJECT_PRIVATE("projectPrivate"),
        PUBLIC_READ("publicRead"),
        PUBLIC_READ_WRITE("publicReadWrite"),
        BUCKET_OWNER_READ("bucketOwnerRead"),
        BUCKET_OWNER_FULL_CONTROL("bucketOwnerFullControl");

        private final String entry;

        private PredefinedAcl(String entry) {
            this.entry = entry;
        }

        String getEntry() {
            return this.entry;
        }
    }
}

