/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.tools.console;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERSerializable;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.log.JavaLogFactory;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.DefaultCounterListener;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableListener;
import org.snmp4j.util.TableUtils;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeListener;
import org.snmp4j.util.TreeUtils;

public class SnmpRequest
implements CommandResponder,
PDUFactory {
    public static final int DEFAULT = 0;
    public static final int WALK = 1;
    public static final int LISTEN = 2;
    public static final int TABLE = 3;
    public static final int CVS_TABLE = 4;
    public static final int TIME_BASED_CVS_TABLE = 5;
    public static final int SNAPSHOT_CREATION = 6;
    public static final int SNAPSHOT_DUMP = 7;
    Target target;
    Address address;
    OID authProtocol;
    OID privProtocol;
    OctetString privPassphrase;
    OctetString authPassphrase;
    OctetString community = new OctetString("public");
    OctetString authoritativeEngineID;
    OctetString contextEngineID;
    OctetString contextName = new OctetString();
    OctetString securityName = new OctetString();
    OctetString localEngineID = new OctetString(MPv3.createLocalEngineID());
    TimeTicks sysUpTime = new TimeTicks(0L);
    OID trapOID = SnmpConstants.coldStart;
    PDUv1 v1TrapPDU = new PDUv1();
    int version = 3;
    int engineBootCount = 0;
    int retries = 1;
    int timeout = 1000;
    int pduType = -95;
    int maxRepetitions = 10;
    int nonRepeaters = 0;
    int maxSizeResponsePDU = 65535;
    Vector vbs = new Vector();
    File snapshotFile;
    protected int operation = 0;
    int numDispatcherThreads = 2;
    boolean useDenseTableOperation = false;
    OID lowerBoundIndex;
    OID upperBoundIndex;

    public SnmpRequest(String[] stringArray) {
        CounterSupport.getInstance().addCounterListener(new DefaultCounterListener());
        this.vbs.add(new VariableBinding(new OID("1.3.6")));
        int n = this.parseArgs(stringArray);
        if (n >= stringArray.length) {
            SnmpRequest.printUsage();
            System.exit(1);
        } else if (this.operation != 7) {
            this.checkOptions();
            this.address = SnmpRequest.getAddress(stringArray[n++]);
            Vector vector = SnmpRequest.getVariableBindings(stringArray, n);
            this.checkTrapVariables(vector);
            if (vector.size() > 0) {
                this.vbs = vector;
            }
        }
    }

    public int getPduType() {
        return this.pduType;
    }

    public int getVersion() {
        return this.version;
    }

    public Vector getVbs() {
        return this.vbs;
    }

    public boolean isUseDenseTableOperation() {
        return this.useDenseTableOperation;
    }

    public OID getUpperBoundIndex() {
        return this.upperBoundIndex;
    }

    public OID getTrapOID() {
        return this.trapOID;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Target getTarget() {
        return this.target;
    }

    public TimeTicks getSysUpTime() {
        return this.sysUpTime;
    }

    public OctetString getSecurityName() {
        return this.securityName;
    }

    public int getRetries() {
        return this.retries;
    }

    public OID getPrivProtocol() {
        return this.privProtocol;
    }

    public OctetString getPrivPassphrase() {
        return this.privPassphrase;
    }

    public int getOperation() {
        return this.operation;
    }

    public int getNumDispatcherThreads() {
        return this.numDispatcherThreads;
    }

    public int getNonRepeaters() {
        return this.nonRepeaters;
    }

    public int getMaxRepetitions() {
        return this.maxRepetitions;
    }

    public OID getLowerBoundIndex() {
        return this.lowerBoundIndex;
    }

    public OctetString getContextName() {
        return this.contextName;
    }

    public OctetString getContextEngineID() {
        return this.contextEngineID;
    }

    public OctetString getCommunity() {
        return this.community;
    }

    public OctetString getAuthoritativeEngineID() {
        return this.authoritativeEngineID;
    }

    public OID getAuthProtocol() {
        return this.authProtocol;
    }

    public OctetString getAuthPassphrase() {
        return this.authPassphrase;
    }

    public Address getAddress() {
        return this.address;
    }

    private void checkOptions() {
        if (this.operation == 1 && this.pduType != -91 && this.pduType != -95) {
            throw new IllegalArgumentException("Walk operation is not supported for PDU type: " + PDU.getTypeString(this.pduType));
        }
        if (this.operation == 1 && this.vbs.size() != 1) {
            throw new IllegalArgumentException("There must be exactly one OID supplied for walk operations");
        }
        if (this.pduType == -92 && this.version != 0) {
            throw new IllegalArgumentException("V1TRAP PDU type is only available for SNMP version 1");
        }
    }

    private void checkTrapVariables(Vector vector) {
        if (this.pduType == -90 || this.pduType == -89) {
            if (vector.size() == 0 || vector.size() > 1 && !((VariableBinding)vector.get(0)).getOid().equals(SnmpConstants.sysUpTime)) {
                vector.add(0, new VariableBinding(SnmpConstants.sysUpTime, this.sysUpTime));
            }
            if (vector.size() == 1 || vector.size() > 2 && !((VariableBinding)vector.get(1)).getOid().equals(SnmpConstants.snmpTrapOID)) {
                vector.add(1, new VariableBinding(SnmpConstants.snmpTrapOID, this.trapOID));
            }
        }
    }

    public synchronized void listen() throws IOException {
        AbstractTransportMapping abstractTransportMapping = this.address instanceof TcpAddress ? new DefaultTcpTransportMapping((TcpAddress)this.address) : new DefaultUdpTransportMapping((UdpAddress)this.address);
        ThreadPool threadPool = ThreadPool.create("DispatcherPool", this.numDispatcherThreads);
        MultiThreadedMessageDispatcher multiThreadedMessageDispatcher = new MultiThreadedMessageDispatcher(threadPool, new MessageDispatcherImpl());
        multiThreadedMessageDispatcher.addMessageProcessingModel(new MPv1());
        multiThreadedMessageDispatcher.addMessageProcessingModel(new MPv2c());
        multiThreadedMessageDispatcher.addMessageProcessingModel(new MPv3(this.localEngineID.getValue()));
        SecurityProtocols.getInstance().addDefaultProtocols();
        SecurityProtocols.getInstance().addPrivacyProtocol(new Priv3DES());
        Snmp snmp = new Snmp(multiThreadedMessageDispatcher, abstractTransportMapping);
        if (this.version == 3) {
            USM uSM = new USM(SecurityProtocols.getInstance(), this.localEngineID, 0);
            SecurityModels.getInstance().addSecurityModel(uSM);
            if (this.authoritativeEngineID != null) {
                snmp.setLocalEngine(this.authoritativeEngineID.getValue(), 0, 0);
            }
            this.addUsmUser(snmp);
        } else {
            CommunityTarget communityTarget = new CommunityTarget();
            communityTarget.setCommunity(this.community);
            this.target = communityTarget;
        }
        snmp.addCommandResponder(this);
        abstractTransportMapping.listen();
        System.out.println("Listening on " + this.address);
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void addUsmUser(Snmp snmp) {
        snmp.getUSM().addUser(this.securityName, new UsmUser(this.securityName, this.authProtocol, this.authPassphrase, this.privProtocol, this.privPassphrase));
    }

    private Snmp createSnmpSession() throws IOException {
        AbstractTransportMapping abstractTransportMapping = this.address instanceof TcpAddress ? new DefaultTcpTransportMapping() : new DefaultUdpTransportMapping();
        Snmp snmp = new Snmp(abstractTransportMapping);
        ((MPv3)snmp.getMessageProcessingModel(3)).setLocalEngineID(this.localEngineID.getValue());
        if (this.version == 3) {
            USM uSM = new USM(SecurityProtocols.getInstance(), this.localEngineID, this.engineBootCount);
            SecurityModels.getInstance().addSecurityModel(uSM);
            this.addUsmUser(snmp);
        }
        return snmp;
    }

    private Target createTarget() {
        if (this.version == 3) {
            UserTarget userTarget = new UserTarget();
            if (this.authPassphrase != null) {
                if (this.privPassphrase != null) {
                    userTarget.setSecurityLevel(3);
                } else {
                    userTarget.setSecurityLevel(2);
                }
            } else {
                userTarget.setSecurityLevel(1);
            }
            userTarget.setSecurityName(this.securityName);
            return userTarget;
        }
        CommunityTarget communityTarget = new CommunityTarget();
        communityTarget.setCommunity(this.community);
        return communityTarget;
    }

    public PDU send() throws IOException {
        Snmp snmp = this.createSnmpSession();
        this.target = this.createTarget();
        this.target.setVersion(this.version);
        this.target.setAddress(this.address);
        this.target.setRetries(this.retries);
        this.target.setTimeout(this.timeout);
        this.target.setMaxSizeRequestPDU(this.maxSizeResponsePDU);
        snmp.listen();
        PDU pDU = this.createPDU(this.target);
        if (pDU.getType() == -91) {
            pDU.setMaxRepetitions(this.maxRepetitions);
            pDU.setNonRepeaters(this.nonRepeaters);
        }
        for (int i = 0; i < this.vbs.size(); ++i) {
            pDU.add((VariableBinding)this.vbs.get(i));
        }
        PDU pDU2 = null;
        if (this.operation == 1 || this.operation == 6) {
            ArrayList arrayList = null;
            if (this.operation == 6) {
                arrayList = new ArrayList();
            }
            this.walk(snmp, pDU, this.target, arrayList);
            if (arrayList != null) {
                this.createSnapshot(arrayList);
            }
            return null;
        }
        long l = System.currentTimeMillis();
        ResponseEvent responseEvent = snmp.send(pDU, this.target);
        if (responseEvent != null) {
            pDU2 = responseEvent.getResponse();
            System.out.println("Received response after " + (System.currentTimeMillis() - l) + " millis");
        }
        snmp.close();
        return pDU2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDU walk(Snmp snmp, PDU pDU, Target target, final List list) throws IOException {
        TreeListener treeListener;
        pDU.setNonRepeaters(0);
        OID oID = pDU.get(0).getOid();
        PDU pDU2 = null;
        final WalkCounts walkCounts = new WalkCounts();
        final long l = System.currentTimeMillis();
        TreeUtils treeUtils = new TreeUtils(snmp, new DefaultPDUFactory());
        TreeListener treeListener2 = treeListener = new TreeListener(){

            public boolean next(TreeEvent treeEvent) {
                ++walkCounts.requests;
                if (treeEvent.getVariableBindings() != null) {
                    VariableBinding[] variableBindingArray = treeEvent.getVariableBindings();
                    walkCounts.objects += variableBindingArray.length;
                    for (int i = 0; i < variableBindingArray.length; ++i) {
                        if (list != null) {
                            list.add(variableBindingArray[i]);
                        }
                        System.out.println(variableBindingArray[i].toString());
                    }
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finished(TreeEvent treeEvent) {
                if (treeEvent.getVariableBindings() != null && treeEvent.getVariableBindings().length > 0) {
                    this.next(treeEvent);
                }
                System.out.println();
                System.out.println("Total requests sent:    " + walkCounts.requests);
                System.out.println("Total objects received: " + walkCounts.objects);
                System.out.println("Total walk time:        " + (System.currentTimeMillis() - l) + " milliseconds");
                if (treeEvent.isError()) {
                    System.err.println("The following error occurred during walk:");
                    System.err.println(treeEvent.getErrorMessage());
                }
                1 var2_2 = this;
                synchronized (var2_2) {
                    this.notify();
                }
            }
        };
        synchronized (treeListener2) {
            treeUtils.getSubtree(target, oID, null, treeListener);
            try {
                treeListener.wait();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Tree retrieval interrupted: " + interruptedException.getMessage());
            }
        }
        return pDU2;
    }

    private static Vector getVariableBindings(String[] stringArray, int n) {
        Vector<Object> vector = new Vector<Object>(stringArray.length - n + 1);
        for (int i = n; i < stringArray.length; ++i) {
            BERSerializable bERSerializable;
            Object object;
            String string = stringArray[i];
            char c = 'i';
            String string2 = null;
            int n2 = string.indexOf("={");
            if (n2 > 0) {
                string = stringArray[i].substring(0, n2);
                c = stringArray[i].charAt(n2 + 2);
                string2 = stringArray[i].substring(stringArray[i].indexOf(125) + 1);
            } else if (string.indexOf(45) > 0) {
                object = new StringTokenizer(string, "-");
                if (((StringTokenizer)object).countTokens() != 2) {
                    throw new IllegalArgumentException("Illegal OID range specified: '" + string);
                }
                string = ((StringTokenizer)object).nextToken();
                bERSerializable = new VariableBinding(new OID(string));
                vector.add(bERSerializable);
                long l = Long.parseLong(((StringTokenizer)object).nextToken());
                long l2 = ((VariableBinding)bERSerializable).getOid().lastUnsigned();
                for (long j = l2 + 1L; j <= l; ++j) {
                    OID oID = new OID(((VariableBinding)bERSerializable).getOid().getValue(), 0, ((VariableBinding)bERSerializable).getOid().size() - 1);
                    oID.appendUnsigned(j);
                    VariableBinding variableBinding = new VariableBinding(oID);
                    vector.add(variableBinding);
                }
                continue;
            }
            object = new VariableBinding(new OID(string));
            if (string2 != null) {
                switch (c) {
                    case 'i': {
                        bERSerializable = new Integer32(Integer.parseInt(string2));
                        break;
                    }
                    case 'u': {
                        bERSerializable = new UnsignedInteger32(Long.parseLong(string2));
                        break;
                    }
                    case 's': {
                        bERSerializable = new OctetString(string2);
                        break;
                    }
                    case 'x': {
                        bERSerializable = OctetString.fromString(string2, ':', 16);
                        break;
                    }
                    case 'd': {
                        bERSerializable = OctetString.fromString(string2, '.', 10);
                        break;
                    }
                    case 'b': {
                        bERSerializable = OctetString.fromString(string2, ' ', 2);
                        break;
                    }
                    case 'n': {
                        bERSerializable = new Null();
                        break;
                    }
                    case 'o': {
                        bERSerializable = new OID(string2);
                        break;
                    }
                    case 't': {
                        bERSerializable = new TimeTicks(Long.parseLong(string2));
                        break;
                    }
                    case 'a': {
                        bERSerializable = new IpAddress(string2);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Variable type " + c + " not supported");
                    }
                }
                ((VariableBinding)object).setVariable((Variable)bERSerializable);
            }
            vector.add(object);
        }
        return vector;
    }

    private static Address getAddress(String string) {
        String string2 = "udp";
        int n = string.indexOf(58);
        if (n > 0) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        if (string.indexOf(47) < 0) {
            string = string + "/161";
        }
        if (string2.equalsIgnoreCase("udp")) {
            return new UdpAddress(string);
        }
        if (string2.equalsIgnoreCase("tcp")) {
            return new TcpAddress(string);
        }
        throw new IllegalArgumentException("Unknown transport " + string2);
    }

    private static String nextOption(String[] stringArray, int n) {
        if (n + 1 >= stringArray.length) {
            throw new IllegalArgumentException("Missing option value for " + stringArray[n]);
        }
        return stringArray[n + 1];
    }

    private static OctetString createOctetString(String string) {
        OctetString octetString = string.startsWith("0x") ? OctetString.fromHexString(string.substring(2), ':') : new OctetString(string);
        return octetString;
    }

    private int parseArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i].equals("-a")) {
                if ((string = SnmpRequest.nextOption(stringArray, i++)).equals("MD5")) {
                    this.authProtocol = AuthMD5.ID;
                    continue;
                }
                if (string.equals("SHA")) {
                    this.authProtocol = AuthSHA.ID;
                    continue;
                }
                throw new IllegalArgumentException("Authentication protocol unsupported: " + string);
            }
            if (stringArray[i].equals("-A")) {
                this.authPassphrase = SnmpRequest.createOctetString(SnmpRequest.nextOption(stringArray, i++));
                continue;
            }
            if (stringArray[i].equals("-X") || stringArray[i].equals("-P")) {
                this.privPassphrase = SnmpRequest.createOctetString(SnmpRequest.nextOption(stringArray, i++));
                continue;
            }
            if (stringArray[i].equals("-c")) {
                this.community = SnmpRequest.createOctetString(SnmpRequest.nextOption(stringArray, i++));
                continue;
            }
            if (stringArray[i].equals("-b")) {
                this.engineBootCount = Math.max(Integer.parseInt(SnmpRequest.nextOption(stringArray, i++)), 0);
                continue;
            }
            if (stringArray[i].equals("-d")) {
                string = SnmpRequest.nextOption(stringArray, i++);
                LogFactory.getLogFactory().getRootLogger().setLogLevel(LogLevel.toLevel(string));
                continue;
            }
            if (stringArray[i].equals("-l")) {
                this.localEngineID = SnmpRequest.createOctetString(SnmpRequest.nextOption(stringArray, i++));
                continue;
            }
            if (stringArray[i].equals("-e")) {
                this.authoritativeEngineID = SnmpRequest.createOctetString(SnmpRequest.nextOption(stringArray, i++));
                continue;
            }
            if (stringArray[i].equals("-E")) {
                this.contextEngineID = SnmpRequest.createOctetString(SnmpRequest.nextOption(stringArray, i++));
                continue;
            }
            if (stringArray[i].equals("-h")) {
                SnmpRequest.printUsage();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-n")) {
                this.contextName = SnmpRequest.createOctetString(SnmpRequest.nextOption(stringArray, i++));
                continue;
            }
            if (stringArray[i].equals("-m")) {
                this.maxSizeResponsePDU = Integer.parseInt(SnmpRequest.nextOption(stringArray, i++));
                continue;
            }
            if (stringArray[i].equals("-r")) {
                this.retries = Integer.parseInt(SnmpRequest.nextOption(stringArray, i++));
                continue;
            }
            if (stringArray[i].equals("-t")) {
                this.timeout = Integer.parseInt(SnmpRequest.nextOption(stringArray, i++));
                continue;
            }
            if (stringArray[i].equals("-u")) {
                this.securityName = SnmpRequest.createOctetString(SnmpRequest.nextOption(stringArray, i++));
                continue;
            }
            if (stringArray[i].equals("-V")) {
                SnmpRequest.printVersion();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-Cr")) {
                this.maxRepetitions = Integer.parseInt(SnmpRequest.nextOption(stringArray, i++));
                continue;
            }
            if (stringArray[i].equals("-Cn")) {
                this.nonRepeaters = Integer.parseInt(SnmpRequest.nextOption(stringArray, i++));
                continue;
            }
            if (stringArray[i].equals("-Ce")) {
                this.v1TrapPDU.setEnterprise(new OID(SnmpRequest.nextOption(stringArray, i++)));
                continue;
            }
            if (stringArray[i].equals("-Ct")) {
                this.trapOID = new OID(SnmpRequest.nextOption(stringArray, i++));
                continue;
            }
            if (stringArray[i].equals("-Cg")) {
                this.v1TrapPDU.setGenericTrap(Integer.parseInt(SnmpRequest.nextOption(stringArray, i++)));
                continue;
            }
            if (stringArray[i].equals("-Cs")) {
                this.v1TrapPDU.setSpecificTrap(Integer.parseInt(SnmpRequest.nextOption(stringArray, i++)));
                continue;
            }
            if (stringArray[i].equals("-Ca")) {
                this.v1TrapPDU.setAgentAddress(new IpAddress(SnmpRequest.nextOption(stringArray, i++)));
                continue;
            }
            if (stringArray[i].equals("-Cu")) {
                string = SnmpRequest.nextOption(stringArray, i++);
                this.v1TrapPDU.setTimestamp(Long.parseLong(string));
                this.sysUpTime.setValue(Long.parseLong(string));
                continue;
            }
            if (stringArray[i].equals("-Ow")) {
                this.operation = 1;
                continue;
            }
            if (stringArray[i].equals("-Ocs")) {
                this.operation = 6;
                this.snapshotFile = new File(SnmpRequest.nextOption(stringArray, i++));
                if (this.snapshotFile.canWrite() || !this.snapshotFile.exists()) continue;
                throw new IllegalArgumentException("Snapshot file '" + this.snapshotFile + "' cannot be written");
            }
            if (stringArray[i].equals("-Ods")) {
                this.operation = 7;
                this.snapshotFile = new File(SnmpRequest.nextOption(stringArray, i++));
                if (this.snapshotFile.canRead()) continue;
                throw new IllegalArgumentException("Snapshot file '" + this.snapshotFile + "' cannot be read");
            }
            if (stringArray[i].equals("-Ol")) {
                this.operation = 2;
                continue;
            }
            if (stringArray[i].equals("-OtCSV")) {
                this.operation = 4;
                continue;
            }
            if (stringArray[i].equals("-OttCSV")) {
                this.operation = 5;
                continue;
            }
            if (stringArray[i].equals("-Ot")) {
                this.operation = 3;
                continue;
            }
            if (stringArray[i].equals("-Otd")) {
                this.operation = 3;
                this.useDenseTableOperation = true;
                continue;
            }
            if (stringArray[i].equals("-Cil")) {
                this.lowerBoundIndex = new OID(SnmpRequest.nextOption(stringArray, i++));
                continue;
            }
            if (stringArray[i].equals("-Ciu")) {
                this.upperBoundIndex = new OID(SnmpRequest.nextOption(stringArray, i++));
                continue;
            }
            if (stringArray[i].equals("-v")) {
                if ((string = SnmpRequest.nextOption(stringArray, i++)).equals("1")) {
                    this.version = 0;
                    continue;
                }
                if (string.equals("2c")) {
                    this.version = 1;
                    continue;
                }
                if (string.equals("3")) {
                    this.version = 3;
                    continue;
                }
                throw new IllegalArgumentException("Version " + string + " not supported");
            }
            if (stringArray[i].equals("-x")) {
                if ((string = SnmpRequest.nextOption(stringArray, i++)).equals("DES")) {
                    this.privProtocol = PrivDES.ID;
                    continue;
                }
                if (string.equals("AES128") || string.equals("AES")) {
                    this.privProtocol = PrivAES128.ID;
                    continue;
                }
                if (string.equals("AES192")) {
                    this.privProtocol = PrivAES192.ID;
                    continue;
                }
                if (string.equals("AES256")) {
                    this.privProtocol = PrivAES256.ID;
                    continue;
                }
                if (string.equals("3DES") || string.equalsIgnoreCase("DESEDE")) {
                    this.privProtocol = Priv3DES.ID;
                    continue;
                }
                throw new IllegalArgumentException("Privacy protocol " + string + " not supported");
            }
            if (stringArray[i].equals("-p")) {
                string = SnmpRequest.nextOption(stringArray, i++);
                this.pduType = PDU.getTypeFromString(string);
                if (this.pduType != Integer.MIN_VALUE) continue;
                throw new IllegalArgumentException("Unknown PDU type " + string);
            }
            if (!stringArray[i].startsWith("-")) {
                return i;
            }
            throw new IllegalArgumentException("Unknown option " + stringArray[i]);
        }
        return 0;
    }

    protected static void printVersion() {
        System.out.println();
        System.out.println("SNMP4J Command Line Tool v1.9.1 Copyright \u00a9 2004-2008, Frank Fock and Jochen Katz");
        System.out.println("http://www.snmp4j.org");
        System.out.println();
        System.out.println("SNMP4J is licensed under the Apache License 2.0:");
        System.out.println("http://www.apache.org/licenses/LICENSE-2.0.txt");
        System.out.println();
    }

    protected static void printUsage() {
        String[] stringArray = new String[]{"", "Usage: SNMP4J [options] [transport:]address [OID[={type}value] ...]", "", "  -a  authProtocol      Sets the authentication protocol used to", "                        authenticate SNMPv3 messages. Valid values are", "                        MD5 and SHA.", "  -A  authPassphrase    Sets the authentication pass phrase for authenticated", "                        SNMPv3 messages.", "  -b  engineBootCount   Sets the engine boot count to the specified value", "                        greater or equal to zero. Default is zero.", "  -c  community         Sets the community for SNMPv1/v2c messages.", "  -Ca agentAddress      Sets the agent address field of a V1TRAP PDU.", "                        The default value is '0.0.0.0'.", "  -Cg genericID         Sets the generic ID for SNMPv1 TRAPs (V1TRAP).", "                        The default is 1 (coldStart).", "  -Ce enterpriseOID     Sets the enterprise OID field of a V1TRAP PDU.", "  -Cil lowerBoundIndex  Sets the lower bound index for TABLE operations.", "  -Ciu upperBoundIndex  Sets the upper bound index for TABLE operations.", "  -Cn non-repeaters     Sets  the  non-repeaters field for GETBULK PDUs.", "                        It specifies the number of supplied variables that", "                        should not be iterated over. The default is 0.", "  -Cr max-repetitions   Sets the max-repetitions field for GETBULK PDUs.", "                        This specifies the maximum number of iterations", "                        over the repeating variables. The default is 10.", "  -Cs specificID        Sets the specific ID for V1TRAP PDU. The default is 0.", "  -Ct trapOID           Sets the trapOID (1.3.6.1.6.3.1.1.4.1.0) of an INFORM", "                        or TRAP PDU. The default is 1.3.6.1.6.3.1.1.5.1.", "  -Cu upTime            Sets the sysUpTime field of an INFORM, TRAP, or", "                        V1TRAP PDU.", "  -d  debugLevel        Sets the global debug level for Log4J logging output.", "                        Valid values are OFF, ERROR, WARN, INFO, and DEBUG.", "  -e  engineID          Sets the authoritative engine ID of the command", "                        responder used for SNMPv3 request messages. If not", "                        supplied, the engine ID will be discovered.", "  -E  contextEngineID   Sets the context engine ID used for the SNMPv3 scoped", "                        PDU. The authoritative engine ID will be used for the", "                        context engine ID, if the latter is not specified.", "  -h                    Displays this message and then exits the application.", "  -l  localEngineID     Sets the local engine ID of the command generator", "                        and the notification receiver (thus this SNMP4J-Tool)", "                        used for SNMPv3 request messages. This option can be", "                        used to avoid engine ID clashes through duplicate IDs", "                        leading to usmStatsNotInTimeWindows reports.", "  -n  contextName       Sets the target context name for SNMPv3 messages. ", "                        Default is the empty string.", "  -m  maxSizeRespPDU    The maximum size of the response PDU in bytes.", "  -Ocs <file>           Same as -Ow except that the retrieved values are also", "                        written as a serialized ArrayList of VariableBinding", "                        instances to the specified file. The snapshot format", "                        can be read later by other applications, for example", "                        MIB Explorer Pro 2.2 or later. See also -Ods.", "  -Ods <file>           Reads the snapshot file and dumps its contents on", "                        standard out. No SNMP operation will be done.", "                        See also -Ocs.", "  -Ol                   Activates listen operation mode. In this mode, the", "                        application will listen for incoming TRAPs and INFORMs", "                        on the supplied address. Received request will be", "                        dumped to the console until the application is stopped.", "  -Ot                   Activates table operation mode. In this mode, the", "                        application receives tabular data from the column", "                        OIDs specified as parameters. The retrieved rows will", "                        be dumped to the console ordered by their index values.", "  -Otd                  Activates dense table operation mode. In this mode, the", "                        application receives tabular data from the column", "                        OIDs specified as parameters. The retrieved rows will", "                        be dumped to the console ordered by their index values.", "                        In contrast to -Ot this option must not be used with", "                        sparse tables. ", "  -OtCSV                Same as -Ot except that for each SNMP row received", "                        exactly one row of comma separated values will printed", "                        to the console where the first column contains the row", "                        index.", "  -OttCSV               Same as -OtCSV except that each row's first column", "                        will report the current time (millis after 1.1.1970)", "                        when the request has been sent.", "  -Ow                   Activates walk operation mode for GETNEXT and GETBULK", "                        PDUs. If activated, the GETNEXT and GETBULK operations", "                        will be repeated until all instances within the", "                        OID subtree of the supplied OID have been retrieved", "                        successfully or until an error occurred.", "  -p  pduType           Specifies the PDU type to be used for the message.", "                        Valid types are GET, GETNEXT, GETBULK (SNMPv2c/v3),", "                        SET, INFORM, TRAP, and V1TRAP (SNMPv1).", "  -P  privacyPassphrase Sets the privacy pass phrase for encrypted", "                        SNMPv3 messages (same as -X).", "  -r  retries           Sets the number of retries used for requests. A zero", "                        value will send out a request exactly once.", "                        Default is 1.", "  -t  timeout           Sets the timeout in milliseconds between retries.", "                        Default is 1000 milliseconds.", "  -u  securityName      Sets the security name for authenticated v3 messages.", "  -v  1|2c|3            Sets the SNMP protocol version to be used.", "                        Default is 3.", "  -V                    Displays version information and then exits.", "  -x  privacyProtocol   Sets the privacy protocol to be used to encrypt", "                        SNMPv3 messages. Valid values are DES, AES (AES128),", "                        AES192, AES256, and 3DES(DESEDE).", "  -X  privacyPassphrase Sets the privacy pass phrase for encrypted", "                        SNMPv3 messages (same as -P).", "", "The address of the target SNMP engine is parsed according to the", "specified <transport> selector (default selector is udp):", "", "  udp | tcp             hostname[/port]", "                        ipv4Address[/port]", "                        ipv6Address[/port]", "", "The OIDs have to be specified in numerical form where strings may beenclosed in single quotes ('), for example:", "  1.3.6.1.2.1.1.5.0  (which will return the sysName.0 instance with a GET)", "  1.3.6.1.6.3.16.1.2.1.3.2.6.'public'  (which will return the ", "    vacmGroupName.2.6.112.117.98.108.105.99 instance with a GET)", "To request multiple instances, add additional OIDs with a space as", "separator. For the last sub-identifier of a plain OID (without an assigned", "value) a range can be specified, for example '1.3.6.1.2.1.2.2.1-10' will", "has the same effect as enumerating all OIDs from '1.3.6.1.2.1.2.2.1' to", "'1.3.6.1.2.1.2.2.10'.", "For SET and INFORM request, you can specify a value for each OID by", "using the following form: OID={type}value where <type> is one of", "the following single characters enclosed by '{' and '}':", "  i                     Integer32", "  u                     UnsingedInteger32, Gauge32", "  s                     OCTET STRING", "  x                     OCTET STRING specified as hex string where", "                        bytes separated by colons (':').", "  d                     OCTET STRING specified as decimal string", "                        where bytes are separated by dots ('.').", "  n                     Null", "  o                     OBJECT IDENTIFIER", "  t                     TimeTicks", "  a                     IpAddress", "  b                     OCTET STRING specified as binary string where", "                        bytes are separated by spaces.", "", "An example for a complete SNMPv2c SET request to set sysName:", " SNMP4J -c private -v 2c -p SET udp:localhost/161 \"1.3.6.1.2.1.1.5.0={s}SNMP4J\"", "", "To walk the whole MIB tree with GETBULK and using SNMPv3 MD5 authentication:", " SNMP4J -a MD5 -A MD5UserAuthPassword -u MD5User -p GETBULK -Ow 127.0.0.1/161", "", "Listen for unauthenticated SNMPv3 INFORMs and TRAPs and all v1/v2c TRAPs:", " SNMP4J -u aSecurityName -Ol 0.0.0.0/162", "", "Send an unauthenticated SNMPv3 notification (trap):", " SNMP4J -p TRAP -v 3 -u aSecurityName 127.0.0.1/162 \"1.3.6.1.2.1.1.3.0={t}0\" \\", "  \"1.3.6.1.6.3.1.1.4.1.0={o}1.3.6.1.6.3.1.1.5.1\" \\", "  \"1.3.6.1.2.1.1.1.0={s}System XYZ, Version N.M\"", "Retrieve rows of the columnar objects ifDescr to ifInOctets and ifOutOctets:", " SNMP4J -c public -v 2c -Ot localhost 1.3.6.1.2.1.2.2.1.2-10\\", "  1.3.6.1.2.1.2.2.1.16", ""};
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
    }

    protected static void printVariableBindings(PDU pDU) {
        for (int i = 0; i < pDU.size(); ++i) {
            VariableBinding variableBinding = pDU.get(i);
            System.out.println(variableBinding.toString());
        }
    }

    protected static void printReport(PDU pDU) {
        if (pDU.size() < 1) {
            System.out.println("REPORT PDU does not contain a variable binding.");
            return;
        }
        VariableBinding variableBinding = pDU.get(0);
        OID oID = variableBinding.getOid();
        if (SnmpConstants.usmStatsUnsupportedSecLevels.equals(oID)) {
            System.out.print("REPORT: Unsupported Security Level.");
        } else if (SnmpConstants.usmStatsNotInTimeWindows.equals(oID)) {
            System.out.print("REPORT: Message not within time window.");
        } else if (SnmpConstants.usmStatsUnknownUserNames.equals(oID)) {
            System.out.print("REPORT: Unknown user name.");
        } else if (SnmpConstants.usmStatsUnknownEngineIDs.equals(oID)) {
            System.out.print("REPORT: Unknown engine id.");
        } else if (SnmpConstants.usmStatsWrongDigests.equals(oID)) {
            System.out.print("REPORT: Wrong digest.");
        } else if (SnmpConstants.usmStatsDecryptionErrors.equals(oID)) {
            System.out.print("REPORT: Decryption error.");
        } else if (SnmpConstants.snmpUnknownSecurityModels.equals(oID)) {
            System.out.print("REPORT: Unknown security model.");
        } else if (SnmpConstants.snmpInvalidMsgs.equals(oID)) {
            System.out.print("REPORT: Invalid message.");
        } else if (SnmpConstants.snmpUnknownPDUHandlers.equals(oID)) {
            System.out.print("REPORT: Unknown PDU handler.");
        } else if (SnmpConstants.snmpUnavailableContexts.equals(oID)) {
            System.out.print("REPORT: Unavailable context.");
        } else if (SnmpConstants.snmpUnknownContexts.equals(oID)) {
            System.out.print("REPORT: Unknown context.");
        } else {
            System.out.print("REPORT contains unknown OID (" + oID.toString() + ").");
        }
        System.out.println(" Current counter value is " + ((Object)variableBinding.getVariable()).toString() + ".");
    }

    public synchronized void processPdu(CommandResponderEvent commandResponderEvent) {
        PDU pDU = commandResponderEvent.getPDU();
        if (pDU != null) {
            System.out.println(pDU.toString());
            if (pDU.getType() != -89 && pDU.getType() != -92 && pDU.getType() != -88 && pDU.getType() != -94) {
                pDU.setErrorIndex(0);
                pDU.setErrorStatus(0);
                pDU.setType(-94);
                StatusInformation statusInformation = new StatusInformation();
                StateReference stateReference = commandResponderEvent.getStateReference();
                try {
                    commandResponderEvent.getMessageDispatcher().returnResponsePdu(commandResponderEvent.getMessageProcessingModel(), commandResponderEvent.getSecurityModel(), commandResponderEvent.getSecurityName(), commandResponderEvent.getSecurityLevel(), pDU, commandResponderEvent.getMaxSizeResponsePDU(), stateReference, statusInformation);
                }
                catch (MessageException messageException) {
                    System.err.println("Error while sending response: " + messageException.getMessage());
                    LogFactory.getLogger(SnmpRequest.class).error(messageException);
                }
            }
        }
    }

    public PDU createPDU(Target target) {
        PDU pDU;
        if (target.getVersion() == 3) {
            pDU = new ScopedPDU();
            ScopedPDU scopedPDU = pDU;
            if (this.contextEngineID != null) {
                scopedPDU.setContextEngineID(this.contextEngineID);
            }
            if (this.contextName != null) {
                scopedPDU.setContextName(this.contextName);
            }
        } else {
            pDU = this.pduType == -92 ? this.v1TrapPDU : new PDU();
        }
        pDU.setType(this.pduType);
        return pDU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void table() throws IOException {
        Snmp snmp = this.createSnmpSession();
        this.target = this.createTarget();
        this.target.setVersion(this.version);
        this.target.setAddress(this.address);
        this.target.setRetries(this.retries);
        this.target.setTimeout(this.timeout);
        snmp.listen();
        TableUtils tableUtils = new TableUtils(snmp, this);
        tableUtils.setMaxNumRowsPerPDU(this.maxRepetitions);
        Counter32 counter32 = new Counter32();
        OID[] oIDArray = new OID[this.vbs.size()];
        for (int i = 0; i < oIDArray.length; ++i) {
            oIDArray[i] = ((VariableBinding)this.vbs.get(i)).getOid();
        }
        long l = System.currentTimeMillis();
        Counter32 counter322 = counter32;
        synchronized (counter322) {
            TableListener tableListener = this.operation == 3 ? new TextTableListener() : new CVSTableListener(System.currentTimeMillis());
            if (this.useDenseTableOperation) {
                tableUtils.getDenseTable(this.target, oIDArray, tableListener, counter32, this.lowerBoundIndex, this.upperBoundIndex);
            } else {
                tableUtils.getTable(this.target, oIDArray, tableListener, counter32, this.lowerBoundIndex, this.upperBoundIndex);
            }
            try {
                counter32.wait(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.out.println("Table received in " + (System.currentTimeMillis() - l) + " milliseconds.");
        snmp.close();
    }

    public static void main(String[] stringArray) {
        block12: {
            try {
                SnmpRequest snmpRequest = new SnmpRequest(stringArray);
                if (snmpRequest.operation == 7) {
                    snmpRequest.dumpSnapshot();
                    break block12;
                }
                try {
                    if (snmpRequest.operation == 2) {
                        snmpRequest.listen();
                        break block12;
                    }
                    if (snmpRequest.operation == 3 || snmpRequest.operation == 4 || snmpRequest.operation == 5) {
                        snmpRequest.table();
                        break block12;
                    }
                    PDU pDU = snmpRequest.send();
                    if (snmpRequest.getPduType() == -89 || snmpRequest.getPduType() == -88 || snmpRequest.getPduType() == -92 || snmpRequest.getPduType() == -94) {
                        System.out.println(PDU.getTypeString(snmpRequest.getPduType()) + " sent successfully");
                        break block12;
                    }
                    if (pDU == null) {
                        if (snmpRequest.operation != 1) {
                            System.out.println("Request timed out.");
                        }
                        break block12;
                    }
                    if (pDU.getType() == -88) {
                        SnmpRequest.printReport(pDU);
                        break block12;
                    }
                    if (snmpRequest.operation == 0) {
                        System.out.println("Response received with requestID=" + pDU.getRequestID() + ", errorIndex=" + pDU.getErrorIndex() + ", " + "errorStatus=" + pDU.getErrorStatusText() + "(" + pDU.getErrorStatus() + ")");
                        SnmpRequest.printVariableBindings(pDU);
                        break block12;
                    }
                    System.out.println("Received something strange: requestID=" + pDU.getRequestID() + ", errorIndex=" + pDU.getErrorIndex() + ", " + "errorStatus=" + pDU.getErrorStatusText() + "(" + pDU.getErrorStatus() + ")");
                    SnmpRequest.printVariableBindings(pDU);
                }
                catch (IOException iOException) {
                    System.err.println("Error while trying to send request: " + iOException.getMessage());
                    iOException.printStackTrace();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.print("Error: " + illegalArgumentException.getMessage());
                illegalArgumentException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSnapshot(List list) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.snapshotFile);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(list);
            objectOutputStream.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSnapshot() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.snapshotFile);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            List list = (List)objectInputStream.readObject();
            int n = 1;
            System.out.println("Dumping snapshot file '" + this.snapshotFile + "':");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                System.out.println("" + n + ": " + iterator.next());
                ++n;
            }
            System.out.println();
            System.out.println("Dumped " + list.size() + " variable bindings.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public void setVbs(Vector vector) {
        this.vbs = vector;
    }

    public void setUseDenseTableOperation(boolean bl) {
        this.useDenseTableOperation = bl;
    }

    public void setUpperBoundIndex(OID oID) {
        this.upperBoundIndex = oID;
    }

    public void setTrapOID(OID oID) {
        this.trapOID = oID;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public void setSysUpTime(TimeTicks timeTicks) {
        this.sysUpTime = timeTicks;
    }

    public void setSecurityName(OctetString octetString) {
        this.securityName = octetString;
    }

    public void setRetries(int n) {
        this.retries = n;
    }

    public void setPrivProtocol(OID oID) {
        this.privProtocol = oID;
    }

    public void setPrivPassphrase(OctetString octetString) {
        this.privPassphrase = octetString;
    }

    public void setPduType(int n) {
        this.pduType = n;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public void setNumDispatcherThreads(int n) {
        this.numDispatcherThreads = n;
    }

    public void setNonRepeaters(int n) {
        this.nonRepeaters = n;
    }

    public void setMaxRepetitions(int n) {
        this.maxRepetitions = n;
    }

    public void setLowerBoundIndex(OID oID) {
        this.lowerBoundIndex = oID;
    }

    public void setContextName(OctetString octetString) {
        this.contextName = octetString;
    }

    public void setContextEngineID(OctetString octetString) {
        this.contextEngineID = octetString;
    }

    public void setCommunity(OctetString octetString) {
        this.community = octetString;
    }

    public void setAuthoritativeEngineID(OctetString octetString) {
        this.authoritativeEngineID = octetString;
    }

    public void setAuthProtocol(OID oID) {
        this.authProtocol = oID;
    }

    public void setAuthPassphrase(OctetString octetString) {
        this.authPassphrase = octetString;
    }

    static {
        LogFactory.setLogFactory(new JavaLogFactory());
        BER.setCheckSequenceLength(false);
    }

    class WalkCounts {
        public int requests;
        public int objects;

        WalkCounts() {
        }
    }

    class TextTableListener
    implements TableListener {
        TextTableListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(TableEvent tableEvent) {
            System.out.println();
            System.out.println("Table walk completed with status " + tableEvent.getStatus() + ". Received " + tableEvent.getUserObject() + " rows.");
            Object object = tableEvent.getUserObject();
            synchronized (object) {
                tableEvent.getUserObject().notify();
            }
        }

        public boolean next(TableEvent tableEvent) {
            System.out.println("Index = " + tableEvent.getIndex() + ":");
            for (int i = 0; i < tableEvent.getColumns().length; ++i) {
                System.out.println(tableEvent.getColumns()[i]);
            }
            System.out.println();
            ((Counter32)tableEvent.getUserObject()).increment();
            return true;
        }
    }

    class CVSTableListener
    implements TableListener {
        private long requestTime;

        public CVSTableListener(long l) {
            this.requestTime = l;
        }

        public boolean next(TableEvent tableEvent) {
            if (SnmpRequest.this.operation == 5) {
                System.out.print(this.requestTime);
                System.out.print(",");
            }
            System.out.print("\"" + tableEvent.getIndex() + "\",");
            for (int i = 0; i < tableEvent.getColumns().length; ++i) {
                Variable variable = tableEvent.getColumns()[i].getVariable();
                String string = ((Object)variable).toString();
                switch (variable.getSyntax()) {
                    case 4: {
                        StringBuffer stringBuffer = new StringBuffer(string.length());
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"", true);
                        while (stringTokenizer.hasMoreTokens()) {
                            String string2 = stringTokenizer.nextToken();
                            stringBuffer.append(string2);
                            if (!string2.equals("\"")) continue;
                            stringBuffer.append("\"");
                        }
                    }
                    case 6: 
                    case 64: 
                    case 68: {
                        System.out.print("\"");
                        System.out.print(string);
                        System.out.print("\"");
                        break;
                    }
                    default: {
                        System.out.print(string);
                    }
                }
                if (i + 1 >= tableEvent.getColumns().length) continue;
                System.out.print(",");
            }
            System.out.println();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(TableEvent tableEvent) {
            Object object = tableEvent.getUserObject();
            synchronized (object) {
                tableEvent.getUserObject().notify();
            }
        }
    }
}

