/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.logs.LogLimits;

public final class LogLimitsBuilder {
    private static final int DEFAULT_LOG_MAX_NUM_ATTRIBUTES = 128;
    private static final int DEFAULT_LOG_MAX_ATTRIBUTE_LENGTH = Integer.MAX_VALUE;
    private int maxNumAttributes = 128;
    private int maxAttributeValueLength = Integer.MAX_VALUE;

    LogLimitsBuilder() {
    }

    public LogLimitsBuilder setMaxNumberOfAttributes(int maxNumberOfAttributes) {
        Utils.checkArgument((maxNumberOfAttributes >= 0 ? 1 : 0) != 0, (String)"maxNumberOfAttributes must be non-negative");
        this.maxNumAttributes = maxNumberOfAttributes;
        return this;
    }

    public LogLimitsBuilder setMaxAttributeValueLength(int maxAttributeValueLength) {
        Utils.checkArgument((maxAttributeValueLength >= 0 ? 1 : 0) != 0, (String)"maxAttributeValueLength must be non-negative");
        this.maxAttributeValueLength = maxAttributeValueLength;
        return this;
    }

    public LogLimits build() {
        return LogLimits.create(this.maxNumAttributes, this.maxAttributeValueLength);
    }
}

