/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptor;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptorSupplier;
import org.jetbrains.annotations.Nullable;

class CatalogStorageIndexDescriptorSupplier
implements StorageIndexDescriptorSupplier {
    private final CatalogService catalogService;
    private final LowWatermark lowWatermark;

    CatalogStorageIndexDescriptorSupplier(CatalogService catalogService, LowWatermark lowWatermark) {
        this.catalogService = catalogService;
        this.lowWatermark = lowWatermark;
    }

    @Nullable
    public StorageIndexDescriptor get(int indexId) {
        int latestCatalogVersion = this.catalogService.latestCatalogVersion();
        HybridTimestamp lowWatermarkTimestamp = this.lowWatermark.getLowWatermark();
        int earliestCatalogVersion = lowWatermarkTimestamp == null ? this.catalogService.earliestCatalogVersion() : this.catalogService.activeCatalogVersion(lowWatermarkTimestamp.longValue());
        for (int catalogVersion = latestCatalogVersion; catalogVersion >= earliestCatalogVersion; --catalogVersion) {
            Catalog catalog = this.catalogService.catalog(catalogVersion);
            CatalogIndexDescriptor index = catalog.index(indexId);
            if (index == null) continue;
            CatalogTableDescriptor table = catalog.table(index.tableId());
            assert (table != null) : "tableId=" + index.tableId() + ", indexId=" + index.id();
            return StorageIndexDescriptor.create((CatalogTableDescriptor)table, (CatalogIndexDescriptor)index);
        }
        return null;
    }
}

