/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.catalog.IgniteCatalog;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.client.IgniteClientConfiguration;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.internal.catalog.sql.IgniteCatalogSqlImpl;
import org.apache.ignite.internal.client.ClientChannel;
import org.apache.ignite.internal.client.ClientChannelFactory;
import org.apache.ignite.internal.client.ClientClusterNode;
import org.apache.ignite.internal.client.ClientMetricSource;
import org.apache.ignite.internal.client.ClientUtils;
import org.apache.ignite.internal.client.PayloadInputChannel;
import org.apache.ignite.internal.client.PayloadReader;
import org.apache.ignite.internal.client.PayloadWriter;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.TcpClientChannel;
import org.apache.ignite.internal.client.compute.ClientCompute;
import org.apache.ignite.internal.client.network.ClientCluster;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.client.table.ClientTables;
import org.apache.ignite.internal.client.tx.ClientTransactions;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.jdbc.proto.ClientMessage;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.internal.marshaller.ReflectionMarshallersProvider;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.MetricManagerImpl;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.internal.metrics.exporters.jmx.JmxExporter;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.IgniteCluster;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.tx.IgniteTransactions;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TcpIgniteClient
implements IgniteClient {
    private static final AtomicLong GLOBAL_CONN_ID_GEN = new AtomicLong();
    private final IgniteClientConfiguration cfg;
    private final ReliableChannel ch;
    private final ClientTables tables;
    private final ClientTransactions transactions;
    private final ClientCompute compute;
    private final ClientSql sql;
    @Nullable
    private final MetricManager metricManager;
    private final ClientMetricSource metrics;
    private final ReflectionMarshallersProvider marshallers = new ReflectionMarshallersProvider();
    private final ClientCluster cluster;
    private String clusterName;
    private final String clientName;

    private TcpIgniteClient(IgniteClientConfiguration cfg, HybridTimestampTracker observableTimeTracker) {
        this(TcpClientChannel::createAsync, cfg, observableTimeTracker);
    }

    private TcpIgniteClient(ClientChannelFactory chFactory, IgniteClientConfiguration cfg, HybridTimestampTracker observableTimeTracker) {
        assert (chFactory != null);
        assert (cfg != null);
        this.cfg = cfg;
        String cfgName = cfg.name();
        this.clientName = cfgName != null ? cfgName : "client_" + GLOBAL_CONN_ID_GEN.incrementAndGet();
        this.metrics = new ClientMetricSource();
        this.ch = new ReliableChannel(chFactory, cfg, this.metrics, observableTimeTracker);
        this.tables = new ClientTables(this.ch, (MarshallersProvider)this.marshallers, cfg.sqlPartitionAwarenessMetadataCacheSize());
        this.transactions = new ClientTransactions(this.ch);
        this.compute = new ClientCompute(this.ch, this.tables);
        this.sql = new ClientSql(this.ch, (MarshallersProvider)this.marshallers, cfg.sqlPartitionAwarenessMetadataCacheSize());
        this.metricManager = this.initMetricManager(cfg);
        this.cluster = new ClientCluster(this.ch);
    }

    @Nullable
    private MetricManager initMetricManager(IgniteClientConfiguration cfg) {
        if (!cfg.metricsEnabled()) {
            return null;
        }
        MetricManagerImpl metricManager = new MetricManagerImpl(ClientUtils.logger(cfg, MetricManagerImpl.class), this.clientName);
        metricManager.registerSource((MetricSource)this.metrics);
        metricManager.enable((MetricSource)this.metrics);
        metricManager.start(List.of(new JmxExporter(ClientUtils.logger(cfg, JmxExporter.class))));
        return metricManager;
    }

    private CompletableFuture<ClientChannel> initAsync() {
        return this.ch.channelsInitAsync().whenComplete((channel, throwable) -> {
            if (throwable == null) {
                this.clusterName = channel.protocolContext().clusterName();
            }
        });
    }

    public static CompletableFuture<IgniteClient> startAsync(IgniteClientConfiguration cfg) {
        return TcpIgniteClient.startAsync(cfg, HybridTimestampTracker.atomicTracker(null));
    }

    public static CompletableFuture<IgniteClient> startAsync(IgniteClientConfiguration cfg, HybridTimestampTracker observableTimeTracker) {
        ErrorGroups.initialize();
        try {
            TcpIgniteClient client = new TcpIgniteClient(cfg, observableTimeTracker);
            return client.initAsync().thenApply(x -> client);
        }
        catch (IgniteException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public IgniteTables tables() {
        return this.tables;
    }

    public IgniteTransactions transactions() {
        return this.transactions;
    }

    public IgniteSql sql() {
        return this.sql;
    }

    public IgniteCompute compute() {
        return this.compute;
    }

    public IgniteCatalog catalog() {
        return new IgniteCatalogSqlImpl((IgniteSql)this.sql, (IgniteTables)this.tables);
    }

    public IgniteCluster cluster() {
        return this.cluster;
    }

    @Override
    public void close() {
        try {
            this.ch.close();
        }
        catch (Exception e) {
            throw new IgniteInternalException(ErrorGroups.Client.CONNECTION_ERR, "Error occurred while closing the channel", (Throwable)e);
        }
        if (this.metricManager != null) {
            this.metricManager.beforeNodeStop();
            this.metricManager.stopAsync(new ComponentContext()).join();
        }
    }

    public String name() {
        return this.clientName;
    }

    @Override
    public IgniteClientConfiguration configuration() {
        return this.cfg;
    }

    @Override
    public List<ClusterNode> connections() {
        return this.ch.connections();
    }

    public String toString() {
        return S.toString((String)TcpIgniteClient.class.getSimpleName(), (String)"name", (Object)this.clientName, (String)"clusterName", (Object)this.clusterName);
    }

    public String clusterName() {
        return this.clusterName;
    }

    @TestOnly
    public ClientMetricSource metrics() {
        return this.metrics;
    }

    public ReliableChannel channel() {
        return this.ch;
    }

    public <T extends ClientMessage> CompletableFuture<T> sendRequestAsync(int opCode, PayloadWriter writer, PayloadReader<T> reader) {
        return this.ch.serviceAsync(opCode, writer, reader);
    }

    public static ClusterNode unpackClusterNode(PayloadInputChannel r) {
        ClientMessageUnpacker in = r.in();
        int fieldCnt = r.in().unpackInt();
        assert (fieldCnt == 4);
        return new ClientClusterNode(in.unpackUuid(), in.unpackString(), new NetworkAddress(in.unpackString(), in.unpackInt()));
    }
}

