/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactor.http.client;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.reactor.http.client.BridgedReactorHttpClient;
import java.net.URL;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public interface ReactorHttpClient
extends HttpClient {
    default public <I, O> Flux<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType) {
        return Flux.from((Publisher)super.exchange(request, bodyType));
    }

    public <I, O, E> Flux<HttpResponse<O>> exchange(@NonNull HttpRequest<I> var1, @NonNull Argument<O> var2, @NonNull Argument<E> var3);

    default public <I, O, E> Flux<O> retrieve(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType, @NonNull Argument<E> errorType) {
        return Flux.from((Publisher)super.retrieve(request, bodyType, errorType));
    }

    default public <I> Flux<HttpResponse<ByteBuffer>> exchange(@NonNull HttpRequest<I> request) {
        return Flux.from((Publisher)super.exchange(request));
    }

    default public Flux<HttpResponse<ByteBuffer>> exchange(@NonNull String uri) {
        return Flux.from((Publisher)super.exchange(uri));
    }

    default public <O> Flux<HttpResponse<O>> exchange(@NonNull String uri, @NonNull Class<O> bodyType) {
        return Flux.from((Publisher)super.exchange(uri, bodyType));
    }

    default public <I, O> Flux<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Class<O> bodyType) {
        return Flux.from((Publisher)super.exchange(request, bodyType));
    }

    default public <I, O> Flux<O> retrieve(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType) {
        return Flux.from((Publisher)super.retrieve(request, bodyType));
    }

    default public <I, O> Flux<O> retrieve(@NonNull HttpRequest<I> request, @NonNull Class<O> bodyType) {
        return this.retrieve(request, (Argument<O>)Argument.of(bodyType), (Argument<E>)DEFAULT_ERROR_TYPE);
    }

    default public <I> Flux<String> retrieve(@NonNull HttpRequest<I> request) {
        return this.retrieve(request, (Argument<O>)Argument.STRING, (Argument<E>)DEFAULT_ERROR_TYPE);
    }

    default public Flux<String> retrieve(@NonNull String uri) {
        return this.retrieve((HttpRequest<I>)((HttpRequest)HttpRequest.GET((String)uri)), (Argument<O>)Argument.STRING, (Argument<E>)DEFAULT_ERROR_TYPE);
    }

    @NonNull
    public static ReactorHttpClient create(@Nullable URL url) {
        return new BridgedReactorHttpClient(HttpClient.create((URL)url));
    }

    @NonNull
    public static ReactorHttpClient create(@Nullable URL url, @NonNull HttpClientConfiguration configuration) {
        return new BridgedReactorHttpClient(HttpClient.create((URL)url, (HttpClientConfiguration)configuration));
    }
}

