/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import org.apache.calcite.DataContext;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.CartesianProductEnumerator;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Deterministic;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.linq4j.function.NonDeterministic;
import org.apache.calcite.linq4j.function.Predicate1;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.type.TimeFrame;
import org.apache.calcite.rel.type.TimeFrameSet;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.runtime.JsonFunctions;
import org.apache.calcite.runtime.Like;
import org.apache.calcite.runtime.MapEntry;
import org.apache.calcite.runtime.variant.VariantValue;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.util.NumberUtil;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.TimeWithTimeZoneString;
import org.apache.calcite.util.TimestampWithTimeZoneString;
import org.apache.calcite.util.TryThreadLocal;
import org.apache.calcite.util.Unsafe;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.format.FormatElement;
import org.apache.calcite.util.format.FormatModel;
import org.apache.calcite.util.format.FormatModels;
import org.apache.calcite.util.format.postgresql.CompiledDateTimeFormat;
import org.apache.calcite.util.format.postgresql.PostgresqlDateTimeFormatter;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.language.Soundex;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

@Deterministic
public class SqlFunctions {
    private static final String COMMA_DELIMITER = ",";
    private static final DecimalFormat DOUBLE_FORMAT = NumberUtil.decimalFormat("0.0E0");
    private static final TimeZone LOCAL_TZ = TimeZone.getDefault();
    private static final DateTimeFormatter ROOT_DAY_FORMAT = DateTimeFormatter.ofPattern("EEEE", Locale.ROOT);
    private static final DateTimeFormatter ROOT_MONTH_FORMAT = DateTimeFormatter.ofPattern("MMMM", Locale.ROOT);
    private static final Soundex SOUNDEX = new Soundex();
    private static final int SOUNDEX_LENGTH = 4;
    private static final LevenshteinDistance LEVENSHTEIN_DISTANCE = LevenshteinDistance.getDefaultInstance();
    private static final Pattern FROM_BASE64_REGEXP = Pattern.compile("[\\t\\n\\r\\s]");
    private static final Base32 BASE_32 = new Base32();
    private static final int MAX_ARRAY_LENGTH = 0x7FFFFFF0;
    private static final Function1<List<Object>, Enumerable<Object>> LIST_AS_ENUMERABLE = a0 -> a0 == null ? Linq4j.emptyEnumerable() : Linq4j.asEnumerable((List)a0);
    private static final Function1<Object[], Enumerable<@Nullable Object[]>> ARRAY_CARTESIAN_PRODUCT = lists -> {
        ArrayList<@Nullable @Nullable Enumerator> enumerators = new ArrayList<Enumerator>();
        for (Object list : lists) {
            enumerators.add(Linq4j.enumerator((Collection)((List)list)));
        }
        final @Nullable @Nullable Enumerator product = Linq4j.product(enumerators);
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<@Nullable Object[]> enumerator() {
                return Linq4j.transform((Enumerator)product, List::toArray);
            }
        };
    };
    private static final TryThreadLocal<Map<String, AtomicLong>> THREAD_SEQUENCES = TryThreadLocal.withInitial(HashMap::new);
    private static final ByteString SINGLE_SPACE_BYTE_STRING = ByteString.of((String)"20", (int)16);
    private static final DateTimeFormatter BIG_QUERY_TIMESTAMP_LITERAL_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).optionalStart().padNext(1, ' ').optionalStart().appendLiteral('T').optionalEnd().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).optionalStart().appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).optionalEnd().optionalStart().parseLenient().appendOffsetId().toFormatter(Locale.ROOT);
    private static final boolean IS_JDK_8 = System.getProperty("java.version").startsWith("1.8");
    private static final BigDecimal BITCOUNT_MAX = new BigDecimal(2).pow(64).subtract(new BigDecimal(1));
    private static final BigDecimal BITCOUNT_MIN = new BigDecimal(2).pow(63).negate();

    private SqlFunctions() {
    }

    @NonDeterministic
    public static boolean throwUnless(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
        return condition;
    }

    public static String uuidToString(UUID uuid) {
        return uuid.toString();
    }

    public static UUID binaryToUuid(ByteString bytes) {
        if (bytes.length() < 16) {
            throw new IllegalArgumentException("Need at least 16 bytes for UUID");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes.getBytes());
        long mostSignificantBits = byteBuffer.getLong();
        long leastSignificantBits = byteBuffer.getLong();
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    public static ByteString uuidToBinary(UUID uuid) {
        byte[] dest = new byte[16];
        ByteBuffer byteBuffer = ByteBuffer.wrap(dest);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        return new ByteString(dest);
    }

    public static String toBase64(String string) {
        return SqlFunctions.toBase64_(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String toBase64(ByteString string) {
        return SqlFunctions.toBase64_(string.getBytes());
    }

    private static String toBase64_(byte[] bytes) {
        String base64 = Base64.getEncoder().encodeToString(bytes);
        StringBuilder str = new StringBuilder(base64.length() + base64.length() / 76);
        Splitter.fixedLength((int)76).split((CharSequence)base64).iterator().forEachRemaining(s -> {
            str.append((String)s);
            str.append("\n");
        });
        return str.substring(0, str.length() - 1);
    }

    public static @Nullable ByteString fromBase64(String base64) {
        try {
            base64 = FROM_BASE64_REGEXP.matcher(base64).replaceAll("");
            return new ByteString(Base64.getDecoder().decode(base64));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String toBase32(String string) {
        return SqlFunctions.toBase32_(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String toBase32(ByteString string) {
        return SqlFunctions.toBase32_(string.getBytes());
    }

    private static String toBase32_(byte[] bytes) {
        return BASE_32.encodeToString(bytes);
    }

    public static ByteString fromBase32(String base32) {
        return new ByteString(BASE_32.decode(base32));
    }

    public static ByteString fromHex(String hex) {
        try {
            return new ByteString(Hex.decodeHex((String)hex));
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Failed to decode hex string: %s", hex), e);
        }
    }

    public static String toHex(ByteString byteString) {
        return Hex.encodeHexString((byte[])byteString.getBytes());
    }

    public static String hex(String value) {
        return Hex.encodeHexString((byte[])value.getBytes(StandardCharsets.UTF_8));
    }

    public static String bin(long value) {
        int zeros = Long.numberOfLeadingZeros(value);
        if (zeros == 64) {
            return "0";
        }
        int length = 64 - zeros;
        byte[] bytes = new byte[length];
        for (int index = length - 1; index >= 0; --index) {
            bytes[index] = (byte)((value & 1L) == 1L ? 49 : 48);
            value >>>= 1;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static long crc32(String value) {
        CRC32 crc32 = new CRC32();
        crc32.reset();
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        crc32.update(bytes, 0, bytes.length);
        return crc32.getValue();
    }

    public static long crc32(ByteString value) {
        CRC32 crc32 = new CRC32();
        crc32.reset();
        byte[] bytes = value.getBytes();
        crc32.update(bytes, 0, bytes.length);
        return crc32.getValue();
    }

    public static String md5(String string) {
        return DigestUtils.md5Hex((byte[])string.getBytes(StandardCharsets.UTF_8));
    }

    public static String md5(ByteString string) {
        return DigestUtils.md5Hex((byte[])string.getBytes());
    }

    public static String sha1(String string) {
        return DigestUtils.sha1Hex((byte[])string.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha1(ByteString string) {
        return DigestUtils.sha1Hex((byte[])string.getBytes());
    }

    public static String sha256(String string) {
        return DigestUtils.sha256Hex((byte[])string.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha256(ByteString string) {
        return DigestUtils.sha256Hex((byte[])string.getBytes());
    }

    public static String sha512(String string) {
        return DigestUtils.sha512Hex((byte[])string.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha512(ByteString string) {
        return DigestUtils.sha512Hex((byte[])string.getBytes());
    }

    public static String lpad(String originalValue, int returnLength, String pattern) {
        if (returnLength < 0) {
            throw Static.RESOURCE.illegalNegativePadLength().ex();
        }
        if (pattern.isEmpty()) {
            throw Static.RESOURCE.illegalEmptyPadPattern().ex();
        }
        if (returnLength <= originalValue.length()) {
            return originalValue.substring(0, returnLength);
        }
        int paddingLengthRequired = returnLength - originalValue.length();
        int patternLength = pattern.length();
        StringBuilder paddedS = new StringBuilder();
        for (int i = 0; i < paddingLengthRequired; ++i) {
            char curChar = pattern.charAt(i % patternLength);
            paddedS.append(curChar);
        }
        paddedS.append(originalValue);
        return paddedS.toString();
    }

    public static String lpad(String originalValue, int returnLength) {
        return SqlFunctions.lpad(originalValue, returnLength, " ");
    }

    public static ByteString lpad(ByteString originalValue, int returnLength, ByteString pattern) {
        int i;
        if (returnLength < 0) {
            throw Static.RESOURCE.illegalNegativePadLength().ex();
        }
        if (pattern.length() == 0) {
            throw Static.RESOURCE.illegalEmptyPadPattern().ex();
        }
        if (returnLength <= originalValue.length()) {
            return originalValue.substring(0, returnLength);
        }
        int paddingLengthRequired = returnLength - originalValue.length();
        int patternLength = pattern.length();
        byte[] bytes = new byte[returnLength];
        for (i = 0; i < paddingLengthRequired; ++i) {
            byte curByte;
            bytes[i] = curByte = pattern.byteAt(i % patternLength);
        }
        for (i = paddingLengthRequired; i < returnLength; ++i) {
            bytes[i] = originalValue.byteAt(i - paddingLengthRequired);
        }
        return new ByteString(bytes);
    }

    public static ByteString lpad(ByteString originalValue, int returnLength) {
        return SqlFunctions.lpad(originalValue, returnLength, SINGLE_SPACE_BYTE_STRING);
    }

    public static String rpad(String originalValue, int returnLength, String pattern) {
        if (returnLength < 0) {
            throw Static.RESOURCE.illegalNegativePadLength().ex();
        }
        if (pattern.isEmpty()) {
            throw Static.RESOURCE.illegalEmptyPadPattern().ex();
        }
        if (returnLength <= originalValue.length()) {
            return originalValue.substring(0, returnLength);
        }
        int paddingLengthRequired = returnLength - originalValue.length();
        int patternLength = pattern.length();
        StringBuilder paddedS = new StringBuilder();
        paddedS.append(originalValue);
        for (int i = 0; i < paddingLengthRequired; ++i) {
            char curChar = pattern.charAt(i % patternLength);
            paddedS.append(curChar);
        }
        return paddedS.toString();
    }

    public static String rpad(String originalValue, int returnLength) {
        return SqlFunctions.rpad(originalValue, returnLength, " ");
    }

    public static ByteString rpad(ByteString originalValue, int returnLength, ByteString pattern) {
        int i;
        if (returnLength < 0) {
            throw Static.RESOURCE.illegalNegativePadLength().ex();
        }
        if (pattern.length() == 0) {
            throw Static.RESOURCE.illegalEmptyPadPattern().ex();
        }
        int originalLength = originalValue.length();
        if (returnLength <= originalLength) {
            return originalValue.substring(0, returnLength);
        }
        int paddingLengthRequired = returnLength - originalLength;
        int patternLength = pattern.length();
        byte[] bytes = new byte[returnLength];
        for (i = 0; i < originalLength; ++i) {
            bytes[i] = originalValue.byteAt(i);
        }
        for (i = returnLength - paddingLengthRequired; i < returnLength; ++i) {
            byte curByte;
            bytes[i] = curByte = pattern.byteAt(i % patternLength);
        }
        return new ByteString(bytes);
    }

    public static ByteString rpad(ByteString originalValue, int returnLength) {
        return SqlFunctions.rpad(originalValue, returnLength, SINGLE_SPACE_BYTE_STRING);
    }

    public static boolean endsWith(String s0, String s1) {
        return s0.endsWith(s1);
    }

    public static boolean endsWith(ByteString s0, ByteString s1) {
        return s0.endsWith(s1);
    }

    public static boolean startsWith(String s0, String s1) {
        return s0.startsWith(s1);
    }

    public static boolean startsWith(ByteString s0, ByteString s1) {
        return s0.startsWith(s1);
    }

    public static List<String> split(String s, String delimiter) {
        if (s.isEmpty()) {
            return ImmutableList.of();
        }
        if (delimiter.isEmpty()) {
            return ImmutableList.of((Object)s);
        }
        ImmutableList.Builder list = ImmutableList.builder();
        int i = 0;
        while (true) {
            int j;
            if ((j = s.indexOf(delimiter, i)) < 0) {
                list.add((Object)s.substring(i));
                return list.build();
            }
            list.add((Object)s.substring(i, j));
            i = j + delimiter.length();
        }
    }

    public static String splitPart(String s, String delimiter, int n) {
        if (Strings.isNullOrEmpty((String)s) || Strings.isNullOrEmpty((String)delimiter)) {
            return "";
        }
        String[] parts = s.split(delimiter, -1);
        int partCount = parts.length;
        if (n < 0) {
            n = partCount + n + 1;
        }
        if (n <= 0 || n > partCount) {
            return "";
        }
        return parts[n - 1];
    }

    public static List<String> split(String s) {
        return SqlFunctions.split(s, COMMA_DELIMITER);
    }

    public static List<ByteString> split(ByteString s, ByteString delimiter) {
        if (s.length() == 0) {
            return ImmutableList.of();
        }
        if (delimiter.length() == 0) {
            return ImmutableList.of((Object)s);
        }
        ImmutableList.Builder list = ImmutableList.builder();
        int i = 0;
        while (true) {
            int j;
            if ((j = s.indexOf(delimiter, i)) < 0) {
                list.add((Object)s.substring(i));
                return list.build();
            }
            list.add((Object)s.substring(i, j));
            i = j + delimiter.length();
        }
    }

    public static @Nullable Boolean containsSubstr(Object[] rows, String substr) {
        boolean nullFlag = false;
        for (Object row : rows) {
            if (row == null) {
                nullFlag = true;
                continue;
            }
            if (row instanceof Object[]) {
                return SqlFunctions.containsSubstr((Object[])row, substr);
            }
            if (row instanceof ArrayList) {
                return SqlFunctions.containsSubstr((List)row, substr);
            }
            if (!SqlFunctions.normalize(row.toString()).contains(SqlFunctions.normalize(substr))) continue;
            return true;
        }
        return nullFlag ? null : Boolean.valueOf(false);
    }

    public static @Nullable Boolean containsSubstr(List arr, String substr) {
        boolean nullFlag = false;
        for (Object item : arr) {
            if (item == null) {
                nullFlag = true;
            }
            if (item == null || !SqlFunctions.containsSubstr(item, substr)) continue;
            return true;
        }
        return nullFlag ? null : Boolean.valueOf(false);
    }

    public static boolean containsSubstr(String jsonString, String substr, String jsonScope) {
        Object o = Objects.requireNonNull(JsonFunctions.dejsonize(jsonString));
        LinkedHashMap map = (LinkedHashMap)o;
        Set keys = map.keySet();
        Collection values = map.values();
        try {
            switch (JsonScope.valueOf(jsonScope)) {
                case JSON_KEYS: {
                    return keys.contains(substr);
                }
                case JSON_KEYS_AND_VALUES: {
                    return keys.contains(substr) || values.contains(substr);
                }
                case JSON_VALUES: {
                    return values.contains(substr);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw new IllegalArgumentException("json_scope argument must be one of: \"JSON_KEYS\", \"JSON_VALUES\", \"JSON_KEYS_AND_VALUES\".");
    }

    public static boolean containsSubstr(Object expr, String substr) {
        expr = SqlFunctions.normalize(expr.toString());
        substr = SqlFunctions.normalize(substr);
        if (Boolean.TRUE.equals(JsonFunctions.isJsonObject(expr.toString()))) {
            return SqlFunctions.containsSubstr(expr.toString(), substr, "JSON_VALUES");
        }
        return ((String)expr).contains(substr);
    }

    public static boolean containsSubstr(boolean s, String substr) {
        return SqlFunctions.containsSubstr(String.valueOf(s), substr);
    }

    public static boolean containsSubstr(int s, String substr) {
        return SqlFunctions.containsSubstr(String.valueOf(s), substr);
    }

    public static boolean containsSubstr(long s, String substr) {
        return SqlFunctions.containsSubstr(String.valueOf(s), substr);
    }

    private static String normalize(String s) {
        s = StringEscapeUtils.unescapeJava((String)s);
        s = Normalizer.normalize(s, Normalizer.Form.NFKC);
        s = SqlFunctions.lower(s);
        return s;
    }

    static int clamp(long s) {
        if (s < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (s > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)s;
    }

    public static String substring(String c, int s) {
        if (s <= 1) {
            return c;
        }
        if (s > c.length()) {
            return "";
        }
        int s0 = s - 1;
        return c.substring(s0);
    }

    public static String substring(String c, long s) {
        return SqlFunctions.substring(c, SqlFunctions.clamp(s));
    }

    public static String substring(String c, int s, int l) {
        int lc = c.length();
        long e = (long)s + (long)l;
        if (l < 0) {
            throw Static.RESOURCE.illegalNegativeSubstringLength().ex();
        }
        if (s > lc || e < 1L) {
            return "";
        }
        int s0 = Math.max(s - 1, 0);
        long e0 = Math.min(e - 1L, (long)lc);
        return c.substring(s0, (int)e0);
    }

    public static String substring(String c, int s, long l) {
        if (s < 0 && l > 0L && l + (long)s > 0L) {
            return SqlFunctions.substring(c, 0, l += (long)s);
        }
        int l0 = SqlFunctions.clamp(l);
        return SqlFunctions.substring(c, s, l0);
    }

    public static String substring(String c, long s, int l) {
        if (s < 0L) {
            if ((s += (long)l) > 0L) {
                return SqlFunctions.substring(c, 0, s);
            }
            return "";
        }
        int s0 = SqlFunctions.clamp(s);
        return SqlFunctions.substring(c, s0, l);
    }

    public static String substring(String c, long s, long l) {
        if (s < 0L && l > 0L) {
            return SqlFunctions.substring(c, 0, SqlFunctions.clamp(l += s));
        }
        int s0 = SqlFunctions.clamp(s);
        int l0 = SqlFunctions.clamp(l);
        return SqlFunctions.substring(c, s0, l0);
    }

    public static ByteString substring(ByteString c, int s) {
        if (s <= 1) {
            return c;
        }
        if (s > c.length()) {
            return ByteString.EMPTY;
        }
        int s0 = s - 1;
        return c.substring(s0);
    }

    public static ByteString substring(ByteString c, int s, int l) {
        int lc = c.length();
        int e = s + l;
        if (l < 0) {
            throw Static.RESOURCE.illegalNegativeSubstringLength().ex();
        }
        if (s > lc || e < 1) {
            return ByteString.EMPTY;
        }
        int s0 = Math.max(s - 1, 0);
        int e0 = Math.min(e - 1, lc);
        return c.substring(s0, e0);
    }

    public static String formatNumber(long value, int decimalVal) {
        DecimalFormat numberFormat = SqlFunctions.getNumberFormat(decimalVal);
        return numberFormat.format(value);
    }

    public static String formatNumber(double value, int decimalVal) {
        DecimalFormat numberFormat = SqlFunctions.getNumberFormat(decimalVal);
        return numberFormat.format(value);
    }

    public static String formatNumber(BigDecimal value, int decimalVal) {
        DecimalFormat numberFormat = SqlFunctions.getNumberFormat(decimalVal);
        return numberFormat.format(value);
    }

    public static String formatNumber(long value, String format) {
        DecimalFormat numberFormat = SqlFunctions.getNumberFormat(format);
        return numberFormat.format(value);
    }

    public static String formatNumber(double value, String format) {
        DecimalFormat numberFormat = SqlFunctions.getNumberFormat(format);
        return numberFormat.format(value);
    }

    public static String formatNumber(BigDecimal value, String format) {
        DecimalFormat numberFormat = SqlFunctions.getNumberFormat(format);
        return numberFormat.format(value);
    }

    public static String getFormatPattern(int decimalVal) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("#,###,###,###,###,###,##0");
        if (decimalVal > 0) {
            pattern.append(".");
            for (int i = 0; i < decimalVal; ++i) {
                pattern.append("0");
            }
        }
        return pattern.toString();
    }

    private static DecimalFormat getNumberFormat(String pattern) {
        return NumberUtil.decimalFormat(pattern);
    }

    private static DecimalFormat getNumberFormat(int decimalVal) {
        if (decimalVal < 0) {
            throw Static.RESOURCE.illegalNegativeDecimalValue().ex();
        }
        String pattern = SqlFunctions.getFormatPattern(decimalVal);
        return SqlFunctions.getNumberFormat(pattern);
    }

    public static String upper(String s) {
        return s.toUpperCase(Locale.ROOT);
    }

    public static String lower(String s) {
        return s.toLowerCase(Locale.ROOT);
    }

    public static String initcap(String s) {
        int len = s.length();
        boolean start = true;
        StringBuilder newS = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char curCh;
            char c = curCh = s.charAt(i);
            if (start) {
                if (c > '/' && c < ':') {
                    start = false;
                } else if (c > '@' && c < '[') {
                    start = false;
                } else if (c > '`' && c < '{') {
                    start = false;
                    curCh = (char)(c - 32);
                }
            } else if (c <= '/' || c >= ':') {
                if (c > '@' && c < '[') {
                    curCh = (char)(c + 32);
                } else if (c <= '`' || c >= '{') {
                    start = true;
                }
            }
            newS.append(curCh);
        }
        return newS.toString();
    }

    public static String reverse(String s) {
        StringBuilder buf = new StringBuilder(s);
        return buf.reverse().toString();
    }

    public static int levenshtein(String string1, String string2) {
        return LEVENSHTEIN_DISTANCE.apply((CharSequence)string1, (CharSequence)string2);
    }

    public static @Nullable Integer findInSet(@Nullable String matchStr, @Nullable String textStr) {
        if (matchStr == null || textStr == null) {
            return null;
        }
        if (matchStr.contains(COMMA_DELIMITER)) {
            return 0;
        }
        String[] splits = textStr.split(COMMA_DELIMITER);
        for (int i = 0; i < splits.length; ++i) {
            if (!matchStr.equals(splits[i])) continue;
            return i + 1;
        }
        return 0;
    }

    public static int ascii(String s) {
        return s.isEmpty() ? 0 : s.codePointAt(0);
    }

    public static String repeat(String s, int n) {
        if (n < 1) {
            return "";
        }
        return Strings.repeat((String)s, (int)n);
    }

    public static String space(int n) {
        return SqlFunctions.repeat(" ", n);
    }

    public static int strcmp(String s0, String s1) {
        return (int)Math.signum(s1.compareTo(s0));
    }

    public static String soundex(String s) {
        return SOUNDEX.soundex(s);
    }

    public static String soundexSpark(String s) {
        try {
            return SOUNDEX.soundex(s);
        }
        catch (IllegalArgumentException ignore) {
            return s;
        }
    }

    public static int difference(String s0, String s1) {
        String result0 = SqlFunctions.soundex(s0);
        String result1 = SqlFunctions.soundex(s1);
        for (int i = 0; i < 4; ++i) {
            if (result0.charAt(i) == result1.charAt(i)) continue;
            return i;
        }
        return 4;
    }

    public static String left(String s, int n) {
        if (n <= 0) {
            return "";
        }
        int len = s.length();
        if (n >= len) {
            return s;
        }
        return s.substring(0, n);
    }

    public static ByteString left(ByteString s, int n) {
        if (n <= 0) {
            return ByteString.EMPTY;
        }
        int len = s.length();
        if (n >= len) {
            return s;
        }
        return s.substring(0, n);
    }

    public static String right(String s, int n) {
        if (n <= 0) {
            return "";
        }
        int len = s.length();
        if (n >= len) {
            return s;
        }
        return s.substring(len - n);
    }

    public static ByteString right(ByteString s, int n) {
        if (n <= 0) {
            return ByteString.EMPTY;
        }
        int len = s.length();
        if (n >= len) {
            return s;
        }
        return s.substring(len - n);
    }

    public static @Nullable String charFromAscii(int n) {
        if (n < 0) {
            return null;
        }
        return String.valueOf(Character.toChars(n % 256));
    }

    public static String charFromUtf8(int n) {
        return String.valueOf(Character.toChars(n));
    }

    public static @Nullable ByteString codePointsToBytes(List codePoints) {
        int length = codePoints.size();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            Object codePoint = codePoints.get(i);
            if (codePoint == null) {
                return null;
            }
            assert (codePoint instanceof Number);
            long cp = ((Number)codePoint).longValue();
            if (cp < 0L || cp > 255L) {
                throw Static.RESOURCE.inputArgumentsOfFunctionOutOfRange("CODE_POINTS_TO_BYTES", cp, "[0, 255]").ex();
            }
            bytes[i] = (byte)cp;
        }
        return new ByteString(bytes);
    }

    public static @Nullable String codePointsToString(List codePoints) {
        StringBuilder sb = new StringBuilder();
        for (Object codePoint : codePoints) {
            if (codePoint == null) {
                return null;
            }
            assert (codePoint instanceof Number);
            long cp = ((Number)codePoint).longValue();
            if (cp >= 0L && cp <= 55295L || cp >= 57344L && cp <= 0x10FFFFL) {
                sb.append(SqlFunctions.charFromUtf8((int)cp));
                continue;
            }
            throw Static.RESOURCE.inputArgumentsOfFunctionOutOfRange("CODE_POINTS_TO_STRING", cp, "[0, 0xD7FF] and [0xE000, 0x10FFFF]").ex();
        }
        return sb.toString();
    }

    public static @Nullable List<Integer> toCodePoints(String s) {
        int cp;
        if (s.isEmpty()) {
            return null;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        int length = s.length();
        for (int i = 0; i < length; i += cp == s.charAt(i) ? 1 : 2) {
            cp = s.codePointAt(i);
            builder.add((Object)cp);
        }
        return builder.build();
    }

    public static @Nullable List<Integer> toCodePoints(ByteString s) {
        if (s.length() == 0) {
            return null;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (byte b : s.getBytes()) {
            builder.add((Object)b);
        }
        return builder.build();
    }

    public static int octetLength(ByteString s) {
        return s.length();
    }

    public static int charLength(String s) {
        return s.length();
    }

    public static int bitLength(String s) {
        return s.getBytes(StandardCharsets.UTF_8).length * 8;
    }

    public static int bitLength(ByteString s) {
        return s.length() * 8;
    }

    public static byte bitGet(long value, int position) {
        SqlFunctions.checkPosition(position, 63);
        return (byte)(value >> position & 1L);
    }

    public static byte bitGet(int value, int position) {
        SqlFunctions.checkPosition(position, 31);
        return (byte)(value >> position & 1);
    }

    public static byte bitGet(short value, int position) {
        SqlFunctions.checkPosition(position, 15);
        return (byte)(value >> position & 1);
    }

    public static byte bitGet(byte value, int position) {
        SqlFunctions.checkPosition(position, 7);
        return (byte)(value >> position & 1);
    }

    private static void checkPosition(int position, int limit) {
        if (position < 0) {
            throw Static.RESOURCE.illegalNegativeBitGetPosition(position).ex();
        }
        if (limit < position) {
            throw Static.RESOURCE.illegalBitGetPositionExceedsLimit(position, limit).ex();
        }
    }

    public static String concat(String s0, String s1) {
        return s0 + s1;
    }

    public static @Nullable String concatWithNull(@Nullable String s0, @Nullable String s1) {
        if (s0 == null) {
            return s1;
        }
        if (s1 == null) {
            return s0;
        }
        return s0 + s1;
    }

    public static ByteString concat(ByteString s0, ByteString s1) {
        return s0.concat(s1);
    }

    public static String concatMulti(String ... args) {
        return String.join((CharSequence)"", args);
    }

    public static String concatMultiWithNull(String ... args) {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(arg == null ? "" : arg);
        }
        return sb.toString();
    }

    public static String concatMultiWithSeparator(String ... args) {
        String sep = args[0] == null ? "" : args[0];
        return SqlFunctions.concatMultiWithSeparator(sep, args);
    }

    public static String concatMultiTypeWithSeparator(String sep, Object ... args) {
        if (args.length == 0) {
            return "";
        }
        Object[] argsArray = SqlFunctions.array(args);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(sep);
        for (Object arg : argsArray) {
            if (arg == null) continue;
            if (arg instanceof String) {
                arrayList.add((String)arg);
            }
            if (!(arg instanceof List)) continue;
            arrayList.addAll((List)arg);
        }
        return SqlFunctions.concatMultiWithSeparator(sep, arrayList.toArray(new String[0]));
    }

    private static String concatMultiWithSeparator(String sep, String ... args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            if (args[i] == null) continue;
            if (i < args.length - 1) {
                sb.append(args[i]).append(sep);
                continue;
            }
            sb.append(args[i]);
        }
        return sb.toString();
    }

    public static String concatMultiObjectWithSeparator(String sep, Object ... args) {
        if (args.length == 0) {
            return "";
        }
        return Arrays.stream(args).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(sep));
    }

    public static String convertWithCharset(String s, String srcCharset, String destCharset) {
        Charset src = SqlUtil.getCharset(srcCharset);
        Charset dest = SqlUtil.getCharset(destCharset);
        byte[] bytes = s.getBytes(src);
        CharsetDecoder decoder = dest.newDecoder();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        try {
            return decoder.decode(buffer).toString();
        }
        catch (CharacterCodingException ex) {
            throw Static.RESOURCE.charsetEncoding(s, dest.name()).ex();
        }
    }

    public static String translateWithCharset(String s, String transcodingName) {
        Charset charset = SqlUtil.getCharset(transcodingName);
        byte[] bytes = s.getBytes(Charset.defaultCharset());
        CharsetDecoder decoder = charset.newDecoder();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        try {
            return decoder.decode(buffer).toString();
        }
        catch (CharacterCodingException ex) {
            throw Static.RESOURCE.charsetEncoding(s, charset.name()).ex();
        }
    }

    public static String convertOracle(String s, String ... args) {
        Charset dest;
        Charset src;
        if (args.length == 1) {
            src = Charset.defaultCharset();
            dest = SqlUtil.getCharset(args[0]);
        } else {
            dest = SqlUtil.getCharset(args[0]);
            src = SqlUtil.getCharset(args[1]);
        }
        byte[] bytes = s.getBytes(src);
        CharsetDecoder decoder = dest.newDecoder();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        try {
            return decoder.decode(buffer).toString();
        }
        catch (CharacterCodingException ex) {
            throw Static.RESOURCE.charsetEncoding(s, dest.name()).ex();
        }
    }

    public static String rtrim(String s) {
        return SqlFunctions.trim(false, true, " ", s);
    }

    public static String ltrim(String s) {
        return SqlFunctions.trim(true, false, " ", s);
    }

    public static String trim(boolean left, boolean right, String seek, String s) {
        return SqlFunctions.trim(left, right, seek, s, true);
    }

    public static String trim(boolean left, boolean right, String seek, String s, boolean strict) {
        if (strict && seek.length() != 1) {
            throw Static.RESOURCE.trimError(seek).ex();
        }
        int j = s.length();
        if (right) {
            while (true) {
                if (j == 0) {
                    return "";
                }
                if (seek.indexOf(s.charAt(j - 1)) < 0) break;
                --j;
            }
        }
        int i = 0;
        if (left) {
            while (true) {
                if (i == j) {
                    return "";
                }
                if (seek.indexOf(s.charAt(i)) < 0) break;
                ++i;
            }
        }
        return s.substring(i, j);
    }

    public static ByteString trim(ByteString s) {
        return SqlFunctions.trim_(s, true, true);
    }

    public static ByteString rtrim(ByteString s) {
        return SqlFunctions.trim_(s, false, true);
    }

    private static ByteString trim_(ByteString s, boolean left, boolean right) {
        int j = s.length();
        if (right) {
            while (true) {
                if (j == 0) {
                    return ByteString.EMPTY;
                }
                if (s.byteAt(j - 1) != 0) break;
                --j;
            }
        }
        int i = 0;
        if (left) {
            while (true) {
                if (i == j) {
                    return ByteString.EMPTY;
                }
                if (s.byteAt(i) != 0) break;
                ++i;
            }
        }
        return s.substring(i, j);
    }

    public static String overlay(String s, String r, int start) {
        return s.substring(0, start - 1) + r + s.substring(start - 1 + r.length());
    }

    public static String overlay(String s, String r, int start, int length) {
        return s.substring(0, start - 1) + r + s.substring(start - 1 + length);
    }

    public static ByteString overlay(ByteString s, ByteString r, int start) {
        return s.substring(0, start - 1).concat(r).concat(s.substring(start - 1 + r.length()));
    }

    public static ByteString overlay(ByteString s, ByteString r, int start, int length) {
        return s.substring(0, start - 1).concat(r).concat(s.substring(start - 1 + length));
    }

    public static boolean eq(BigDecimal b0, BigDecimal b1) {
        return b0.stripTrailingZeros().equals(b1.stripTrailingZeros());
    }

    public static boolean eq(@Nullable Object @Nullable [] b0, @Nullable Object @Nullable [] b1) {
        return Arrays.deepEquals(b0, b1);
    }

    public static boolean eq(Object b0, Object b1) {
        return b0.equals(b1);
    }

    public static boolean eq(String s0, String s1, Comparator<String> comparator) {
        return comparator.compare(s0, s1) == 0;
    }

    public static boolean eqAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass())) {
            if (BigDecimal.class.isInstance(b0)) {
                return SqlFunctions.eq((BigDecimal)b0, (BigDecimal)b1);
            }
            return b0.equals(b1);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.eq(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        return false;
    }

    private static boolean allAssignable(Class clazz, Object o0, Object o1) {
        return clazz.isInstance(o0) && clazz.isInstance(o1);
    }

    public static boolean ne(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) != 0;
    }

    public static boolean ne(Object b0, Object b1) {
        return !SqlFunctions.eq(b0, b1);
    }

    public static boolean ne(String s0, String s1, Comparator<String> comparator) {
        return !SqlFunctions.eq(s0, s1, comparator);
    }

    public static boolean neAny(Object b0, Object b1) {
        return !SqlFunctions.eqAny(b0, b1);
    }

    public static boolean lt(boolean b0, boolean b1) {
        return Boolean.compare(b0, b1) < 0;
    }

    public static boolean lt(String b0, String b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean lt(String b0, String b1, Comparator<String> comparator) {
        return comparator.compare(b0, b1) < 0;
    }

    public static boolean lt(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean lt(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) < 0;
    }

    public static <T extends Comparable<T>> boolean ltNullable(T b0, T b1) {
        return b1 == null || b0 != null && b0.compareTo(b1) < 0;
    }

    public static boolean lt(byte b0, byte b1) {
        return b0 < b1;
    }

    public static boolean lt(char b0, char b1) {
        return b0 < b1;
    }

    public static boolean lt(short b0, short b1) {
        return b0 < b1;
    }

    public static boolean lt(int b0, int b1) {
        return b0 < b1;
    }

    public static boolean lt(long b0, long b1) {
        return b0 < b1;
    }

    public static boolean lt(float b0, float b1) {
        return b0 < b1;
    }

    public static boolean lt(double b0, double b1) {
        return b0 < b1;
    }

    public static boolean lt(List<?> b0, List<?> b1) {
        return Functions.compareLists(b0, b1) < 0;
    }

    public static boolean lt(Object[] b0, Object[] b1) {
        return Functions.compareObjectArrays((Object[])b0, (Object[])b1) < 0;
    }

    public static boolean ltAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) < 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.lt(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable("<", b0, b1);
    }

    public static boolean le(boolean b0, boolean b1) {
        return Boolean.compare(b0, b1) <= 0;
    }

    public static boolean le(String b0, String b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean le(String b0, String b1, Comparator<String> comparator) {
        return comparator.compare(b0, b1) <= 0;
    }

    public static boolean le(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean le(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean le(List<?> b0, List<?> b1) {
        return Functions.compareLists(b0, b1) <= 0;
    }

    public static boolean le(Object[] b0, Object[] b1) {
        return Functions.compareObjectArrays((Object[])b0, (Object[])b1) <= 0;
    }

    public static boolean leAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) <= 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.le(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable("<=", b0, b1);
    }

    public static boolean gt(boolean b0, boolean b1) {
        return Boolean.compare(b0, b1) > 0;
    }

    public static boolean gt(String b0, String b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean gt(String b0, String b1, Comparator<String> comparator) {
        return comparator.compare(b0, b1) > 0;
    }

    public static boolean gt(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean gt(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) > 0;
    }

    public static <T extends Comparable<T>> boolean gtNullable(T b0, T b1) {
        return b1 == null || b0 != null && b0.compareTo(b1) > 0;
    }

    public static boolean gt(byte b0, byte b1) {
        return b0 > b1;
    }

    public static boolean gt(char b0, char b1) {
        return b0 > b1;
    }

    public static boolean gt(short b0, short b1) {
        return b0 > b1;
    }

    public static boolean gt(int b0, int b1) {
        return b0 > b1;
    }

    public static boolean gt(long b0, long b1) {
        return b0 > b1;
    }

    public static boolean gt(float b0, float b1) {
        return b0 > b1;
    }

    public static boolean gt(double b0, double b1) {
        return b0 > b1;
    }

    public static boolean gt(List<?> b0, List<?> b1) {
        return Functions.compareLists(b0, b1) > 0;
    }

    public static boolean gt(Object[] b0, Object[] b1) {
        return Functions.compareObjectArrays((Object[])b0, (Object[])b1) > 0;
    }

    public static boolean gtAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) > 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.gt(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable(">", b0, b1);
    }

    public static boolean ge(boolean b0, boolean b1) {
        return Boolean.compare(b0, b1) >= 0;
    }

    public static boolean ge(String b0, String b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean ge(String b0, String b1, Comparator<String> comparator) {
        return comparator.compare(b0, b1) >= 0;
    }

    public static boolean ge(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean ge(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean ge(List<?> b0, List<?> b1) {
        return Functions.compareLists(b0, b1) >= 0;
    }

    public static boolean ge(Object[] b0, Object[] b1) {
        return Functions.compareObjectArrays((Object[])b0, (Object[])b1) >= 0;
    }

    public static boolean geAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) >= 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.ge(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable(">=", b0, b1);
    }

    public static int plus(int b0, int b1) {
        return b0 + b1;
    }

    public static @PolyNull Integer plus(@PolyNull Integer b0, int b1) {
        return b0 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 + b1);
    }

    public static @PolyNull Integer plus(int b0, @PolyNull Integer b1) {
        return b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 + b1);
    }

    public static @PolyNull Integer plus(@PolyNull Integer b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 + b1);
    }

    public static @PolyNull Long plus(@PolyNull Long b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0 + b1.longValue());
    }

    public static @PolyNull Long plus(@PolyNull Integer b0, @PolyNull Long b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0.longValue() + b1);
    }

    public static @PolyNull BigDecimal plus(@PolyNull BigDecimal b0, @PolyNull BigDecimal b1) {
        return b0 == null || b1 == null ? (BigDecimal)Nullness.castNonNull(null) : b0.add(b1);
    }

    public static @PolyNull Object plusAny(@PolyNull Object b0, @PolyNull Object b1) {
        if (b0 == null || b1 == null) {
            return Nullness.castNonNull(null);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.plus(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("+", b0, b1);
    }

    static byte intToByte(int value) {
        if (value < -128 || value > 127) {
            throw new ArithmeticException("integer overflow: Value " + value + " does not fit in a TINYINT");
        }
        return (byte)value;
    }

    static short intToShort(int value) {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new ArithmeticException("integer overflow: Value " + value + " does not fit in a SMALLINT");
        }
        return (short)value;
    }

    public static byte checkedPlus(byte b0, byte b1) {
        return SqlFunctions.intToByte(b0 + b1);
    }

    public static short checkedPlus(short b0, short b1) {
        return SqlFunctions.intToShort(b0 + b1);
    }

    public static int checkedPlus(int b0, int b1) {
        return Math.addExact(b0, b1);
    }

    public static long checkedPlus(long b0, long b1) {
        return Math.addExact(b0, b1);
    }

    public static int minus(int b0, int b1) {
        return b0 - b1;
    }

    public static @PolyNull Integer minus(@PolyNull Integer b0, int b1) {
        return b0 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 - b1);
    }

    public static @PolyNull Integer minus(int b0, @PolyNull Integer b1) {
        return b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 - b1);
    }

    public static @PolyNull Integer minus(@PolyNull Integer b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 - b1);
    }

    public static @PolyNull Long minus(@PolyNull Long b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0 - b1.longValue());
    }

    public static @PolyNull Long minus(@PolyNull Integer b0, @PolyNull Long b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0.longValue() - b1);
    }

    public static @PolyNull BigDecimal minus(@PolyNull BigDecimal b0, @PolyNull BigDecimal b1) {
        return b0 == null || b1 == null ? (BigDecimal)Nullness.castNonNull(null) : b0.subtract(b1);
    }

    public static @PolyNull Object minusAny(@PolyNull Object b0, @PolyNull Object b1) {
        if (b0 == null || b1 == null) {
            return Nullness.castNonNull(null);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.minus(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("-", b0, b1);
    }

    public static byte checkedMinus(byte b0, byte b1) {
        return SqlFunctions.intToByte(b0 - b1);
    }

    public static short checkedMinus(short b0, short b1) {
        return SqlFunctions.intToShort(b0 - b1);
    }

    public static int checkedMinus(int b0, int b1) {
        return Math.subtractExact(b0, b1);
    }

    public static long checkedMinus(long b0, long b1) {
        return Math.subtractExact(b0, b1);
    }

    public static byte checkedUnaryMinus(byte b) {
        return SqlFunctions.intToByte(-b);
    }

    public static short checkedUnaryMinus(short b) {
        return SqlFunctions.intToShort(-b);
    }

    public static int checkedUnaryMinus(int b) {
        return Math.subtractExact(0, b);
    }

    public static long checkedUnaryMinus(long b) {
        return Math.subtractExact(0L, b);
    }

    public static int divide(int b0, int b1) {
        return b0 / b1;
    }

    public static @PolyNull Integer divide(@PolyNull Integer b0, int b1) {
        return b0 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 / b1);
    }

    public static @PolyNull Integer divide(int b0, @PolyNull Integer b1) {
        return b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 / b1);
    }

    public static @PolyNull Integer divide(@PolyNull Integer b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 / b1);
    }

    public static @PolyNull Long divide(Long b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0 / b1.longValue());
    }

    public static @PolyNull Long divide(@PolyNull Integer b0, @PolyNull Long b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0.longValue() / b1);
    }

    public static @PolyNull BigDecimal divide(@PolyNull BigDecimal b0, @PolyNull BigDecimal b1) {
        return b0 == null || b1 == null ? (BigDecimal)Nullness.castNonNull(null) : b0.divide(b1, MathContext.DECIMAL64);
    }

    public static @PolyNull Object divideAny(@PolyNull Object b0, @PolyNull Object b1) {
        if (b0 == null || b1 == null) {
            return Nullness.castNonNull(null);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.divide(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("/", b0, b1);
    }

    public static int divide(int b0, BigDecimal b1) {
        return BigDecimal.valueOf(b0).divide(b1, RoundingMode.HALF_DOWN).intValue();
    }

    public static long divide(long b0, BigDecimal b1) {
        return BigDecimal.valueOf(b0).divide(b1, RoundingMode.HALF_DOWN).longValue();
    }

    public static byte checkedDivide(byte b0, byte b1) {
        return SqlFunctions.intToByte(b0 / b1);
    }

    public static short checkedDivide(short b0, short b1) {
        return SqlFunctions.intToShort(b0 / b1);
    }

    public static int checkedDivide(int b0, int b1) {
        int q = b0 / b1;
        if ((b0 & b1 & q) >= 0) {
            return q;
        }
        throw new ArithmeticException("integer overflow");
    }

    public static long checkedDivide(long b0, long b1) {
        long q = b0 / b1;
        if ((b0 & b1 & q) >= 0L) {
            return q;
        }
        throw new ArithmeticException("integer overflow");
    }

    public static int multiply(int b0, int b1) {
        return b0 * b1;
    }

    public static @PolyNull Integer multiply(@PolyNull Integer b0, int b1) {
        return b0 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 * b1);
    }

    public static @PolyNull Integer multiply(int b0, @PolyNull Integer b1) {
        return b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 * b1);
    }

    public static @PolyNull Integer multiply(@PolyNull Integer b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 * b1);
    }

    public static @PolyNull Long multiply(@PolyNull Long b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0 * b1.longValue());
    }

    public static @PolyNull Long multiply(@PolyNull Integer b0, @PolyNull Long b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0.longValue() * b1);
    }

    public static @PolyNull BigDecimal multiply(@PolyNull BigDecimal b0, @PolyNull BigDecimal b1) {
        return b0 == null || b1 == null ? (BigDecimal)Nullness.castNonNull(null) : b0.multiply(b1);
    }

    public static @PolyNull Object multiplyAny(@PolyNull Object b0, @PolyNull Object b1) {
        if (b0 == null || b1 == null) {
            return Nullness.castNonNull(null);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.multiply(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("*", b0, b1);
    }

    public static byte checkedMultiply(byte b0, byte b1) {
        return SqlFunctions.intToByte(b0 * b1);
    }

    public static short checkedMultiply(short b0, short b1) {
        return SqlFunctions.intToShort(b0 * b1);
    }

    public static int checkedMultiply(int b0, int b1) {
        return Math.multiplyExact(b0, b1);
    }

    public static long checkedMultiply(long b0, long b1) {
        return Math.multiplyExact(b0, b1);
    }

    public static @Nullable Long safeAdd(long b0, long b1) {
        try {
            return Math.addExact(b0, b1);
        }
        catch (ArithmeticException e) {
            return null;
        }
    }

    public static @Nullable BigDecimal safeAdd(long b0, BigDecimal b1) {
        BigDecimal ans = BigDecimal.valueOf(b0).add(b1);
        return SqlFunctions.safeDecimal(ans) ? ans : null;
    }

    public static @Nullable BigDecimal safeAdd(BigDecimal b0, long b1) {
        return SqlFunctions.safeAdd(b1, b0);
    }

    public static @Nullable BigDecimal safeAdd(BigDecimal b0, BigDecimal b1) {
        BigDecimal ans = b0.add(b1);
        return SqlFunctions.safeDecimal(ans) ? ans : null;
    }

    public static @Nullable Double safeAdd(double b0, long b1) {
        double ans = b0 + (double)b1;
        return SqlFunctions.safeDouble(ans) || !Double.isFinite(b0) ? Double.valueOf(ans) : null;
    }

    public static @Nullable Double safeAdd(long b0, double b1) {
        return SqlFunctions.safeAdd(b1, b0);
    }

    public static @Nullable Double safeAdd(double b0, BigDecimal b1) {
        double ans = b0 + b1.doubleValue();
        return SqlFunctions.safeDouble(ans) || !Double.isFinite(b0) ? Double.valueOf(ans) : null;
    }

    public static @Nullable Double safeAdd(BigDecimal b0, double b1) {
        return SqlFunctions.safeAdd(b1, b0);
    }

    public static @Nullable Double safeAdd(double b0, double b1) {
        double ans = b0 + b1;
        boolean isFinite = Double.isFinite(b0) && Double.isFinite(b1);
        return SqlFunctions.safeDouble(ans) || !isFinite ? Double.valueOf(ans) : null;
    }

    public static @Nullable Double safeDivide(long b0, long b1) {
        double ans = (double)b0 / (double)b1;
        return SqlFunctions.safeDouble(ans) && b1 != 0L ? Double.valueOf(ans) : null;
    }

    public static @Nullable BigDecimal safeDivide(long b0, BigDecimal b1) {
        try {
            BigDecimal ans = BigDecimal.valueOf(b0).divide(b1);
            return SqlFunctions.safeDecimal(ans) ? ans : null;
        }
        catch (ArithmeticException e) {
            return null;
        }
    }

    public static @Nullable BigDecimal safeDivide(BigDecimal b0, long b1) {
        try {
            BigDecimal ans = b0.divide(BigDecimal.valueOf(b1));
            return SqlFunctions.safeDecimal(ans) ? ans : null;
        }
        catch (ArithmeticException e) {
            return null;
        }
    }

    public static @Nullable BigDecimal safeDivide(BigDecimal b0, BigDecimal b1) {
        try {
            BigDecimal ans = b0.divide(b1);
            return SqlFunctions.safeDecimal(ans) ? ans : null;
        }
        catch (ArithmeticException e) {
            return null;
        }
    }

    public static @Nullable Double safeDivide(double b0, long b1) {
        double ans = b0 / (double)b1;
        return SqlFunctions.safeDouble(ans) || !Double.isFinite(b0) ? Double.valueOf(ans) : null;
    }

    public static @Nullable Double safeDivide(long b0, double b1) {
        double ans = (double)b0 / b1;
        return SqlFunctions.safeDouble(ans) || !Double.isFinite(b1) ? Double.valueOf(ans) : null;
    }

    public static @Nullable Double safeDivide(double b0, BigDecimal b1) {
        double ans = b0 / b1.doubleValue();
        return SqlFunctions.safeDouble(ans) || !Double.isFinite(b0) ? Double.valueOf(ans) : null;
    }

    public static @Nullable Double safeDivide(BigDecimal b0, double b1) {
        double ans = b0.doubleValue() / b1;
        return SqlFunctions.safeDouble(ans) || !Double.isFinite(b1) ? Double.valueOf(ans) : null;
    }

    public static @Nullable Double safeDivide(double b0, double b1) {
        double ans = b0 / b1;
        boolean isFinite = Double.isFinite(b0) && Double.isFinite(b1);
        return SqlFunctions.safeDouble(ans) || !isFinite ? Double.valueOf(ans) : null;
    }

    public static @Nullable Long safeMultiply(long b0, long b1) {
        try {
            return Math.multiplyExact(b0, b1);
        }
        catch (ArithmeticException e) {
            return null;
        }
    }

    public static @Nullable BigDecimal safeMultiply(long b0, BigDecimal b1) {
        BigDecimal ans = BigDecimal.valueOf(b0).multiply(b1);
        return SqlFunctions.safeDecimal(ans) ? ans : null;
    }

    public static @Nullable BigDecimal safeMultiply(BigDecimal b0, long b1) {
        return SqlFunctions.safeMultiply(b1, b0);
    }

    public static @Nullable BigDecimal safeMultiply(BigDecimal b0, BigDecimal b1) {
        BigDecimal ans = b0.multiply(b1);
        return SqlFunctions.safeDecimal(ans) ? ans : null;
    }

    public static @Nullable Double safeMultiply(double b0, long b1) {
        double ans = b0 * (double)b1;
        return SqlFunctions.safeDouble(ans) || !Double.isFinite(b0) ? Double.valueOf(ans) : null;
    }

    public static @Nullable Double safeMultiply(long b0, double b1) {
        return SqlFunctions.safeMultiply(b1, b0);
    }

    public static @Nullable Double safeMultiply(double b0, BigDecimal b1) {
        double ans = b0 * b1.doubleValue();
        return SqlFunctions.safeDouble(ans) || !Double.isFinite(b0) ? Double.valueOf(ans) : null;
    }

    public static @Nullable Double safeMultiply(BigDecimal b0, double b1) {
        return SqlFunctions.safeMultiply(b1, b0);
    }

    public static @Nullable Double safeMultiply(double b0, double b1) {
        double ans = b0 * b1;
        boolean isFinite = Double.isFinite(b0) && Double.isFinite(b1);
        return SqlFunctions.safeDouble(ans) || !isFinite ? Double.valueOf(ans) : null;
    }

    public static @Nullable Long safeSubtract(long b0, long b1) {
        try {
            return Math.subtractExact(b0, b1);
        }
        catch (ArithmeticException e) {
            return null;
        }
    }

    public static @Nullable BigDecimal safeSubtract(long b0, BigDecimal b1) {
        BigDecimal ans = BigDecimal.valueOf(b0).subtract(b1);
        return SqlFunctions.safeDecimal(ans) ? ans : null;
    }

    public static @Nullable BigDecimal safeSubtract(BigDecimal b0, long b1) {
        BigDecimal ans = b0.subtract(BigDecimal.valueOf(b1));
        return SqlFunctions.safeDecimal(ans) ? ans : null;
    }

    public static @Nullable BigDecimal safeSubtract(BigDecimal b0, BigDecimal b1) {
        BigDecimal ans = b0.subtract(b1);
        return SqlFunctions.safeDecimal(ans) ? ans : null;
    }

    public static @Nullable Double safeSubtract(double b0, long b1) {
        double ans = b0 - (double)b1;
        return SqlFunctions.safeDouble(ans) || !Double.isFinite(b0) ? Double.valueOf(ans) : null;
    }

    public static @Nullable Double safeSubtract(long b0, double b1) {
        double ans = (double)b0 - b1;
        return SqlFunctions.safeDouble(ans) || !Double.isFinite(b1) ? Double.valueOf(ans) : null;
    }

    public static @Nullable Double safeSubtract(double b0, BigDecimal b1) {
        double ans = b0 - b1.doubleValue();
        return SqlFunctions.safeDouble(ans) || !Double.isFinite(b0) ? Double.valueOf(ans) : null;
    }

    public static @Nullable Double safeSubtract(BigDecimal b0, double b1) {
        double ans = b0.doubleValue() - b1;
        return SqlFunctions.safeDouble(ans) || !Double.isFinite(b1) ? Double.valueOf(ans) : null;
    }

    public static @Nullable Double safeSubtract(double b0, double b1) {
        double ans = b0 - b1;
        boolean isFinite = Double.isFinite(b0) && Double.isFinite(b1);
        return SqlFunctions.safeDouble(ans) || !isFinite ? Double.valueOf(ans) : null;
    }

    private static boolean safeDecimal(BigDecimal b) {
        return b.scale() <= 38 && b.precision() <= 76;
    }

    private static boolean safeDouble(double d) {
        return Math.abs(d) > Double.MIN_VALUE && Math.abs(d) < Double.MAX_VALUE || d == 0.0;
    }

    private static RuntimeException notArithmetic(String op, Object b0, Object b1) {
        return Static.RESOURCE.invalidTypesForArithmetic(b0.getClass().toString(), op, b1.getClass().toString()).ex();
    }

    private static RuntimeException notComparable(String op, Object b0, Object b1) {
        return Static.RESOURCE.invalidTypesForComparison(b0.getClass().toString(), op, b1.getClass().toString()).ex();
    }

    public static long bitAnd(long b0, long b1) {
        return b0 & b1;
    }

    public static long bitAnd(Long b0, int b1) {
        return b0 & (long)b1;
    }

    public static long bitAnd(int b0, Long b1) {
        return (long)b0 & b1;
    }

    public static ByteString bitAnd(ByteString b0, ByteString b1) {
        return SqlFunctions.binaryOperator(b0, b1, (x, y) -> (byte)(x & y));
    }

    public static long bitCount(long b) {
        return Long.bitCount(b);
    }

    public static long bitCount(BigDecimal b) {
        int comparison = b.compareTo(BITCOUNT_MAX);
        if (comparison < 0) {
            if (b.compareTo(BITCOUNT_MIN) <= 0) {
                return 1L;
            }
            return SqlFunctions.bitCount(b.setScale(0, RoundingMode.DOWN).longValue());
        }
        if (comparison == 0) {
            return 64L;
        }
        return 63L;
    }

    public static long bitCount(ByteString b) {
        long bitsSet = 0L;
        for (int i = 0; i < b.length(); ++i) {
            bitsSet += (long)Integer.bitCount(0xFF & b.byteAt(i));
        }
        return bitsSet;
    }

    public static long bitCountMySQL(Boolean b) {
        return Long.bitCount(b != false ? 1L : 0L);
    }

    public static long bitCountMySQL(String b) {
        try {
            return SqlFunctions.bitCount(new BigDecimal(b));
        }
        catch (Exception ignore) {
            return 0L;
        }
    }

    public static long bitCountMySQL(Number b) {
        return SqlFunctions.bitCount(new BigDecimal(b.toString()));
    }

    public static long bitCountMySQL(java.sql.Date b) {
        return SqlFunctions.bitCountMySQL(new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH).format(b));
    }

    public static long bitCountMySQL(Time b) {
        return SqlFunctions.bitCountMySQL(new SimpleDateFormat("HHmmss", Locale.ENGLISH).format(b));
    }

    public static long bitCountMySQL(Timestamp b) {
        return SqlFunctions.bitCountMySQL(new SimpleDateFormat("yyyyMMddHHmmss", Locale.ENGLISH).format(b));
    }

    public static long bitOr(long b0, long b1) {
        return b0 | b1;
    }

    public static long bitOr(Long b0, int b1) {
        return b0 | (long)b1;
    }

    public static long bitOr(int b0, Long b1) {
        return (long)b0 | b1;
    }

    public static ByteString bitOr(ByteString b0, ByteString b1) {
        return SqlFunctions.binaryOperator(b0, b1, (x, y) -> (byte)(x | y));
    }

    public static long bitXor(long b0, long b1) {
        return b0 ^ b1;
    }

    public static long bitXor(Long b0, int b1) {
        return b0 ^ (long)b1;
    }

    public static long bitXor(int b0, Long b1) {
        return (long)b0 ^ b1;
    }

    public static ByteString bitXor(ByteString b0, ByteString b1) {
        return SqlFunctions.binaryOperator(b0, b1, (x, y) -> (byte)(x ^ y));
    }

    public static long bitNot(long b) {
        return b ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static ByteString bitNot(ByteString b) {
        byte[] result = new byte[b.length()];
        for (int i = 0; i < b.length(); ++i) {
            result[i] = ~b.byteAt(i);
        }
        return new ByteString(result);
    }

    private static ByteString binaryOperator(ByteString b0, ByteString b1, BinaryOperator<Byte> bitOp) {
        if (b0.length() == 0) {
            return b1;
        }
        if (b1.length() == 0) {
            return b0;
        }
        if (b0.length() != b1.length()) {
            throw Static.RESOURCE.differentLengthForBitwiseOperands(b0.length(), b1.length()).ex();
        }
        byte[] result = new byte[b0.length()];
        for (int i = 0; i < b0.length(); ++i) {
            result[i] = (Byte)bitOp.apply(b0.byteAt(i), b1.byteAt(i));
        }
        return new ByteString(result);
    }

    public static double exp(double b0) {
        return Math.exp(b0);
    }

    public static double exp(BigDecimal b0) {
        return Math.exp(b0.doubleValue());
    }

    public static double power(double b0, double b1) {
        return Math.pow(b0, b1);
    }

    public static double power(double b0, BigDecimal b1) {
        return Math.pow(b0, b1.doubleValue());
    }

    public static double power(BigDecimal b0, double b1) {
        return Math.pow(b0.doubleValue(), b1);
    }

    public static double power(BigDecimal b0, BigDecimal b1) {
        return Math.pow(b0.doubleValue(), b1.doubleValue());
    }

    public static @Nullable Double log(double number, double base, boolean nonPositiveIsNull) {
        if (nonPositiveIsNull && number <= 0.0) {
            return null;
        }
        if (number <= 0.0 || base <= 0.0) {
            throw new IllegalArgumentException("Cannot take logarithm of zero or negative number");
        }
        return Math.log(number) / Math.log(base);
    }

    public static @Nullable Double log(double number, BigDecimal base, boolean nonPositiveIsNull) {
        if (nonPositiveIsNull && number <= 0.0) {
            return null;
        }
        if (number <= 0.0 || base.doubleValue() <= 0.0) {
            throw new IllegalArgumentException("Cannot take logarithm of zero or negative number");
        }
        return Math.log(number) / Math.log(base.doubleValue());
    }

    public static @Nullable Double log(BigDecimal number, double base, Boolean nonPositiveIsNull) {
        if (nonPositiveIsNull.booleanValue() && number.doubleValue() <= 0.0) {
            return null;
        }
        if (number.doubleValue() <= 0.0 || base <= 0.0) {
            throw new IllegalArgumentException("Cannot take logarithm of zero or negative number");
        }
        return Math.log(number.doubleValue()) / Math.log(base);
    }

    public static @Nullable Double log(BigDecimal number, BigDecimal base, Boolean nonPositiveIsNull) {
        if (nonPositiveIsNull.booleanValue() && number.doubleValue() <= 0.0) {
            return null;
        }
        if (number.doubleValue() <= 0.0 || base.doubleValue() <= 0.0) {
            throw new IllegalArgumentException("Cannot take logarithm of zero or negative number");
        }
        return Math.log(number.doubleValue()) / Math.log(base.doubleValue());
    }

    public static @Nullable Double log1p(double b0) {
        return b0 <= -1.0 ? null : Double.valueOf(Math.log1p(b0));
    }

    public static @Nullable Double log1p(BigDecimal b0) {
        return b0.doubleValue() <= -1.0 ? null : Double.valueOf(Math.log1p(b0.doubleValue()));
    }

    public static byte mod(byte b0, byte b1) {
        return (byte)(b0 % b1);
    }

    public static short mod(short b0, short b1) {
        return (short)(b0 % b1);
    }

    public static int mod(int b0, int b1) {
        return b0 % b1;
    }

    public static long mod(long b0, long b1) {
        return b0 % b1;
    }

    public static BigDecimal mod(BigDecimal b0, int b1) {
        return SqlFunctions.mod(b0, BigDecimal.valueOf(b1));
    }

    public static BigDecimal mod(int b0, BigDecimal b1) {
        return SqlFunctions.mod(BigDecimal.valueOf(b0), b1);
    }

    public static BigDecimal mod(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        return bigDecimals[1];
    }

    public static double floor(double b0) {
        return Math.floor(b0);
    }

    public static float floor(float b0) {
        return (float)Math.floor(b0);
    }

    public static BigDecimal floor(BigDecimal b0) {
        return b0.setScale(0, RoundingMode.FLOOR);
    }

    public static byte floor(byte b0, byte b1) {
        return (byte)SqlFunctions.floor((int)b0, (int)b1);
    }

    public static short floor(short b0, short b1) {
        return (short)SqlFunctions.floor((int)b0, (int)b1);
    }

    public static int floor(int b0, int b1) {
        int r = b0 % b1;
        if (r < 0) {
            r += b1;
        }
        return b0 - r;
    }

    public static long floor(long b0, long b1) {
        long r = b0 % b1;
        if (r < 0L) {
            r += b1;
        }
        return b0 - r;
    }

    public static BigDecimal floor(BigDecimal b0, int b1) {
        return SqlFunctions.floor(b0, BigDecimal.valueOf(b1));
    }

    public static int floor(int b0, BigDecimal b1) {
        return SqlFunctions.floor(b0, b1.intValue());
    }

    public static BigDecimal floor(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        BigDecimal r = bigDecimals[1];
        if (r.signum() < 0) {
            r = r.add(b1);
        }
        return b0.subtract(r);
    }

    public static double ceil(double b0) {
        return Math.ceil(b0);
    }

    public static float ceil(float b0) {
        return (float)Math.ceil(b0);
    }

    public static BigDecimal ceil(BigDecimal b0) {
        return b0.setScale(0, RoundingMode.CEILING);
    }

    public static byte ceil(byte b0, byte b1) {
        return SqlFunctions.floor((byte)(b0 + b1 - 1), b1);
    }

    public static short ceil(short b0, short b1) {
        return SqlFunctions.floor((short)(b0 + b1 - 1), b1);
    }

    public static int ceil(int b0, int b1) {
        int r = b0 % b1;
        if (r > 0) {
            r -= b1;
        }
        return b0 - r;
    }

    public static long ceil(long b0, long b1) {
        return SqlFunctions.floor(b0 + b1 - 1L, b1);
    }

    public static BigDecimal ceil(BigDecimal b0, int b1) {
        return SqlFunctions.ceil(b0, BigDecimal.valueOf(b1));
    }

    public static int ceil(int b0, BigDecimal b1) {
        return SqlFunctions.ceil(b0, b1.intValue());
    }

    public static BigDecimal ceil(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        BigDecimal r = bigDecimals[1];
        if (r.signum() > 0) {
            r = r.subtract(b1);
        }
        return b0.subtract(r);
    }

    public static byte abs(byte b0) {
        return (byte)Math.abs(b0);
    }

    public static short abs(short b0) {
        return (short)Math.abs(b0);
    }

    public static int abs(int b0) {
        return Math.abs(b0);
    }

    public static long abs(long b0) {
        return Math.abs(b0);
    }

    public static float abs(float b0) {
        return Math.abs(b0);
    }

    public static double abs(double b0) {
        return Math.abs(b0);
    }

    public static BigDecimal abs(BigDecimal b0) {
        return b0.abs();
    }

    public static double acos(BigDecimal b0) {
        return Math.acos(b0.doubleValue());
    }

    public static double acos(double b0) {
        return Math.acos(b0);
    }

    public static double acosd(BigDecimal b0) {
        return SqlFunctions.acosd(b0.doubleValue());
    }

    public static double acosd(double b0) {
        if (b0 < -1.0 || b0 > 1.0) {
            throw new IllegalArgumentException("input is out of range");
        }
        return Math.toDegrees(Math.acos(b0));
    }

    public static double acosh(BigDecimal b0) {
        return SqlFunctions.acosh(b0.doubleValue());
    }

    public static double acosh(double b0) {
        if (b0 < 1.0) {
            throw new IllegalArgumentException("Input parameter of acosh cannot be less than 1!");
        }
        return Math.log(Math.sqrt(b0 * b0 - 1.0) + b0);
    }

    public static double asin(BigDecimal b0) {
        return Math.asin(b0.doubleValue());
    }

    public static double asin(double b0) {
        return Math.asin(b0);
    }

    public static double asind(BigDecimal b0) {
        return SqlFunctions.asind(b0.doubleValue());
    }

    public static double asind(double b0) {
        if (b0 < -1.0 || b0 > 1.0) {
            throw new IllegalArgumentException("input is out of range");
        }
        return Math.toDegrees(Math.asin(b0));
    }

    public static double asinh(BigDecimal b0) {
        return SqlFunctions.asinh(b0.doubleValue());
    }

    public static double asinh(double b0) {
        double sign;
        if (Double.doubleToRawLongBits(b0) < 0L) {
            b0 = Math.abs(b0);
            sign = -1.0;
        } else {
            sign = 1.0;
        }
        return sign * Math.log(Math.sqrt(b0 * b0 + 1.0) + b0);
    }

    public static double atan(BigDecimal b0) {
        return Math.atan(b0.doubleValue());
    }

    public static double atan(double b0) {
        return Math.atan(b0);
    }

    public static double atand(BigDecimal b0) {
        return SqlFunctions.atand(b0.doubleValue());
    }

    public static double atand(double b0) {
        if (Double.isNaN(b0)) {
            return Double.NaN;
        }
        return Math.toDegrees(Math.atan(b0));
    }

    public static double atan2(double b0, BigDecimal b1) {
        return Math.atan2(b0, b1.doubleValue());
    }

    public static double atan2(BigDecimal b0, double b1) {
        return Math.atan2(b0.doubleValue(), b1);
    }

    public static double atan2(BigDecimal b0, BigDecimal b1) {
        return Math.atan2(b0.doubleValue(), b1.doubleValue());
    }

    public static double atan2(double b0, double b1) {
        return Math.atan2(b0, b1);
    }

    public static double atanh(BigDecimal b) {
        return SqlFunctions.atanh(b.doubleValue());
    }

    public static double atanh(double b) {
        double mult;
        if (Math.abs(b) >= 1.0) {
            throw Static.RESOURCE.inputArgumentsOfFunctionOutOfRange("ATANH", b, "(-1, 1)").ex();
        }
        if (Double.doubleToRawLongBits(b) < 0L) {
            b = Math.abs(b);
            mult = -0.5;
        } else {
            mult = 0.5;
        }
        return mult * Math.log((1.0 + b) / (1.0 - b));
    }

    public static double cbrt(BigDecimal b) {
        return SqlFunctions.cbrt(b.doubleValue());
    }

    public static double cbrt(double b) {
        return Math.cbrt(b);
    }

    public static double cos(BigDecimal b0) {
        return Math.cos(b0.doubleValue());
    }

    public static double cos(double b0) {
        return Math.cos(b0);
    }

    public static double cosd(BigDecimal b0) {
        return SqlFunctions.cosd(b0.doubleValue());
    }

    public static double cosd(double b0) {
        if (Double.isInfinite(b0)) {
            throw new IllegalArgumentException("input is out of range");
        }
        return Math.cos(Math.toRadians(b0));
    }

    public static double cosh(BigDecimal b) {
        return SqlFunctions.cosh(b.doubleValue());
    }

    public static double cosh(double b) {
        return Math.cosh(b);
    }

    public static double cot(BigDecimal b0) {
        return 1.0 / Math.tan(b0.doubleValue());
    }

    public static double cot(double b0) {
        return 1.0 / Math.tan(b0);
    }

    public static double coth(BigDecimal b0) {
        return 1.0 / Math.tanh(b0.doubleValue());
    }

    public static double coth(double b0) {
        return 1.0 / Math.tanh(b0);
    }

    public static double csch(BigDecimal b0) {
        return 1.0 / Math.sinh(b0.doubleValue());
    }

    public static double csch(double b0) {
        return 1.0 / Math.sinh(b0);
    }

    public static double degrees(BigDecimal b0) {
        return Math.toDegrees(b0.doubleValue());
    }

    public static double degrees(double b0) {
        return Math.toDegrees(b0);
    }

    public static @Nullable Long factorial(int b0) {
        if (b0 < 0 || b0 > 20) {
            return null;
        }
        return CombinatoricsUtils.factorial((int)b0);
    }

    public static boolean isInf(BigDecimal b0) {
        return Double.isInfinite(b0.doubleValue());
    }

    public static boolean isInf(double b0) {
        return Double.isInfinite(b0);
    }

    public static boolean isInf(float b0) {
        return Float.isInfinite(b0);
    }

    public static boolean isNaN(BigDecimal b0) {
        return Double.isNaN(b0.doubleValue());
    }

    public static boolean isNaN(double b0) {
        return Double.isNaN(b0);
    }

    public static boolean isNaN(float b0) {
        return Float.isNaN(b0);
    }

    public static double radians(BigDecimal b0) {
        return Math.toRadians(b0.doubleValue());
    }

    public static double radians(double b0) {
        return Math.toRadians(b0);
    }

    public static double sech(BigDecimal b0) {
        return 1.0 / Math.cosh(b0.doubleValue());
    }

    public static double sech(double b0) {
        return 1.0 / Math.cosh(b0);
    }

    public static int sround(int b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static int sround(int b0, int b1) {
        return SqlFunctions.sround(BigDecimal.valueOf(b0), b1).intValue();
    }

    public static long sround(long b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static long sround(long b0, int b1) {
        return SqlFunctions.sround(BigDecimal.valueOf(b0), b1).longValue();
    }

    public static BigDecimal sround(BigDecimal b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static BigDecimal sround(BigDecimal b0, int b1) {
        return b0.movePointRight(b1).setScale(0, RoundingMode.HALF_UP).movePointLeft(b1);
    }

    public static double sround(double b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static double sround(double b0, int b1) {
        return SqlFunctions.sround(BigDecimal.valueOf(b0), b1).doubleValue();
    }

    public static int struncate(int b0) {
        return SqlFunctions.struncate(b0, 0);
    }

    public static int struncate(int b0, int b1) {
        return SqlFunctions.struncate(BigDecimal.valueOf(b0), b1).intValue();
    }

    public static long struncate(long b0) {
        return SqlFunctions.struncate(b0, 0);
    }

    public static long struncate(long b0, int b1) {
        return SqlFunctions.struncate(BigDecimal.valueOf(b0), b1).longValue();
    }

    public static BigDecimal struncate(BigDecimal b0) {
        return SqlFunctions.struncate(b0, 0);
    }

    public static BigDecimal struncate(BigDecimal b0, int b1) {
        return b0.movePointRight(b1).setScale(0, RoundingMode.DOWN).movePointLeft(b1);
    }

    public static double struncate(double b0) {
        return SqlFunctions.struncate(b0, 0);
    }

    public static double struncate(double b0, int b1) {
        return SqlFunctions.struncate(BigDecimal.valueOf(b0), b1).doubleValue();
    }

    public static int sign(int b0) {
        return Integer.signum(b0);
    }

    public static long sign(long b0) {
        return Long.signum(b0);
    }

    public static BigDecimal sign(BigDecimal b0) {
        return BigDecimal.valueOf(b0.signum());
    }

    public static double sign(double b0) {
        return Math.signum(b0);
    }

    public static double sin(BigDecimal b0) {
        return Math.sin(b0.doubleValue());
    }

    public static double sin(double b0) {
        return Math.sin(b0);
    }

    public static double sind(BigDecimal b0) {
        return SqlFunctions.sind(b0.doubleValue());
    }

    public static double sind(double b0) {
        if (Double.isInfinite(b0)) {
            throw new IllegalArgumentException("input is out of range");
        }
        return Math.sin(Math.toRadians(b0));
    }

    public static double sinh(BigDecimal b) {
        return SqlFunctions.sinh(b.doubleValue());
    }

    public static double sinh(double b) {
        return Math.sinh(b);
    }

    public static double tan(BigDecimal b0) {
        return Math.tan(b0.doubleValue());
    }

    public static double tan(double b0) {
        return Math.tan(b0);
    }

    public static double tand(BigDecimal b0) {
        return SqlFunctions.tand(b0.doubleValue());
    }

    public static double tand(double b0) {
        if (Double.isInfinite(b0)) {
            throw new IllegalArgumentException("input is out of range");
        }
        return Math.tan(Math.toRadians(b0));
    }

    public static double tanh(BigDecimal b) {
        return SqlFunctions.tanh(b.doubleValue());
    }

    public static double tanh(double b) {
        return Math.tanh(b);
    }

    public static double csc(BigDecimal b0) {
        return 1.0 / Math.sin(b0.doubleValue());
    }

    public static double csc(double b0) {
        return 1.0 / Math.sin(b0);
    }

    public static double sec(BigDecimal b0) {
        return 1.0 / Math.cos(b0.doubleValue());
    }

    public static double sec(double b0) {
        return 1.0 / Math.cos(b0);
    }

    public static <T extends Comparable<T>> @Nullable T lesser(@Nullable T b0, @Nullable T b1) {
        if (b0 == null) {
            return b1;
        }
        if (b1 == null) {
            return b0;
        }
        return b0.compareTo(b1) > 0 ? b1 : b0;
    }

    public static <T extends Comparable<T>> @Nullable T least(@Nullable T b0, @Nullable T b1) {
        return b0 == null || b1 != null && b0.compareTo(b1) > 0 ? b1 : b0;
    }

    public static boolean greater(boolean b0, boolean b1) {
        return b0 || b1;
    }

    public static boolean lesser(boolean b0, boolean b1) {
        return b0 && b1;
    }

    public static byte greater(byte b0, byte b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static byte lesser(byte b0, byte b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static char greater(char b0, char b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static char lesser(char b0, char b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static short greater(short b0, short b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static short lesser(short b0, short b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static int greater(int b0, int b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static int lesser(int b0, int b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static long greater(long b0, long b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static long lesser(long b0, long b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static float greater(float b0, float b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static float lesser(float b0, float b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static double greater(double b0, double b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static double lesser(double b0, double b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static <T extends Comparable<T>> @Nullable List<T> lesser(@Nullable List<T> b0, @Nullable List<T> b1) {
        if (b0 == null) {
            return b1;
        }
        if (b1 == null) {
            return b0;
        }
        return SqlFunctions.lt(b0, b1) ? b0 : b1;
    }

    public static <T extends Comparable<T>> @Nullable List<T> greater(@Nullable List<T> b0, @Nullable List<T> b1) {
        if (b0 == null) {
            return b1;
        }
        if (b1 == null) {
            return b0;
        }
        return SqlFunctions.gt(b0, b1) ? b0 : b1;
    }

    public static <T extends Comparable<T>> @Nullable T greater(@Nullable T b0, @Nullable T b1) {
        if (b0 == null) {
            return b1;
        }
        if (b1 == null) {
            return b0;
        }
        return b0.compareTo(b1) < 0 ? b1 : b0;
    }

    public static <T extends Comparable<T>> @Nullable T greatest(@Nullable T b0, @Nullable T b1) {
        return b0 == null || b1 != null && b0.compareTo(b1) < 0 ? b1 : b0;
    }

    public static String toString(float x) {
        if (x == 0.0f) {
            return "0E0";
        }
        return Float.toString(x);
    }

    public static String toString(double x) {
        if (x == 0.0) {
            return "0E0";
        }
        return Double.toString(x);
    }

    public static String toString(BigDecimal x) {
        String s = x.toString();
        if (s.equals("0")) {
            return s;
        }
        if (s.startsWith("0.")) {
            return s.substring(1);
        }
        if (s.startsWith("-0.")) {
            return "-" + s.substring(2);
        }
        return s;
    }

    public static String toString(boolean x) {
        return x ? "TRUE" : "FALSE";
    }

    @NonDeterministic
    private static Object cannotConvert(Object o, Class toType) {
        throw Static.RESOURCE.cannotConvert(String.valueOf(o), toType.toString()).ex();
    }

    public static boolean toBoolean(String s) {
        if ((s = SqlFunctions.trim(true, true, " ", s)).equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (s.equalsIgnoreCase("FALSE")) {
            return false;
        }
        throw Static.RESOURCE.invalidCharacterForCast(s).ex();
    }

    public static boolean toBoolean(Number number) {
        return !number.equals(0);
    }

    public static boolean toBoolean(Object o) {
        return o instanceof Boolean ? (Boolean)o : (o instanceof Number ? SqlFunctions.toBoolean((Number)o) : (o instanceof String ? SqlFunctions.toBoolean((String)o) : (Boolean)SqlFunctions.cannotConvert(o, Boolean.TYPE)));
    }

    public static byte toByte(Object o) {
        return o instanceof Byte ? (Byte)o : (o instanceof Number ? SqlFunctions.toByte((Number)o) : Byte.parseByte(o.toString()));
    }

    public static byte toByte(Number number) {
        return number.byteValue();
    }

    public static char toChar(String s) {
        return s.charAt(0);
    }

    public static Character toCharBoxed(String s) {
        return Character.valueOf(s.charAt(0));
    }

    public static short toShort(String s) {
        return Short.parseShort(s.trim());
    }

    public static short toShort(Number number) {
        return number.shortValue();
    }

    public static short toShort(Object o) {
        return o instanceof Short ? (Short)o : (o instanceof Number ? SqlFunctions.toShort((Number)o) : (o instanceof String ? SqlFunctions.toShort((String)o) : (Short)SqlFunctions.cannotConvert(o, Short.TYPE)));
    }

    public static int toInt(java.sql.Date v) {
        return SqlFunctions.toInt(v, LOCAL_TZ);
    }

    public static int toInt(java.sql.Date v, TimeZone timeZone) {
        return DateTimeUtils.sqlDateToUnixDate((java.sql.Date)v, (TimeZone)timeZone);
    }

    public static @PolyNull Integer toIntOptional(@PolyNull java.sql.Date v) {
        return v == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(SqlFunctions.toInt(v));
    }

    public static @PolyNull Integer toIntOptional(@PolyNull java.sql.Date v, TimeZone timeZone) {
        return v == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(SqlFunctions.toInt(v, timeZone));
    }

    public static int toInt(Time v) {
        return DateTimeUtils.sqlTimeToUnixTime((Time)v, (TimeZone)LOCAL_TZ);
    }

    public static @PolyNull Integer toIntOptional(@PolyNull Time v) {
        return v == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(SqlFunctions.toInt(v));
    }

    @NonDeterministic
    public static int toInt(String s) {
        return Integer.parseInt(s.trim());
    }

    public static int toInt(Number number) {
        return number.intValue();
    }

    public static int toInt(Object o) {
        return o instanceof Integer ? (Integer)o : (o instanceof Number ? SqlFunctions.toInt((Number)o) : (o instanceof String ? SqlFunctions.toInt((String)o) : (o instanceof java.sql.Date ? SqlFunctions.toInt((java.sql.Date)o) : (o instanceof Time ? SqlFunctions.toInt((Time)o) : (Integer)SqlFunctions.cannotConvert(o, Integer.TYPE)))));
    }

    public static @PolyNull Integer toIntOptional(@PolyNull Object o) {
        return o == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(SqlFunctions.toInt(o));
    }

    public static long toLong(Date v) {
        return DateTimeUtils.utilDateToUnixTimestamp((Date)v, (TimeZone)LOCAL_TZ);
    }

    public static long toLong(Timestamp v) {
        return SqlFunctions.toLong(v, LOCAL_TZ);
    }

    public static long toLong(Timestamp v, TimeZone timeZone) {
        return DateTimeUtils.sqlTimestampToUnixTimestamp((Timestamp)v, (TimeZone)timeZone);
    }

    public static @PolyNull Long toLongOptional(@PolyNull Timestamp v) {
        return v == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(SqlFunctions.toLong(v, LOCAL_TZ));
    }

    public static @PolyNull Long toLongOptional(@PolyNull Timestamp v, TimeZone timeZone) {
        if (v == null) {
            return (Long)Nullness.castNonNull(null);
        }
        return SqlFunctions.toLong(v, timeZone);
    }

    public static long toLong(String s) {
        if (s.startsWith("199") && s.contains(":")) {
            return Timestamp.valueOf(s).getTime();
        }
        return Long.parseLong(s.trim());
    }

    public static long toLong(Number number) {
        return number.longValue();
    }

    public static long toLong(Object o) {
        return o instanceof Long ? (Long)o : (o instanceof Number ? SqlFunctions.toLong((Number)o) : (o instanceof String ? SqlFunctions.toLong((String)o) : (o instanceof java.sql.Date ? (long)SqlFunctions.toInt((java.sql.Date)o) : (o instanceof Time ? (long)SqlFunctions.toInt((Time)o) : (o instanceof Timestamp ? SqlFunctions.toLong((Timestamp)o) : (o instanceof Date ? SqlFunctions.toLong((Date)o) : (Long)SqlFunctions.cannotConvert(o, Long.TYPE)))))));
    }

    public static @PolyNull Long toLongOptional(@PolyNull Object o) {
        return o == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(SqlFunctions.toLong(o));
    }

    public static float toFloat(String s) {
        return Float.parseFloat(s.trim());
    }

    public static float toFloat(Number number) {
        return number.floatValue();
    }

    public static float toFloat(Object o) {
        return o instanceof Float ? ((Float)o).floatValue() : (o instanceof Number ? SqlFunctions.toFloat((Number)o) : (o instanceof String ? SqlFunctions.toFloat((String)o) : ((Float)SqlFunctions.cannotConvert(o, Float.TYPE)).floatValue()));
    }

    public static double toDouble(String s) {
        return Double.parseDouble(s.trim());
    }

    public static double toDouble(Number number) {
        return number.doubleValue();
    }

    public static double toDouble(Object o) {
        return o instanceof Double ? (Double)o : (o instanceof Number ? SqlFunctions.toDouble((Number)o) : (o instanceof String ? SqlFunctions.toDouble((String)o) : (Double)SqlFunctions.cannotConvert(o, Double.TYPE)));
    }

    public static BigDecimal toBigDecimal(String s) {
        return new BigDecimal(s.trim());
    }

    public static BigDecimal toBigDecimal(Number number) {
        return number instanceof BigDecimal ? (BigDecimal)number : (number instanceof BigInteger ? new BigDecimal((BigInteger)number) : (number instanceof Long ? new BigDecimal(number.longValue()) : new BigDecimal(number.doubleValue())));
    }

    public static BigDecimal toBigDecimal(Object o) {
        return o instanceof Number ? SqlFunctions.toBigDecimal((Number)o) : SqlFunctions.toBigDecimal(o.toString());
    }

    public static java.sql.Date internalToDate(int v) {
        LocalDate date = LocalDate.ofEpochDay(v);
        return java.sql.Date.valueOf(date);
    }

    public static @PolyNull java.sql.Date internalToDate(@PolyNull Integer v) {
        return v == null ? (java.sql.Date)Nullness.castNonNull(null) : SqlFunctions.internalToDate((int)v);
    }

    public static Time internalToTime(int v) {
        return new Time(v - LOCAL_TZ.getOffset(v));
    }

    public static @PolyNull Time internalToTime(@PolyNull Integer v) {
        return v == null ? (Time)Nullness.castNonNull(null) : SqlFunctions.internalToTime((int)v);
    }

    public static @PolyNull Integer toTimeWithLocalTimeZone(@PolyNull String v) {
        if (v == null) {
            return (Integer)Nullness.castNonNull(null);
        }
        return new TimeWithTimeZoneString(v).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimeString().getMillisOfDay();
    }

    public static @PolyNull Integer toTimeWithLocalTimeZone(@PolyNull String v, TimeZone timeZone) {
        if (v == null) {
            return (Integer)Nullness.castNonNull(null);
        }
        return new TimeWithTimeZoneString(v + " " + timeZone.getID()).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimeString().getMillisOfDay();
    }

    public static int timeWithLocalTimeZoneToTime(int v, TimeZone timeZone) {
        return TimeWithTimeZoneString.fromMillisOfDay(v).withTimeZone(timeZone).getLocalTimeString().getMillisOfDay();
    }

    public static long timeWithLocalTimeZoneToTimestamp(String date, int v, TimeZone timeZone) {
        TimeWithTimeZoneString tTZ = TimeWithTimeZoneString.fromMillisOfDay(v).withTimeZone(DateTimeUtils.UTC_ZONE);
        return new TimestampWithTimeZoneString(date + " " + tTZ).withTimeZone(timeZone).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static long timeWithLocalTimeZoneToTimestampWithLocalTimeZone(String date, int v) {
        TimeWithTimeZoneString tTZ = TimeWithTimeZoneString.fromMillisOfDay(v).withTimeZone(DateTimeUtils.UTC_ZONE);
        return new TimestampWithTimeZoneString(date + " " + tTZ).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static String timeWithLocalTimeZoneToString(int v, TimeZone timeZone) {
        return TimeWithTimeZoneString.fromMillisOfDay(v).withTimeZone(timeZone).toString();
    }

    public static long unixDateExtract(TimeUnitRange range, long date) {
        return DateTimeUtils.unixDateExtract((TimeUnitRange)range, (long)date);
    }

    public static long unixDateExtract(String rangeString, long date) {
        TimeUnitRange timeUnitRange = TimeUnitRange.of((TimeUnit)SqlIntervalQualifier.stringToDatePartTimeUnit(rangeString), null);
        return DateTimeUtils.unixDateExtract((TimeUnitRange)timeUnitRange, (long)date);
    }

    public static Timestamp internalToTimestamp(long v) {
        LocalDateTime dateTime = LocalDateTime.ofEpochSecond(Math.floorDiv(v, 1000L), (int)(Math.floorMod(v, 1000L) * 1000000L), ZoneOffset.UTC);
        return Timestamp.valueOf(dateTime);
    }

    public static @PolyNull Timestamp internalToTimestamp(@PolyNull Long v) {
        return v == null ? (Timestamp)Nullness.castNonNull(null) : SqlFunctions.internalToTimestamp((long)v);
    }

    public static int timestampWithLocalTimeZoneToDate(long v, TimeZone timeZone) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).withTimeZone(timeZone).getLocalDateString().getDaysSinceEpoch();
    }

    public static int timestampWithLocalTimeZoneToTime(long v, TimeZone timeZone) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).withTimeZone(timeZone).getLocalTimeString().getMillisOfDay();
    }

    public static long timestampWithLocalTimeZoneToTimestamp(long v, TimeZone timeZone) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).withTimeZone(timeZone).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static String timestampWithLocalTimeZoneToString(long v, TimeZone timeZone) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).withTimeZone(timeZone).toString();
    }

    public static int timestampWithLocalTimeZoneToTimeWithLocalTimeZone(long v) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).getLocalTimeString().getMillisOfDay();
    }

    public static long timestampSeconds(long v) {
        return v * 1000L;
    }

    public static long timestampMillis(long v) {
        return v;
    }

    public static long timestampMicros(long v) {
        return v / 1000L;
    }

    public static long unixSeconds(long v) {
        return v / 1000L;
    }

    public static long unixMillis(long v) {
        return v;
    }

    public static long unixMicros(long v) {
        return v * 1000L;
    }

    public static int dateFromUnixDate(int v) {
        return v;
    }

    public static int unixDate(int v) {
        return v;
    }

    public static int date(int year, int month, int day) {
        return (int)LocalDate.of(year, month, day).toEpochDay();
    }

    public static int date(long timestampMillis) {
        return (int)(timestampMillis / 86400000L);
    }

    public static int date(long timestampMillis, String timeZone) {
        return (int)OffsetDateTime.ofInstant(Instant.ofEpochMilli(timestampMillis), ZoneId.of(timeZone)).toLocalDate().toEpochDay();
    }

    public static long datetime(int year, int month, int day, int hour, int minute, int second) {
        return LocalDateTime.of(year, month, day, hour, minute, second).toEpochSecond(ZoneOffset.UTC) * 1000L;
    }

    public static long datetime(int daysSinceEpoch) {
        return (long)daysSinceEpoch * 86400000L;
    }

    public static long datetime(int daysSinceEpoch, int millisSinceMidnight) {
        return (long)daysSinceEpoch * 86400000L + (long)millisSinceMidnight;
    }

    public static long datetime(long millisSinceEpoch) {
        return millisSinceEpoch;
    }

    public static long datetime(long millisSinceEpoch, String timeZone) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(millisSinceEpoch), ZoneId.of(timeZone)).atZoneSimilarLocal(ZoneId.of("UTC")).toInstant().toEpochMilli();
    }

    public static long timestamp(String expression) {
        return SqlFunctions.parseBigQueryTimestampLiteral(expression).toInstant().toEpochMilli();
    }

    public static long timestamp(String expression, String timeZone) {
        return SqlFunctions.parseBigQueryTimestampLiteral(expression).atZoneSimilarLocal(ZoneId.of(timeZone)).toInstant().toEpochMilli();
    }

    private static OffsetDateTime parseBigQueryTimestampLiteral(String expression) {
        try {
            return OffsetDateTime.parse(expression, BIG_QUERY_TIMESTAMP_LITERAL_FORMATTER);
        }
        catch (DateTimeParseException dateTimeParseException) {
            if (IS_JDK_8 && expression.matches(".*[+-][0-9][0-9]$")) {
                try {
                    expression = expression + ":00";
                    return OffsetDateTime.parse(expression, BIG_QUERY_TIMESTAMP_LITERAL_FORMATTER);
                }
                catch (DateTimeParseException dateTimeParseException2) {
                    // empty catch block
                }
            }
            try {
                return LocalDateTime.parse(expression, BIG_QUERY_TIMESTAMP_LITERAL_FORMATTER).atOffset(ZoneOffset.UTC);
            }
            catch (DateTimeParseException e2) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Could not parse BigQuery timestamp literal: %s", expression), e2);
            }
        }
    }

    public static long timestamp(int days) {
        return (long)days * 86400000L;
    }

    public static long timestamp(int days, String timeZone) {
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.ofEpochDay(days), LocalTime.MIDNIGHT);
        ZoneOffset zoneOffset = ZoneId.of(timeZone).getRules().getOffset(localDateTime);
        return OffsetDateTime.of(localDateTime, zoneOffset).toInstant().toEpochMilli();
    }

    public static long timestamp(long millisSinceEpoch) {
        return millisSinceEpoch;
    }

    public static long timestamp(long millisSinceEpoch, String timeZone) {
        Instant instant = Instant.ofEpochMilli(millisSinceEpoch);
        ZoneId utcZone = ZoneId.of("UTC");
        return OffsetDateTime.ofInstant(instant, utcZone).atZoneSimilarLocal(ZoneId.of(timeZone)).toInstant().toEpochMilli();
    }

    public static int time(int hour, int minute, int second) {
        return (int)((long)LocalTime.of(hour, minute, second).toSecondOfDay() * 1000L);
    }

    public static int time(long timestampMillis) {
        return (int)(timestampMillis % 86400000L);
    }

    public static int time(long timestampMillis, String timeZone) {
        Instant instant = Instant.ofEpochMilli(timestampMillis);
        ZoneId zoneId = ZoneId.of(timeZone);
        return (int)(OffsetDateTime.ofInstant(instant, zoneId).toLocalTime().toNanoOfDay() / 1000000L);
    }

    public static @PolyNull Long toTimestampWithLocalTimeZone(@PolyNull String v) {
        if (v == null) {
            return (Long)Nullness.castNonNull(null);
        }
        return new TimestampWithTimeZoneString(v).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static @PolyNull Long toTimestampWithLocalTimeZone(@PolyNull String v, TimeZone timeZone) {
        if (v == null) {
            return (Long)Nullness.castNonNull(null);
        }
        return new TimestampWithTimeZoneString(v + " " + timeZone.getID()).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static @PolyNull String truncate(@PolyNull String s, int maxLength) {
        if (s == null) {
            return s;
        }
        if (s.length() > maxLength) {
            return s.substring(0, maxLength);
        }
        return s;
    }

    public static @PolyNull String truncateOrPad(@PolyNull String s, int maxLength) {
        if (s == null) {
            return s;
        }
        int length = s.length();
        if (length > maxLength) {
            return s.substring(0, maxLength);
        }
        return length < maxLength ? Spaces.padRight((String)s, (int)maxLength) : s;
    }

    public static @PolyNull ByteString stringToBinary(@PolyNull String s, Charset charset) {
        if (s == null) {
            return null;
        }
        return new ByteString(s.getBytes(charset));
    }

    public static @PolyNull ByteString truncate(@PolyNull ByteString s, int maxLength) {
        if (s == null) {
            return s;
        }
        if (s.length() > maxLength) {
            return s.substring(0, maxLength);
        }
        return s;
    }

    public static @PolyNull ByteString truncateOrPad(@PolyNull ByteString s, int maxLength) {
        if (s == null) {
            return s;
        }
        int length = s.length();
        if (length > maxLength) {
            return s.substring(0, maxLength);
        }
        if (length < maxLength) {
            return s.concat(new ByteString(new byte[maxLength - length]));
        }
        return s;
    }

    public static int position(String seek, String s) {
        return s.indexOf(seek) + 1;
    }

    public static int position(ByteString seek, ByteString s) {
        return s.indexOf(seek) + 1;
    }

    public static int position(String seek, String s, int from) {
        if (from == 0) {
            throw Static.RESOURCE.fromNotZero().ex();
        }
        if (from > 0) {
            return SqlFunctions.positionForwards(seek, s, from);
        }
        return SqlFunctions.positionBackwards(seek, s, from += s.length());
    }

    public static int position(ByteString seek, ByteString s, int from) {
        if (from == 0) {
            throw Static.RESOURCE.fromNotZero().ex();
        }
        if (from > 0) {
            return SqlFunctions.positionForwards(seek, s, from);
        }
        return SqlFunctions.positionBackwards(seek, s, from += s.length());
    }

    private static int positionForwards(String seek, String s, int from) {
        int from0 = from - 1;
        if (from0 >= s.length()) {
            return 0;
        }
        return s.indexOf(seek, from0) + 1;
    }

    private static int positionForwards(ByteString seek, ByteString s, int from) {
        int from0 = from - 1;
        if (from0 >= s.length()) {
            return 0;
        }
        return s.indexOf(seek, from0) + 1;
    }

    private static int positionBackwards(String seek, String s, int rightIndex) {
        if (rightIndex <= 0) {
            return 0;
        }
        int lastIndex = s.lastIndexOf(seek) + 1;
        while (lastIndex > rightIndex + 1) {
            if ((lastIndex = s.substring(0, lastIndex - 1).lastIndexOf(seek) + 1) != 0) continue;
            return 0;
        }
        return lastIndex;
    }

    private static int positionBackwards(ByteString seek, ByteString s, int rightIndex) {
        int lastIndex;
        int indexOf;
        if (rightIndex <= 0) {
            return 0;
        }
        for (lastIndex = 0; lastIndex < rightIndex && (indexOf = s.substring(lastIndex).indexOf(seek) + 1) != 0 && lastIndex + indexOf <= rightIndex + 1; lastIndex += indexOf) {
        }
        return lastIndex;
    }

    public static int position(String seek, String s, int from, int occurrence) {
        if (from == 0) {
            throw Static.RESOURCE.fromNotZero().ex();
        }
        if (occurrence == 0) {
            throw Static.RESOURCE.occurrenceNotZero().ex();
        }
        if (from > 0) {
            --from;
            for (int i = 0; i < occurrence; ++i) {
                ++from;
                if ((from = SqlFunctions.positionForwards(seek, s, from)) != 0) continue;
                return 0;
            }
        } else {
            from += s.length() + 1;
            ++from;
            for (int i = 0; i < occurrence; ++i) {
                --from;
                if ((from = SqlFunctions.positionBackwards(seek, s, from - 1)) != 0) continue;
                return 0;
            }
        }
        return from;
    }

    public static int position(ByteString seek, ByteString s, int from, int occurrence) {
        if (from == 0) {
            throw Static.RESOURCE.fromNotZero().ex();
        }
        if (occurrence == 0) {
            throw Static.RESOURCE.occurrenceNotZero().ex();
        }
        if (from > 0) {
            --from;
            for (int i = 0; i < occurrence; ++i) {
                ++from;
                if ((from = SqlFunctions.positionForwards(seek, s, from)) != 0) continue;
                return 0;
            }
        } else {
            from += s.length() + 1;
            ++from;
            for (int i = 0; i < occurrence; ++i) {
                --from;
                if ((from = SqlFunctions.positionBackwards(seek, s, from - 1)) != 0) continue;
                return 0;
            }
        }
        return from;
    }

    public static long round(long v, long x) {
        return SqlFunctions.truncate(v + x / 2L, x);
    }

    public static long truncate(long v, long x) {
        long remainder = v % x;
        if (remainder < 0L) {
            remainder += x;
        }
        return v - remainder;
    }

    public static int round(int v, int x) {
        return SqlFunctions.truncate(v + x / 2, x);
    }

    public static int truncate(int v, int x) {
        int remainder = v % x;
        if (remainder < 0) {
            remainder += x;
        }
        return v - remainder;
    }

    public static String dayNameWithTimestamp(long timestamp, Locale locale) {
        return SqlFunctions.timeStampToLocalDate(timestamp).format(ROOT_DAY_FORMAT.withLocale(locale));
    }

    public static String dayNameWithDate(int date, Locale locale) {
        return SqlFunctions.dateToLocalDate(date).format(ROOT_DAY_FORMAT.withLocale(locale));
    }

    public static String monthNameWithTimestamp(long timestamp, Locale locale) {
        return SqlFunctions.timeStampToLocalDate(timestamp).format(ROOT_MONTH_FORMAT.withLocale(locale));
    }

    public static String monthNameWithDate(int date, Locale locale) {
        return SqlFunctions.dateToLocalDate(date).format(ROOT_MONTH_FORMAT.withLocale(locale));
    }

    private static LocalDate dateToLocalDate(int date) {
        int y0 = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.YEAR, (long)date);
        int m0 = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.MONTH, (long)date);
        int d0 = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.DAY, (long)date);
        return LocalDate.of(y0, m0, d0);
    }

    private static LocalDate timeStampToLocalDate(long timestamp) {
        int date = SqlFunctions.timestampToDate(timestamp);
        return SqlFunctions.dateToLocalDate(date);
    }

    public static int timestampToDate(long timestamp) {
        return (int)(timestamp / 86400000L);
    }

    public static int timestampToTime(long timestamp) {
        return (int)(timestamp % 86400000L);
    }

    @NonDeterministic
    public static long currentTimestamp(DataContext root) {
        return (Long)DataContext.Variable.CURRENT_TIMESTAMP.get(root);
    }

    @NonDeterministic
    public static int currentTime(DataContext root) {
        int time = SqlFunctions.timestampToTime(SqlFunctions.currentTimestamp(root));
        if (time < 0) {
            time = (int)((long)time + 86400000L);
        }
        return time;
    }

    @NonDeterministic
    public static int currentDate(DataContext root) {
        long timestamp = SqlFunctions.currentTimestamp(root);
        int date = SqlFunctions.timestampToDate(timestamp);
        int time = SqlFunctions.timestampToTime(timestamp);
        if (time < 0) {
            --date;
        }
        return date;
    }

    @NonDeterministic
    public static Long currentDatetime(DataContext root) {
        long timestamp = (Long)DataContext.Variable.CURRENT_TIMESTAMP.get(root);
        return SqlFunctions.datetime(timestamp);
    }

    @NonDeterministic
    public static @Nullable Long currentDatetime(DataContext root, @Nullable String timezone) {
        if (timezone == null) {
            return null;
        }
        long timestamp = (Long)DataContext.Variable.UTC_TIMESTAMP.get(root);
        return SqlFunctions.datetime(timestamp, timezone);
    }

    @NonDeterministic
    public static long localTimestamp(DataContext root) {
        return (Long)DataContext.Variable.LOCAL_TIMESTAMP.get(root);
    }

    @NonDeterministic
    public static int localTime(DataContext root) {
        return SqlFunctions.timestampToTime(SqlFunctions.localTimestamp(root));
    }

    @NonDeterministic
    public static long sysTimestamp(DataContext root) {
        return (Long)DataContext.Variable.SYS_TIMESTAMP.get(root);
    }

    @NonDeterministic
    public static int sysDate(DataContext root) {
        long timestamp = SqlFunctions.sysTimestamp(root);
        int date = SqlFunctions.timestampToDate(timestamp);
        int time = SqlFunctions.timestampToTime(timestamp);
        if (time < 0) {
            --date;
        }
        return date;
    }

    @NonDeterministic
    public static TimeZone timeZone(DataContext root) {
        return (TimeZone)DataContext.Variable.TIME_ZONE.get(root);
    }

    @Deterministic
    public static String user(DataContext root) {
        return (String)Objects.requireNonNull(DataContext.Variable.USER.get(root));
    }

    @Deterministic
    public static String systemUser(DataContext root) {
        return (String)Objects.requireNonNull(DataContext.Variable.SYSTEM_USER.get(root));
    }

    @NonDeterministic
    public static Locale locale(DataContext root) {
        return (Locale)DataContext.Variable.LOCALE.get(root);
    }

    public static int customDateAdd(DataContext root, String timeFrameName, int interval, int date) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.addDate(date, interval, timeFrame);
    }

    public static long customTimestampAdd(DataContext root, String timeFrameName, long interval, long timestamp) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.addTimestamp(timestamp, interval, timeFrame);
    }

    public static int customDateDiff(DataContext root, String timeFrameName, int date, int date2) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.diffDate(date, date2, timeFrame);
    }

    public static long customTimestampDiff(DataContext root, String timeFrameName, long timestamp, long timestamp2) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.diffTimestamp(timestamp, timestamp2, timeFrame);
    }

    public static int customDateFloor(DataContext root, String timeFrameName, int date) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.floorDate(date, timeFrame);
    }

    public static int customDateCeil(DataContext root, String timeFrameName, int date) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.ceilDate(date, timeFrame);
    }

    public static long customTimestampFloor(DataContext root, String timeFrameName, long timestamp) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.floorTimestamp(timestamp, timeFrame);
    }

    public static long customTimestampCeil(DataContext root, String timeFrameName, long timestamp) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.ceilTimestamp(timestamp, timeFrame);
    }

    public static String translate3(String s, String search, String replacement) {
        return StringUtils.replaceChars((String)s, (String)search, (String)replacement);
    }

    public static String replace(String s, String search, String replacement, boolean isCaseSensitive) {
        if (search.isEmpty()) {
            return s;
        }
        if (isCaseSensitive) {
            return s.replace(search, replacement);
        }
        return StringUtils.replaceIgnoreCase((String)s, (String)search, (String)replacement);
    }

    public static @Nullable Object arrayItem(List list, int item, int offset, boolean safe) {
        if (item < offset || item > list.size() + 1 - offset) {
            if (safe) {
                return null;
            }
            throw Static.RESOURCE.arrayIndexOutOfBounds(item).ex();
        }
        return list.get(item - offset);
    }

    public static @Nullable Object mapItem(Map map, Object item) {
        return map.get(item);
    }

    public static @Nullable Object item(Object object, Object index) {
        if (object instanceof VariantValue) {
            return ((VariantValue)object).item(index);
        }
        if (object instanceof Map) {
            return SqlFunctions.mapItem((Map)object, index);
        }
        if (object instanceof List && index instanceof Number) {
            return SqlFunctions.arrayItem((List)object, ((Number)index).intValue(), 1, true);
        }
        if (index instanceof Number) {
            return SqlFunctions.structAccess(object, ((Number)index).intValue() - 1, null);
        }
        if (index instanceof String) {
            return SqlFunctions.structAccess(object, -1, index.toString());
        }
        return null;
    }

    public static @Nullable Object arrayItemOptional(@Nullable List list, int item, int offset, boolean safe) {
        if (list == null) {
            return null;
        }
        return SqlFunctions.arrayItem(list, item, offset, safe);
    }

    public static @Nullable Object mapItemOptional(@Nullable Map map, Object item) {
        if (map == null) {
            return null;
        }
        return SqlFunctions.mapItem(map, item);
    }

    public static @Nullable Object itemOptional(@Nullable Object object, Object index) {
        if (object == null) {
            return null;
        }
        return SqlFunctions.item(object, index);
    }

    public static boolean isTrue(@Nullable Boolean b) {
        return b != null && b != false;
    }

    public static boolean isFalse(@Nullable Boolean b) {
        return b != null && b == false;
    }

    public static boolean isNotTrue(@Nullable Boolean b) {
        return b == null || b == false;
    }

    public static boolean isNotFalse(@Nullable Boolean b) {
        return b == null || b != false;
    }

    public static @PolyNull Boolean not(@PolyNull Boolean b) {
        return b == null ? (Boolean)Nullness.castNonNull(null) : Boolean.valueOf(b == false);
    }

    public static @PolyNull List arrayToList(@PolyNull Array a) {
        if (a == null) {
            return (List)Nullness.castNonNull(null);
        }
        try {
            return Primitive.asList((Object)a.getArray());
        }
        catch (SQLException e) {
            throw Util.toUnchecked(e);
        }
    }

    @NonDeterministic
    public static long sequenceCurrentValue(String key) {
        return SqlFunctions.getAtomicLong(key).get();
    }

    @NonDeterministic
    public static long sequenceNextValue(String key) {
        return SqlFunctions.getAtomicLong(key).incrementAndGet();
    }

    private static AtomicLong getAtomicLong(String key) {
        Map<String, AtomicLong> map = THREAD_SEQUENCES.get();
        return map.computeIfAbsent(key, key_ -> new AtomicLong());
    }

    public static @Nullable Boolean arraysOverlap(List list1, List list2) {
        if (list1.size() > list2.size()) {
            return SqlFunctions.arraysOverlap(list2, list1);
        }
        List smaller = list1;
        List bigger = list2;
        boolean hasNull = false;
        if (!smaller.isEmpty() && !bigger.isEmpty()) {
            HashSet smallestSet = new HashSet(smaller);
            hasNull = smallestSet.remove(null);
            for (Object element : bigger) {
                if (element == null) {
                    hasNull = true;
                    continue;
                }
                if (!smallestSet.contains(element)) continue;
                return true;
            }
        }
        if (hasNull) {
            return null;
        }
        return false;
    }

    public static List arraysZip(List ... lists) {
        int biggestCardinality = lists.length == 0 ? 0 : Arrays.stream(lists).mapToInt(List::size).max().getAsInt();
        ArrayList result = new ArrayList(biggestCardinality);
        for (int i = 0; i < biggestCardinality; ++i) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (List list : lists) {
                Object value = i < list.size() && list.get(i) != null ? (Object)list.get(i) : null;
                row.add(value);
            }
            result.add(row);
        }
        return result;
    }

    public static List compact(List list) {
        ArrayList result = new ArrayList();
        for (Object element : list) {
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    public static List arrayAppend(List list, Object element) {
        ArrayList<Object> result = new ArrayList<Object>(list.size() + 1);
        result.addAll(list);
        result.add(element);
        return result;
    }

    public static List distinct(List list) {
        LinkedHashSet result = new LinkedHashSet(list);
        return new ArrayList(result);
    }

    public static <T> @Nullable T arrayMax(List<? extends T> list) {
        Object max = null;
        for (int i = 0; i < list.size(); ++i) {
            T item = list.get(i);
            if (item == null || max != null && ((Comparable)item).compareTo(max) <= 0) continue;
            max = item;
        }
        return max;
    }

    public static <T> @Nullable T arrayMin(List<? extends T> list) {
        Object min = null;
        for (int i = 0; i < list.size(); ++i) {
            T item = list.get(i);
            if (item == null || min != null && ((Comparable)item).compareTo(min) >= 0) continue;
            min = item;
        }
        return min;
    }

    public static List arrayPrepend(List list, Object element) {
        ArrayList<Object> result = new ArrayList<Object>(list.size() + 1);
        result.add(element);
        result.addAll(list);
        return result;
    }

    public static Long arrayPosition(List list, Object element) {
        int index = list.indexOf(element);
        if (index != -1) {
            return (long)index + 1L;
        }
        return 0L;
    }

    public static List arrayRemove(List list, Object element) {
        ArrayList result = new ArrayList();
        for (Object obj : list) {
            if (obj != null && obj.equals(element)) continue;
            result.add(obj);
        }
        return result;
    }

    public static @Nullable List<Object> arrayRepeat(Object element, Object count) {
        if (count == null) {
            return null;
        }
        int numberOfElement = (Integer)count;
        if (numberOfElement < 0) {
            numberOfElement = 0;
        }
        return Collections.nCopies(numberOfElement, element);
    }

    public static List arrayExcept(List list1, List list2) {
        LinkedHashSet result = new LinkedHashSet(list1);
        result.removeAll(list2);
        return new ArrayList(result);
    }

    public static @Nullable List arrayInsert(List baselist, Object pos, Object val) {
        boolean newPosExtendsArrayLeft;
        boolean usePositivePos;
        if (baselist == null || pos == null) {
            return null;
        }
        int posInt = (Integer)pos;
        Object[] baseArray = baselist.toArray();
        if (posInt == 0 || posInt >= 0x7FFFFFF0 || posInt <= -2147483632) {
            throw new IllegalArgumentException("The index 0 is invalid. An index shall be either < 0 or > 0 (the first element has index 1) and not exceeds the allowed limit.");
        }
        if (posInt == -1) {
            posInt = baseArray.length + 1;
        }
        boolean bl = usePositivePos = posInt > 0;
        if (usePositivePos) {
            int newArrayLength = Math.max(baseArray.length + 1, posInt);
            if (newArrayLength > 0x7FFFFFF0) {
                throw new IndexOutOfBoundsException(String.format(Locale.ROOT, "The new array length %s exceeds the allowed limit.", newArrayLength));
            }
            Object[] newArray = new Object[newArrayLength];
            int posIndex = posInt - 1;
            if (posIndex < baseArray.length) {
                System.arraycopy(baseArray, 0, newArray, 0, posIndex);
                newArray[posIndex] = val;
                System.arraycopy(baseArray, posIndex, newArray, posIndex + 1, baseArray.length - posIndex);
            } else {
                System.arraycopy(baseArray, 0, newArray, 0, baseArray.length);
                newArray[posIndex] = val;
            }
            return Arrays.asList(newArray);
        }
        int posIndex = posInt + 1;
        boolean bl2 = newPosExtendsArrayLeft = baseArray.length + posIndex < 0;
        if (newPosExtendsArrayLeft) {
            int newArrayLength = -posIndex + 1;
            if (newArrayLength > 0x7FFFFFF0) {
                throw new IndexOutOfBoundsException(String.format(Locale.ROOT, "The new array length %s exceeds the allowed limit.", newArrayLength));
            }
            Object[] newArray = new Object[newArrayLength];
            System.arraycopy(baseArray, 0, newArray, Math.abs(posIndex + baseArray.length) + 1, baseArray.length);
            newArray[0] = val;
            return Arrays.asList(newArray);
        }
        int newArrayLength = Math.max(baseArray.length + 1, (posIndex += baseArray.length) + 1);
        if (newArrayLength > 0x7FFFFFF0) {
            throw new IndexOutOfBoundsException(String.format(Locale.ROOT, "The new array length %s exceeds the allowed limit.", newArrayLength));
        }
        Object[] newArray = new Object[newArrayLength];
        if (posIndex < baseArray.length) {
            System.arraycopy(baseArray, 0, newArray, 0, posIndex);
            newArray[posIndex] = val;
            System.arraycopy(baseArray, posIndex, newArray, posIndex + 1, baseArray.length - posIndex);
        } else {
            System.arraycopy(baseArray, 0, newArray, 0, baseArray.length);
            newArray[posIndex] = val;
        }
        return Arrays.asList(newArray);
    }

    public static List arrayIntersect(List list1, List list2) {
        LinkedHashSet result = new LinkedHashSet(list1);
        result.retainAll(list2);
        return new ArrayList(result);
    }

    public static List arrayUnion(List list1, List list2) {
        LinkedHashSet result = new LinkedHashSet();
        result.addAll(list1);
        result.addAll(list2);
        return new ArrayList(result);
    }

    public static <F, T> List<T> transform(List<? extends F> list, Function1<? super F, ? extends T> function) {
        return new TransformingList<F, T>(list, function);
    }

    public static List sortArray(List list, boolean ascending) {
        Comparator comparator = ascending ? Comparator.nullsFirst(Comparator.naturalOrder()) : Comparator.nullsLast(Comparator.reverseOrder());
        list.sort(comparator);
        return list;
    }

    public static @Nullable Boolean exists(List list, Function1<Object, Boolean> function1) {
        return SqlFunctions.nullableExists(list, function1);
    }

    public static Boolean exists(List list, Predicate1 predicate1) {
        for (Object element : list) {
            boolean ret = predicate1.apply(element);
            if (!ret) continue;
            return true;
        }
        return false;
    }

    public static Map mapConcat(Map ... maps) {
        LinkedHashMap result = new LinkedHashMap();
        Arrays.stream(maps).forEach(result::putAll);
        return result;
    }

    public static List mapEntries(Map<Object, Object> map) {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>(map.size());
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            if (entry.getKey() == null) {
                throw Static.RESOURCE.illegalMapEntriesWithNullKey().ex();
            }
            result.add(Arrays.asList(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public static List mapKeys(Map map) {
        try {
            return ImmutableList.copyOf(map.keySet());
        }
        catch (NullPointerException e) {
            throw Static.RESOURCE.illegalMapKeysWithNullKey().ex();
        }
    }

    public static List mapValues(Map map) {
        if (map.containsKey(null)) {
            throw Static.RESOURCE.illegalMapValuesWithNullKey().ex();
        }
        return new ArrayList(map.values());
    }

    public static Boolean mapContainsKey(Map map, Object key) {
        return map.containsKey(key);
    }

    public static Map mapFromArrays(List keysArray, List valuesArray) {
        if (keysArray.size() != valuesArray.size()) {
            throw Static.RESOURCE.illegalArgumentsInMapFromArraysFunc(keysArray.size(), valuesArray.size()).ex();
        }
        LinkedHashMap map = new LinkedHashMap();
        for (int i = 0; i < keysArray.size(); ++i) {
            map.put(keysArray.get(i), valuesArray.get(i));
        }
        return map;
    }

    public static @Nullable Map mapFromEntries(List entries) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (Object entry : entries) {
            if (entry == null) {
                return null;
            }
            map.put(SqlFunctions.structAccess(entry, 0, null), SqlFunctions.structAccess(entry, 1, null));
        }
        return map;
    }

    public static Map map(Object ... args) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < args.length; i += 2) {
            Object key = args[i];
            Object value = args[i + 1];
            map.put(key, value);
        }
        return map;
    }

    public static Map strToMap(String string, String stringDelimiter, String keyValueDelimiter) {
        String[] keyValues;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String s : keyValues = string.split(stringDelimiter, -1)) {
            String[] keyValueArray = s.split(keyValueDelimiter, 2);
            String key = keyValueArray[0];
            String value = keyValueArray.length < 2 ? null : keyValueArray[1];
            map.put(key, value);
        }
        return map;
    }

    public static String substringIndex(String string, String delimiter, int count) {
        if (string.isEmpty() || count == 0) {
            return "";
        }
        if (count > 0) {
            int idx = -1;
            while (count > 0) {
                if ((idx = string.indexOf(delimiter, idx + 1)) >= 0) {
                    --count;
                    continue;
                }
                return string;
            }
            if (idx == 0) {
                return "";
            }
            return string.substring(0, idx);
        }
        int idx = string.length() - delimiter.length() + 1;
        for (count = -count; count > 0; --count) {
            if ((idx = SqlFunctions.rfind(string, delimiter, idx - 1)) >= 0) {
                continue;
            }
            return string;
        }
        if (idx + delimiter.length() == string.length()) {
            return "";
        }
        return string.substring(idx + delimiter.length());
    }

    private static int rfind(String string, String delim, int start) {
        while (start >= 0) {
            if (string.indexOf(delim, start) >= 0) {
                return start;
            }
            --start;
        }
        return -1;
    }

    public static List slice(List list) {
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        for (Object e : list) {
            result.add(SqlFunctions.structAccess(e, 0, null));
        }
        return result;
    }

    public static @Nullable Object element(List list) {
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        throw Static.RESOURCE.moreThanOneValueInList(list.toString()).ex();
    }

    public static boolean memberOf(@Nullable Object object, Collection collection) {
        return collection.contains(object);
    }

    public static <E> Collection<E> multisetIntersectDistinct(Collection<E> c1, Collection<E> c2) {
        HashSet<E> result = new HashSet<E>(c1);
        result.retainAll(c2);
        return new ArrayList<E>(result);
    }

    public static <E> Collection<E> multisetIntersectAll(Collection<E> c1, Collection<E> c2) {
        ArrayList<E> result = new ArrayList<E>(c1.size());
        ArrayList<E> c2Copy = new ArrayList<E>(c2);
        for (E e : c1) {
            if (!c2Copy.remove(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static <E> Collection<E> multisetExceptAll(Collection<E> c1, Collection<E> c2) {
        LinkedList<E> result = new LinkedList<E>(c1);
        for (E e : c2) {
            result.remove(e);
        }
        return result;
    }

    public static <E> Collection<E> multisetExceptDistinct(Collection<E> c1, Collection<E> c2) {
        HashSet<E> result = new HashSet<E>(c1);
        result.removeAll(c2);
        return new ArrayList<E>(result);
    }

    public static boolean isASet(Collection collection) {
        if (collection instanceof Set) {
            return true;
        }
        HashSet set = new HashSet(Math.max((int)((float)collection.size() / 0.75f) + 1, 16));
        for (Object e : collection) {
            if (set.add(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean submultisetOf(Collection possibleSubMultiset, Collection multiset) {
        if (possibleSubMultiset.size() > multiset.size()) {
            return false;
        }
        LinkedList multisetLocal = new LinkedList(multiset);
        for (Object e : possibleSubMultiset) {
            if (multisetLocal.remove(e)) continue;
            return false;
        }
        return true;
    }

    public static Collection multisetUnionDistinct(Collection collection1, Collection collection2) {
        HashSet resultCollection = new HashSet(Math.max((int)((float)(collection1.size() + collection2.size()) / 0.75f) + 1, 16));
        resultCollection.addAll(collection1);
        resultCollection.addAll(collection2);
        return new ArrayList(resultCollection);
    }

    public static Collection multisetUnionAll(Collection collection1, Collection collection2) {
        ArrayList resultCollection = new ArrayList(collection1.size() + collection2.size());
        resultCollection.addAll(collection1);
        resultCollection.addAll(collection2);
        return resultCollection;
    }

    public static List reverse(List list) {
        Collections.reverse(list);
        return list;
    }

    public static List arraySlice(List list, int start, int length) {
        if (start + length > list.size()) {
            return Collections.emptyList();
        }
        return list.subList(start, start + length);
    }

    public static String arrayToString(List list, String delimiter) {
        return SqlFunctions.arrayToString(list, delimiter, null);
    }

    public static String arrayToString(List list, String delimiter, @Nullable String nullText) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object item : list) {
            String str;
            if (item == null) {
                if (nullText == null) continue;
                str = nullText;
            } else if (item instanceof String) {
                str = (String)item;
            } else if (item instanceof ByteString) {
                str = item.toString();
            } else {
                throw new IllegalStateException("arrayToString supports only String or ByteString, but got " + item.getClass().getName());
            }
            if (!isFirst) {
                sb.append(delimiter);
            }
            sb.append(str);
            isFirst = false;
        }
        return sb.toString();
    }

    public static List<@Nullable String> stringToArray(String string, @Nullable String delimiter) {
        return SqlFunctions.stringToArray(string, delimiter, null);
    }

    public static List<@Nullable String> stringToArray(String string, @Nullable String delimiter, @Nullable String nullString) {
        String[] parts = delimiter == null ? (String[])string.chars().mapToObj(c -> Character.toString((char)c)).toArray(String[]::new) : (delimiter.isEmpty() ? new String[]{string} : string.split(delimiter));
        ArrayList<@Nullable String> result = new ArrayList<String>(parts.length);
        for (String part : parts) {
            if (nullString != null && nullString.equals(part)) {
                result.add(null);
                continue;
            }
            result.add(part);
        }
        return result;
    }

    public static Function1<List<Object>, Enumerable<Object>> flatList() {
        return inputList -> Linq4j.asEnumerable((List)inputList).select(v -> SqlFunctions.structAccess(v, 0, null));
    }

    public static Function1<Object, Enumerable<FlatLists.ComparableList<Comparable>>> flatProduct(int[] fieldCounts, boolean withOrdinality, FlatProductInputType[] inputTypes) {
        if (fieldCounts.length == 1) {
            if (!withOrdinality && inputTypes[0] == FlatProductInputType.SCALAR) {
                return LIST_AS_ENUMERABLE;
            }
            return row -> SqlFunctions.p2(new Object[]{row}, fieldCounts, withOrdinality, inputTypes);
        }
        return lists -> SqlFunctions.p2((Object[])lists, fieldCounts, withOrdinality, inputTypes);
    }

    private static Enumerable<FlatLists.ComparableList<Comparable>> p2(Object[] lists, int[] fieldCounts, boolean withOrdinality, FlatProductInputType[] inputTypes) {
        ArrayList<Enumerator<List<Enumerator>>> enumerators = new ArrayList<Enumerator<List<Enumerator>>>();
        int totalFieldCount = 0;
        for (int i = 0; i < lists.length; ++i) {
            int fieldCount = fieldCounts[i];
            FlatProductInputType inputType = inputTypes[i];
            Object inputObject = lists[i];
            switch (inputType) {
                case SCALAR: {
                    List list = (List)inputObject;
                    enumerators.add(Linq4j.transform((Enumerator)Linq4j.enumerator((Collection)list), FlatLists::of));
                    break;
                }
                case LIST: {
                    List listList = (List)inputObject;
                    enumerators.add(Linq4j.enumerator((Collection)listList));
                    break;
                }
                case MAP: {
                    Map map = (Map)inputObject;
                    Enumerator enumerator = Linq4j.enumerator(map.entrySet());
                    Enumerator transformed = Linq4j.transform((Enumerator)enumerator, e -> FlatLists.of(e.getKey(), e.getValue()));
                    enumerators.add(transformed);
                    break;
                }
            }
            if (fieldCount < 0) {
                ++totalFieldCount;
                continue;
            }
            totalFieldCount += fieldCount;
        }
        if (withOrdinality) {
            ++totalFieldCount;
        }
        return SqlFunctions.product(enumerators, totalFieldCount, withOrdinality);
    }

    public static Object[] array(Object ... args) {
        return args;
    }

    public static <E> @Nullable Boolean nullableExists(List<? extends E> list, Function1<E, Boolean> predicate) {
        boolean nullExists = false;
        for (E e : list) {
            Boolean res = (Boolean)predicate.apply(e);
            if (res == null) {
                nullExists = true;
                continue;
            }
            if (!res.booleanValue()) continue;
            return true;
        }
        return nullExists ? null : Boolean.valueOf(false);
    }

    public static <E> @Nullable Boolean nullableAll(List<? extends E> list, Function1<E, Boolean> predicate) {
        boolean nullExists = false;
        for (E e : list) {
            Boolean res = (Boolean)predicate.apply(e);
            if (res == null) {
                nullExists = true;
                continue;
            }
            if (res.booleanValue()) continue;
            return false;
        }
        return nullExists ? null : Boolean.valueOf(true);
    }

    public static <E extends Comparable> Enumerable<FlatLists.ComparableList<E>> product(final List<Enumerator<List<E>>> enumerators, final int fieldCount, final boolean withOrdinality) {
        return new AbstractEnumerable<FlatLists.ComparableList<E>>(){

            public Enumerator<FlatLists.ComparableList<E>> enumerator() {
                return new ProductComparableListEnumerator(enumerators, fieldCount, withOrdinality);
            }
        };
    }

    public static @Nullable Object structAccess(@Nullable Object structObject, int index, @Nullable String fieldName) {
        if (structObject == null) {
            return null;
        }
        if (structObject instanceof Object[]) {
            return ((Object[])structObject)[index];
        }
        if (structObject instanceof List) {
            return ((List)structObject).get(index);
        }
        if (structObject instanceof Row) {
            return ((Row)structObject).getObject(index);
        }
        Class<?> beanClass = structObject.getClass();
        try {
            if (fieldName == null) {
                throw new IllegalStateException("Field name cannot be null for struct field access");
            }
            Field structField = beanClass.getDeclaredField(fieldName);
            return structField.get(structObject);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw Static.RESOURCE.failedToAccessField(fieldName, index, beanClass.getName()).ex(ex);
        }
    }

    private static enum PartToExtract {
        HOST,
        PATH,
        QUERY,
        REF,
        PROTOCOL,
        FILE,
        AUTHORITY,
        USERINFO;

    }

    public static enum FlatProductInputType {
        SCALAR,
        LIST,
        MAP;

    }

    public static enum JsonScope {
        JSON_KEYS,
        JSON_KEYS_AND_VALUES,
        JSON_VALUES;

    }

    private static class ProductComparableListEnumerator<E extends Comparable>
    extends CartesianProductEnumerator<List<E>, FlatLists.ComparableList<E>> {
        final Object[] flatElements;
        final List<Object> list;
        private final boolean withOrdinality;
        private int ordinality;

        ProductComparableListEnumerator(List<Enumerator<List<E>>> enumerators, int fieldCount, boolean withOrdinality) {
            super(enumerators);
            this.withOrdinality = withOrdinality;
            this.flatElements = new Object[fieldCount];
            this.list = Arrays.asList(this.flatElements);
        }

        public boolean moveNext() {
            boolean hasNext = super.moveNext();
            if (hasNext && this.withOrdinality) {
                ++this.ordinality;
            }
            return hasNext;
        }

        public FlatLists.ComparableList<E> current() {
            int i = 0;
            for (Object element : this.elements) {
                Object[] a;
                if (element.getClass().isArray()) {
                    a = (Object[])element;
                } else {
                    List list2 = (List)element;
                    a = list2.toArray();
                }
                System.arraycopy(a, 0, this.flatElements, i, a.length);
                i += a.length;
            }
            if (this.withOrdinality) {
                this.flatElements[i] = this.ordinality;
            }
            return (FlatLists.ComparableList)FlatLists.of(this.list);
        }

        public void reset() {
            super.reset();
            if (this.withOrdinality) {
                this.ordinality = 0;
            }
        }
    }

    private static class TransformingList<F, T>
    extends AbstractList<T> {
        private final Function1<? super F, ? extends T> function;
        private final List<? extends F> list;

        TransformingList(List<? extends F> list, Function1<? super F, ? extends T> function) {
            this.function = function;
            this.list = list;
        }

        @Override
        public T get(int i) {
            return (T)this.function.apply(this.list.get(i));
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public Iterator<T> iterator() {
            return this.listIterator();
        }
    }

    @Deterministic
    public static class DateParseFunction {
        final DateFormatFunction f = new DateFormatFunction();
        private final LoadingCache<Key, DateFormat> cache = CacheBuilder.newBuilder().maximumSize((long)CalciteSystemProperty.FUNCTION_LEVEL_CACHE_MAX_SIZE.value().intValue()).build(CacheLoader.from(key -> key.toDateFormat(this.f)));

        private <T> T withParser(String fmt, String timeZone, Function<DateFormat, T> action) {
            DateFormat dateFormat = (DateFormat)this.cache.getUnchecked((Object)new Key(fmt, timeZone));
            return action.apply(dateFormat);
        }

        private long internalParseDatetime(String fmtString, String datetime) {
            return this.internalParseDatetime(fmtString, datetime, DateTimeUtils.DEFAULT_ZONE.getID());
        }

        private long internalParseDatetime(String fmt, String datetime, String timeZone) {
            ParsePosition pos = new ParsePosition(0);
            Date parsed = this.withParser(fmt, timeZone, parser -> parser.parse(datetime, pos));
            if (pos.getErrorIndex() >= 0 || pos.getIndex() != datetime.length()) {
                SQLException e = new SQLException(String.format(Locale.ROOT, "Invalid format: '%s' for datetime string: '%s'.", fmt, datetime));
                throw Util.toUnchecked(e);
            }
            long millisSinceEpoch = parsed.getTime();
            return millisSinceEpoch;
        }

        public int parseDate(String fmtString, String date) {
            long millisSinceEpoch = this.internalParseDatetime(fmtString, date);
            return SqlFunctions.toInt(new java.sql.Date(millisSinceEpoch));
        }

        public long parseDatetime(String fmtString, String datetime) {
            long millisSinceEpoch = this.internalParseDatetime(fmtString, datetime);
            return SqlFunctions.toLong(new Timestamp(millisSinceEpoch));
        }

        public int parseTime(String fmtString, String time) {
            long millisSinceEpoch = this.internalParseDatetime(fmtString, time);
            return SqlFunctions.toInt(new Time(millisSinceEpoch));
        }

        public long parseTimestamp(String fmtString, String timestamp) {
            return this.parseTimestamp(fmtString, timestamp, "UTC");
        }

        public long parseTimestamp(String fmtString, String timestamp, String timeZone) {
            TimeZone tz = TimeZone.getTimeZone(timeZone);
            long millisSinceEpoch = this.internalParseDatetime(fmtString, timestamp, timeZone);
            return SqlFunctions.toLong(new Timestamp(millisSinceEpoch), tz);
        }

        private static final class Key {
            final String fmt;
            final String timeZone;

            Key(String fmt, String timeZone) {
                this.fmt = fmt;
                this.timeZone = timeZone;
            }

            public int hashCode() {
                return this.fmt.hashCode() + this.timeZone.hashCode() * 37;
            }

            public boolean equals(@Nullable Object obj) {
                return this == obj || obj instanceof Key && this.fmt.equals(((Key)obj).fmt) && this.timeZone.equals(((Key)obj).timeZone);
            }

            DateFormat toDateFormat(DateFormatFunction f) {
                f.sb.setLength(0);
                f.withElements(FormatModels.BIG_QUERY, this.fmt, elements -> elements.forEach(ele -> ele.toPattern(f.sb)));
                String javaFmt = f.sb.toString();
                SimpleDateFormat parser = new SimpleDateFormat(javaFmt, Locale.ENGLISH);
                parser.setLenient(false);
                TimeZone tz = TimeZone.getTimeZone(this.timeZone);
                parser.setCalendar(Calendar.getInstance(tz, Locale.ROOT));
                return parser;
            }
        }
    }

    @Deterministic
    public static class DateFormatFunctionPg {
        private static final ZoneId LOCAL_ZONE = ZoneId.ofOffset("", ZoneOffset.UTC);
        private final DataContext dataContext;
        private final LoadingCache<String, CompiledDateTimeFormat> formatCachePg = CacheBuilder.newBuilder().maximumSize((long)CalciteSystemProperty.FUNCTION_LEVEL_CACHE_MAX_SIZE.value().intValue()).build(CacheLoader.from(PostgresqlDateTimeFormatter::compilePattern));

        public DateFormatFunctionPg(DataContext dataContext) {
            this.dataContext = dataContext;
        }

        public String toChar(long timestamp, String pattern) {
            ZoneId zoneId = ((TimeZone)DataContext.Variable.TIME_ZONE.get(this.dataContext)).toZoneId();
            Locale locale = (Locale)Objects.requireNonNull(DataContext.Variable.LOCALE.get(this.dataContext));
            CompiledDateTimeFormat dateTimeFormat = (CompiledDateTimeFormat)this.formatCachePg.getUnchecked((Object)pattern);
            Timestamp sqlTimestamp = SqlFunctions.internalToTimestamp(timestamp);
            ZonedDateTime zonedDateTime = ZonedDateTime.of(sqlTimestamp.toLocalDateTime(), zoneId);
            return dateTimeFormat.formatDateTime(zonedDateTime, locale);
        }

        public int toDate(String dateString, String fmtString) {
            try {
                Locale locale = (Locale)Objects.requireNonNull(DataContext.Variable.LOCALE.get(this.dataContext));
                CompiledDateTimeFormat dateTimeFormat = (CompiledDateTimeFormat)this.formatCachePg.getUnchecked((Object)fmtString);
                return (int)dateTimeFormat.parseDateTime(dateString, LOCAL_ZONE, locale).getLong(ChronoField.EPOCH_DAY);
            }
            catch (Exception e) {
                SQLException sqlEx = new SQLException(String.format(Locale.ROOT, "Invalid format: '%s' for datetime string: '%s'.", fmtString, dateString));
                throw Util.toUnchecked(sqlEx);
            }
        }

        public long toTimestamp(String timestampString, String fmtString) {
            try {
                Locale locale = (Locale)Objects.requireNonNull(DataContext.Variable.LOCALE.get(this.dataContext));
                CompiledDateTimeFormat dateTimeFormat = (CompiledDateTimeFormat)this.formatCachePg.getUnchecked((Object)fmtString);
                return dateTimeFormat.parseDateTime(timestampString, LOCAL_ZONE, locale).toInstant().toEpochMilli();
            }
            catch (Exception e) {
                SQLException sqlEx = new SQLException(String.format(Locale.ROOT, "Invalid format: '%s' for timestamp string: '%s'.", fmtString, timestampString));
                throw Util.toUnchecked(sqlEx);
            }
        }
    }

    @Deterministic
    public static class DateFormatFunction {
        final StringBuilder sb = new StringBuilder();
        private final LoadingCache<Key, List<FormatElement>> formatCache = CacheBuilder.newBuilder().maximumSize((long)CalciteSystemProperty.FUNCTION_LEVEL_CACHE_MAX_SIZE.value().intValue()).build(CacheLoader.from(key -> ((FormatModel)key.t).parseNoCache((String)key.u)));

        protected final void withElements(FormatModel formatModel, String format, Consumer<List<FormatElement>> consumer) {
            List elements = (List)this.formatCache.getUnchecked((Object)new Key(formatModel, format));
            consumer.accept(elements);
        }

        private String internalFormatDatetime(String fmtString, Date date) {
            this.sb.setLength(0);
            this.withElements(FormatModels.BIG_QUERY, fmtString, elements -> elements.forEach(element -> element.format(this.sb, date)));
            return this.sb.toString();
        }

        public String formatTimestamp(String fmtString, long timestamp) {
            return this.internalFormatDatetime(fmtString, SqlFunctions.internalToTimestamp(timestamp));
        }

        public String toChar(long timestamp, String pattern) {
            Timestamp sqlTimestamp = SqlFunctions.internalToTimestamp(timestamp);
            this.sb.setLength(0);
            this.withElements(FormatModels.POSTGRESQL, pattern, elements -> elements.forEach(element -> element.format(this.sb, sqlTimestamp)));
            return this.sb.toString().trim();
        }

        public int toDate(String dateString, String fmtString) {
            return SqlFunctions.toInt(new java.sql.Date(this.internalToDateTime(dateString, fmtString)));
        }

        public long toTimestamp(String timestampString, String fmtString) {
            return SqlFunctions.toLong(new Timestamp(this.internalToDateTime(timestampString, fmtString)));
        }

        private long internalToDateTime(String dateString, String fmtString) {
            ParsePosition pos = new ParsePosition(0);
            this.sb.setLength(0);
            this.withElements(FormatModels.POSTGRESQL, fmtString, elements -> elements.forEach(element -> element.toPattern(this.sb)));
            String dateFormatString = this.sb.toString().trim();
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormatString, Locale.ENGLISH);
            Date date = sdf.parse(dateString, pos);
            if (pos.getErrorIndex() >= 0 || pos.getIndex() != dateString.length()) {
                SQLException e = new SQLException(String.format(Locale.ROOT, "Invalid format: '%s' for datetime string: '%s'.", fmtString, dateString));
                throw Util.toUnchecked(e);
            }
            long millisSinceEpoch = date.getTime();
            return millisSinceEpoch;
        }

        public String formatDate(String fmtString, int date) {
            return this.internalFormatDatetime(fmtString, SqlFunctions.internalToDate(date));
        }

        public String formatTime(String fmtString, int time) {
            return this.internalFormatDatetime(fmtString, SqlFunctions.internalToTime(time));
        }

        private static class Key
        extends MapEntry<FormatModel, String> {
            Key(FormatModel formatModel, String format) {
                super(formatModel, format);
            }
        }
    }

    @Deterministic
    public static class PosixRegexFunction {
        private final LoadingCache<Ord<String>, Pattern> cache = CacheBuilder.newBuilder().maximumSize((long)CalciteSystemProperty.FUNCTION_LEVEL_CACHE_MAX_SIZE.value().intValue()).build(CacheLoader.from(pattern -> Like.posixRegexToPattern((String)pattern.e, pattern.i)));

        boolean posixRegex(String s, String regex, int flags) {
            Ord key = Ord.of((int)flags, (Object)regex);
            return ((Pattern)this.cache.getUnchecked((Object)key)).matcher(s).find();
        }

        public boolean posixRegexInsensitive(String s, String regex) {
            return this.posixRegex(s, regex, 2);
        }

        public boolean posixRegexSensitive(String s, String regex) {
            return this.posixRegex(s, regex, 0);
        }
    }

    public static class SimilarEscapeFunction {
        private final LoadingCache<Key, Pattern> cache = CacheBuilder.newBuilder().maximumSize((long)CalciteSystemProperty.FUNCTION_LEVEL_CACHE_MAX_SIZE.value().intValue()).build(CacheLoader.from(Key::toPattern));

        public boolean similar(String s, String pattern, String escape) {
            return ((Pattern)this.cache.getUnchecked((Object)new Key(pattern, escape))).matcher(s).matches();
        }

        private static class Key
        extends MapEntry<String, String> {
            Key(String formatModel, String format) {
                super(formatModel, format);
            }

            Pattern toPattern() {
                return Pattern.compile(Like.sqlToRegexSimilar((String)this.t, (CharSequence)this.u));
            }
        }
    }

    @Deterministic
    public static class SimilarFunction {
        private final LoadingCache<String, Pattern> cache = CacheBuilder.newBuilder().maximumSize((long)CalciteSystemProperty.FUNCTION_LEVEL_CACHE_MAX_SIZE.value().intValue()).build(CacheLoader.from(pattern -> Pattern.compile(Like.sqlToRegexSimilar(pattern, null))));

        public boolean similar(String s, String pattern) {
            return ((Pattern)this.cache.getUnchecked((Object)pattern)).matcher(s).matches();
        }
    }

    @Deterministic
    public static class LikeFunction {
        private final LoadingCache<Key, Pattern> cache = CacheBuilder.newBuilder().maximumSize((long)CalciteSystemProperty.FUNCTION_LEVEL_CACHE_MAX_SIZE.value().intValue()).build(CacheLoader.from(Key::toPattern));

        public boolean like(String s, String pattern) {
            Key key = new Key(pattern, null, 0);
            return ((Pattern)this.cache.getUnchecked((Object)key)).matcher(s).matches();
        }

        public boolean like(String s, String pattern, String escape) {
            Key key = new Key(pattern, escape, 0);
            return ((Pattern)this.cache.getUnchecked((Object)key)).matcher(s).matches();
        }

        public boolean ilike(String s, String pattern) {
            Key key = new Key(pattern, null, 2);
            return ((Pattern)this.cache.getUnchecked((Object)key)).matcher(s).matches();
        }

        public boolean ilike(String s, String pattern, String escape) {
            Key key = new Key(pattern, escape, 2);
            return ((Pattern)this.cache.getUnchecked((Object)key)).matcher(s).matches();
        }

        private static final class Key {
            final String pattern;
            final @Nullable String escape;
            final int flags;

            Key(String pattern, @Nullable String escape, int flags) {
                this.pattern = pattern;
                this.escape = escape;
                this.flags = flags;
            }

            public int hashCode() {
                return this.pattern.hashCode() ^ (this.escape == null ? 0 : this.escape.hashCode()) ^ this.flags;
            }

            public boolean equals(@Nullable Object obj) {
                return this == obj || obj instanceof Key && this.pattern.equals(((Key)obj).pattern) && Objects.equals(this.escape, ((Key)obj).escape) && this.flags == ((Key)obj).flags;
            }

            Pattern toPattern() {
                String regex = Like.sqlToRegexLike(this.pattern, this.escape);
                return Pattern.compile(regex, this.flags);
            }
        }
    }

    @Deterministic
    public static class ParseUrlFunction {
        private final LoadingCache<String, Pattern> cache = CacheBuilder.newBuilder().maximumSize((long)CalciteSystemProperty.FUNCTION_LEVEL_CACHE_MAX_SIZE.value().intValue()).build(CacheLoader.from(ParseUrlFunction::keyToPattern));

        static Pattern keyToPattern(String keyToExtract) {
            return Pattern.compile("(&|^)" + keyToExtract + "=([^&]*)");
        }

        public @Nullable String parseUrl(String urlStr, String partToExtract, String keyToExtract) {
            if (!partToExtract.equals("QUERY")) {
                return null;
            }
            String query = this.parseUrl(urlStr, partToExtract);
            if (query == null) {
                return null;
            }
            Pattern p = (Pattern)this.cache.getUnchecked((Object)keyToExtract);
            Matcher m = p.matcher(query);
            return m.find() ? m.group(2) : null;
        }

        public @Nullable String parseUrl(String urlStr, String partToExtract) {
            PartToExtract part;
            URI uri;
            try {
                uri = new URI(urlStr);
            }
            catch (URISyntaxException e) {
                return null;
            }
            try {
                part = PartToExtract.valueOf(partToExtract);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            switch (part) {
                case HOST: {
                    return uri.getHost();
                }
                case PATH: {
                    return uri.getRawPath();
                }
                case QUERY: {
                    return uri.getRawQuery();
                }
                case REF: {
                    return uri.getRawFragment();
                }
                case PROTOCOL: {
                    return uri.getScheme();
                }
                case FILE: {
                    if (uri.getRawQuery() != null) {
                        return uri.getRawPath() + "?" + uri.getRawQuery();
                    }
                    return uri.getRawPath();
                }
                case AUTHORITY: {
                    return uri.getRawAuthority();
                }
                case USERINFO: {
                    return uri.getRawUserInfo();
                }
            }
            return null;
        }
    }

    @Deterministic
    public static class RegexFunction {
        private final LoadingCache<Key, Pattern> cache = CacheBuilder.newBuilder().maximumSize((long)CalciteSystemProperty.FUNCTION_LEVEL_CACHE_MAX_SIZE.value().intValue()).build(CacheLoader.from(Key::toPattern));
        private final LoadingCache<String, String> replacementStrCache = CacheBuilder.newBuilder().maximumSize((long)CalciteSystemProperty.FUNCTION_LEVEL_CACHE_MAX_SIZE.value().intValue()).build(CacheLoader.from(RegexFunction::replaceNonDollarIndexedString));

        private Pattern validateRegexPattern(String regex, String methodName) {
            return this.validateRegexPattern(regex, methodName, 0);
        }

        private Pattern validateRegexPattern(String regex, String methodName, int flags) {
            try {
                return (Pattern)this.cache.getUnchecked((Object)new Key(flags, regex));
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof PatternSyntaxException) {
                    throw Static.RESOURCE.invalidRegexInputForRegexpFunctions(Objects.requireNonNull(e.getCause().getMessage(), "message").replace(System.lineSeparator(), " "), methodName).ex();
                }
                throw e;
            }
        }

        private static void checkMultipleCapturingGroupsInRegex(Matcher matcher, String methodName) {
            if (matcher.groupCount() > 1) {
                throw Static.RESOURCE.multipleCapturingGroupsForRegexpFunctions(Integer.toString(matcher.groupCount()), methodName).ex();
            }
        }

        private static boolean validatePosOccurrenceParamValues(int position, int occurrence, int occurrencePosition, String value, String methodName) {
            if (position <= 0) {
                throw Static.RESOURCE.invalidIntegerInputForRegexpFunctions(Integer.toString(position), "position", methodName).ex();
            }
            if (occurrence <= 0) {
                throw Static.RESOURCE.invalidIntegerInputForRegexpFunctions(Integer.toString(occurrence), "occurrence", methodName).ex();
            }
            if (occurrencePosition != 0 && occurrencePosition != 1) {
                throw Static.RESOURCE.invalidIntegerInputForRegexpFunctions(Integer.toString(occurrencePosition), "occurrence_position", methodName).ex();
            }
            return position <= value.length();
        }

        public static String replaceNonDollarIndexedString(String replacement) {
            String indexedReplacement = replacement.replace("\\\\", "\\").replace("$", "\\$");
            int lastOccIdx = indexedReplacement.indexOf("\\");
            while (lastOccIdx != -1 && lastOccIdx < indexedReplacement.length() - 1) {
                char escapedChar = indexedReplacement.charAt(lastOccIdx + 1);
                if (Character.isDigit(escapedChar)) {
                    indexedReplacement = indexedReplacement.replaceFirst("\\\\(\\d)", "\\$$1");
                } else if (escapedChar != '\\' && escapedChar != '$') {
                    throw Static.RESOURCE.invalidReplacePatternForRegexpReplace(replacement).ex();
                }
                lastOccIdx = indexedReplacement.indexOf("\\", lastOccIdx + 2);
            }
            return indexedReplacement;
        }

        public boolean regexpContains(String value, String regex) {
            Pattern pattern = this.validateRegexPattern(regex, "REGEXP_CONTAINS");
            return pattern.matcher(value).find();
        }

        public boolean regexpLike(String value, String regex, String stringFlags) {
            Pattern pattern = this.validateRegexPattern(regex, "REGEXP_LIKE", RegexFunction.makeRegexpFlags(stringFlags));
            return pattern.matcher(value).find();
        }

        public @Nullable String regexpExtract(String value, String regex) {
            return this.regexpExtract(value, regex, 1, 1);
        }

        public @Nullable String regexpExtract(String value, String regex, int position) {
            return this.regexpExtract(value, regex, position, 1);
        }

        public @Nullable String regexpExtract(String value, String regex, int position, int occurrence) {
            String methodName = "REGEXP_EXTRACT";
            Pattern pattern = this.validateRegexPattern(regex, "REGEXP_EXTRACT");
            if (!RegexFunction.validatePosOccurrenceParamValues(position, occurrence, 0, value, "REGEXP_EXTRACT")) {
                return null;
            }
            Matcher matcher = pattern.matcher(value);
            RegexFunction.checkMultipleCapturingGroupsInRegex(matcher, "REGEXP_EXTRACT");
            matcher.region(position - 1, value.length());
            String match = null;
            while (occurrence > 0) {
                if (!matcher.find()) {
                    return null;
                }
                match = matcher.group(matcher.groupCount());
                --occurrence;
            }
            return match;
        }

        public List<String> regexpExtractAll(String value, String regex) {
            String methodName = "REGEXP_EXTRACT_ALL";
            Pattern regexp = this.validateRegexPattern(regex, "REGEXP_EXTRACT_ALL");
            Matcher matcher = regexp.matcher(value);
            RegexFunction.checkMultipleCapturingGroupsInRegex(matcher, "REGEXP_EXTRACT_ALL");
            ImmutableList.Builder matches = ImmutableList.builder();
            while (matcher.find()) {
                String match = matcher.group(matcher.groupCount());
                if (match == null) continue;
                matches.add((Object)match);
            }
            return matches.build();
        }

        public int regexpInstr(String value, String regex) {
            return this.regexpInstr(value, regex, 1, 1, 0);
        }

        public int regexpInstr(String value, String regex, int position) {
            return this.regexpInstr(value, regex, position, 1, 0);
        }

        public int regexpInstr(String value, String regex, int position, int occurrence) {
            return this.regexpInstr(value, regex, position, occurrence, 0);
        }

        public int regexpInstr(String value, String regex, int position, int occurrence, int occurrencePosition) {
            String methodName = "REGEXP_INSTR";
            Pattern pattern = this.validateRegexPattern(regex, "REGEXP_INSTR");
            if (regex.isEmpty() || !RegexFunction.validatePosOccurrenceParamValues(position, occurrence, occurrencePosition, value, "REGEXP_INSTR")) {
                return 0;
            }
            Matcher matcher = pattern.matcher(value);
            RegexFunction.checkMultipleCapturingGroupsInRegex(matcher, "REGEXP_INSTR");
            matcher.region(position - 1, value.length());
            int matchIndex = 0;
            while (occurrence > 0) {
                if (matcher.find()) {
                    matchIndex = occurrencePosition == 0 ? matcher.start(matcher.groupCount()) + 1 : matcher.end(matcher.groupCount()) + 1;
                } else {
                    return 0;
                }
                --occurrence;
            }
            return matchIndex;
        }

        public String regexpReplace(String s, String regex) {
            return this.regexpReplace(s, regex, "", 1, 0, null);
        }

        public String regexpReplace(String s, String regex, String replacement) {
            return this.regexpReplace(s, regex, replacement, 1, 0, null);
        }

        public String regexpReplace(String s, String regex, String replacement, int pos) {
            return this.regexpReplace(s, regex, replacement, pos, 0, null);
        }

        public String regexpReplace(String s, String regex, String replacement, int pos, int occurrence) {
            return this.regexpReplace(s, regex, replacement, pos, occurrence, null);
        }

        public String regexpReplace(String s, String regex, String replacement, int pos, String matchType) {
            return this.regexpReplace(s, regex, replacement, pos, 0, matchType);
        }

        public String regexpReplace(String s, String regex, String replacement, int pos, int occurrence, @Nullable String matchType) {
            if (pos < 1 || pos > s.length() + 1) {
                throw Static.RESOURCE.invalidInputForRegexpReplace(Integer.toString(pos)).ex();
            }
            int flags = matchType == null ? 0 : RegexFunction.makeRegexpFlags(matchType);
            Pattern pattern = (Pattern)this.cache.getUnchecked((Object)new Key(flags, regex));
            return Unsafe.regexpReplace(s, pattern, replacement, pos, occurrence);
        }

        public String regexpReplacePg(String s, String regex, String replacement) {
            return this.regexpReplaceNonDollarIndexed(s, regex, replacement, 1, 1, null);
        }

        public String regexpReplacePg(String s, String regex, String replacement, String matchType) {
            int occurrence = matchType.contains("g") ? 0 : 1;
            return this.regexpReplaceNonDollarIndexed(s, regex, replacement, 1, occurrence, matchType);
        }

        public String regexpReplaceNonDollarIndexed(String s, String regex, String replacement) {
            return this.regexpReplaceNonDollarIndexed(s, regex, replacement, 1, 0, null);
        }

        private String regexpReplaceNonDollarIndexed(String s, String regex, String replacement, int pos, int occurrence, @Nullable String matchType) {
            String indexedReplacement;
            try {
                indexedReplacement = (String)this.replacementStrCache.getUnchecked((Object)replacement);
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof CalciteException) {
                    throw Static.RESOURCE.invalidReplacePatternForRegexpReplace(replacement).ex();
                }
                throw e;
            }
            return this.regexpReplace(s, regex, indexedReplacement, pos, occurrence, matchType);
        }

        private static int makeRegexpFlags(String stringFlags) {
            int flags = 0;
            block8: for (int i = 0; i < stringFlags.length(); ++i) {
                switch (stringFlags.charAt(i)) {
                    case 'i': {
                        flags |= 2;
                        continue block8;
                    }
                    case 'c': {
                        flags &= 0xFFFFFFFD;
                        continue block8;
                    }
                    case 'n': {
                        flags |= 0x20;
                        continue block8;
                    }
                    case 'm': {
                        flags |= 8;
                        continue block8;
                    }
                    case 's': {
                        flags &= 0xFFFFFFDF;
                        continue block8;
                    }
                    case 'g': {
                        continue block8;
                    }
                    default: {
                        throw Static.RESOURCE.invalidInputForRegexpReplace(stringFlags).ex();
                    }
                }
            }
            return flags;
        }

        public boolean rlike(String s, String pattern) {
            return ((Pattern)this.cache.getUnchecked((Object)new Key(0, pattern))).matcher(s).find();
        }

        private static class Key
        extends Ord<String> {
            Key(int flags, String regex) {
                super(flags, (Object)regex);
            }

            Pattern toPattern() {
                return Pattern.compile((String)this.e, this.i);
            }
        }
    }
}

