/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.persistence.mappers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.migrationtools.persistence.utils.pubsub.BasicProcessor;
import org.apache.ignite3.table.Tuple;

public class CacheDataRowProcessor
extends BasicProcessor<CacheDataRow, Map.Entry<Object, Object>> {
    private final CacheObjectContext cacheObjectCtx;

    public CacheDataRowProcessor(CacheObjectContext ctx) {
        this.cacheObjectCtx = ctx;
    }

    @Override
    public void onNext(CacheDataRow row) {
        KeyCacheObject key = row.key();
        KeyCacheObject keyVal = key instanceof BinaryObjectImpl ? key : key.value((CacheObjectValueContext)this.cacheObjectCtx, false);
        CacheObject val = row.value();
        CacheObject valVal = val instanceof BinaryObjectImpl ? val : val.value((CacheObjectValueContext)this.cacheObjectCtx, false);
        this.subscriber.onNext(Map.entry(keyVal, valVal));
    }

    private static Tuple parseBinaryObject(BinaryObjectImpl obj) {
        Collection fieldNames = obj.rawType().fieldNames();
        HashMap<String, Object> fields = new HashMap<String, Object>(fieldNames.size());
        for (String fieldName : fieldNames) {
            Object val = obj.field(fieldName);
            if (val instanceof BinaryObject) {
                BinaryObject nested = (BinaryObject)val;
                val = nested.type().isEnum() ? nested.enumName() : CacheDataRowProcessor.parseBinaryObject((BinaryObjectImpl)val);
            }
            fields.put(fieldName, val);
        }
        return Tuple.create(fields);
    }
}

