/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.queue;

import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite3.compute.ComputeException;
import org.apache.ignite3.compute.JobState;
import org.apache.ignite3.compute.JobStatus;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadata;
import org.apache.ignite3.internal.compute.events.ComputeEventsFactory;
import org.apache.ignite3.internal.compute.queue.ComputeThreadPoolExecutor;
import org.apache.ignite3.internal.compute.queue.QueueEntry;
import org.apache.ignite3.internal.compute.queue.QueueEntryCanceledException;
import org.apache.ignite3.internal.compute.queue.QueueExecution;
import org.apache.ignite3.internal.compute.queue.QueueOverflowException;
import org.apache.ignite3.internal.compute.state.ComputeStateMachine;
import org.apache.ignite3.internal.compute.state.IllegalJobStatusTransition;
import org.apache.ignite3.internal.eventlog.api.EventLog;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

class QueueExecutionImpl<R>
implements QueueExecution<R> {
    private static final IgniteLogger LOG = Loggers.forClass(QueueExecutionImpl.class);
    private final UUID jobId;
    private final Callable<CompletableFuture<R>> job;
    private final ComputeThreadPoolExecutor executor;
    private final ComputeStateMachine stateMachine;
    private final EventLog eventLog;
    @Nullable
    private final ComputeEventMetadata eventMetadata;
    private final CompletableFuture<R> result = new CompletableFuture();
    private final Lock executionLock = new ReentrantLock();
    @Nullable
    private volatile QueueEntry<R> queueEntry;
    private volatile int priority;
    private final AtomicInteger retries = new AtomicInteger();

    QueueExecutionImpl(UUID jobId, Callable<CompletableFuture<R>> job, int priority, ComputeThreadPoolExecutor executor, ComputeStateMachine stateMachine, EventLog eventLog, @Nullable ComputeEventMetadata eventMetadata) {
        this.jobId = jobId;
        this.job = job;
        this.priority = priority;
        this.executor = executor;
        this.stateMachine = stateMachine;
        this.eventLog = eventLog;
        this.eventMetadata = eventMetadata;
    }

    @Override
    public CompletableFuture<R> resultAsync() {
        return this.result;
    }

    @Override
    @Nullable
    public JobState state() {
        return this.stateMachine.currentState(this.jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        this.executionLock.lock();
        try {
            QueueEntry<R> queueEntry;
            JobState state = this.stateMachine.cancelingJob(this.jobId);
            if (state.status() == JobStatus.CANCELING) {
                ComputeEventsFactory.logJobCancelingEvent(this.eventLog, this.eventMetadata);
            }
            if ((queueEntry = this.queueEntry) != null) {
                this.cancel(queueEntry);
                boolean bl = true;
                return bl;
            }
        }
        catch (IllegalJobStatusTransition e) {
            LOG.info("Cannot cancel the job", (Throwable)e);
        }
        finally {
            this.executionLock.unlock();
        }
        return false;
    }

    private void cancel(QueueEntry<R> queueEntry) {
        if (this.executor.remove(queueEntry)) {
            ComputeEventsFactory.logJobCanceledEvent(this.eventLog, this.eventMetadata);
            this.result.cancel(true);
        } else {
            queueEntry.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean changePriority(int newPriority) {
        if (newPriority == this.priority) {
            return false;
        }
        this.executionLock.lock();
        try {
            QueueEntry<R> queueEntry = this.queueEntry;
            if (queueEntry != null && this.executor.removeFromQueue(queueEntry)) {
                this.priority = newPriority;
                this.queueEntry = null;
                this.run();
                boolean bl = true;
                return bl;
            }
            LOG.info("Cannot change job priority, job already processing. [job id = {}]", this.jobId);
        }
        finally {
            this.executionLock.unlock();
        }
        return false;
    }

    void run(int numRetries) {
        this.retries.set(numRetries);
        this.run();
    }

    private void run() {
        QueueEntry queueEntry = new QueueEntry(() -> {
            this.executionLock.lock();
            try {
                if (this.isCanceled()) {
                    throw new QueueEntryCanceledException();
                }
                this.stateMachine.executeJob(this.jobId);
                ComputeEventsFactory.logJobExecutingEvent(this.eventLog, this.eventMetadata);
            }
            finally {
                this.executionLock.unlock();
            }
            return this.job.call();
        }, this.priority);
        this.queueEntry = queueEntry;
        this.executionLock.lock();
        try {
            this.executor.execute(queueEntry);
        }
        catch (QueueOverflowException e) {
            this.result.completeExceptionally(new ComputeException(ErrorGroups.Compute.QUEUE_OVERFLOW_ERR, (Throwable)e));
            return;
        }
        finally {
            this.executionLock.unlock();
        }
        queueEntry.toFuture().whenComplete((r, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof QueueEntryCanceledException) {
                    ComputeEventsFactory.logJobCanceledEvent(this.eventLog, this.eventMetadata);
                    this.result.completeExceptionally(new CancellationException());
                } else if (queueEntry.isInterrupted()) {
                    this.stateMachine.cancelJob(this.jobId);
                    ComputeEventsFactory.logJobCanceledEvent(this.eventLog, this.eventMetadata);
                    this.result.completeExceptionally((Throwable)throwable);
                } else if (this.retries.decrementAndGet() >= 0) {
                    this.stateMachine.queueJob(this.jobId);
                    this.run();
                } else {
                    this.stateMachine.failJob(this.jobId);
                    ComputeEventsFactory.logJobFailedEvent(this.eventLog, this.eventMetadata);
                    this.result.completeExceptionally((Throwable)throwable);
                }
            } else if (queueEntry.isInterrupted()) {
                this.stateMachine.cancelJob(this.jobId);
                ComputeEventsFactory.logJobCanceledEvent(this.eventLog, this.eventMetadata);
                this.result.completeExceptionally(new CancellationException());
            } else {
                this.stateMachine.completeJob(this.jobId);
                ComputeEventsFactory.logJobCompletedEvent(this.eventLog, this.eventMetadata);
                this.result.complete(r);
            }
        });
    }

    private boolean isCanceled() {
        JobState state = this.stateMachine.currentState(this.jobId);
        return state != null && state.status() == JobStatus.CANCELED;
    }
}

