/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.prf;

import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.prf.Prf;
import com.google.crypto.tink.prf.PrfSet;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Immutable
public class PrfSetWrapper
implements PrimitiveWrapper<Prf, PrfSet> {
    @Override
    public PrfSet wrap(PrimitiveSet<Prf> set) throws GeneralSecurityException {
        return new WrappedPrfSet(set);
    }

    @Override
    public Class<PrfSet> getPrimitiveClass() {
        return PrfSet.class;
    }

    @Override
    public Class<Prf> getInputPrimitiveClass() {
        return Prf.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(new PrfSetWrapper());
    }

    private static class WrappedPrfSet
    extends PrfSet {
        private final Map<Integer, Prf> keyIdToPrfMap;
        private final int primaryKeyId;

        private WrappedPrfSet(PrimitiveSet<Prf> primitives) throws GeneralSecurityException {
            if (primitives.getRawPrimitives().isEmpty()) {
                throw new GeneralSecurityException("No primitives provided.");
            }
            if (primitives.getPrimary() == null) {
                throw new GeneralSecurityException("Primary key not set.");
            }
            this.primaryKeyId = primitives.getPrimary().getKeyId();
            List<PrimitiveSet.Entry<Prf>> entries = primitives.getRawPrimitives();
            HashMap<Integer, Prf> mutablePrfMap = new HashMap<Integer, Prf>();
            for (PrimitiveSet.Entry<Prf> entry : entries) {
                if (!entry.getOutputPrefixType().equals((Object)OutputPrefixType.RAW)) {
                    throw new GeneralSecurityException("Key " + entry.getKeyId() + " has non raw prefix type");
                }
                mutablePrfMap.put(entry.getKeyId(), entry.getPrimitive());
            }
            this.keyIdToPrfMap = Collections.unmodifiableMap(mutablePrfMap);
        }

        @Override
        public int getPrimaryId() {
            return this.primaryKeyId;
        }

        @Override
        public Map<Integer, Prf> getPrfs() throws GeneralSecurityException {
            return this.keyIdToPrfMap;
        }
    }
}

