/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.externalresource.ExternalResourceInfo;
import org.apache.flink.api.common.functions.BroadcastVariableInitializer;
import org.apache.flink.api.common.functions.util.AbstractRuntimeUDFContext;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.state.v2.AggregatingState;
import org.apache.flink.api.common.state.v2.ListState;
import org.apache.flink.api.common.state.v2.MapState;
import org.apache.flink.api.common.state.v2.ReducingState;
import org.apache.flink.api.common.state.v2.ValueState;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.state.v2.AggregatingStateDescriptor;
import org.apache.flink.runtime.state.v2.KeyedStateStoreV2;
import org.apache.flink.runtime.state.v2.MapStateDescriptor;
import org.apache.flink.runtime.state.v2.ReducingStateDescriptor;
import org.apache.flink.runtime.state.v2.StateDescriptor;
import org.apache.flink.runtime.taskexecutor.GlobalAggregateManager;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.Preconditions;

@Internal
public class StreamingRuntimeContext
extends AbstractRuntimeUDFContext {
    private final Environment taskEnvironment;
    private final StreamConfig streamConfig;
    private final String operatorUniqueID;
    private final ProcessingTimeService processingTimeService;
    @Nullable
    private KeyedStateStore keyedStateStore;
    @Nullable
    private KeyedStateStoreV2 keyedStateStoreV2;
    private final ExternalResourceInfoProvider externalResourceInfoProvider;

    @VisibleForTesting
    public StreamingRuntimeContext(AbstractStreamOperator<?> operator, Environment env, Map<String, Accumulator<?, ?>> accumulators) {
        this(env, accumulators, operator.getMetricGroup(), operator.getOperatorID(), operator.getProcessingTimeService(), operator.getKeyedStateStore(), env.getExternalResourceInfoProvider());
    }

    public StreamingRuntimeContext(Environment env, Map<String, Accumulator<?, ?>> accumulators, OperatorMetricGroup operatorMetricGroup, OperatorID operatorID, ProcessingTimeService processingTimeService, @Nullable KeyedStateStore keyedStateStore, ExternalResourceInfoProvider externalResourceInfoProvider) {
        super(((Environment)Preconditions.checkNotNull((Object)env)).getJobInfo(), ((Environment)Preconditions.checkNotNull((Object)env)).getTaskInfo(), env.getUserCodeClassLoader(), env.getExecutionConfig(), accumulators, env.getDistributedCacheEntries(), operatorMetricGroup);
        this.taskEnvironment = env;
        this.streamConfig = new StreamConfig(env.getTaskConfiguration());
        this.operatorUniqueID = ((OperatorID)Preconditions.checkNotNull((Object)operatorID)).toString();
        this.processingTimeService = processingTimeService;
        this.keyedStateStore = keyedStateStore;
        this.externalResourceInfoProvider = externalResourceInfoProvider;
    }

    public void setKeyedStateStore(@Nullable KeyedStateStore keyedStateStore) {
        this.keyedStateStore = keyedStateStore;
    }

    public void setKeyedStateStoreV2(@Nullable KeyedStateStoreV2 keyedStateStoreV2) {
        this.keyedStateStoreV2 = keyedStateStoreV2;
    }

    public InputSplitProvider getInputSplitProvider() {
        return this.taskEnvironment.getInputSplitProvider();
    }

    public ProcessingTimeService getProcessingTimeService() {
        return this.processingTimeService;
    }

    public GlobalAggregateManager getGlobalAggregateManager() {
        return this.taskEnvironment.getGlobalAggregateManager();
    }

    public String getOperatorUniqueID() {
        return this.operatorUniqueID;
    }

    public TaskManagerRuntimeInfo getTaskManagerRuntimeInfo() {
        return this.taskEnvironment.getTaskManagerInfo();
    }

    public Configuration getJobConfiguration() {
        return this.taskEnvironment.getJobConfiguration();
    }

    public JobType getJobType() {
        return this.taskEnvironment.getJobType();
    }

    public Set<ExternalResourceInfo> getExternalResourceInfos(String resourceName) {
        return this.externalResourceInfoProvider.getExternalResourceInfos(resourceName);
    }

    public boolean hasBroadcastVariable(String name) {
        throw new UnsupportedOperationException("Broadcast variables can only be used in DataSet programs");
    }

    public <RT> List<RT> getBroadcastVariable(String name) {
        throw new UnsupportedOperationException("Broadcast variables can only be used in DataSet programs");
    }

    public <T, C> C getBroadcastVariableWithInitializer(String name, BroadcastVariableInitializer<T, C> initializer) {
        throw new UnsupportedOperationException("Broadcast variables can only be used in DataSet programs");
    }

    public <T> org.apache.flink.api.common.state.ValueState<T> getState(ValueStateDescriptor<T> stateProperties) {
        KeyedStateStore keyedStateStore = this.checkPreconditionsAndGetKeyedStateStore((org.apache.flink.api.common.state.StateDescriptor<?, ?>)stateProperties);
        stateProperties.initializeSerializerUnlessSet(arg_0 -> ((StreamingRuntimeContext)this).createSerializer(arg_0));
        return keyedStateStore.getState(stateProperties);
    }

    public <T> org.apache.flink.api.common.state.ListState<T> getListState(ListStateDescriptor<T> stateProperties) {
        KeyedStateStore keyedStateStore = this.checkPreconditionsAndGetKeyedStateStore((org.apache.flink.api.common.state.StateDescriptor<?, ?>)stateProperties);
        stateProperties.initializeSerializerUnlessSet(arg_0 -> ((StreamingRuntimeContext)this).createSerializer(arg_0));
        return keyedStateStore.getListState(stateProperties);
    }

    public <T> org.apache.flink.api.common.state.ReducingState<T> getReducingState(org.apache.flink.api.common.state.ReducingStateDescriptor<T> stateProperties) {
        KeyedStateStore keyedStateStore = this.checkPreconditionsAndGetKeyedStateStore((org.apache.flink.api.common.state.StateDescriptor<?, ?>)stateProperties);
        stateProperties.initializeSerializerUnlessSet(arg_0 -> ((StreamingRuntimeContext)this).createSerializer(arg_0));
        return keyedStateStore.getReducingState(stateProperties);
    }

    public <IN, ACC, OUT> org.apache.flink.api.common.state.AggregatingState<IN, OUT> getAggregatingState(org.apache.flink.api.common.state.AggregatingStateDescriptor<IN, ACC, OUT> stateProperties) {
        KeyedStateStore keyedStateStore = this.checkPreconditionsAndGetKeyedStateStore((org.apache.flink.api.common.state.StateDescriptor<?, ?>)stateProperties);
        stateProperties.initializeSerializerUnlessSet(arg_0 -> ((StreamingRuntimeContext)this).createSerializer(arg_0));
        return keyedStateStore.getAggregatingState(stateProperties);
    }

    public <UK, UV> org.apache.flink.api.common.state.MapState<UK, UV> getMapState(org.apache.flink.api.common.state.MapStateDescriptor<UK, UV> stateProperties) {
        KeyedStateStore keyedStateStore = this.checkPreconditionsAndGetKeyedStateStore((org.apache.flink.api.common.state.StateDescriptor<?, ?>)stateProperties);
        stateProperties.initializeSerializerUnlessSet(arg_0 -> ((StreamingRuntimeContext)this).createSerializer(arg_0));
        return keyedStateStore.getMapState(stateProperties);
    }

    private KeyedStateStore checkPreconditionsAndGetKeyedStateStore(org.apache.flink.api.common.state.StateDescriptor<?, ?> stateDescriptor) {
        Preconditions.checkNotNull(stateDescriptor, (String)"The state properties must not be null");
        Preconditions.checkNotNull((Object)this.keyedStateStore, (String)String.format("Keyed state '%s' with type %s can only be used on a 'keyed stream', i.e., after a 'keyBy()' operation.", stateDescriptor.getName(), stateDescriptor.getType()));
        return this.keyedStateStore;
    }

    public <T> ValueState<T> getValueState(org.apache.flink.runtime.state.v2.ValueStateDescriptor<T> stateProperties) {
        KeyedStateStoreV2 keyedStateStoreV2 = this.checkPreconditionsAndGetKeyedStateStoreV2((StateDescriptor<?>)stateProperties);
        return keyedStateStoreV2.getValueState(stateProperties);
    }

    public <T> ListState<T> getListState(org.apache.flink.runtime.state.v2.ListStateDescriptor<T> stateProperties) {
        KeyedStateStoreV2 keyedStateStoreV2 = this.checkPreconditionsAndGetKeyedStateStoreV2((StateDescriptor<?>)stateProperties);
        return keyedStateStoreV2.getListState(stateProperties);
    }

    public <UK, UV> MapState<UK, UV> getMapState(MapStateDescriptor<UK, UV> stateProperties) {
        KeyedStateStoreV2 keyedStateStoreV2 = this.checkPreconditionsAndGetKeyedStateStoreV2((StateDescriptor<?>)stateProperties);
        return keyedStateStoreV2.getMapState(stateProperties);
    }

    public <T> ReducingState<T> getReducingState(ReducingStateDescriptor<T> stateProperties) {
        KeyedStateStoreV2 keyedStateStoreV2 = this.checkPreconditionsAndGetKeyedStateStoreV2((StateDescriptor<?>)stateProperties);
        return keyedStateStoreV2.getReducingState(stateProperties);
    }

    public <IN, ACC, OUT> AggregatingState<IN, OUT> getAggregatingState(AggregatingStateDescriptor<IN, ACC, OUT> stateProperties) {
        KeyedStateStoreV2 keyedStateStoreV2 = this.checkPreconditionsAndGetKeyedStateStoreV2((StateDescriptor<?>)stateProperties);
        return keyedStateStoreV2.getAggregatingState(stateProperties);
    }

    private KeyedStateStoreV2 checkPreconditionsAndGetKeyedStateStoreV2(StateDescriptor<?> stateDescriptor) {
        Preconditions.checkNotNull(stateDescriptor, (String)"The state properties must not be null");
        Preconditions.checkNotNull((Object)this.keyedStateStoreV2, (String)String.format("Keyed state '%s' with type %s can only be used on a 'keyed stream', i.e., after a 'keyBy()' operation.", stateDescriptor.getStateId(), stateDescriptor.getType()));
        return this.keyedStateStoreV2;
    }

    public boolean isCheckpointingEnabled() {
        return this.streamConfig.isCheckpointingEnabled();
    }
}

