/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.TableFormat;
import org.apache.amoro.config.OptimizingConfig;
import org.apache.amoro.optimizing.MetricsSummary;
import org.apache.amoro.optimizing.plan.AbstractOptimizingEvaluator;
import org.apache.amoro.server.dashboard.model.TableOptimizingInfo;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.optimizing.OptimizingTaskMeta;
import org.apache.amoro.server.optimizing.TaskRuntime;
import org.apache.amoro.server.persistence.TableRuntimeMeta;
import org.apache.amoro.table.descriptor.FilesStatistics;
import org.apache.iceberg.ContentFile;

public class OptimizingUtil {
    public static TableOptimizingInfo buildTableOptimizeInfo(TableRuntimeMeta optimizingTableRuntime, List<OptimizingTaskMeta> processTasks, List<TaskRuntime.TaskQuota> quotas) {
        FilesStatistics optimizeFileInfo;
        ServerTableIdentifier identifier = ServerTableIdentifier.of((Long)optimizingTableRuntime.getTableId(), (String)optimizingTableRuntime.getCatalogName(), (String)optimizingTableRuntime.getDbName(), (String)optimizingTableRuntime.getTableName(), (TableFormat)optimizingTableRuntime.getFormat());
        TableOptimizingInfo tableOptimizeInfo = new TableOptimizingInfo(identifier);
        OptimizingStatus optimizingStatus = optimizingTableRuntime.getTableStatus();
        tableOptimizeInfo.setOptimizeStatus(optimizingStatus.displayValue());
        tableOptimizeInfo.setDuration(System.currentTimeMillis() - optimizingTableRuntime.getCurrentStatusStartTime());
        OptimizingConfig optimizingConfig = optimizingTableRuntime.getTableConfig().getOptimizingConfig();
        tableOptimizeInfo.setQuota(optimizingConfig.getTargetQuota());
        double quotaOccupy = OptimizingUtil.calculateQuotaOccupy(processTasks, quotas, optimizingTableRuntime.getCurrentStatusStartTime(), System.currentTimeMillis());
        tableOptimizeInfo.setQuotaOccupation(quotaOccupy);
        if (optimizingStatus.isProcessing()) {
            MetricsSummary summary = null;
            if (processTasks != null && !processTasks.isEmpty()) {
                List taskSummary = processTasks.stream().map(OptimizingTaskMeta::getMetricsSummary).collect(Collectors.toList());
                summary = new MetricsSummary(taskSummary);
            }
            optimizeFileInfo = OptimizingUtil.collectOptimizingFileInfo(summary);
        } else {
            optimizeFileInfo = optimizingStatus == OptimizingStatus.PENDING ? OptimizingUtil.collectPendingFileInfo(optimizingTableRuntime.getPendingInput()) : null;
        }
        if (optimizeFileInfo != null) {
            tableOptimizeInfo.setFileCount(optimizeFileInfo.getFileCnt());
            tableOptimizeInfo.setFileSize(optimizeFileInfo.getTotalSize());
        }
        tableOptimizeInfo.setGroupName(optimizingTableRuntime.getOptimizerGroup());
        return tableOptimizeInfo;
    }

    private static double calculateQuotaOccupy(List<OptimizingTaskMeta> processTasks, List<TaskRuntime.TaskQuota> quotas, long startTime, long endTime) {
        double finishedOccupy = 0.0;
        if (quotas != null) {
            finishedOccupy = quotas.stream().mapToDouble(q -> q.getQuotaTime(startTime)).sum();
        }
        double runningOccupy = 0.0;
        if (processTasks != null) {
            runningOccupy = processTasks.stream().mapToDouble(t -> TaskRuntime.taskRunningQuotaTime(startTime, endTime, t.getStartTime(), t.getCostTime())).sum();
        }
        return finishedOccupy + runningOccupy;
    }

    private static FilesStatistics collectPendingFileInfo(AbstractOptimizingEvaluator.PendingInput pendingInput) {
        if (pendingInput == null) {
            return null;
        }
        return FilesStatistics.builder().addFiles(pendingInput.getDataFileSize(), pendingInput.getDataFileCount()).addFiles(pendingInput.getEqualityDeleteBytes(), pendingInput.getEqualityDeleteFileCount()).addFiles(pendingInput.getPositionalDeleteBytes(), pendingInput.getPositionalDeleteFileCount()).build();
    }

    private static FilesStatistics collectOptimizingFileInfo(MetricsSummary metricsSummary) {
        if (metricsSummary == null) {
            return null;
        }
        return FilesStatistics.builder().addFiles(metricsSummary.getEqualityDeleteSize(), metricsSummary.getEqDeleteFileCnt()).addFiles(Math.max(metricsSummary.getPositionalDeleteSize(), metricsSummary.getPositionDeleteSize()), metricsSummary.getPosDeleteFileCnt()).addFiles(metricsSummary.getRewriteDataSize(), metricsSummary.getRewriteDataFileCnt()).build();
    }

    public static long getFileSize(ContentFile<?>[] contentFiles) {
        long size = 0L;
        if (contentFiles != null) {
            for (ContentFile<?> contentFile : contentFiles) {
                size += contentFile.fileSizeInBytes();
            }
        }
        return size;
    }

    public static int getFileCount(ContentFile<?>[] contentFiles) {
        return contentFiles == null ? 0 : contentFiles.length;
    }

    public static long getRecordCnt(ContentFile<?>[] contentFiles) {
        int recordCnt = 0;
        if (contentFiles != null) {
            for (ContentFile<?> contentFile : contentFiles) {
                recordCnt = (int)((long)recordCnt + contentFile.recordCount());
            }
        }
        return recordCnt;
    }
}

