/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized;

import org.apache.arrow.vector.ValueVector;

public class ArrowVectorAccessor<DecimalT, Utf8StringT, ArrayT, ChildVectorT extends AutoCloseable>
implements AutoCloseable {
    private final ValueVector vector;
    private final ChildVectorT[] childColumns;

    protected ArrowVectorAccessor(ValueVector vector) {
        this(vector, null);
    }

    protected ArrowVectorAccessor(ValueVector vector, ChildVectorT[] children) {
        this.vector = vector;
        this.childColumns = children;
    }

    @Override
    public void close() {
        if (this.childColumns != null) {
            for (ChildVectorT column : this.childColumns) {
                try {
                    column.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.vector.close();
    }

    public boolean getBoolean(int rowId) {
        throw new UnsupportedOperationException("Unsupported type: boolean");
    }

    public int getInt(int rowId) {
        throw new UnsupportedOperationException("Unsupported type: int");
    }

    public long getLong(int rowId) {
        throw new UnsupportedOperationException("Unsupported type: long");
    }

    public float getFloat(int rowId) {
        throw new UnsupportedOperationException("Unsupported type: float");
    }

    public double getDouble(int rowId) {
        throw new UnsupportedOperationException("Unsupported type: double");
    }

    public byte[] getBinary(int rowId) {
        throw new UnsupportedOperationException("Unsupported type: binary");
    }

    public DecimalT getDecimal(int rowId, int precision, int scale) {
        throw new UnsupportedOperationException("Unsupported type: decimal");
    }

    public Utf8StringT getUTF8String(int rowId) {
        throw new UnsupportedOperationException("Unsupported type: UTF8String");
    }

    public ArrayT getArray(int rowId) {
        throw new UnsupportedOperationException("Unsupported type: array");
    }

    public ChildVectorT childColumn(int pos) {
        if (this.childColumns != null) {
            return this.childColumns[pos];
        }
        throw new IndexOutOfBoundsException("Child columns is null hence cannot find index: " + pos);
    }

    public final ValueVector getVector() {
        return this.vector;
    }
}

