/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizing.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.config.OptimizingConfig;
import org.apache.amoro.data.DataFileType;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.data.PrimaryKeyedFile;
import org.apache.amoro.optimizing.MixedIcebergRewriteExecutorFactory;
import org.apache.amoro.optimizing.OptimizingInputProperties;
import org.apache.amoro.optimizing.plan.AbstractPartitionPlan;
import org.apache.amoro.optimizing.plan.CommonPartitionEvaluator;
import org.apache.amoro.optimizing.plan.PartitionEvaluator;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.util.Pair;

public class MixedIcebergPartitionPlan
extends AbstractPartitionPlan {
    protected final Map<String, String> partitionProperties;

    public MixedIcebergPartitionPlan(ServerTableIdentifier identifier, MixedTable table, OptimizingConfig config, Pair<Integer, StructLike> partition, long planTime, long lastMinorOptimizingTime, long lastFullOptimizingTime) {
        super(identifier, table, config, partition, planTime, lastMinorOptimizingTime, lastFullOptimizingTime);
        this.partitionProperties = TablePropertyUtil.getPartitionProperties(table, (StructLike)partition.second());
    }

    @Override
    public boolean addFile(DataFile dataFile, List<ContentFile<?>> deletes) {
        if (!super.addFile(dataFile, deletes)) {
            return false;
        }
        if (this.evaluator().isChangeFile(dataFile)) {
            this.markSequence(dataFile.dataSequenceNumber());
        }
        for (ContentFile<?> deleteFile : deletes) {
            if (deleteFile.content() != FileContent.DATA) continue;
            this.markSequence(deleteFile.dataSequenceNumber());
        }
        return true;
    }

    @Override
    protected MixedIcebergPartitionEvaluator evaluator() {
        return (MixedIcebergPartitionEvaluator)super.evaluator();
    }

    @Override
    protected OptimizingInputProperties buildTaskProperties() {
        OptimizingInputProperties properties = new OptimizingInputProperties();
        properties.setExecutorFactoryImpl(MixedIcebergRewriteExecutorFactory.class.getName());
        return properties;
    }

    protected boolean isKeyedTable() {
        return this.tableObject.isKeyedTable();
    }

    @Override
    protected AbstractPartitionPlan.TaskSplitter buildTaskSplitter() {
        if (this.isKeyedTable()) {
            return new TreeNodeTaskSplitter();
        }
        return new AbstractPartitionPlan.BinPackingTaskSplitter();
    }

    @Override
    protected CommonPartitionEvaluator buildEvaluator() {
        return new MixedIcebergPartitionEvaluator(this.identifier, this.config, (Pair<Integer, StructLike>)this.partition, this.partitionProperties, this.planTime, this.isKeyedTable(), this.lastMinorOptimizingTime, this.lastFullOptimizingTime);
    }

    private static class SplitIfNoFileExists
    implements Predicate<FileTree> {
        @Override
        public boolean test(FileTree fileTree) {
            return !fileTree.isLeaf() && fileTree.isRootEmpty();
        }
    }

    private static class FileTree {
        private final DataTreeNode node;
        private final Map<DataFile, List<ContentFile<?>>> rewriteDataFiles = Maps.newHashMap();
        private final Map<DataFile, List<ContentFile<?>>> rewritePosDataFiles = Maps.newHashMap();
        private FileTree left;
        private FileTree right;

        public FileTree(DataTreeNode node) {
            this.node = node;
        }

        public static FileTree newTreeRoot() {
            return new FileTree(DataTreeNode.of(0L, 0L));
        }

        private FileTree putNodeIfAbsent(@Nonnull DataTreeNode newNode) {
            if (newNode.equals(this.node)) {
                return this;
            }
            if (newNode.isSonOf(this.node.left())) {
                if (this.left == null) {
                    this.left = new FileTree(this.node.left());
                }
                return this.left.putNodeIfAbsent(newNode);
            }
            if (newNode.isSonOf(this.node.right())) {
                if (this.right == null) {
                    this.right = new FileTree(this.node.right());
                }
                return this.right.putNodeIfAbsent(newNode);
            }
            throw new IllegalArgumentException(newNode + " is not son of " + this.node);
        }

        public void splitFileTree(List<FileTree> collector, Predicate<FileTree> canSplit) {
            if (canSplit.test(this)) {
                if (this.left != null) {
                    this.left.splitFileTree(collector, canSplit);
                }
                if (this.right != null) {
                    this.right.splitFileTree(collector, canSplit);
                }
            } else {
                collector.add(this);
            }
        }

        public void collectRewriteDataFiles(Map<DataFile, List<ContentFile<?>>> collector) {
            collector.putAll(this.rewriteDataFiles);
            if (this.left != null) {
                this.left.collectRewriteDataFiles(collector);
            }
            if (this.right != null) {
                this.right.collectRewriteDataFiles(collector);
            }
        }

        public void collectRewritePosDataFiles(Map<DataFile, List<ContentFile<?>>> collector) {
            collector.putAll(this.rewritePosDataFiles);
            if (this.left != null) {
                this.left.collectRewritePosDataFiles(collector);
            }
            if (this.right != null) {
                this.right.collectRewritePosDataFiles(collector);
            }
        }

        public void addRewritePosDataFile(DataFile file, List<ContentFile<?>> deleteFiles) {
            PrimaryKeyedFile primaryKeyedFile = (PrimaryKeyedFile)file;
            FileTree node = this.putNodeIfAbsent(primaryKeyedFile.node());
            node.rewritePosDataFiles.put(file, deleteFiles);
        }

        public void addRewriteDataFile(DataFile file, List<ContentFile<?>> deleteFiles) {
            PrimaryKeyedFile primaryKeyedFile = (PrimaryKeyedFile)file;
            FileTree node = this.putNodeIfAbsent(primaryKeyedFile.node());
            node.rewriteDataFiles.put(file, deleteFiles);
        }

        public boolean isRootEmpty() {
            return this.rewritePosDataFiles.isEmpty() && this.rewriteDataFiles.isEmpty();
        }

        public boolean isLeaf() {
            return this.left == null && this.right == null;
        }

        public void completeTree() {
            this.completeTree(false);
        }

        private void completeTree(boolean ancestorFileExist) {
            boolean thisNodeMustBalance;
            if (this.left == null && this.right == null) {
                return;
            }
            boolean bl = thisNodeMustBalance = ancestorFileExist || this.fileExist();
            if (thisNodeMustBalance) {
                if (this.left == null) {
                    this.left = new FileTree(this.node.left());
                }
                if (this.right == null) {
                    this.right = new FileTree(this.node.right());
                }
            }
            if (this.left != null) {
                this.left.completeTree(ancestorFileExist || this.fileExist());
            }
            if (this.right != null) {
                this.right.completeTree(ancestorFileExist || this.fileExist());
            }
        }

        private boolean fileExist() {
            return !this.rewritePosDataFiles.isEmpty() || !this.rewriteDataFiles.isEmpty();
        }
    }

    private class TreeNodeTaskSplitter
    implements AbstractPartitionPlan.TaskSplitter {
        private TreeNodeTaskSplitter() {
        }

        @Override
        public List<AbstractPartitionPlan.SplitTask> splitTasks(int targetTaskCount) {
            ArrayList result = Lists.newArrayList();
            FileTree rootTree = FileTree.newTreeRoot();
            MixedIcebergPartitionPlan.this.undersizedSegmentFiles.forEach(rootTree::addRewriteDataFile);
            for (AbstractPartitionPlan.SplitTask splitTask : this.genSplitTasks(rootTree)) {
                if (splitTask.getRewriteDataFiles().size() > 1) {
                    result.add(splitTask);
                    continue;
                }
                MixedIcebergPartitionPlan.this.disposeUndersizedSegmentFile(splitTask);
            }
            rootTree = FileTree.newTreeRoot();
            MixedIcebergPartitionPlan.this.rewritePosDataFiles.forEach(rootTree::addRewritePosDataFile);
            MixedIcebergPartitionPlan.this.rewriteDataFiles.forEach(rootTree::addRewriteDataFile);
            result.addAll(this.genSplitTasks(rootTree));
            return result;
        }

        private Collection<? extends AbstractPartitionPlan.SplitTask> genSplitTasks(FileTree rootTree) {
            ArrayList result = Lists.newArrayList();
            rootTree.completeTree();
            ArrayList subTrees = Lists.newArrayList();
            rootTree.splitFileTree(subTrees, new SplitIfNoFileExists());
            for (FileTree subTree : subTrees) {
                HashMap rewriteDataFiles = Maps.newHashMap();
                HashMap rewritePosDataFiles = Maps.newHashMap();
                HashSet deleteFiles = Sets.newHashSet();
                subTree.collectRewriteDataFiles(rewriteDataFiles);
                subTree.collectRewritePosDataFiles(rewritePosDataFiles);
                if (rewriteDataFiles.size() == 0 && rewritePosDataFiles.size() == 0) continue;
                rewriteDataFiles.forEach((f, deletes) -> deleteFiles.addAll(deletes));
                rewritePosDataFiles.forEach((f, deletes) -> deleteFiles.addAll(deletes));
                result.add(new AbstractPartitionPlan.SplitTask(rewriteDataFiles.keySet(), rewritePosDataFiles.keySet(), deleteFiles));
            }
            return result;
        }
    }

    public static class MixedIcebergPartitionEvaluator
    extends CommonPartitionEvaluator {
        protected final boolean keyedTable;
        protected boolean hasChangeFiles = false;
        private final boolean reachBaseRefreshInterval;

        public MixedIcebergPartitionEvaluator(ServerTableIdentifier identifier, OptimizingConfig config, Pair<Integer, StructLike> partition, Map<String, String> partitionProperties, long planTime, boolean keyedTable, long lastMinorOptimizingTime, long lastFullOptimizingTime) {
            super(identifier, config, partition, planTime, lastMinorOptimizingTime, lastFullOptimizingTime);
            this.keyedTable = keyedTable;
            String optimizedTime = partitionProperties.get("base-op-time");
            long lastBaseOptimizedTime = optimizedTime == null ? 0L : Long.parseLong(optimizedTime);
            this.reachBaseRefreshInterval = config.getBaseRefreshInterval() >= 0L && planTime - lastBaseOptimizedTime > config.getBaseRefreshInterval();
        }

        @Override
        public boolean addFile(DataFile dataFile, List<ContentFile<?>> deletes) {
            if (!super.addFile(dataFile, deletes)) {
                return false;
            }
            if (!this.hasChangeFiles && this.isChangeFile(dataFile)) {
                this.hasChangeFiles = true;
            }
            return true;
        }

        protected boolean isChangeFile(DataFile dataFile) {
            if (!this.keyedTable) {
                return false;
            }
            PrimaryKeyedFile file = (PrimaryKeyedFile)dataFile;
            return file.type() == DataFileType.INSERT_FILE || file.type() == DataFileType.EQ_DELETE_FILE;
        }

        @Override
        protected boolean isFragmentFile(DataFile dataFile) {
            PrimaryKeyedFile file = (PrimaryKeyedFile)dataFile;
            if (file.type() == DataFileType.BASE_FILE) {
                return dataFile.fileSizeInBytes() <= this.fragmentSize;
            }
            if (file.type() == DataFileType.INSERT_FILE) {
                return true;
            }
            throw new IllegalStateException("unexpected file type " + (Object)((Object)file.type()) + " of " + file);
        }

        @Override
        protected boolean isUndersizedSegmentFile(DataFile dataFile) {
            PrimaryKeyedFile file = (PrimaryKeyedFile)dataFile;
            if (file.type() == DataFileType.BASE_FILE) {
                return dataFile.fileSizeInBytes() <= this.minTargetSize;
            }
            throw new IllegalStateException("unexpected file type " + (Object)((Object)file.type()) + " of " + file);
        }

        @Override
        public boolean isMinorNecessary() {
            if (this.keyedTable) {
                int smallFileCount = this.fragmentFileCount + this.equalityDeleteFileCount;
                int baseSplitCount = this.getBaseSplitCount();
                if (smallFileCount >= Math.max(baseSplitCount + 1, this.config.getMinorLeastFileCount())) {
                    return true;
                }
                if ((smallFileCount > baseSplitCount || this.hasChangeFiles) && this.reachMinorInterval()) {
                    return true;
                }
                return this.hasChangeFiles && this.reachBaseRefreshInterval();
            }
            return super.isMinorNecessary();
        }

        @Override
        public boolean segmentShouldRewritePos(DataFile dataFile, List<ContentFile<?>> deletes) {
            if (deletes.stream().anyMatch(delete -> delete.content() == FileContent.EQUALITY_DELETES || delete.content() == FileContent.DATA)) {
                return true;
            }
            return deletes.stream().filter(delete -> delete.content() == FileContent.POSITION_DELETES).count() >= 2L;
        }

        protected boolean reachBaseRefreshInterval() {
            return this.reachBaseRefreshInterval;
        }

        protected int getBaseSplitCount() {
            if (this.keyedTable) {
                return this.config.getBaseHashBucket();
            }
            return 1;
        }

        @Override
        public boolean isFullNecessary() {
            if (!this.reachFullInterval()) {
                return false;
            }
            return this.anyDeleteExist() || this.fragmentFileCount > this.getBaseSplitCount() || this.hasChangeFiles;
        }

        @Override
        public PartitionEvaluator.Weight getWeight() {
            return new Weight(this.getCost(), this.hasChangeFiles && this.reachBaseRefreshInterval());
        }

        protected static class Weight
        implements PartitionEvaluator.Weight {
            private final long cost;
            private final boolean reachDelay;

            public Weight(long cost, boolean reachDelay) {
                this.cost = cost;
                this.reachDelay = reachDelay;
            }

            @Override
            public int compareTo(PartitionEvaluator.Weight o) {
                Weight that = (Weight)o;
                int compare = Boolean.compare(this.reachDelay, that.reachDelay);
                if (compare != 0) {
                    return compare;
                }
                return Long.compare(this.cost, that.cost);
            }
        }
    }
}

