/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils.map;

import javax.annotation.Nullable;
import org.apache.amoro.utils.SerializationUtil;
import org.apache.amoro.utils.map.DefaultSizeEstimator;
import org.apache.amoro.utils.map.SimpleMap;
import org.apache.amoro.utils.map.SimpleSpillableMap;
import org.apache.amoro.utils.map.StructLikeBaseMap;
import org.apache.amoro.utils.map.StructLikeWrapperSerializer;
import org.apache.amoro.utils.map.StructLikeWrapperSizeEstimator;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;

public class StructLikeSpillableMap<T>
extends StructLikeBaseMap<T> {
    private final SimpleMap<StructLikeWrapper, T> wrapperMap;

    public static <T> StructLikeSpillableMap<T> create(Types.StructType type, Long maxInMemorySizeInBytes, @Nullable String backendBaseDir) {
        return new StructLikeSpillableMap<T>(type, maxInMemorySizeInBytes, backendBaseDir);
    }

    private StructLikeSpillableMap(Types.StructType type, Long maxInMemorySizeInBytes, @Nullable String backendBaseDir) {
        super(type);
        this.wrapperMap = new SimpleSpillableMap(maxInMemorySizeInBytes, backendBaseDir, new StructLikeWrapperSerializer(this.structLikeWrapper), SerializationUtil.createJavaSimpleSerializer(), new StructLikeWrapperSizeEstimator(), new DefaultSizeEstimator());
    }

    @Override
    protected SimpleMap<StructLikeWrapper, T> getInternalMap() {
        return this.wrapperMap;
    }
}

