/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(col, percentage [, accuracy]) - Returns the approximate `percentile` of the numeric or\n      ansi interval column `col` which is the smallest value in the ordered `col` values (sorted\n      from least to greatest) such that no more than `percentage` of `col` values is less than\n      the value or equal to that value. The value of percentage must be between 0.0 and 1.0.\n      The `accuracy` parameter (default: 10000) is a positive numeric literal which controls\n      approximation accuracy at the cost of memory. Higher value of `accuracy` yields better\n      accuracy, `1.0/accuracy` is the relative error of the approximation.\n      When `percentage` is an array, each value of the percentage array must be between 0.0 and 1.0.\n      In this case, returns the approximate percentile array of column `col` at the given\n      percentage array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(col, array(0.5, 0.4, 0.1), 100) FROM VALUES (0), (1), (2), (10) AS tab(col);\n       [1,1,0]\n      > SELECT _FUNC_(col, 0.5, 100) FROM VALUES (0), (6), (7), (9), (10) AS tab(col);\n       7\n      > SELECT _FUNC_(col, 0.5, 100) FROM VALUES (INTERVAL '0' MONTH), (INTERVAL '1' MONTH), (INTERVAL '2' MONTH), (INTERVAL '10' MONTH) AS tab(col);\n       0-1\n      > SELECT _FUNC_(col, array(0.5, 0.7), 100) FROM VALUES (INTERVAL '0' SECOND), (INTERVAL '1' SECOND), (INTERVAL '2' SECOND), (INTERVAL '10' SECOND) AS tab(col);\n       [0 00:00:01.000000000,0 00:00:02.000000000]\n  ", group="agg_funcs", since="2.1.0")
@ScalaSignature(bytes="\u0006\u0001\r%d\u0001B&M\u0001nC!\"a/\u0001\u0005+\u0007I\u0011\u0001B\u000b\u0011)\u00119\u0002\u0001B\tB\u0003%\u0011Q\u0018\u0005\u000b\u0003\u000f\u0004!Q3A\u0005\u0002\tU\u0001B\u0003B\r\u0001\tE\t\u0015!\u0003\u0002>\"Q\u00111\u001a\u0001\u0003\u0016\u0004%\tA!\u0006\t\u0015\tm\u0001A!E!\u0002\u0013\ti\f\u0003\u0006\u0002P\u0002\u0011)\u001a!C!\u0003\u000bA!B!\b\u0001\u0005#\u0005\u000b\u0011BA\u0004\u0011)\t\u0019\u000e\u0001BK\u0002\u0013\u0005\u0013Q\u0001\u0005\u000b\u0005?\u0001!\u0011#Q\u0001\n\u0005\u001d\u0001BB@\u0001\t\u0003\u0011\t\u0003\u0003\u0004\u0000\u0001\u0011\u0005!Q\u0006\u0005\u0007\u007f\u0002!\tA!\u000e\t\u0015\tm\u0002\u0001#b\u0001\n\u0013\u0011i\u0004C\u0004\u0003F\u0001!\tEa\u0012\t\u0019\u0005=\u0002\u0001%A\t\b\u0004&IAa\u0016\t\u0015\t}\u0003\u0001#b\u0001\n\u0013\tI\u0005\u0003\u0006\u0002|\u0001A)\u0019!C\u0005\u0005CBqAa\u0019\u0001\t\u0003\u0012)\u0007C\u0004\u0003t\u0001!\tE!\u001e\t\u000f\t]\u0004\u0001\"\u0011\u0003z!9\u00111\f\u0001\u0005B\t-\u0005b\u0002BI\u0001\u0011\u0005#1\u0013\u0005\b\u0005;\u0003A\u0011\tBP\u0011\u001d\u0011)\u000b\u0001C!\u0005OCqAa+\u0001\t\u0003\u0012)\u0002C\u0004\u0003.\u0002!\tE!\u0006\t\u000f\t=\u0006\u0001\"\u0011\u0003\u0016!9!\u0011\u0017\u0001\u0005B\u0005%\u0003B\u0003BZ\u0001!\u0015\r\u0011\"\u0003\u00036\"9!Q\u0018\u0001\u0005B\tU\u0006b\u0002B`\u0001\u0011\u0005#\u0011\u0019\u0005\b\u0003+\u0003A\u0011\tBj\u0011\u001d\t)\u000b\u0001C!\u0005/DqAa7\u0001\t#\u0012i\u000eC\u0005\u0003l\u0002\t\t\u0011\"\u0001\u0003n\"I!\u0011 \u0001\u0012\u0002\u0013\u0005!1 \u0005\n\u0007#\u0001\u0011\u0013!C\u0001\u0005wD\u0011ba\u0005\u0001#\u0003%\tAa?\t\u0013\rU\u0001!%A\u0005\u0002\r]\u0001\"CB\u000e\u0001E\u0005I\u0011AB\f\u0011%\u0019i\u0002AA\u0001\n\u0003\u001ay\u0002C\u0005\u0004&\u0001\t\t\u0011\"\u0001\u0002\u0006!I1q\u0005\u0001\u0002\u0002\u0013\u00051\u0011\u0006\u0005\n\u0007[\u0001\u0011\u0011!C!\u0007_A\u0011b!\u0010\u0001\u0003\u0003%\taa\u0010\t\u0013\r\r\u0003!!A\u0005B\r\u0015s!B:M\u0011\u0003!h!B&M\u0011\u0003)\bBB@2\t\u0003\t\t\u0001C\u0005\u0002\u0004E\u0012\r\u0011\"\u0001\u0002\u0006!A\u0011QB\u0019!\u0002\u0013\t9A\u0002\u0004\u0002\u0010E\u0002\u0011\u0011\u0003\u0005\u000b\u0003')$\u00111A\u0005\n\u0005U\u0001BCA\u0012k\t\u0005\r\u0011\"\u0003\u0002&!Q\u0011\u0011G\u001b\u0003\u0002\u0003\u0006K!a\u0006\t\r},D\u0011AA\u001a\u0011\u0019yX\u0007\"\u0001\u0002<!A\u0011qI\u001b\u0005\u0002I\u000bI\u0005C\u0004\u0002RU\"\t!!\u0006\t\u000f\u0005MS\u0007\"\u0001\u0002V!9\u00111L\u001b\u0005\u0002\u0005u\u0003bBA2k\u0011\u0005\u0011Q\r\u0005\b\u0003\u0007+DQBAC\r\u0019\t9)\r\u0001\u0002\n\"1q0\u0011C\u0001\u0003\u0017Cq!a$B\t\u001b\t\t\nC\u0004\u0002\u0016\u0006#)!a&\t\u000f\u0005\u0015\u0016\t\"\u0002\u0002(\"I\u0011QV\u0019C\u0002\u0013\u0005\u0011q\u0016\u0005\t\u0003c\u000b\u0004\u0015!\u0003\u0002\u000e\"I\u00111W\u0019\u0002\u0002\u0013\u0005\u0015Q\u0017\u0005\n\u0003+\f\u0014\u0011!CA\u0003/D\u0011\"!;2\u0003\u0003%I!a;\u0003+\u0005\u0003\bO]8yS6\fG/\u001a)fe\u000e,g\u000e^5mK*\u0011QJT\u0001\nC\u001e<'/Z4bi\u0016T!a\u0014)\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003#J\u000b\u0001bY1uC2L8\u000f\u001e\u0006\u0003'R\u000b1a]9m\u0015\t)f+A\u0003ta\u0006\u00148N\u0003\u0002X1\u00061\u0011\r]1dQ\u0016T\u0011!W\u0001\u0004_J<7\u0001A\n\n\u0001q\u000biPa\u0001\u0003\u0010q\u00042!\u00180a\u001b\u0005a\u0015BA0M\u0005a!\u0016\u0010]3e\u00136\u0004XM]1uSZ,\u0017iZ4sK\u001e\fG/\u001a\t\u0003CVr!A\u0019\u0019\u000f\u0005\r\u0014hB\u00013r\u001d\t)\u0007O\u0004\u0002g_:\u0011qM\u001c\b\u0003Q6t!!\u001b7\u000e\u0003)T!a\u001b.\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0016BA,Y\u0013\t)f+\u0003\u0002T)&\u0011\u0011KU\u0005\u0003\u001fBK!!\u0014(\u0002+\u0005\u0003\bO]8yS6\fG/\u001a)fe\u000e,g\u000e^5mKB\u0011Q,M\n\u0004cYd\bCA<{\u001b\u0005A(\"A=\u0002\u000bM\u001c\u0017\r\\1\n\u0005mD(AB!osJ+g\r\u0005\u0002x{&\u0011a\u0010\u001f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\f1\u0004R#G\u0003VcEk\u0018)F%\u000e+e\nV%M\u000b~\u000b5iQ+S\u0003\u000eKVCAA\u0004!\r9\u0018\u0011B\u0005\u0004\u0003\u0017A(aA%oi\u0006aB)\u0012$B+2#v\fU#S\u0007\u0016sE+\u0013'F?\u0006\u001b5)\u0016*B\u0007f\u0003#\u0001\u0005)fe\u000e,g\u000e^5mK\u0012Kw-Z:u'\t)d/A\u0005tk6l\u0017M]5fgV\u0011\u0011q\u0003\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011Q\u0004)\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003C\tYBA\tRk\u0006tG/\u001b7f'VlW.\u0019:jKN\fQb];n[\u0006\u0014\u0018.Z:`I\u0015\fH\u0003BA\u0014\u0003[\u00012a^A\u0015\u0013\r\tY\u0003\u001f\u0002\u0005+:LG\u000fC\u0005\u00020]\n\t\u00111\u0001\u0002\u0018\u0005\u0019\u0001\u0010J\u0019\u0002\u0015M,X.\\1sS\u0016\u001c\b\u0005\u0006\u0003\u00026\u0005e\u0002cAA\u001ck5\t\u0011\u0007C\u0004\u0002\u0014e\u0002\r!a\u0006\u0015\t\u0005U\u0012Q\b\u0005\b\u0003\u007fQ\u0004\u0019AA!\u00035\u0011X\r\\1uSZ,WI\u001d:peB\u0019q/a\u0011\n\u0007\u0005\u0015\u0003P\u0001\u0004E_V\u0014G.Z\u0001\rSN\u001cu.\u001c9sKN\u001cX\rZ\u000b\u0003\u0003\u0017\u00022a^A'\u0013\r\ty\u0005\u001f\u0002\b\u0005>|G.Z1o\u0003E\tX/\u00198uS2,7+^7nCJLWm]\u0001\u0004C\u0012$G\u0003BA\u0014\u0003/Bq!!\u0017>\u0001\u0004\t\t%A\u0003wC2,X-A\u0003nKJ<W\r\u0006\u0003\u0002(\u0005}\u0003bBA1}\u0001\u0007\u0011QG\u0001\u0006_RDWM]\u0001\u000fO\u0016$\b+\u001a:dK:$\u0018\u000e\\3t)\u0011\t9'!\u001f\u0011\r\u0005%\u00141OA!\u001d\u0011\tY'a\u001c\u000f\u0007%\fi'C\u0001z\u0013\r\t\t\b_\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)(a\u001e\u0003\u0007M+\u0017OC\u0002\u0002raDq!a\u001f@\u0001\u0004\ti(A\u0006qKJ\u001cWM\u001c;bO\u0016\u001c\b#B<\u0002\u0000\u0005\u0005\u0013bAAAq\n)\u0011I\u001d:bs\u0006A1m\\7qe\u0016\u001c8\u000f\u0006\u0002\u0002(\tQ\u0002+\u001a:dK:$\u0018\u000e\\3ES\u001e,7\u000f^*fe&\fG.\u001b>feN\u0011\u0011I\u001e\u000b\u0003\u0003\u001b\u00032!a\u000eB\u0003\u0019aWM\\4uQR!\u0011qAAJ\u0011\u001d\t\u0019b\u0011a\u0001\u0003/\t\u0011b]3sS\u0006d\u0017N_3\u0015\t\u0005e\u0015\u0011\u0015\t\u0006o\u0006}\u00141\u0014\t\u0004o\u0006u\u0015bAAPq\n!!)\u001f;f\u0011\u001d\t\u0019\u000b\u0012a\u0001\u0003k\t1a\u001c2k\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\t\u0005U\u0012\u0011\u0016\u0005\b\u0003W+\u0005\u0019AAM\u0003\u0015\u0011\u0017\u0010^3t\u0003)\u0019XM]5bY&TXM]\u000b\u0003\u0003\u001b\u000b1b]3sS\u0006d\u0017N_3sA\u0005)\u0011\r\u001d9msRa\u0011qWA]\u0003\u000b\fI-!4\u0002RB\u0011Q\f\u0001\u0005\b\u0003wC\u0005\u0019AA_\u0003\u0015\u0019\u0007.\u001b7e!\u0011\ty,!1\u000e\u00039K1!a1O\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\b\u0003\u000fD\u0005\u0019AA_\u0003Q\u0001XM]2f]R\fw-Z#yaJ,7o]5p]\"9\u00111\u001a%A\u0002\u0005u\u0016AE1dGV\u0014\u0018mY=FqB\u0014Xm]:j_:Dq!a4I\u0001\u0004\t9!\u0001\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u\u0011\u001d\t\u0019\u000e\u0013a\u0001\u0003\u000f\tA#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u00033\f)\u000fE\u0003x\u00037\fy.C\u0002\u0002^b\u0014aa\u00149uS>t\u0007#D<\u0002b\u0006u\u0016QXA_\u0003\u000f\t9!C\u0002\u0002db\u0014a\u0001V;qY\u0016,\u0004\"CAt\u0013\u0006\u0005\t\u0019AA\\\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002nB!\u0011q^A}\u001b\t\t\tP\u0003\u0003\u0002t\u0006U\u0018\u0001\u00027b]\u001eT!!a>\u0002\t)\fg/Y\u0005\u0005\u0003w\f\tP\u0001\u0004PE*,7\r\u001e\t\u0005\u0003\u007f\u000by0C\u0002\u0003\u00029\u0013a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0007\u0005\u000b\u0011Y!!0\u000e\u0005\t\u001d!b\u0001B\u0005!\u0006)AO]3fg&!!Q\u0002B\u0004\u0005-!VM\u001d8befd\u0015n[3\u0011\u0007]\u0014\t\"C\u0002\u0003\u0014a\u0014q\u0001\u0015:pIV\u001cG/\u0006\u0002\u0002>\u000611\r[5mI\u0002\nQ\u0003]3sG\u0016tG/Y4f\u000bb\u0004(/Z:tS>t\u0007%A\nbG\u000e,(/Y2z\u000bb\u0004(/Z:tS>t\u0007%A\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3uA\u0005)\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004C\u0003DA\\\u0005G\u0011)Ca\n\u0003*\t-\u0002bBA^\u0017\u0001\u0007\u0011Q\u0018\u0005\b\u0003\u000f\\\u0001\u0019AA_\u0011\u001d\tYm\u0003a\u0001\u0003{Cq!a4\f\u0001\u0004\t9\u0001C\u0004\u0002T.\u0001\r!a\u0002\u0015\u0011\u0005]&q\u0006B\u0019\u0005gAq!a/\r\u0001\u0004\ti\fC\u0004\u0002H2\u0001\r!!0\t\u000f\u0005-G\u00021\u0001\u0002>R1\u0011q\u0017B\u001c\u0005sAq!a/\u000e\u0001\u0004\ti\fC\u0004\u0002H6\u0001\r!!0\u0002\u0011\u0005\u001c7-\u001e:bGf,\"Aa\u0010\u0011\u0007]\u0014\t%C\u0002\u0003Da\u0014A\u0001T8oO\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\t%\u0003CBA5\u0003g\u0012Y\u0005\u0005\u0003\u0003N\tMSB\u0001B(\u0015\r\u0011\tFU\u0001\u0006if\u0004Xm]\u0005\u0005\u0005+\u0012yE\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qKV\u0011!\u0011\f\t\bo\nm\u00131JA?\u0013\r\u0011i\u0006\u001f\u0002\u0007)V\u0004H.\u001a\u001a\u0002+I,G/\u001e:o!\u0016\u00148-\u001a8uS2,\u0017I\u001d:bsV\u0011\u0011QP\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0005O\u0002BA!\u001b\u0003p5\u0011!1\u000e\u0006\u0004\u0005[\u0002\u0016\u0001C1oC2L8/[:\n\t\tE$1\u000e\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u000692M]3bi\u0016\fum\u001a:fO\u0006$\u0018n\u001c8Ck\u001a4WM\u001d\u000b\u0002A\u00061Q\u000f\u001d3bi\u0016$R\u0001\u0019B>\u0005\u007fBaA! \u0016\u0001\u0004\u0001\u0017A\u00022vM\u001a,'\u000fC\u0004\u0003\u0002V\u0001\rAa!\u0002\u0011%t\u0007/\u001e;S_^\u0004BA!\"\u0003\b6\t\u0001+C\u0002\u0003\nB\u00131\"\u00138uKJt\u0017\r\u001c*poR)\u0001M!$\u0003\u0010\"1!Q\u0010\fA\u0002\u0001Da!!\u0019\u0017\u0001\u0004\u0001\u0017\u0001B3wC2$BA!&\u0003\u001cB\u0019qOa&\n\u0007\te\u0005PA\u0002B]fDaA! \u0018\u0001\u0004\u0001\u0017!H<ji\"tUm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\t\u0005]&\u0011\u0015\u0005\b\u0005GC\u0002\u0019AA\u0004\u0003%qWm^(gMN,G/A\u000exSRDg*Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0005\u0003o\u0013I\u000bC\u0004\u0003$f\u0001\r!a\u0002\u0002\u000b\u0019L'o\u001d;\u0002\rM,7m\u001c8e\u0003\u0015!\b.\u001b:e\u0003!qW\u000f\u001c7bE2,\u0017\u0001E5oi\u0016\u0014h.\u00197ECR\fG+\u001f9f+\t\u00119\f\u0005\u0003\u0003N\te\u0016\u0002\u0002B^\u0005\u001f\u0012\u0001\u0002R1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qK\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\t\r\u0007\u0003\u0002Bc\u0005\u001btAAa2\u0003JB\u0011\u0011\u000e_\u0005\u0004\u0005\u0017D\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0003P\nE'AB*ue&twMC\u0002\u0003Lb$B!!'\u0003V\"1\u00111U\u0011A\u0002\u0001$2\u0001\u0019Bm\u0011\u001d\tYK\ta\u0001\u00033\u000bqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0011\u0005]&q\u001cBr\u0005ODqA!9$\u0001\u0004\ti,\u0001\u0005oK^4\u0015N]:u\u0011\u001d\u0011)o\ta\u0001\u0003{\u000b\u0011B\\3x'\u0016\u001cwN\u001c3\t\u000f\t%8\u00051\u0001\u0002>\u0006Aa.Z<UQ&\u0014H-\u0001\u0003d_BLH\u0003DA\\\u0005_\u0014\tPa=\u0003v\n]\b\"CA^IA\u0005\t\u0019AA_\u0011%\t9\r\nI\u0001\u0002\u0004\ti\fC\u0005\u0002L\u0012\u0002\n\u00111\u0001\u0002>\"I\u0011q\u001a\u0013\u0011\u0002\u0003\u0007\u0011q\u0001\u0005\n\u0003'$\u0003\u0013!a\u0001\u0003\u000f\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003~*\"\u0011Q\u0018B\u0000W\t\u0019\t\u0001\u0005\u0003\u0004\u0004\r5QBAB\u0003\u0015\u0011\u00199a!\u0003\u0002\u0013Ut7\r[3dW\u0016$'bAB\u0006q\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r=1Q\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"a!\u0007+\t\u0005\u001d!q`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u00111\u0011\u0005\t\u0005\u0003_\u001c\u0019#\u0003\u0003\u0003P\u0006E\u0018\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005+\u001bY\u0003C\u0005\u000201\n\t\u00111\u0001\u0002\b\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00042A111GB\u001d\u0005+k!a!\u000e\u000b\u0007\r]\u00020\u0001\u0006d_2dWm\u0019;j_:LAaa\u000f\u00046\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tYe!\u0011\t\u0013\u0005=b&!AA\u0002\tU\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002L\r\u001d\u0003\"CA\u0018_\u0005\u0005\t\u0019\u0001BKQM\u000111JB)\u0007'\u001a9f!\u0017\u0004^\r}31MB3!\u0011\tyl!\u0014\n\u0007\r=cJA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\rU\u0013A\"0\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006fY8mY\u0001\u0002XM]2f]R\fw-\u001a\u0011\\Y\u0001\n7mY;sC\u000eLX,\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011baB\u0014x\u000e_5nCR,\u0007\u0005\u00199fe\u000e,g\u000e^5mK\u0002\u0004sN\u001a\u0011uQ\u0016\u0004c.^7fe&\u001c\u0007e\u001c:\u000bA\u0001\u0002\u0003\u0005\t\u0011b]NL\u0007%\u001b8uKJ4\u0018\r\u001c\u0011d_2,XN\u001c\u0011aG>d\u0007\rI<iS\u000eD\u0007%[:!i\",\u0007e]7bY2,7\u000f\u001e\u0011wC2,X\rI5oAQDW\rI8sI\u0016\u0014X\r\u001a\u0011aG>d\u0007\r\t<bYV,7\u000f\t\u0015t_J$X\r\u001a\u0006!A\u0001\u0002\u0003\u0005\t4s_6\u0004C.Z1ti\u0002\"x\u000eI4sK\u0006$Xm\u001d;*AM,8\r\u001b\u0011uQ\u0006$\bE\\8![>\u0014X\r\t;iC:\u0004\u0003\r]3sG\u0016tG/Y4fA\u0002zg\r\t1d_2\u0004\u0007E^1mk\u0016\u001c\b%[:!Y\u0016\u001c8\u000f\t;iC:T\u0001\u0005\t\u0011!A\u0001\"\b.\u001a\u0011wC2,X\rI8sA\u0015\fX/\u00197!i>\u0004C\u000f[1uAY\fG.^3/AQCW\r\t<bYV,\u0007e\u001c4!a\u0016\u00148-\u001a8uC\u001e,\u0007%\\;ti\u0002\u0012W\r\t2fi^,WM\u001c\u00111]A\u0002\u0013M\u001c3!c9\u0002dF\u0003\u0011!A\u0001\u0002\u0003\u0005\u00165fA\u0001\f7mY;sC\u000eL\b\r\t9be\u0006lW\r^3sA!\"WMZ1vYRT\u0004%\r\u00191aAJ\u0003%[:!C\u0002\u0002xn]5uSZ,\u0007E\\;nKJL7\r\t7ji\u0016\u0014\u0018\r\u001c\u0011xQ&\u001c\u0007\u000eI2p]R\u0014x\u000e\\:\u000bA\u0001\u0002\u0003\u0005\t\u0011baB\u0014x\u000e_5nCRLwN\u001c\u0011bG\u000e,(/Y2zA\u0005$\b\u0005\u001e5fA\r|7\u000f\u001e\u0011pM\u0002jW-\\8ss:\u0002\u0003*[4iKJ\u0004c/\u00197vK\u0002zg\r\t1bG\u000e,(/Y2zA\u0002J\u0018.\u001a7eg\u0002\u0012W\r\u001e;fe*\u0001\u0003\u0005\t\u0011!A\u0005\u001c7-\u001e:bGfd\u0003\u0005Y\u0019/a=\n7mY;sC\u000eL\b\rI5tAQDW\r\t:fY\u0006$\u0018N^3!KJ\u0014xN\u001d\u0011pM\u0002\"\b.\u001a\u0011baB\u0014x\u000e_5nCRLwN\u001c\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011XQ\u0016t\u0007\u0005\u00199fe\u000e,g\u000e^1hK\u0002\u0004\u0013n\u001d\u0011b]\u0002\n'O]1zY\u0001*\u0017m\u00195!m\u0006dW/\u001a\u0011pM\u0002\"\b.\u001a\u0011qKJ\u001cWM\u001c;bO\u0016\u0004\u0013M\u001d:bs\u0002jWo\u001d;!E\u0016\u0004#-\u001a;xK\u0016t\u0007\u0005\r\u00181A\u0005tG\rI\u0019/a9R\u0001\u0005\t\u0011!A\u0001Je\u000e\t;iSN\u00043-Y:fY\u0001\u0012X\r^;s]N\u0004C\u000f[3!CB\u0004(o\u001c=j[\u0006$X\r\t9fe\u000e,g\u000e^5mK\u0002\n'O]1zA=4\u0007eY8mk6t\u0007\u0005Y2pY\u0002\u0004\u0013\r\u001e\u0011uQ\u0016\u0004s-\u001b<f]*\u0001\u0003\u0005\t\u0011!AA,'oY3oi\u0006<W\rI1se\u0006LhF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAB.\u0003\u0011m&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY2\u0002\u0013M\u001d:bs\"\u0002d&\u000e\u0017!a9\"D\u0006\t\u0019/c%b\u0003%\r\u00191S\u00012%kT'!-\u0006cU+R*!QAJC\u0006\t\u00152S1\u0002\u0003FM\u0015-A!\n\u0004'\u000b\u0011B'\u0002\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.2YEb\u0003'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)G>dG\u0006\t\u0019/k1\u0002\u0013\u0007\r\u0019*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)a%b\u0003\u0005\u000b\u001c*Y\u0001Bs'\u000b\u0017!QeJC\u0006\t\u00152a%\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001:$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY2\u0002\u0003GL\u001b-AE\u0002\u0004'\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K%O)\u0016\u0013f+\u0011'!OA:\u0003%T(O)\"KC\u0006\t\u0015J\u001dR+%KV!MA\u001d\nt\u0005I'P\u001dRC\u0015\u0006\f\u0011)\u0013:#VI\u0015,B\u0019\u0002:#g\n\u0011N\u001f:#\u0006*\u000b\u0017!Q%sE+\u0012*W\u00032\u0003s%\r\u0019(A5{e\n\u0016%*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a5\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY2\u0002\u0013M\u001d:bs\"\u0002d&\u000e\u0017!a9:\u0014\u0006\f\u00112aAJ\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0013J\u0014+F%Z\u000bE\nI\u00141O\u0001\u001aViQ(O\t&b\u0003\u0005K%O)\u0016\u0013f+\u0011'!OE:\u0003eU#D\u001f:#\u0015\u0006\f\u0011)\u0013:#VI\u0015,B\u0019\u0002:#g\n\u0011T\u000b\u000e{e\nR\u0015-A!Je\nV#S-\u0006c\u0005eJ\u00191O\u0001\u001aViQ(O\t&\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0006\u0007\t\u00191uA\u0002$\bM\u0019/aA\u0002\u0004\u0007\r\u00191aAb\u0003\u0007\t\u00191uA\u0002$\b\r\u001a/aA\u0002\u0004\u0007\r\u00191aAj&\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\r\u0005\u0014!C1hO~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u00199'A\u00033]Er\u0003\u0007")
public class ApproximatePercentile
extends TypedImperativeAggregate<PercentileDigest>
implements ImplicitCastInputTypes,
TernaryLike<Expression>,
scala.Serializable {
    private long accuracy;
    private Tuple2<Object, double[]> x$1;
    private boolean returnPercentileArray;
    private double[] percentages;
    private DataType internalDataType;
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression accuracyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproximatePercentile approximatePercentile) {
        return ApproximatePercentile$.MODULE$.unapply(approximatePercentile);
    }

    public static PercentileDigestSerializer serializer() {
        return ApproximatePercentile$.MODULE$.serializer();
    }

    public static int DEFAULT_PERCENTILE_ACCURACY() {
        return ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if (!this.bitmap$trans$0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression accuracyExpression() {
        return this.accuracyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private long accuracy$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.accuracy = ((Number)this.accuracyExpression().eval(this.accuracyExpression().eval$default$1())).longValue();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.accuracy;
    }

    private long accuracy() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.accuracy$lzycompute() : this.accuracy;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, new ArrayType(DoubleType$.MODULE$, false)})), (List)new .colon.colon((Object)IntegralType$.MODULE$, (List)Nil$.MODULE$)));
    }

    private Tuple2<Object, double[]> x$1$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2;
                Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                if (object == null) {
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), null);
                } else if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new double[]{d});
                } else if (object instanceof ArrayData) {
                    ArrayData arrayData = (ArrayData)object;
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)arrayData.toDoubleArray());
                } else {
                    throw new MatchError(object);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                boolean returnPercentileArray = tuple22._1$mcZ$sp();
                double[] percentages = (double[])tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)returnPercentileArray), (Object)percentages);
                this.x$1 = tuple23;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private boolean returnPercentileArray$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.returnPercentileArray = this.x$1()._1$mcZ$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.returnPercentileArray;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private double[] percentages$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.percentages = (double[])this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.percentages;
    }

    private double[] percentages() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.percentageExpression().foldable() || !this.accuracyExpression().foldable() ? new TypeCheckResult.TypeCheckFailure("The accuracy or percentage provided must be a constant literal") : (this.accuracy() <= 0L || this.accuracy() > Integer.MAX_VALUE ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(72).append("The accuracy provided must be a literal between (0, ").append(Integer.MAX_VALUE).append("]").append(" (current value = ").append(this.accuracy()).append(")").toString()) : (this.percentages() == null ? new TypeCheckResult.TypeCheckFailure("Percentage value must not be null") : (new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).exists((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)percentage -> percentage < 0.0 || percentage > 1.0) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(62).append("All percentage values must be between 0.0 and 1.0 ").append("(current = ").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).mkString(", ")).append(")").toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$))));
    }

    @Override
    public PercentileDigest createAggregationBuffer() {
        double relativeError = 1.0 / (double)this.accuracy();
        return new PercentileDigest(relativeError);
    }

    @Override
    public PercentileDigest update(PercentileDigest buffer, InternalRow inputRow) {
        block7: {
            double d;
            Object value = this.child().eval(inputRow);
            if (value == null) break block7;
            DataType dataType = this.child().dataType();
            boolean bl = DateType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType;
            if (bl) {
                d = BoxesRunTime.unboxToInt((Object)value);
            } else {
                boolean bl2 = TimestampType$.MODULE$.equals(dataType) ? true : (TimestampNTZType$.MODULE$.equals(dataType) ? true : dataType instanceof DayTimeIntervalType);
                if (bl2) {
                    d = BoxesRunTime.unboxToLong((Object)value);
                } else if (dataType instanceof NumericType) {
                    NumericType numericType = (NumericType)dataType;
                    d = numericType.numeric().toDouble(value);
                } else {
                    if (dataType != null) {
                        DataType dataType2 = dataType;
                        throw QueryExecutionErrors$.MODULE$.dataTypeUnexpectedError(dataType2);
                    }
                    throw new MatchError((Object)dataType);
                }
            }
            double doubleValue = d;
            buffer.add(doubleValue);
        }
        return buffer;
    }

    @Override
    public PercentileDigest merge(PercentileDigest buffer, PercentileDigest other) {
        buffer.merge(other);
        return buffer;
    }

    @Override
    public Object eval(PercentileDigest buffer) {
        Seq seq;
        Seq doubleResult = buffer.getPercentiles(this.percentages());
        DataType dataType = this.child().dataType();
        boolean bl = DateType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType;
        if (bl) {
            seq = (Seq)doubleResult.map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$2 -> (int)x$2, Seq$.MODULE$.canBuildFrom());
        } else {
            boolean bl2 = TimestampType$.MODULE$.equals(dataType) ? true : (TimestampNTZType$.MODULE$.equals(dataType) ? true : dataType instanceof DayTimeIntervalType);
            if (bl2) {
                seq = (Seq)doubleResult.map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)x$3 -> (long)x$3, Seq$.MODULE$.canBuildFrom());
            } else if (ByteType$.MODULE$.equals(dataType)) {
                seq = (Seq)doubleResult.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToByte((byte)ApproximatePercentile.$anonfun$eval$3(BoxesRunTime.unboxToDouble((Object)x$4))), Seq$.MODULE$.canBuildFrom());
            } else if (ShortType$.MODULE$.equals(dataType)) {
                seq = (Seq)doubleResult.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToShort((short)ApproximatePercentile.$anonfun$eval$4(BoxesRunTime.unboxToDouble((Object)x$5))), Seq$.MODULE$.canBuildFrom());
            } else if (IntegerType$.MODULE$.equals(dataType)) {
                seq = (Seq)doubleResult.map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$6 -> (int)x$6, Seq$.MODULE$.canBuildFrom());
            } else if (LongType$.MODULE$.equals(dataType)) {
                seq = (Seq)doubleResult.map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)x$7 -> (long)x$7, Seq$.MODULE$.canBuildFrom());
            } else if (FloatType$.MODULE$.equals(dataType)) {
                seq = (Seq)doubleResult.map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$8 -> (float)x$8, Seq$.MODULE$.canBuildFrom());
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                seq = doubleResult;
            } else if (dataType instanceof DecimalType) {
                seq = (Seq)doubleResult.map((Function1 & Serializable & scala.Serializable)x$9 -> Decimal$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)x$9)), Seq$.MODULE$.canBuildFrom());
            } else {
                if (dataType != null) {
                    DataType dataType2 = dataType;
                    throw QueryExecutionErrors$.MODULE$.dataTypeUnexpectedError(dataType2);
                }
                throw new MatchError((Object)dataType);
            }
        }
        Seq result = seq;
        return result.length() == 0 ? null : (this.returnPercentileArray() ? new GenericArrayData((Seq<Object>)result) : result.apply(0));
    }

    @Override
    public ApproximatePercentile withNewMutableAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public ApproximatePercentile withNewInputAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    @Override
    public Expression first() {
        return this.child();
    }

    @Override
    public Expression second() {
        return this.percentageExpression();
    }

    @Override
    public Expression third() {
        return this.accuracyExpression();
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private DataType internalDataType$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.internalDataType = this.returnPercentileArray() ? new ArrayType(this.child().dataType(), false) : this.child().dataType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.internalDataType;
    }

    private DataType internalDataType() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.internalDataType$lzycompute() : this.internalDataType;
    }

    @Override
    public DataType dataType() {
        return this.internalDataType();
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "percentile_approx");
    }

    @Override
    public byte[] serialize(PercentileDigest obj) {
        return ApproximatePercentile$.MODULE$.serializer().serialize(obj);
    }

    @Override
    public PercentileDigest deserialize(byte[] bytes) {
        return ApproximatePercentile$.MODULE$.serializer().deserialize(bytes);
    }

    @Override
    public ApproximatePercentile withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4(), this.copy$default$5());
    }

    public ApproximatePercentile copy(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproximatePercentile(child, percentageExpression, accuracyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.accuracyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproximatePercentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 2: {
                object = this.accuracyExpression();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproximatePercentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproximatePercentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproximatePercentile approximatePercentile = (ApproximatePercentile)x$1;
        Expression expression = this.child();
        Expression expression2 = approximatePercentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = approximatePercentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.accuracyExpression();
        Expression expression6 = approximatePercentile.accuracyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != approximatePercentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approximatePercentile.inputAggBufferOffset()) return false;
        if (!approximatePercentile.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ byte $anonfun$eval$3(double x$4) {
        return (byte)x$4;
    }

    public static final /* synthetic */ short $anonfun$eval$4(double x$5) {
        return (short)x$5;
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.accuracyExpression = accuracyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        TernaryLike.$init$(this);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression) {
        this(child, percentageExpression, accuracyExpression, 0, 0);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY())));
    }

    public static class PercentileDigest {
        private QuantileSummaries summaries;

        private QuantileSummaries summaries() {
            return this.summaries;
        }

        private void summaries_$eq(QuantileSummaries x$1) {
            this.summaries = x$1;
        }

        public boolean isCompressed() {
            return this.summaries().compressed();
        }

        public QuantileSummaries quantileSummaries() {
            block0: {
                if (this.isCompressed()) break block0;
                this.compress();
            }
            return this.summaries();
        }

        public void add(double value) {
            this.summaries_$eq(this.summaries().insert(value));
        }

        public void merge(PercentileDigest other) {
            if (!this.isCompressed()) {
                this.compress();
            }
            this.summaries_$eq(this.summaries().merge(other.quantileSummaries()));
        }

        public Seq<Object> getPercentiles(double[] percentages) {
            if (!this.isCompressed()) {
                this.compress();
            }
            return this.summaries().count() == 0L || percentages.length == 0 ? Predef$.MODULE$.wrapDoubleArray(Array$.MODULE$.emptyDoubleArray()) : (Seq)this.summaries().query((Seq<Object>)Predef$.MODULE$.wrapDoubleArray(percentages)).get();
        }

        private final void compress() {
            this.summaries_$eq(this.summaries().compress());
        }

        public PercentileDigest(QuantileSummaries summaries) {
            this.summaries = summaries;
        }

        public PercentileDigest(double relativeError) {
            int x$1 = QuantileSummaries$.MODULE$.defaultCompressThreshold();
            double x$2 = relativeError;
            boolean x$3 = true;
            QuantileSummaries.Stats[] x$4 = QuantileSummaries$.MODULE$.$lessinit$greater$default$3();
            long x$5 = QuantileSummaries$.MODULE$.$lessinit$greater$default$4();
            this(new QuantileSummaries(x$1, x$2, x$4, x$5, x$3));
        }
    }

    public static class PercentileDigestSerializer {
        private final int length(QuantileSummaries summaries) {
            return 24 + summaries.sampled().length * 24;
        }

        public final byte[] serialize(PercentileDigest obj) {
            QuantileSummaries summary = obj.quantileSummaries();
            ByteBuffer buffer = ByteBuffer.wrap(new byte[this.length(summary)]);
            buffer.putInt(summary.compressThreshold());
            buffer.putDouble(summary.relativeError());
            buffer.putLong(summary.count());
            buffer.putInt(summary.sampled().length);
            for (int i = 0; i < summary.sampled().length; ++i) {
                QuantileSummaries.Stats stat = summary.sampled()[i];
                buffer.putDouble(stat.value());
                buffer.putLong(stat.g());
                buffer.putLong(stat.delta());
            }
            return buffer.array();
        }

        public final PercentileDigest deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int compressThreshold = buffer.getInt();
            double relativeError = buffer.getDouble();
            long count = buffer.getLong();
            int sampledLength = buffer.getInt();
            QuantileSummaries.Stats[] sampled = new QuantileSummaries.Stats[sampledLength];
            for (int i = 0; i < sampledLength; ++i) {
                double value = buffer.getDouble();
                long g = buffer.getLong();
                long delta = buffer.getLong();
                sampled[i] = new QuantileSummaries.Stats(value, g, delta);
            }
            QuantileSummaries summary = new QuantileSummaries(compressThreshold, relativeError, sampled, count, true);
            return new PercentileDigest(summary);
        }
    }
}

