/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.StateBackendOptions;

@PublicEvolving
public class StateLatencyTrackOptions {
    @Documentation.Section(value={"state_latency_tracking"})
    public static final ConfigOption<Boolean> LATENCY_TRACK_ENABLED = ConfigOptions.key("state.latency-track.keyed-state-enabled").booleanType().defaultValue(false).withDeprecatedKeys(StateBackendOptions.LATENCY_TRACK_ENABLED.key()).withDescription("Whether to track latency of keyed state operations, e.g value state put/get/clear.");
    @Documentation.Section(value={"state_latency_tracking"})
    public static final ConfigOption<Integer> LATENCY_TRACK_SAMPLE_INTERVAL = ConfigOptions.key("state.latency-track.sample-interval").intType().defaultValue(100).withDeprecatedKeys(StateBackendOptions.LATENCY_TRACK_SAMPLE_INTERVAL.key()).withDescription(String.format("The sample interval of latency track once '%s' is enabled. The default value is 100, which means we would track the latency every 100 access requests.", LATENCY_TRACK_ENABLED.key()));
    @Documentation.Section(value={"state_latency_tracking"})
    public static final ConfigOption<Integer> LATENCY_TRACK_HISTORY_SIZE = ConfigOptions.key("state.latency-track.history-size").intType().defaultValue(128).withDeprecatedKeys(StateBackendOptions.LATENCY_TRACK_HISTORY_SIZE.key()).withDescription("Defines the number of measured latencies to maintain at each state access operation.");
    @Documentation.Section(value={"state_latency_tracking"})
    public static final ConfigOption<Boolean> LATENCY_TRACK_STATE_NAME_AS_VARIABLE = ConfigOptions.key("state.latency-track.state-name-as-variable").booleanType().defaultValue(true).withDeprecatedKeys(StateBackendOptions.LATENCY_TRACK_STATE_NAME_AS_VARIABLE.key()).withDescription("Whether to expose state name as a variable if tracking latency.");
}

