/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.mixed;

import java.util.List;
import java.util.Map;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.TableBuilder;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.table.blocker.TableBlockerManager;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.NoSuchTableException;

public interface MixedFormatCatalog {
    public String name();

    public void initialize(String var1, Map<String, String> var2, TableMetaStore var3);

    public List<String> listDatabases();

    public void createDatabase(String var1);

    public void dropDatabase(String var1);

    public List<TableIdentifier> listTables(String var1);

    public MixedTable loadTable(TableIdentifier var1);

    default public boolean tableExists(TableIdentifier tableIdentifier) {
        try {
            this.loadTable(tableIdentifier);
            return true;
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    public void renameTable(TableIdentifier var1, String var2);

    public boolean dropTable(TableIdentifier var1, boolean var2);

    public TableBuilder newTableBuilder(TableIdentifier var1, Schema var2);

    public TableBlockerManager getTableBlockerManager(TableIdentifier var1);

    public Map<String, String> properties();
}

