/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.table;

import java.util.Map;
import org.apache.amoro.TableFormat;
import org.apache.amoro.hive.HMSClientPool;
import org.apache.amoro.hive.op.HiveOperationTransaction;
import org.apache.amoro.hive.op.HiveSchemaUpdate;
import org.apache.amoro.hive.op.OverwriteHiveFiles;
import org.apache.amoro.hive.op.ReplaceHivePartitions;
import org.apache.amoro.hive.op.RewriteHiveFiles;
import org.apache.amoro.hive.table.SupportHive;
import org.apache.amoro.hive.utils.HiveMetaSynchronizer;
import org.apache.amoro.hive.utils.HiveTableUtil;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.AuthenticatedHadoopFileIO;
import org.apache.amoro.table.BaseTable;
import org.apache.amoro.table.BasicUnkeyedTable;
import org.apache.amoro.table.TableIdentifier;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.util.PropertyUtil;

public class UnkeyedHiveTable
extends BasicUnkeyedTable
implements BaseTable,
SupportHive {
    private final HMSClientPool hiveClient;
    private final String tableLocation;
    private boolean syncHiveChange = true;
    private final AuthenticatedHadoopFileIO fileIO;

    public UnkeyedHiveTable(TableIdentifier tableIdentifier, Table icebergTable, AuthenticatedHadoopFileIO fileIO, String tableLocation, HMSClientPool hiveClient, Map<String, String> catalogProperties) {
        this(tableIdentifier, icebergTable, fileIO, tableLocation, hiveClient, catalogProperties, true);
    }

    public UnkeyedHiveTable(TableIdentifier tableIdentifier, Table icebergTable, AuthenticatedHadoopFileIO fileIO, String tableLocation, HMSClientPool hiveClient, Map<String, String> catalogProperties, boolean syncHiveChange) {
        super(tableIdentifier, icebergTable, (AuthenticatedFileIO)fileIO, catalogProperties);
        this.fileIO = fileIO;
        this.hiveClient = hiveClient;
        this.tableLocation = tableLocation;
        this.syncHiveChange = syncHiveChange;
        if (this.enableSyncHiveSchemaToMixedTable()) {
            this.syncHiveSchemaToMixedTable();
        }
        if (this.enableSyncHiveDataToMixedTable()) {
            this.syncHiveDataToMixedTable(false);
        }
    }

    public TableFormat format() {
        return TableFormat.MIXED_HIVE;
    }

    @Override
    public AuthenticatedHadoopFileIO io() {
        return this.fileIO;
    }

    public void refresh() {
        super.refresh();
        if (this.enableSyncHiveSchemaToMixedTable()) {
            this.syncHiveSchemaToMixedTable();
        }
        if (this.enableSyncHiveDataToMixedTable()) {
            this.syncHiveDataToMixedTable(false);
        }
    }

    public Schema schema() {
        return super.schema();
    }

    public ReplacePartitions newReplacePartitions() {
        return new ReplaceHivePartitions(super.newTransaction(), false, this, this.hiveClient, this.hiveClient);
    }

    public String name() {
        return this.id().getTableName();
    }

    @Override
    public String hiveLocation() {
        return this.properties().containsKey("base.hive.location-root") ? (String)this.properties().get("base.hive.location-root") : HiveTableUtil.hiveRootLocation(this.tableLocation);
    }

    @Override
    public HMSClientPool getHMSClient() {
        return this.hiveClient;
    }

    public OverwriteHiveFiles newOverwrite() {
        return new OverwriteHiveFiles(super.newTransaction(), false, this, this.hiveClient, this.hiveClient);
    }

    public RewriteHiveFiles newRewrite() {
        return new RewriteHiveFiles(super.newTransaction(), false, this, this.hiveClient, this.hiveClient);
    }

    public Transaction newTransaction() {
        Transaction transaction = super.newTransaction();
        return new HiveOperationTransaction(this, transaction, this.hiveClient);
    }

    public UpdateSchema updateSchema() {
        return new HiveSchemaUpdate(this, this.hiveClient, this.hiveClient, super.updateSchema());
    }

    @Override
    public boolean enableSyncHiveSchemaToMixedTable() {
        return this.syncHiveChange && PropertyUtil.propertyAsBoolean((Map)this.properties(), (String)"base.hive.auto-sync-schema-change", (boolean)true);
    }

    @Override
    public void syncHiveSchemaToMixedTable() {
        HiveMetaSynchronizer.syncHiveSchemaToMixedTable(this, this.hiveClient);
    }

    @Override
    public boolean enableSyncHiveDataToMixedTable() {
        return this.syncHiveChange && PropertyUtil.propertyAsBoolean((Map)this.properties(), (String)"base.hive.auto-sync-data-write", (boolean)false);
    }

    @Override
    public void syncHiveDataToMixedTable(boolean force) {
        HiveMetaSynchronizer.syncHiveDataToMixedTable(this, this.hiveClient, force);
    }
}

