/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.stream;

import org.apache.flink.api.common.SlotSharingGroup;
import org.apache.flink.api.common.operators.util.OperatorValidationUtils;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.datastream.api.stream.ProcessConfigurable;
import org.apache.flink.datastream.impl.ExecutionEnvironmentImpl;

public class ProcessConfigureHandle<T, S extends ProcessConfigurable<S>>
implements ProcessConfigurable<S> {
    protected final ExecutionEnvironmentImpl environment;
    protected final Transformation<T> transformation;

    public ProcessConfigureHandle(ExecutionEnvironmentImpl environment, Transformation<T> transformation) {
        this.environment = environment;
        this.transformation = transformation;
    }

    public S withUid(String uid) {
        this.transformation.setUid(uid);
        return (S)this;
    }

    public S withName(String name) {
        this.transformation.setName(name);
        return (S)this;
    }

    public S withParallelism(int parallelism) {
        OperatorValidationUtils.validateParallelism((int)parallelism, (boolean)this.canBeParallel());
        this.transformation.setParallelism(parallelism);
        return (S)this;
    }

    public S withMaxParallelism(int maxParallelism) {
        OperatorValidationUtils.validateMaxParallelism((int)maxParallelism, (boolean)this.canBeParallel());
        this.transformation.setMaxParallelism(maxParallelism);
        return (S)this;
    }

    public S withSlotSharingGroup(SlotSharingGroup ssg) {
        this.transformation.setSlotSharingGroup(org.apache.flink.api.common.operators.SlotSharingGroup.from((SlotSharingGroup)ssg));
        return (S)this;
    }

    protected boolean canBeParallel() {
        return true;
    }
}

