/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.iceberg;

import java.util.regex.Pattern;
import org.apache.amoro.TableFormat;
import org.apache.amoro.spark.SparkTableFormat;
import org.apache.amoro.spark.mixed.MixedFormatSparkUtil;
import org.apache.iceberg.MetadataTableType;
import org.apache.spark.sql.connector.catalog.Table;

public class IcebergSparkFormat
implements SparkTableFormat {
    private static final Pattern AT_TIMESTAMP = Pattern.compile("at_timestamp_(\\d+)");
    private static final Pattern SNAPSHOT_ID = Pattern.compile("snapshot_id_(\\d+)");
    private static final Pattern BRANCH = Pattern.compile("branch_(.*)");
    private static final Pattern TAG = Pattern.compile("tag_(.*)");
    private static final Pattern CHANGES = Pattern.compile("changes");

    @Override
    public TableFormat format() {
        return TableFormat.ICEBERG;
    }

    @Override
    public boolean isSubTableName(String tableName) {
        return MetadataTableType.from((String)tableName) != null || AT_TIMESTAMP.matcher(tableName).matches() || SNAPSHOT_ID.matcher(tableName).matches() || TAG.matcher(tableName).matches() || CHANGES.matcher(tableName).matches() || BRANCH.matcher(tableName).matches();
    }

    @Override
    public boolean isFormatOf(Table table) {
        String icebergTableType = (String)table.properties().get("table_type");
        return "iceberg".equalsIgnoreCase(icebergTableType) && !MixedFormatSparkUtil.isMixedFormatTable(table);
    }
}

