/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.dao;

import com.j256.ormlite.dao.BaseForeignCollection;
import com.j256.ormlite.dao.CloseableIterable;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.CloseableWrappedIterable;
import com.j256.ormlite.dao.CloseableWrappedIterableImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.dao.DatabaseResultsMapper;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.dao.RawRowMapper;
import com.j256.ormlite.dao.RawRowObjectMapper;
import com.j256.ormlite.dao.ReferenceObjectCache;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.misc.BaseDaoEnabled;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.SelectIterator;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.StatementExecutor;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.ObjectFactory;
import com.j256.ormlite.table.TableInfo;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class BaseDaoImpl<T, ID>
implements Dao<T, ID> {
    private static final ThreadLocal<List<BaseDaoImpl<?, ?>>> daoConfigLevelLocal = new ThreadLocal<List<BaseDaoImpl<?, ?>>>(){

        @Override
        protected List<BaseDaoImpl<?, ?>> initialValue() {
            return new ArrayList(10);
        }
    };
    private static ReferenceObjectCache defaultObjectCache;
    private static final Object constantObject;
    protected StatementExecutor<T, ID> statementExecutor;
    protected DatabaseType databaseType;
    protected final Class<T> dataClass;
    protected Constructor<T> constructor;
    protected DatabaseTableConfig<T> tableConfig;
    protected TableInfo<T, ID> tableInfo;
    protected ConnectionSource connectionSource;
    protected CloseableIterator<T> lastIterator;
    protected ObjectFactory<T> objectFactory;
    private boolean initialized;
    ObjectCache objectCache;
    private ConcurrentMap<Dao.DaoObserver, Object> daoObserverMap;

    protected BaseDaoImpl(Class<T> dataClass) throws SQLException {
        this(null, dataClass, null);
    }

    protected BaseDaoImpl(ConnectionSource connectionSource, Class<T> dataClass) throws SQLException {
        this(connectionSource, dataClass, null);
    }

    protected BaseDaoImpl(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) throws SQLException {
        this(connectionSource, tableConfig.getDataClass(), tableConfig);
    }

    private BaseDaoImpl(ConnectionSource connectionSource, Class<T> dataClass, DatabaseTableConfig<T> tableConfig) throws SQLException {
        this.dataClass = dataClass;
        this.tableConfig = tableConfig;
        this.constructor = this.findNoArgConstructor(dataClass);
        if (connectionSource != null) {
            this.connectionSource = connectionSource;
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SQLException {
        if (this.initialized) {
            return;
        }
        if (this.connectionSource == null) {
            throw new IllegalStateException("connectionSource was never set on " + this.getClass().getSimpleName());
        }
        this.databaseType = this.connectionSource.getDatabaseType();
        if (this.databaseType == null) {
            throw new IllegalStateException("connectionSource is getting a null DatabaseType in " + this.getClass().getSimpleName());
        }
        if (this.tableConfig == null) {
            this.tableInfo = new TableInfo(this.databaseType, this.dataClass);
        } else {
            this.tableConfig.extractFieldTypes(this.databaseType);
            this.tableInfo = new TableInfo(this.databaseType, this.tableConfig);
        }
        this.statementExecutor = new StatementExecutor<T, ID>(this.databaseType, this.tableInfo, this);
        List<BaseDaoImpl<?, ?>> daoConfigList = daoConfigLevelLocal.get();
        daoConfigList.add(this);
        if (daoConfigList.size() > 1) {
            return;
        }
        try {
            for (int i = 0; i < daoConfigList.size(); ++i) {
                BaseDaoImpl<?, ?> dao = daoConfigList.get(i);
                DaoManager.registerDao(this.connectionSource, dao);
                try {
                    for (FieldType fieldType : dao.getTableInfo().getFieldTypes()) {
                        fieldType.configDaoInformation(this.connectionSource, dao.getDataClass());
                    }
                }
                catch (SQLException e) {
                    DaoManager.unregisterDao(this.connectionSource, dao);
                    throw e;
                }
                dao.initialized = true;
            }
        }
        finally {
            daoConfigList.clear();
            daoConfigLevelLocal.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T queryForId(ID id) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection(this.tableInfo.getTableName());
        try {
            T t = this.statementExecutor.queryForId(connection, id, this.objectCache);
            return t;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T queryForFirst(PreparedQuery<T> preparedQuery) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection(this.tableInfo.getTableName());
        try {
            T t = this.statementExecutor.queryForFirst(connection, preparedQuery, this.objectCache);
            return t;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public List<T> queryForAll() throws SQLException {
        this.checkForInitialized();
        return this.statementExecutor.queryForAll(this.connectionSource, this.objectCache);
    }

    @Override
    public T queryForFirst() throws SQLException {
        this.checkForInitialized();
        return this.queryBuilder().queryForFirst();
    }

    @Override
    public List<T> queryForEq(String fieldName, Object value) throws SQLException {
        return this.queryBuilder().where().eq(fieldName, value).query();
    }

    @Override
    public QueryBuilder<T, ID> queryBuilder() {
        this.checkForInitialized();
        return new QueryBuilder<T, ID>(this.databaseType, this.tableInfo, this);
    }

    @Override
    public UpdateBuilder<T, ID> updateBuilder() {
        this.checkForInitialized();
        return new UpdateBuilder<T, ID>(this.databaseType, this.tableInfo, this);
    }

    @Override
    public DeleteBuilder<T, ID> deleteBuilder() {
        this.checkForInitialized();
        return new DeleteBuilder<T, ID>(this.databaseType, this.tableInfo, this);
    }

    @Override
    public List<T> query(PreparedQuery<T> preparedQuery) throws SQLException {
        this.checkForInitialized();
        return this.statementExecutor.query(this.connectionSource, preparedQuery, this.objectCache);
    }

    @Override
    public List<T> queryForMatching(T matchObj) throws SQLException {
        return this.queryForMatching(matchObj, false);
    }

    @Override
    public List<T> queryForMatchingArgs(T matchObj) throws SQLException {
        return this.queryForMatching(matchObj, true);
    }

    @Override
    public List<T> queryForFieldValues(Map<String, Object> fieldValues) throws SQLException {
        return this.queryForFieldValues(fieldValues, false);
    }

    @Override
    public List<T> queryForFieldValuesArgs(Map<String, Object> fieldValues) throws SQLException {
        return this.queryForFieldValues(fieldValues, true);
    }

    @Override
    public T queryForSameId(T data) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return null;
        }
        ID id = this.extractId(data);
        if (id == null) {
            return null;
        }
        return this.queryForId(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int create(T data) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return 0;
        }
        if (data instanceof BaseDaoEnabled) {
            BaseDaoEnabled daoEnabled = (BaseDaoEnabled)data;
            daoEnabled.setDao(this);
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection(this.tableInfo.getTableName());
        try {
            int n = this.statementExecutor.create(connection, data, this.objectCache);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int create(final Collection<T> datas) throws SQLException {
        this.checkForInitialized();
        for (T data : datas) {
            if (!(data instanceof BaseDaoEnabled)) continue;
            BaseDaoEnabled daoEnabled = (BaseDaoEnabled)data;
            daoEnabled.setDao(this);
        }
        final DatabaseConnection connection = this.connectionSource.getReadWriteConnection(this.tableInfo.getTableName());
        try {
            int n = this.callBatchTasks(new Callable<Integer>(){

                @Override
                public Integer call() throws SQLException {
                    int modCount = 0;
                    for (Object data : datas) {
                        modCount += BaseDaoImpl.this.statementExecutor.create(connection, data, BaseDaoImpl.this.objectCache);
                    }
                    return modCount;
                }
            });
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public synchronized T createIfNotExists(T data) throws SQLException {
        if (data == null) {
            return null;
        }
        T existing = this.queryForSameId(data);
        if (existing == null) {
            this.create(data);
            return data;
        }
        return existing;
    }

    @Override
    public synchronized Dao.CreateOrUpdateStatus createOrUpdate(T data) throws SQLException {
        if (data == null) {
            return new Dao.CreateOrUpdateStatus(false, false, 0);
        }
        ID id = this.extractId(data);
        if (id == null || !this.idExists(id)) {
            int numRows = this.create(data);
            return new Dao.CreateOrUpdateStatus(true, false, numRows);
        }
        int numRows = this.update(data);
        return new Dao.CreateOrUpdateStatus(false, true, numRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(T data) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return 0;
        }
        if (data instanceof BaseDaoEnabled) {
            BaseDaoEnabled daoEnabled = (BaseDaoEnabled)data;
            daoEnabled.setDao(this);
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection(this.tableInfo.getTableName());
        try {
            int n = this.statementExecutor.update(connection, data, this.objectCache);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateId(T data, ID newId) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection(this.tableInfo.getTableName());
        try {
            int n = this.statementExecutor.updateId(connection, data, newId, this.objectCache);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(PreparedUpdate<T> preparedUpdate) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection(this.tableInfo.getTableName());
        try {
            int n = this.statementExecutor.update(connection, preparedUpdate);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int refresh(T data) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return 0;
        }
        if (data instanceof BaseDaoEnabled) {
            BaseDaoEnabled daoEnabled = (BaseDaoEnabled)data;
            daoEnabled.setDao(this);
        }
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection(this.tableInfo.getTableName());
        try {
            int n = this.statementExecutor.refresh(connection, data, this.objectCache);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(T data) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection(this.tableInfo.getTableName());
        try {
            int n = this.statementExecutor.delete(connection, data, this.objectCache);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteById(ID id) throws SQLException {
        this.checkForInitialized();
        if (id == null) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection(this.tableInfo.getTableName());
        try {
            int n = this.statementExecutor.deleteById(connection, id, this.objectCache);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(Collection<T> datas) throws SQLException {
        this.checkForInitialized();
        if (datas == null || datas.isEmpty()) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection(this.tableInfo.getTableName());
        try {
            int n = this.statementExecutor.deleteObjects(connection, datas, this.objectCache);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteIds(Collection<ID> ids) throws SQLException {
        this.checkForInitialized();
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection(this.tableInfo.getTableName());
        try {
            int n = this.statementExecutor.deleteIds(connection, ids, this.objectCache);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(PreparedDelete<T> preparedDelete) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection(this.tableInfo.getTableName());
        try {
            int n = this.statementExecutor.delete(connection, preparedDelete);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public CloseableIterator<T> iterator() {
        return this.iterator(-1);
    }

    @Override
    public CloseableIterator<T> closeableIterator() {
        return this.iterator(-1);
    }

    @Override
    public CloseableIterator<T> iterator(int resultFlags) {
        this.checkForInitialized();
        CloseableIterator<T> iterator = this.createIterator(resultFlags);
        this.lastIterator = iterator;
        return iterator;
    }

    @Override
    public CloseableWrappedIterable<T> getWrappedIterable() {
        this.checkForInitialized();
        return new CloseableWrappedIterableImpl(new CloseableIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return this.closeableIterator();
            }

            @Override
            public CloseableIterator<T> closeableIterator() {
                try {
                    return BaseDaoImpl.this.createIterator(-1);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not build iterator for " + BaseDaoImpl.this.dataClass, e);
                }
            }
        });
    }

    @Override
    public CloseableWrappedIterable<T> getWrappedIterable(final PreparedQuery<T> preparedQuery) {
        this.checkForInitialized();
        return new CloseableWrappedIterableImpl(new CloseableIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return this.closeableIterator();
            }

            @Override
            public CloseableIterator<T> closeableIterator() {
                try {
                    return BaseDaoImpl.this.createIterator(preparedQuery, -1);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not build prepared-query iterator for " + BaseDaoImpl.this.dataClass, e);
                }
            }
        });
    }

    @Override
    public void closeLastIterator() throws Exception {
        if (this.lastIterator != null) {
            this.lastIterator.close();
            this.lastIterator = null;
        }
    }

    @Override
    public CloseableIterator<T> iterator(PreparedQuery<T> preparedQuery) throws SQLException {
        return this.iterator(preparedQuery, -1);
    }

    @Override
    public CloseableIterator<T> iterator(PreparedQuery<T> preparedQuery, int resultFlags) throws SQLException {
        this.checkForInitialized();
        CloseableIterator<T> li = this.createIterator(preparedQuery, resultFlags);
        this.lastIterator = li;
        return li;
    }

    @Override
    public GenericRawResults<String[]> queryRaw(String query, String ... arguments) throws SQLException {
        this.checkForInitialized();
        try {
            return this.statementExecutor.queryRaw(this.connectionSource, query, arguments, this.objectCache);
        }
        catch (SQLException e) {
            throw new SQLException("Could not perform raw query for " + query, e);
        }
    }

    @Override
    public <GR> GenericRawResults<GR> queryRaw(String query, RawRowMapper<GR> mapper, String ... arguments) throws SQLException {
        this.checkForInitialized();
        try {
            return this.statementExecutor.queryRaw(this.connectionSource, query, mapper, arguments, this.objectCache);
        }
        catch (SQLException e) {
            throw new SQLException("Could not perform raw query for " + query, e);
        }
    }

    @Override
    public <UO> GenericRawResults<UO> queryRaw(String query, DataType[] columnTypes, RawRowObjectMapper<UO> mapper, String ... arguments) throws SQLException {
        this.checkForInitialized();
        try {
            return this.statementExecutor.queryRaw(this.connectionSource, query, columnTypes, mapper, arguments, this.objectCache);
        }
        catch (SQLException e) {
            throw new SQLException("Could not perform raw query for " + query, e);
        }
    }

    @Override
    public GenericRawResults<Object[]> queryRaw(String query, DataType[] columnTypes, String ... arguments) throws SQLException {
        this.checkForInitialized();
        try {
            return this.statementExecutor.queryRaw(this.connectionSource, query, columnTypes, arguments, this.objectCache);
        }
        catch (SQLException e) {
            throw new SQLException("Could not perform raw query for " + query, e);
        }
    }

    @Override
    public <UO> GenericRawResults<UO> queryRaw(String query, DatabaseResultsMapper<UO> mapper, String ... arguments) throws SQLException {
        this.checkForInitialized();
        try {
            return this.statementExecutor.queryRaw(this.connectionSource, query, mapper, arguments, this.objectCache);
        }
        catch (SQLException e) {
            throw new SQLException("Could not perform raw query for " + query, e);
        }
    }

    @Override
    public long queryRawValue(String query, String ... arguments) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection(this.tableInfo.getTableName());
        try {
            long l = this.statementExecutor.queryForLong(connection, query, arguments);
            return l;
        }
        catch (SQLException e) {
            throw new SQLException("Could not perform raw value query for " + query, e);
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public int executeRaw(String statement, String ... arguments) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection(this.tableInfo.getTableName());
        try {
            int n = this.statementExecutor.executeRaw(connection, statement, arguments);
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Could not run raw execute statement " + statement, e);
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public int executeRawNoArgs(String statement) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection(this.tableInfo.getTableName());
        try {
            int n = this.statementExecutor.executeRawNoArgs(connection, statement);
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Could not run raw execute statement " + statement, e);
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public int updateRaw(String statement, String ... arguments) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection(this.tableInfo.getTableName());
        try {
            int n = this.statementExecutor.updateRaw(connection, statement, arguments);
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Could not run raw update statement " + statement, e);
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public <CT> CT callBatchTasks(Callable<CT> callable) throws SQLException {
        this.checkForInitialized();
        return this.statementExecutor.callBatchTasks(this.connectionSource, callable);
    }

    @Override
    public String objectToString(T data) {
        this.checkForInitialized();
        return this.tableInfo.objectToString(data);
    }

    @Override
    public boolean objectsEqual(T data1, T data2) throws SQLException {
        this.checkForInitialized();
        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
            Object fieldObj1 = fieldType.extractJavaFieldValue(data1);
            Object fieldObj2 = fieldType.extractJavaFieldValue(data2);
            if (fieldType.getDataPersister().dataIsEqual(fieldObj1, fieldObj2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ID extractId(T data) throws SQLException {
        this.checkForInitialized();
        FieldType idField = this.tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Class " + this.dataClass + " does not have an id field");
        }
        Object id = idField.extractJavaFieldValue(data);
        return (ID)id;
    }

    @Override
    public Class<T> getDataClass() {
        return this.dataClass;
    }

    @Override
    public FieldType findForeignFieldType(Class<?> clazz) {
        this.checkForInitialized();
        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
            if (fieldType.getType() != clazz) continue;
            return fieldType;
        }
        return null;
    }

    @Override
    public boolean isUpdatable() {
        return this.tableInfo.isUpdatable();
    }

    @Override
    public boolean isTableExists() throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection(this.tableInfo.getTableName());
        try {
            boolean bl = connection.isTableExists(this.tableInfo.getTableName());
            return bl;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countOf() throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection(this.tableInfo.getTableName());
        try {
            long l = this.statementExecutor.queryForCountStar(connection);
            return l;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countOf(PreparedQuery<T> preparedQuery) throws SQLException {
        this.checkForInitialized();
        if (preparedQuery.getType() != StatementBuilder.StatementType.SELECT_LONG) {
            throw new IllegalArgumentException("Prepared query is not of type " + (Object)((Object)StatementBuilder.StatementType.SELECT_LONG) + ", you need to call QueryBuilder.setCountOf(true)");
        }
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection(this.tableInfo.getTableName());
        try {
            long l = this.statementExecutor.queryForLong(connection, preparedQuery);
            return l;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public void assignEmptyForeignCollection(T parent, String fieldName) throws SQLException {
        this.makeEmptyForeignCollection(parent, fieldName);
    }

    @Override
    public <FT> ForeignCollection<FT> getEmptyForeignCollection(String fieldName) throws SQLException {
        return this.makeEmptyForeignCollection(null, fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setObjectCache(boolean enabled) throws SQLException {
        if (enabled) {
            if (this.objectCache != null) return;
            if (this.tableInfo.getIdField() == null) {
                throw new SQLException("Class " + this.dataClass + " must have an id field to enable the object cache");
            }
            Class<BaseDaoImpl> clazz = BaseDaoImpl.class;
            synchronized (BaseDaoImpl.class) {
                if (defaultObjectCache == null) {
                    defaultObjectCache = ReferenceObjectCache.makeWeakCache();
                }
                this.objectCache = defaultObjectCache;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.objectCache.registerClass(this.dataClass);
                return;
            }
        }
        if (this.objectCache == null) return;
        this.objectCache.clear(this.dataClass);
        this.objectCache = null;
    }

    @Override
    public void setObjectCache(ObjectCache objectCache) throws SQLException {
        if (objectCache == null) {
            if (this.objectCache != null) {
                this.objectCache.clear(this.dataClass);
                this.objectCache = null;
            }
        } else {
            if (this.objectCache != null && this.objectCache != objectCache) {
                this.objectCache.clear(this.dataClass);
            }
            if (this.tableInfo.getIdField() == null) {
                throw new SQLException("Class " + this.dataClass + " must have an id field to enable the object cache");
            }
            this.objectCache = objectCache;
            this.objectCache.registerClass(this.dataClass);
        }
    }

    @Override
    public ObjectCache getObjectCache() {
        return this.objectCache;
    }

    @Override
    public void clearObjectCache() {
        if (this.objectCache != null) {
            this.objectCache.clear(this.dataClass);
        }
    }

    public static synchronized void clearAllInternalObjectCaches() {
        if (defaultObjectCache != null) {
            defaultObjectCache.clearAll();
            defaultObjectCache = null;
        }
    }

    @Override
    public T mapSelectStarRow(DatabaseResults results) throws SQLException {
        return this.statementExecutor.getSelectStarRowMapper().mapRow(results);
    }

    @Override
    public void notifyChanges() {
        if (this.daoObserverMap != null) {
            for (Dao.DaoObserver daoObserver : this.daoObserverMap.keySet()) {
                daoObserver.onChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerObserver(Dao.DaoObserver observer) {
        if (this.daoObserverMap == null) {
            BaseDaoImpl baseDaoImpl = this;
            synchronized (baseDaoImpl) {
                if (this.daoObserverMap == null) {
                    this.daoObserverMap = new ConcurrentHashMap<Dao.DaoObserver, Object>();
                }
            }
        }
        this.daoObserverMap.put(observer, constantObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterObserver(Dao.DaoObserver observer) {
        if (this.daoObserverMap != null) {
            ConcurrentMap<Dao.DaoObserver, Object> concurrentMap = this.daoObserverMap;
            synchronized (concurrentMap) {
                this.daoObserverMap.remove(observer);
            }
        }
    }

    @Override
    public GenericRowMapper<T> getSelectStarRowMapper() throws SQLException {
        return this.statementExecutor.getSelectStarRowMapper();
    }

    @Override
    public RawRowMapper<T> getRawRowMapper() {
        return this.statementExecutor.getRawRowMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean idExists(ID id) throws SQLException {
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection(this.tableInfo.getTableName());
        try {
            boolean bl = this.statementExecutor.ifExists(connection, id);
            return bl;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public DatabaseConnection startThreadConnection() throws SQLException {
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection(this.tableInfo.getTableName());
        this.connectionSource.saveSpecialConnection(connection);
        return connection;
    }

    @Override
    public void endThreadConnection(DatabaseConnection connection) throws SQLException {
        this.connectionSource.clearSpecialConnection(connection);
        this.connectionSource.releaseConnection(connection);
    }

    @Override
    public void setAutoCommit(DatabaseConnection connection, boolean autoCommit) throws SQLException {
        connection.setAutoCommit(autoCommit);
    }

    @Override
    public boolean isAutoCommit(DatabaseConnection connection) throws SQLException {
        return connection.isAutoCommit();
    }

    @Override
    public void commit(DatabaseConnection connection) throws SQLException {
        connection.commit(null);
    }

    @Override
    public void rollBack(DatabaseConnection connection) throws SQLException {
        connection.rollback(null);
    }

    @Override
    public T createObjectInstance() throws SQLException {
        try {
            T instance = this.objectFactory == null ? this.constructor.newInstance(new Object[0]) : this.objectFactory.createObject(this.constructor, this.dataClass);
            this.wireNewInstance(instance);
            return instance;
        }
        catch (Exception e) {
            throw new SQLException("Could not create object for " + this.constructor.getDeclaringClass(), e);
        }
    }

    @Override
    public void setObjectFactory(ObjectFactory<T> objectFactory) {
        this.checkForInitialized();
        this.objectFactory = objectFactory;
    }

    public DatabaseTableConfig<T> getTableConfig() {
        return this.tableConfig;
    }

    @Override
    public TableInfo<T, ID> getTableInfo() {
        return this.tableInfo;
    }

    @Override
    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public void setConnectionSource(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    public void setTableConfig(DatabaseTableConfig<T> tableConfig) {
        this.tableConfig = tableConfig;
    }

    @Override
    public String getTableName() {
        return this.tableInfo.getTableName();
    }

    static <T, ID> Dao<T, ID> createDao(ConnectionSource connectionSource, Class<T> clazz) throws SQLException {
        return new BaseDaoImpl<T, ID>(connectionSource, (Class)clazz){};
    }

    static <T, ID> Dao<T, ID> createDao(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) throws SQLException {
        return new BaseDaoImpl<T, ID>(connectionSource, (DatabaseTableConfig)tableConfig){};
    }

    protected void checkForInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("you must call initialize() before you can use the dao");
        }
    }

    private <FT> ForeignCollection<FT> makeEmptyForeignCollection(T parent, String fieldName) throws SQLException {
        this.checkForInitialized();
        Object id = parent == null ? null : (Object)this.extractId(parent);
        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
            if (!fieldType.getColumnName().equals(fieldName)) continue;
            BaseForeignCollection collection = fieldType.buildForeignCollection(parent, id);
            if (parent != null) {
                fieldType.assignField(this.connectionSource, parent, collection, true, null);
            }
            return collection;
        }
        throw new IllegalArgumentException("Could not find a field named " + fieldName);
    }

    CloseableIterator<T> createIterator(int resultFlags) {
        try {
            SelectIterator<T, ID> iterator = this.statementExecutor.buildIterator(this, this.connectionSource, resultFlags, this.objectCache);
            return iterator;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not build iterator for " + this.dataClass, e);
        }
    }

    CloseableIterator<T> createIterator(PreparedQuery<T> preparedQuery, int resultFlags) throws SQLException {
        try {
            SelectIterator<T, ID> iterator = this.statementExecutor.buildIterator(this, this.connectionSource, preparedQuery, this.objectCache, resultFlags);
            return iterator;
        }
        catch (SQLException e) {
            throw new SQLException("Could not build prepared-query iterator for " + this.dataClass, e);
        }
    }

    private List<T> queryForMatching(T matchObj, boolean useArgs) throws SQLException {
        this.checkForInitialized();
        QueryBuilder<T, ID> qb = this.queryBuilder();
        Where where = qb.where();
        int fieldC = 0;
        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
            Object fieldValue = fieldType.getFieldValueIfNotDefault(matchObj);
            if (fieldValue == null) continue;
            if (useArgs) {
                fieldValue = new SelectArg(fieldValue);
            }
            where.eq(fieldType.getColumnName(), fieldValue);
            ++fieldC;
        }
        if (fieldC == 0) {
            return Collections.emptyList();
        }
        where.and(fieldC);
        return qb.query();
    }

    private List<T> queryForFieldValues(Map<String, Object> fieldValues, boolean useArgs) throws SQLException {
        this.checkForInitialized();
        QueryBuilder<T, ID> qb = this.queryBuilder();
        Where where = qb.where();
        for (Map.Entry<String, Object> entry : fieldValues.entrySet()) {
            Object fieldValue = entry.getValue();
            if (useArgs) {
                fieldValue = new SelectArg(fieldValue);
            }
            where.eq(entry.getKey(), fieldValue);
        }
        if (fieldValues.size() == 0) {
            return Collections.emptyList();
        }
        where.and(fieldValues.size());
        return qb.query();
    }

    private Constructor<T> findNoArgConstructor(Class<T> dataClass) {
        Constructor<?>[] constructors;
        try {
            Constructor<?>[] consts;
            constructors = consts = dataClass.getDeclaredConstructors();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't lookup declared constructors for " + dataClass, e);
        }
        for (Constructor<?> con : constructors) {
            if (con.getParameterTypes().length != 0) continue;
            if (!con.isAccessible()) {
                try {
                    con.setAccessible(true);
                }
                catch (SecurityException e) {
                    throw new IllegalArgumentException("Could not open access to constructor for " + dataClass);
                }
            }
            return con;
        }
        if (dataClass.getEnclosingClass() == null) {
            throw new IllegalArgumentException("Can't find a no-arg constructor for " + dataClass);
        }
        throw new IllegalArgumentException("Can't find a no-arg constructor for " + dataClass + ".  Missing static on inner class?");
    }

    private void wireNewInstance(T instance) {
        if (instance instanceof BaseDaoEnabled) {
            BaseDaoEnabled daoEnabled = (BaseDaoEnabled)instance;
            daoEnabled.setDao(this);
        }
    }

    static {
        constantObject = new Object();
    }
}

