/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.simple;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.metadata.internal.Identifiers;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.collection.Containers;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class SimpleIdentifiedObject
implements IdentifiedObject,
LenientComparable,
Serializable {
    private static final long serialVersionUID = 5297493321524903545L;
    protected ReferenceIdentifier name;

    protected SimpleIdentifiedObject() {
    }

    public SimpleIdentifiedObject(IdentifiedObject object) {
        this.name = object.getName();
    }

    public SimpleIdentifiedObject(ReferenceIdentifier name) {
        this.name = name;
    }

    public ReferenceIdentifier getName() {
        return this.name;
    }

    public final Set<ReferenceIdentifier> getIdentifiers() {
        return Collections.emptySet();
    }

    public final Collection<GenericName> getAlias() {
        return Collections.emptySet();
    }

    @Deprecated
    public final Extent getDomainOfValidity() {
        return null;
    }

    @Deprecated
    public final InternationalString getScope() {
        return null;
    }

    public final InternationalString getRemarks() {
        return null;
    }

    public int hashCode() {
        int code = -847315335;
        ReferenceIdentifier name = this.getName();
        if (name != null) {
            code ^= name.hashCode();
        }
        return code;
    }

    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object instanceof IdentifiedObject && (mode != ComparisonMode.STRICT || object.getClass() == this.getClass())) {
            if (mode.isIgnoringMetadata()) {
                return true;
            }
            IdentifiedObject that = (IdentifiedObject)object;
            return Objects.equals(this.getName(), that.getName()) && Containers.isNullOrEmpty((Collection)that.getIdentifiers()) && Containers.isNullOrEmpty((Collection)that.getAlias()) && that.getRemarks() == null;
        }
        return false;
    }

    public String toWKT() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        Citation authority;
        String codespace;
        String code;
        ReferenceIdentifier name = this.name;
        if (name != null) {
            code = name.getCode();
            codespace = name.getCodeSpace();
            authority = name.getAuthority();
        } else {
            code = null;
            codespace = null;
            authority = null;
        }
        StringBuilder buffer = new StringBuilder("IdentifiedObject[\"");
        if (codespace != null) {
            buffer.append(codespace).append(':');
        }
        buffer.append(code).append('\"');
        String identifier = Identifiers.getIdentifier(authority, true);
        if (identifier != null) {
            buffer.append(", Id[\"").append(identifier).append("\"]");
        }
        return buffer.append(']').toString();
    }
}

