/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.disk;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.AbstractRowDataSerializer;
import org.apache.paimon.data.serializer.BinaryRowSerializer;
import org.apache.paimon.disk.ChannelReaderInputView;
import org.apache.paimon.disk.ChannelWithMeta;
import org.apache.paimon.disk.ChannelWriterOutputView;
import org.apache.paimon.disk.FileIOChannel;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.disk.InMemoryBuffer;
import org.apache.paimon.disk.RowBuffer;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.utils.MutableObjectIterator;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalBuffer
implements RowBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalBuffer.class);
    private final IOManager ioManager;
    private final MemorySegmentPool pool;
    private final BinaryRowSerializer binaryRowSerializer;
    private final InMemoryBuffer inMemoryBuffer;
    private final MemorySize maxDiskSize;
    private final BlockCompressionFactory compactionFactory;
    private final int segmentSize;
    private final List<ChannelWithMeta> spilledChannelIDs;
    private int numRows;
    private boolean addCompleted;

    ExternalBuffer(IOManager ioManager, MemorySegmentPool pool, AbstractRowDataSerializer<?> serializer, MemorySize maxDiskSize, String compression) {
        this.ioManager = ioManager;
        this.pool = pool;
        this.maxDiskSize = maxDiskSize;
        this.compactionFactory = BlockCompressionFactory.create((String)compression);
        this.binaryRowSerializer = serializer instanceof BinaryRowSerializer ? (BinaryRowSerializer)serializer.duplicate() : new BinaryRowSerializer(serializer.getArity());
        this.segmentSize = pool.pageSize();
        this.spilledChannelIDs = new ArrayList<ChannelWithMeta>();
        this.numRows = 0;
        this.addCompleted = false;
        this.inMemoryBuffer = new InMemoryBuffer(pool, serializer);
    }

    @Override
    public void reset() {
        this.clearChannels();
        this.inMemoryBuffer.reset();
        this.numRows = 0;
        this.addCompleted = false;
    }

    @Override
    public boolean flushMemory() throws IOException {
        boolean isFull;
        boolean bl = isFull = this.getDiskUsage() >= this.maxDiskSize.getBytes();
        if (isFull) {
            return false;
        }
        this.spill();
        return true;
    }

    private long getDiskUsage() {
        long bytes = 0L;
        for (ChannelWithMeta spillChannelID : this.spilledChannelIDs) {
            bytes += spillChannelID.getNumBytes();
        }
        return bytes;
    }

    @Override
    public boolean put(InternalRow row) throws IOException {
        Preconditions.checkState((!this.addCompleted ? 1 : 0) != 0, (Object)"This buffer has add completed.");
        if (!this.inMemoryBuffer.put(row)) {
            if (this.inMemoryBuffer.getCurrentDataBufferOffset() == 0L) {
                this.throwTooBigException(row);
            }
            this.spill();
            if (!this.inMemoryBuffer.put(row)) {
                this.throwTooBigException(row);
            }
        }
        ++this.numRows;
        return true;
    }

    @Override
    public void complete() {
        this.addCompleted = true;
    }

    @Override
    public RowBuffer.RowBufferIterator newIterator() {
        Preconditions.checkState((boolean)this.addCompleted, (Object)"This buffer has not add completed.");
        return new BufferIterator();
    }

    private void throwTooBigException(InternalRow row) throws IOException {
        int rowSize = this.inMemoryBuffer.getSerializer().toBinaryRow(row).toBytes().length;
        throw new IOException("Record is too big, it can't be added to a empty InMemoryBuffer! Record size: " + rowSize + ", Buffer: " + this.memorySize());
    }

    private void spill() throws IOException {
        FileIOChannel.ID channel = this.ioManager.createChannel();
        ChannelWriterOutputView channelWriterOutputView = new ChannelWriterOutputView(this.ioManager.createBufferFileWriter(channel), this.compactionFactory, this.segmentSize);
        int numRecordBuffers = this.inMemoryBuffer.getNumRecordBuffers();
        ArrayList<MemorySegment> segments = this.inMemoryBuffer.getRecordBufferSegments();
        try {
            for (int i = 0; i < numRecordBuffers; ++i) {
                MemorySegment segment = segments.get(i);
                int bufferSize = i == numRecordBuffers - 1 ? this.inMemoryBuffer.getNumBytesInLastBuffer() : segment.size();
                channelWriterOutputView.write(segment, 0, bufferSize);
            }
            LOG.info("here spill the reset buffer data with {} records {} bytes", (Object)this.inMemoryBuffer.size(), (Object)channelWriterOutputView.getNumBytes());
            channelWriterOutputView.close();
        }
        catch (IOException e) {
            channelWriterOutputView.closeAndDelete();
            throw e;
        }
        this.spilledChannelIDs.add(new ChannelWithMeta(channel, this.inMemoryBuffer.getNumRecordBuffers(), this.inMemoryBuffer.getNumBytesInLastBuffer(), channelWriterOutputView.getNumBytes()));
        this.inMemoryBuffer.reset();
    }

    @Override
    public int size() {
        return this.numRows;
    }

    @Override
    public long memoryOccupancy() {
        return this.inMemoryBuffer.memoryOccupancy();
    }

    private int memorySize() {
        return this.pool.freePages() * this.segmentSize;
    }

    private void clearChannels() {
        for (ChannelWithMeta meta : this.spilledChannelIDs) {
            File f = new File(meta.getChannel().getPath());
            if (!f.exists()) continue;
            f.delete();
        }
        this.spilledChannelIDs.clear();
    }

    @VisibleForTesting
    public List<ChannelWithMeta> getSpillChannels() {
        return this.spilledChannelIDs;
    }

    public class BufferIterator
    implements RowBuffer.RowBufferIterator {
        private MutableObjectIterator<BinaryRow> currentIterator;
        private final BinaryRow reuse;
        private int currentChannelID;
        private BinaryRow row;
        private boolean closed;
        private ChannelReaderInputView channelReader;

        private BufferIterator() {
            this.reuse = ExternalBuffer.this.binaryRowSerializer.createInstance();
            this.currentChannelID = -1;
            this.closed = false;
        }

        private void checkValidity() {
            if (this.closed) {
                throw new RuntimeException("This iterator is closed!");
            }
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            try {
                this.closeCurrentFileReader();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.closed = true;
        }

        @Override
        public boolean advanceNext() {
            this.checkValidity();
            try {
                do {
                    if (this.currentIterator == null || (this.row = this.currentIterator.next(this.reuse)) == null) continue;
                    return true;
                } while (this.nextIterator());
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean nextIterator() throws IOException {
            if (this.currentChannelID == Integer.MAX_VALUE || ExternalBuffer.this.numRows == 0) {
                return false;
            }
            if (this.currentChannelID < ExternalBuffer.this.spilledChannelIDs.size() - 1) {
                this.nextSpilledIterator();
            } else {
                this.newMemoryIterator();
            }
            return true;
        }

        @Override
        public BinaryRow getRow() {
            return this.row;
        }

        private void closeCurrentFileReader() throws IOException {
            if (this.channelReader != null) {
                this.channelReader.close();
                this.channelReader = null;
            }
        }

        private void nextSpilledIterator() throws IOException {
            ChannelWithMeta channel = (ChannelWithMeta)ExternalBuffer.this.spilledChannelIDs.get(this.currentChannelID + 1);
            ++this.currentChannelID;
            this.closeCurrentFileReader();
            this.channelReader = new ChannelReaderInputView(channel.getChannel(), ExternalBuffer.this.ioManager, ExternalBuffer.this.compactionFactory, ExternalBuffer.this.segmentSize, channel.getBlockCount());
            this.currentIterator = this.channelReader.createBinaryRowIterator(ExternalBuffer.this.binaryRowSerializer);
        }

        private void newMemoryIterator() {
            this.currentChannelID = Integer.MAX_VALUE;
            this.currentIterator = ExternalBuffer.this.inMemoryBuffer.newIterator();
        }
    }
}

